/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.DataVersion;
import org.slf4j.Logger;

public class DetectedVersion
implements WorldVersion {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final WorldVersion BUILT_IN = new DetectedVersion();
    private final String id;
    private final String name;
    private final boolean stable;
    private final DataVersion worldVersion;
    private final int protocolVersion;
    private final int resourcePackVersion;
    private final int dataPackVersion;
    private final Date buildTime;

    private DetectedVersion() {
        this.id = UUID.randomUUID().toString().replaceAll("-", "");
        this.name = "1.21";
        this.stable = true;
        this.worldVersion = new DataVersion(3953, "main");
        this.protocolVersion = SharedConstants.getProtocolVersion();
        this.resourcePackVersion = 34;
        this.dataPackVersion = 48;
        this.buildTime = new Date();
    }

    private DetectedVersion(JsonObject p_132489_) {
        this.id = GsonHelper.getAsString(p_132489_, "id");
        this.name = GsonHelper.getAsString(p_132489_, "name");
        this.stable = GsonHelper.getAsBoolean(p_132489_, "stable");
        this.worldVersion = new DataVersion(GsonHelper.getAsInt(p_132489_, "world_version"), GsonHelper.getAsString(p_132489_, "series_id", DataVersion.MAIN_SERIES));
        this.protocolVersion = GsonHelper.getAsInt(p_132489_, "protocol_version");
        JsonObject $$1 = GsonHelper.getAsJsonObject(p_132489_, "pack_version");
        this.resourcePackVersion = GsonHelper.getAsInt($$1, "resource");
        this.dataPackVersion = GsonHelper.getAsInt($$1, "data");
        this.buildTime = Date.from(ZonedDateTime.parse(GsonHelper.getAsString(p_132489_, "build_time")).toInstant());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static WorldVersion tryDetectVersion() {
        try (InputStream $$0 = DetectedVersion.class.getResourceAsStream("/version.json");){
            DetectedVersion detectedVersion;
            if ($$0 == null) {
                LOGGER.warn("Missing version information!");
                WorldVersion worldVersion = BUILT_IN;
                return worldVersion;
            }
            try (InputStreamReader $$1 = new InputStreamReader($$0);){
                detectedVersion = new DetectedVersion(GsonHelper.parse($$1));
            }
            return detectedVersion;
        }
        catch (JsonParseException | IOException $$2) {
            throw new IllegalStateException("Game version information is corrupt", $$2);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataVersion getDataVersion() {
        return this.worldVersion;
    }

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public int getPackVersion(PackType p_265454_) {
        return p_265454_ == PackType.SERVER_DATA ? this.dataPackVersion : this.resourcePackVersion;
    }

    @Override
    public Date getBuildTime() {
        return this.buildTime;
    }

    @Override
    public boolean isStable() {
        return this.stable;
    }
}

