/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.SignedArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;

public class MessageArgument
implements SignedArgument<Message> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Hello world!", "foo", "@e", "Hello @p :)");
    static final Dynamic2CommandExceptionType TOO_LONG = new Dynamic2CommandExceptionType((p_341561_, p_341562_) -> Component.translatableEscape("argument.message.too_long", p_341561_, p_341562_));

    public static MessageArgument message() {
        return new MessageArgument();
    }

    public static Component getMessage(CommandContext<CommandSourceStack> p_96836_, String p_96837_) throws CommandSyntaxException {
        Message $$2 = (Message)p_96836_.getArgument(p_96837_, Message.class);
        return $$2.resolveComponent((CommandSourceStack)p_96836_.getSource());
    }

    public static void resolveChatMessage(CommandContext<CommandSourceStack> p_249433_, String p_248718_, Consumer<PlayerChatMessage> p_249460_) throws CommandSyntaxException {
        Message $$3 = (Message)p_249433_.getArgument(p_248718_, Message.class);
        CommandSourceStack $$4 = (CommandSourceStack)p_249433_.getSource();
        Component $$5 = $$3.resolveComponent($$4);
        CommandSigningContext $$6 = $$4.getSigningContext();
        PlayerChatMessage $$7 = $$6.getArgument(p_248718_);
        if ($$7 != null) {
            MessageArgument.resolveSignedMessage(p_249460_, $$4, $$7.withUnsignedContent($$5));
        } else {
            MessageArgument.resolveDisguisedMessage(p_249460_, $$4, PlayerChatMessage.system($$3.text).withUnsignedContent($$5));
        }
    }

    private static void resolveSignedMessage(Consumer<PlayerChatMessage> p_250000_, CommandSourceStack p_252335_, PlayerChatMessage p_249420_) {
        MinecraftServer $$3 = p_252335_.getServer();
        CompletableFuture<FilteredText> $$4 = MessageArgument.filterPlainText(p_252335_, p_249420_);
        Component $$5 = $$3.getChatDecorator().decorate(p_252335_.getPlayer(), p_249420_.decoratedContent());
        p_252335_.getChatMessageChainer().append($$4, p_300688_ -> {
            PlayerChatMessage $$4 = p_249420_.withUnsignedContent($$5).filter(p_300688_.mask());
            p_250000_.accept($$4);
        });
    }

    private static void resolveDisguisedMessage(Consumer<PlayerChatMessage> p_249162_, CommandSourceStack p_248759_, PlayerChatMessage p_252332_) {
        ChatDecorator $$3 = p_248759_.getServer().getChatDecorator();
        Component $$4 = $$3.decorate(p_248759_.getPlayer(), p_252332_.decoratedContent());
        p_249162_.accept(p_252332_.withUnsignedContent($$4));
    }

    private static CompletableFuture<FilteredText> filterPlainText(CommandSourceStack p_252063_, PlayerChatMessage p_251184_) {
        ServerPlayer $$2 = p_252063_.getPlayer();
        if ($$2 != null && p_251184_.hasSignatureFrom($$2.getUUID())) {
            return $$2.getTextFilter().processStreamMessage(p_251184_.signedContent());
        }
        return CompletableFuture.completedFuture(FilteredText.passThrough(p_251184_.signedContent()));
    }

    public Message parse(StringReader p_96834_) throws CommandSyntaxException {
        return Message.parseText(p_96834_, true);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public record Message(String text, Part[] parts) {
        Component resolveComponent(CommandSourceStack p_232197_) throws CommandSyntaxException {
            return this.toComponent(p_232197_, p_232197_.hasPermission(2));
        }

        public Component toComponent(CommandSourceStack p_96850_, boolean p_96851_) throws CommandSyntaxException {
            if (this.parts.length == 0 || !p_96851_) {
                return Component.literal(this.text);
            }
            MutableComponent $$2 = Component.literal(this.text.substring(0, this.parts[0].start()));
            int $$3 = this.parts[0].start();
            for (Part $$4 : this.parts) {
                Component $$5 = $$4.toComponent(p_96850_);
                if ($$3 < $$4.start()) {
                    $$2.append(this.text.substring($$3, $$4.start()));
                }
                $$2.append($$5);
                $$3 = $$4.end();
            }
            if ($$3 < this.text.length()) {
                $$2.append(this.text.substring($$3));
            }
            return $$2;
        }

        /*
         * WARNING - void declaration
         */
        public static Message parseText(StringReader p_96847_, boolean p_96848_) throws CommandSyntaxException {
            if (p_96847_.getRemainingLength() > 256) {
                throw TOO_LONG.create((Object)p_96847_.getRemainingLength(), (Object)256);
            }
            String $$2 = p_96847_.getRemaining();
            if (!p_96848_) {
                p_96847_.setCursor(p_96847_.getTotalLength());
                return new Message($$2, new Part[0]);
            }
            ArrayList $$3 = Lists.newArrayList();
            int $$4 = p_96847_.getCursor();
            while (p_96847_.canRead()) {
                if (p_96847_.peek() == '@') {
                    void $$9;
                    int $$5 = p_96847_.getCursor();
                    try {
                        EntitySelectorParser $$6 = new EntitySelectorParser(p_96847_);
                        EntitySelector $$7 = $$6.parse();
                    }
                    catch (CommandSyntaxException $$8) {
                        if ($$8.getType() == EntitySelectorParser.ERROR_MISSING_SELECTOR_TYPE || $$8.getType() == EntitySelectorParser.ERROR_UNKNOWN_SELECTOR_TYPE) {
                            p_96847_.setCursor($$5 + 1);
                            continue;
                        }
                        throw $$8;
                    }
                    $$3.add(new Part($$5 - $$4, p_96847_.getCursor() - $$4, (EntitySelector)$$9));
                    continue;
                }
                p_96847_.skip();
            }
            return new Message($$2, $$3.toArray(new Part[0]));
        }
    }

    public record Part(int start, int end, EntitySelector selector) {
        public Component toComponent(CommandSourceStack p_96861_) throws CommandSyntaxException {
            return EntitySelector.joinNames(this.selector.findEntities(p_96861_));
        }
    }
}

