/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.gametest.framework.AfterBatch;
import net.minecraft.gametest.framework.BeforeBatch;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestGenerator;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Rotation;

public class GameTestRegistry {
    private static final Collection<TestFunction> TEST_FUNCTIONS = Lists.newArrayList();
    private static final Set<String> TEST_CLASS_NAMES = Sets.newHashSet();
    private static final Map<String, Consumer<ServerLevel>> BEFORE_BATCH_FUNCTIONS = Maps.newHashMap();
    private static final Map<String, Consumer<ServerLevel>> AFTER_BATCH_FUNCTIONS = Maps.newHashMap();
    private static final Set<TestFunction> LAST_FAILED_TESTS = Sets.newHashSet();

    public static void register(Class<?> p_177502_) {
        Arrays.stream(p_177502_.getDeclaredMethods()).sorted(Comparator.comparing(Method::getName)).forEach(GameTestRegistry::register);
    }

    public static void register(Method p_177504_) {
        GameTestGenerator $$3;
        String $$1 = p_177504_.getDeclaringClass().getSimpleName();
        GameTest $$2 = p_177504_.getAnnotation(GameTest.class);
        if ($$2 != null) {
            TEST_FUNCTIONS.add(GameTestRegistry.turnMethodIntoTestFunction(p_177504_));
            TEST_CLASS_NAMES.add($$1);
        }
        if (($$3 = p_177504_.getAnnotation(GameTestGenerator.class)) != null) {
            TEST_FUNCTIONS.addAll(GameTestRegistry.useTestGeneratorMethod(p_177504_));
            TEST_CLASS_NAMES.add($$1);
        }
        GameTestRegistry.registerBatchFunction(p_177504_, BeforeBatch.class, BeforeBatch::batch, BEFORE_BATCH_FUNCTIONS);
        GameTestRegistry.registerBatchFunction(p_177504_, AfterBatch.class, AfterBatch::batch, AFTER_BATCH_FUNCTIONS);
    }

    private static <T extends Annotation> void registerBatchFunction(Method p_177506_, Class<T> p_177507_, Function<T, String> p_177508_, Map<String, Consumer<ServerLevel>> p_177509_) {
        String $$5;
        Consumer<?> $$6;
        T $$4 = p_177506_.getAnnotation(p_177507_);
        if ($$4 != null && ($$6 = p_177509_.putIfAbsent($$5 = p_177508_.apply($$4), GameTestRegistry.turnMethodIntoConsumer(p_177506_))) != null) {
            throw new RuntimeException("Hey, there should only be one " + String.valueOf(p_177507_) + " method per batch. Batch '" + $$5 + "' has more than one!");
        }
    }

    public static Stream<TestFunction> getTestFunctionsForClassName(String p_127660_) {
        return TEST_FUNCTIONS.stream().filter(p_127674_ -> GameTestRegistry.isTestFunctionPartOfClass(p_127674_, p_127660_));
    }

    public static Collection<TestFunction> getAllTestFunctions() {
        return TEST_FUNCTIONS;
    }

    public static Collection<String> getAllTestClassNames() {
        return TEST_CLASS_NAMES;
    }

    public static boolean isTestClass(String p_127671_) {
        return TEST_CLASS_NAMES.contains(p_127671_);
    }

    public static Consumer<ServerLevel> getBeforeBatchFunction(String p_127677_) {
        return BEFORE_BATCH_FUNCTIONS.getOrDefault(p_127677_, p_319462_ -> {});
    }

    public static Consumer<ServerLevel> getAfterBatchFunction(String p_177518_) {
        return AFTER_BATCH_FUNCTIONS.getOrDefault(p_177518_, p_319461_ -> {});
    }

    public static Optional<TestFunction> findTestFunction(String p_127680_) {
        return GameTestRegistry.getAllTestFunctions().stream().filter(p_319460_ -> p_319460_.testName().equalsIgnoreCase(p_127680_)).findFirst();
    }

    public static TestFunction getTestFunction(String p_127682_) {
        Optional<TestFunction> $$1 = GameTestRegistry.findTestFunction(p_127682_);
        if ($$1.isEmpty()) {
            throw new IllegalArgumentException("Can't find the test function for " + p_127682_);
        }
        return $$1.get();
    }

    private static Collection<TestFunction> useTestGeneratorMethod(Method p_177514_) {
        try {
            Object $$1 = p_177514_.getDeclaringClass().newInstance();
            return (Collection)p_177514_.invoke($$1, new Object[0]);
        }
        catch (ReflectiveOperationException $$2) {
            throw new RuntimeException($$2);
        }
    }

    private static TestFunction turnMethodIntoTestFunction(Method p_177516_) {
        GameTest $$1 = p_177516_.getAnnotation(GameTest.class);
        String $$2 = p_177516_.getDeclaringClass().getSimpleName();
        String $$3 = $$2.toLowerCase();
        String $$4 = $$3 + "." + p_177516_.getName().toLowerCase();
        String $$5 = $$1.template().isEmpty() ? $$4 : $$3 + "." + $$1.template();
        String $$6 = $$1.batch();
        Rotation $$7 = StructureUtils.getRotationForRotationSteps($$1.rotationSteps());
        return new TestFunction($$6, $$4, $$5, $$7, $$1.timeoutTicks(), $$1.setupTicks(), $$1.required(), $$1.manualOnly(), $$1.requiredSuccesses(), $$1.attempts(), $$1.skyAccess(), GameTestRegistry.turnMethodIntoConsumer(p_177516_));
    }

    private static Consumer<?> turnMethodIntoConsumer(Method p_177520_) {
        return p_177512_ -> {
            try {
                Object $$2 = p_177520_.getDeclaringClass().newInstance();
                p_177520_.invoke($$2, p_177512_);
            }
            catch (InvocationTargetException $$3) {
                if ($$3.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)$$3.getCause();
                }
                throw new RuntimeException($$3.getCause());
            }
            catch (ReflectiveOperationException $$4) {
                throw new RuntimeException($$4);
            }
        };
    }

    private static boolean isTestFunctionPartOfClass(TestFunction p_127667_, String p_127668_) {
        return p_127667_.testName().toLowerCase().startsWith(p_127668_.toLowerCase() + ".");
    }

    public static Stream<TestFunction> getLastFailedTests() {
        return LAST_FAILED_TESTS.stream();
    }

    public static void rememberFailedTest(TestFunction p_127665_) {
        LAST_FAILED_TESTS.add(p_127665_);
    }

    public static void forgetFailedTests() {
        LAST_FAILED_TESTS.clear();
    }
}

