/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.capabilities;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.capabilities.ICapabilityInvalidationListener;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CapabilityListenerHolder {
    private final Long2ReferenceMap<Long2ReferenceMap<Set<ListenerReference>>> byChunkThenBlock = new Long2ReferenceOpenHashMap();
    private final ReferenceQueue<ICapabilityInvalidationListener> queue = new ReferenceQueue();

    public void addListener(BlockPos pos, ICapabilityInvalidationListener listener) {
        ListenerReference reference;
        Long2ReferenceMap chunkHolder = (Long2ReferenceMap)this.byChunkThenBlock.computeIfAbsent(ChunkPos.asLong((BlockPos)(pos = pos.immutable())), l -> new Long2ReferenceOpenHashMap());
        Set listenersSet = (Set)chunkHolder.computeIfAbsent(pos.asLong(), l -> new ObjectOpenHashSet());
        if (!listenersSet.add(reference = new ListenerReference(this.queue, pos, listener))) {
            reference.clear();
        }
    }

    public void invalidatePos(BlockPos pos) {
        Set caches;
        Long2ReferenceMap chunkHolder = (Long2ReferenceMap)this.byChunkThenBlock.get(ChunkPos.asLong((BlockPos)pos));
        if (chunkHolder != null && (caches = (Set)chunkHolder.get(pos.asLong())) != null) {
            this.invalidateList(caches);
        }
    }

    public void invalidateChunk(ChunkPos chunkPos) {
        Long2ReferenceMap chunkHolder = (Long2ReferenceMap)this.byChunkThenBlock.get(chunkPos.toLong());
        if (chunkHolder != null) {
            for (Set caches : chunkHolder.values()) {
                this.invalidateList(caches);
            }
        }
    }

    private void invalidateList(Set<ListenerReference> caches) {
        caches.removeIf(ref -> {
            ICapabilityInvalidationListener listener = (ICapabilityInvalidationListener)ref.get();
            return listener == null || !listener.onInvalidate();
        });
    }

    public void clean() {
        ListenerReference ref;
        while ((ref = (ListenerReference)this.queue.poll()) != null) {
            boolean removed;
            Set set;
            Long2ReferenceMap chunkHolder = (Long2ReferenceMap)this.byChunkThenBlock.get(ChunkPos.asLong((BlockPos)ref.pos));
            if (chunkHolder == null || (set = (Set)chunkHolder.get(ref.pos.asLong())) == null || !(removed = set.remove(ref)) || !set.isEmpty()) continue;
            chunkHolder.remove(ref.pos.asLong());
            if (!chunkHolder.isEmpty()) continue;
            this.byChunkThenBlock.remove(ChunkPos.asLong((BlockPos)ref.pos));
        }
        return;
    }

    private static class ListenerReference
    extends WeakReference<ICapabilityInvalidationListener> {
        private final BlockPos pos;
        private final int listenerHashCode;

        private ListenerReference(ReferenceQueue<ICapabilityInvalidationListener> queue, BlockPos pos, ICapabilityInvalidationListener listener) {
            super(listener, queue);
            this.pos = pos;
            this.listenerHashCode = System.identityHashCode(listener);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ListenerReference) {
                ListenerReference otherRef = (ListenerReference)obj;
                return otherRef.listenerHashCode == this.listenerHashCode && otherRef.get() == this.get();
            }
            return false;
        }

        public int hashCode() {
            return this.listenerHashCode;
        }
    }
}

