/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

class DimensionsCommand {
    DimensionsCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"dimensions").requires(cs -> cs.hasPermission(0))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.neoforge.dimensions.list"), true);
            Registry reg = ((CommandSourceStack)ctx.getSource()).registryAccess().registryOrThrow(Registries.DIMENSION_TYPE);
            HashMap<ResourceLocation, List> types = new HashMap<ResourceLocation, List>();
            for (ServerLevel dim : ((CommandSourceStack)ctx.getSource()).getServer().getAllLevels()) {
                types.computeIfAbsent(reg.getKey((Object)dim.dimensionType()), k -> new ArrayList()).add(dim.getDescription());
            }
            types.keySet().stream().sorted().forEach(key -> ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> {
                MutableComponent component = Component.literal((String)(String.valueOf(key) + ": "));
                List components = (List)types.get(key);
                for (int i = 0; i < components.size(); ++i) {
                    component.append((Component)components.get(i));
                    if (i + 1 >= components.size()) continue;
                    component.append(", ");
                }
                return component;
            }, false));
            return 0;
        });
    }
}

