/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.crafting.CraftingHelper;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public final class Ingredient
implements Predicate<ItemStack> {
    public static final Ingredient EMPTY = new Ingredient(Stream.empty());
    public static final StreamCodec<RegistryFriendlyByteBuf, Ingredient> CONTENTS_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Ingredient>(){
        private static final StreamCodec<RegistryFriendlyByteBuf, ICustomIngredient> CUSTOM_INGREDIENT_CODEC = ByteBufCodecs.registry(NeoForgeRegistries.Keys.INGREDIENT_TYPES).dispatch(c -> c.getType(), t -> t.streamCodec());

        public void encode(RegistryFriendlyByteBuf buf, Ingredient ingredient) {
            if (ingredient.isSimple()) {
                ItemStack.LIST_STREAM_CODEC.encode((Object)buf, Arrays.asList(ingredient.getItems()));
            } else {
                buf.writeVarInt(-1);
                CUSTOM_INGREDIENT_CODEC.encode((Object)buf, (Object)ingredient.customIngredient);
            }
        }

        public Ingredient decode(RegistryFriendlyByteBuf buf) {
            int size = buf.readVarInt();
            if (size == -1) {
                return new Ingredient((ICustomIngredient)CUSTOM_INGREDIENT_CODEC.decode((Object)buf));
            }
            return Ingredient.fromValues(Stream.generate(() -> (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf)).limit(size).map(ItemValue::new));
        }
    };
    private final Value[] values;
    @Nullable
    private ItemStack[] itemStacks;
    @Nullable
    private IntList stackingIds;
    @Nullable
    private ICustomIngredient customIngredient = null;
    public static final Codec<Ingredient> CODEC = CraftingHelper.makeIngredientCodec((boolean)true);
    public static final Codec<Ingredient> CODEC_NONEMPTY = CraftingHelper.makeIngredientCodec((boolean)false);
    public static final MapCodec<Ingredient> MAP_CODEC_NONEMPTY = CraftingHelper.makeIngredientMapCodec();
    public static final Codec<List<Ingredient>> LIST_CODEC = MAP_CODEC_NONEMPTY.codec().listOf();
    public static final Codec<List<Ingredient>> LIST_CODEC_NONEMPTY = LIST_CODEC.validate(list -> list.isEmpty() ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)list));

    private Ingredient(Stream<? extends Value> p_43907_) {
        this.values = (Value[])p_43907_.toArray(Value[]::new);
    }

    private Ingredient(Value[] p_301044_) {
        this.values = p_301044_;
    }

    public Ingredient(ICustomIngredient customIngredient) {
        this(new Value[0]);
        this.customIngredient = customIngredient;
    }

    public ItemStack[] getItems() {
        if (this.itemStacks == null) {
            Stream<Set> stream = this.customIngredient == null ? Arrays.stream(this.values).flatMap(value -> value.getItems().stream()) : this.customIngredient.getItems();
            this.itemStacks = (ItemStack[])stream.collect(Collectors.toCollection(ItemStackLinkedSet::createTypeAndComponentsSet)).toArray(ItemStack[]::new);
        }
        return this.itemStacks;
    }

    @Override
    public boolean test(@Nullable ItemStack p_43914_) {
        if (p_43914_ == null) {
            return false;
        }
        if (this.customIngredient != null) {
            return this.customIngredient.test(p_43914_);
        }
        if (this.isEmpty()) {
            return p_43914_.isEmpty();
        }
        for (ItemStack itemstack : this.getItems()) {
            if (!itemstack.is(p_43914_.getItem())) continue;
            return true;
        }
        return false;
    }

    public IntList getStackingIds() {
        if (this.stackingIds == null) {
            ItemStack[] aitemstack = this.getItems();
            this.stackingIds = new IntArrayList(aitemstack.length);
            for (ItemStack itemstack : aitemstack) {
                this.stackingIds.add(StackedContents.getStackingIndex((ItemStack)itemstack));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public boolean isEmpty() {
        return this.values.length == 0 && !this.isCustom();
    }

    public boolean hasNoItems() {
        ItemStack[] items = this.getItems();
        if (items.length == 0) {
            return true;
        }
        if (items.length == 1) {
            MutableComponent hoverName;
            Component component;
            ItemStack item = items[0];
            return item.getItem() == Items.BARRIER && (component = item.getHoverName()) instanceof MutableComponent && (hoverName = (MutableComponent)component).getString().startsWith("Empty Tag: ");
        }
        return false;
    }

    public boolean equals(Object p_301003_) {
        boolean bl;
        if (p_301003_ instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)p_301003_;
            bl = Objects.equals(this.customIngredient, ingredient.customIngredient) && Arrays.equals(this.values, ingredient.values);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        if (this.customIngredient != null) {
            return this.customIngredient.hashCode();
        }
        return Arrays.hashCode(this.values);
    }

    public Value[] getValues() {
        if (this.isCustom()) {
            throw new IllegalStateException("Cannot retrieve values from custom ingredient!");
        }
        return this.values;
    }

    public boolean isSimple() {
        return this.customIngredient == null || this.customIngredient.isSimple();
    }

    @Nullable
    public ICustomIngredient getCustomIngredient() {
        return this.customIngredient;
    }

    public boolean isCustom() {
        return this.customIngredient != null;
    }

    public static Ingredient fromValues(Stream<? extends Value> p_43939_) {
        Ingredient ingredient = new Ingredient(p_43939_);
        return ingredient.isEmpty() ? EMPTY : ingredient;
    }

    public static Ingredient of() {
        return EMPTY;
    }

    public static Ingredient of(ItemLike ... p_43930_) {
        return Ingredient.of(Arrays.stream(p_43930_).map(ItemStack::new));
    }

    public static Ingredient of(ItemStack ... p_43928_) {
        return Ingredient.of(Arrays.stream(p_43928_));
    }

    public static Ingredient of(Stream<ItemStack> p_43922_) {
        return Ingredient.fromValues(p_43922_.filter(p_43944_ -> !p_43944_.isEmpty()).map(ItemValue::new));
    }

    public static Ingredient of(TagKey<Item> p_204133_) {
        return Ingredient.fromValues(Stream.of(new TagValue(p_204133_)));
    }

    @Deprecated
    private static Codec<Ingredient> codec(boolean p_301074_) {
        Codec codec = Codec.list(Value.CODEC).comapFlatMap(p_300810_ -> !p_301074_ && p_300810_.size() < 1 ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)p_300810_.toArray(new Value[0])), List::of);
        return Codec.either((Codec)codec, Value.CODEC).flatComapMap(p_300805_ -> (Ingredient)p_300805_.map(Ingredient::new, p_300806_ -> new Ingredient(new Value[]{p_300806_})), p_300808_ -> {
            if (p_300808_.values.length == 1) {
                return DataResult.success((Object)Either.right((Object)p_300808_.values[0]));
            }
            return p_300808_.values.length == 0 && !p_301074_ ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)Either.left((Object)p_300808_.values));
        });
    }

    public static interface Value {
        public static final MapCodec<Value> MAP_CODEC = NeoForgeExtraCodecs.xor(ItemValue.MAP_CODEC, TagValue.MAP_CODEC).xmap(p_300956_ -> (Value)p_300956_.map(p_300932_ -> p_300932_, p_301313_ -> p_301313_), p_301304_ -> {
            if (p_301304_ instanceof TagValue) {
                TagValue ingredient$tagvalue = (TagValue)p_301304_;
                return Either.right((Object)ingredient$tagvalue);
            }
            if (p_301304_ instanceof ItemValue) {
                ItemValue ingredient$itemvalue = (ItemValue)p_301304_;
                return Either.left((Object)ingredient$itemvalue);
            }
            throw new UnsupportedOperationException("This is neither an item value nor a tag value.");
        });
        public static final Codec<Value> CODEC = MAP_CODEC.codec();

        public Collection<ItemStack> getItems();
    }

    public record TagValue(TagKey<Item> tag) implements Value
    {
        static final MapCodec<TagValue> MAP_CODEC = RecordCodecBuilder.mapCodec(p_301118_ -> p_301118_.group((App)TagKey.codec(Registries.ITEM).fieldOf("tag").forGetter(p_301154_ -> p_301154_.tag)).apply((Applicative)p_301118_, TagValue::new));
        static final Codec<TagValue> CODEC = MAP_CODEC.codec();

        @Override
        public boolean equals(Object p_301162_) {
            boolean bl;
            if (p_301162_ instanceof TagValue) {
                TagValue ingredient$tagvalue = (TagValue)p_301162_;
                bl = ingredient$tagvalue.tag.location().equals(this.tag.location());
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public Collection<ItemStack> getItems() {
            ArrayList list = Lists.newArrayList();
            for (Holder holder : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
                list.add(new ItemStack(holder));
            }
            if (list.isEmpty()) {
                ItemStack itemStack = new ItemStack(Blocks.BARRIER);
                itemStack.set(DataComponents.CUSTOM_NAME, Component.literal((String)("Empty Tag: " + String.valueOf(this.tag.location()))));
                list.add(itemStack);
            }
            return list;
        }
    }

    public record ItemValue(ItemStack item) implements Value
    {
        static final MapCodec<ItemValue> MAP_CODEC = RecordCodecBuilder.mapCodec(p_330109_ -> p_330109_.group((App)ItemStack.SIMPLE_ITEM_CODEC.fieldOf("item").forGetter(p_300919_ -> p_300919_.item)).apply((Applicative)p_330109_, ItemValue::new));
        static final Codec<ItemValue> CODEC = MAP_CODEC.codec();

        @Override
        public boolean equals(Object p_301316_) {
            boolean bl;
            if (!(p_301316_ instanceof ItemValue)) {
                bl = false;
            } else {
                ItemValue ingredient$itemvalue = (ItemValue)p_301316_;
                bl = ingredient$itemvalue.item.getItem().equals(this.item.getItem()) && ingredient$itemvalue.item.getCount() == this.item.getCount();
            }
            return bl;
        }

        @Override
        public int hashCode() {
            return 31 * this.item.getItem().hashCode() + this.item.getCount();
        }

        @Override
        public Collection<ItemStack> getItems() {
            return Collections.singleton(this.item);
        }
    }
}

