/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class BowItem
extends ProjectileWeaponItem {
    public static final int MAX_DRAW_DURATION = 20;
    public static final int DEFAULT_RANGE = 15;

    public BowItem(Item.Properties p_40660_) {
        super(p_40660_);
    }

    @Override
    public void releaseUsing(ItemStack p_40667_, Level p_40668_, LivingEntity p_40669_, int p_40670_) {
        if (!(p_40669_ instanceof Player)) {
            return;
        }
        Player $$4 = (Player)p_40669_;
        ItemStack $$5 = $$4.getProjectile(p_40667_);
        if ($$5.isEmpty()) {
            return;
        }
        int $$6 = this.getUseDuration(p_40667_, p_40669_) - p_40670_;
        float $$7 = BowItem.getPowerForTime($$6);
        if ((double)$$7 < 0.1) {
            return;
        }
        List<ItemStack> $$8 = BowItem.draw(p_40667_, $$5, $$4);
        if (p_40668_ instanceof ServerLevel) {
            ServerLevel $$9 = (ServerLevel)p_40668_;
            if (!$$8.isEmpty()) {
                this.shoot($$9, $$4, $$4.getUsedItemHand(), p_40667_, $$8, $$7 * 3.0f, 1.0f, $$7 == 1.0f, null);
            }
        }
        p_40668_.playSound(null, $$4.getX(), $$4.getY(), $$4.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (p_40668_.getRandom().nextFloat() * 0.4f + 1.2f) + $$7 * 0.5f);
        $$4.awardStat(Stats.ITEM_USED.get(this));
    }

    @Override
    protected void shootProjectile(LivingEntity p_331372_, Projectile p_332000_, int p_330631_, float p_331251_, float p_331199_, float p_330857_, @Nullable LivingEntity p_331572_) {
        p_332000_.shootFromRotation(p_331372_, p_331372_.getXRot(), p_331372_.getYRot() + p_330857_, 0.0f, p_331251_, p_331199_);
    }

    public static float getPowerForTime(int p_40662_) {
        float $$1 = (float)p_40662_ / 20.0f;
        if (($$1 = ($$1 * $$1 + $$1 * 2.0f) / 3.0f) > 1.0f) {
            $$1 = 1.0f;
        }
        return $$1;
    }

    @Override
    public int getUseDuration(ItemStack p_40680_, LivingEntity p_345962_) {
        return 72000;
    }

    @Override
    public UseAnim getUseAnimation(ItemStack p_40678_) {
        return UseAnim.BOW;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level p_40672_, Player p_40673_, InteractionHand p_40674_) {
        boolean $$4;
        ItemStack $$3 = p_40673_.getItemInHand(p_40674_);
        boolean bl = $$4 = !p_40673_.getProjectile($$3).isEmpty();
        if (p_40673_.hasInfiniteMaterials() || $$4) {
            p_40673_.startUsingItem(p_40674_);
            return InteractionResultHolder.consume($$3);
        }
        return InteractionResultHolder.fail($$3);
    }

    @Override
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    @Override
    public int getDefaultProjectileRange() {
        return 15;
    }
}

