/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import org.slf4j.Logger;

public final class DensityFunctions {
    private static final Codec<DensityFunction> CODEC = BuiltInRegistries.DENSITY_FUNCTION_TYPE.byNameCodec().dispatch(p_338092_ -> p_338092_.codec().codec(), Function.identity());
    protected static final double MAX_REASONABLE_NOISE_VALUE = 1000000.0;
    static final Codec<Double> NOISE_VALUE_CODEC = Codec.doubleRange((double)-1000000.0, (double)1000000.0);
    public static final Codec<DensityFunction> DIRECT_CODEC = Codec.either(NOISE_VALUE_CODEC, CODEC).xmap(p_224023_ -> (DensityFunction)p_224023_.map(DensityFunctions::constant, Function.identity()), p_224051_ -> {
        if (p_224051_ instanceof Constant) {
            Constant $$1 = (Constant)p_224051_;
            return Either.left((Object)$$1.value());
        }
        return Either.right((Object)p_224051_);
    });

    public static MapCodec<? extends DensityFunction> bootstrap(Registry<MapCodec<? extends DensityFunction>> p_208343_) {
        DensityFunctions.register(p_208343_, "blend_alpha", BlendAlpha.CODEC);
        DensityFunctions.register(p_208343_, "blend_offset", BlendOffset.CODEC);
        DensityFunctions.register(p_208343_, "beardifier", BeardifierMarker.CODEC);
        DensityFunctions.register(p_208343_, "old_blended_noise", BlendedNoise.CODEC);
        for (Marker.Type type : Marker.Type.values()) {
            DensityFunctions.register(p_208343_, type.getSerializedName(), type.codec);
        }
        DensityFunctions.register(p_208343_, "noise", Noise.CODEC);
        DensityFunctions.register(p_208343_, "end_islands", EndIslandDensityFunction.CODEC);
        DensityFunctions.register(p_208343_, "weird_scaled_sampler", WeirdScaledSampler.CODEC);
        DensityFunctions.register(p_208343_, "shifted_noise", ShiftedNoise.CODEC);
        DensityFunctions.register(p_208343_, "range_choice", RangeChoice.CODEC);
        DensityFunctions.register(p_208343_, "shift_a", ShiftA.CODEC);
        DensityFunctions.register(p_208343_, "shift_b", ShiftB.CODEC);
        DensityFunctions.register(p_208343_, "shift", Shift.CODEC);
        DensityFunctions.register(p_208343_, "blend_density", BlendDensity.CODEC);
        DensityFunctions.register(p_208343_, "clamp", Clamp.CODEC);
        for (Enum enum_ : Mapped.Type.values()) {
            DensityFunctions.register(p_208343_, ((Mapped.Type)enum_).getSerializedName(), ((Mapped.Type)enum_).codec);
        }
        for (Enum enum_ : TwoArgumentSimpleFunction.Type.values()) {
            DensityFunctions.register(p_208343_, ((TwoArgumentSimpleFunction.Type)enum_).getSerializedName(), ((TwoArgumentSimpleFunction.Type)enum_).codec);
        }
        DensityFunctions.register(p_208343_, "spline", Spline.CODEC);
        DensityFunctions.register(p_208343_, "constant", Constant.CODEC);
        return DensityFunctions.register(p_208343_, "y_clamped_gradient", YClampedGradient.CODEC);
    }

    private static MapCodec<? extends DensityFunction> register(Registry<MapCodec<? extends DensityFunction>> p_224035_, String p_224036_, KeyDispatchDataCodec<? extends DensityFunction> p_224037_) {
        return Registry.register(p_224035_, p_224036_, p_224037_.codec());
    }

    static <A, O> KeyDispatchDataCodec<O> singleArgumentCodec(Codec<A> p_224025_, Function<A, O> p_224026_, Function<O, A> p_224027_) {
        return KeyDispatchDataCodec.of(p_224025_.fieldOf("argument").xmap(p_224026_, p_224027_));
    }

    static <O> KeyDispatchDataCodec<O> singleFunctionArgumentCodec(Function<DensityFunction, O> p_224043_, Function<O, DensityFunction> p_224044_) {
        return DensityFunctions.singleArgumentCodec(DensityFunction.HOLDER_HELPER_CODEC, p_224043_, p_224044_);
    }

    static <O> KeyDispatchDataCodec<O> doubleFunctionArgumentCodec(BiFunction<DensityFunction, DensityFunction, O> p_224039_, Function<O, DensityFunction> p_224040_, Function<O, DensityFunction> p_224041_) {
        return KeyDispatchDataCodec.of(RecordCodecBuilder.mapCodec(p_224049_ -> p_224049_.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument1").forGetter(p_224040_), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument2").forGetter(p_224041_)).apply((Applicative)p_224049_, p_224039_)));
    }

    static <O> KeyDispatchDataCodec<O> makeCodec(MapCodec<O> p_224029_) {
        return KeyDispatchDataCodec.of(p_224029_);
    }

    private DensityFunctions() {
    }

    public static DensityFunction interpolated(DensityFunction p_208282_) {
        return new Marker(Marker.Type.Interpolated, p_208282_);
    }

    public static DensityFunction flatCache(DensityFunction p_208362_) {
        return new Marker(Marker.Type.FlatCache, p_208362_);
    }

    public static DensityFunction cache2d(DensityFunction p_208374_) {
        return new Marker(Marker.Type.Cache2D, p_208374_);
    }

    public static DensityFunction cacheOnce(DensityFunction p_208381_) {
        return new Marker(Marker.Type.CacheOnce, p_208381_);
    }

    public static DensityFunction cacheAllInCell(DensityFunction p_208388_) {
        return new Marker(Marker.Type.CacheAllInCell, p_208388_);
    }

    public static DensityFunction mappedNoise(Holder<NormalNoise.NoiseParameters> p_208337_, @Deprecated double p_208338_, double p_208339_, double p_208340_, double p_208341_) {
        return DensityFunctions.mapFromUnitTo(new Noise(new DensityFunction.NoiseHolder(p_208337_), p_208338_, p_208339_), p_208340_, p_208341_);
    }

    public static DensityFunction mappedNoise(Holder<NormalNoise.NoiseParameters> p_208332_, double p_208333_, double p_208334_, double p_208335_) {
        return DensityFunctions.mappedNoise(p_208332_, 1.0, p_208333_, p_208334_, p_208335_);
    }

    public static DensityFunction mappedNoise(Holder<NormalNoise.NoiseParameters> p_208328_, double p_208329_, double p_208330_) {
        return DensityFunctions.mappedNoise(p_208328_, 1.0, 1.0, p_208329_, p_208330_);
    }

    public static DensityFunction shiftedNoise2d(DensityFunction p_208297_, DensityFunction p_208298_, double p_208299_, Holder<NormalNoise.NoiseParameters> p_208300_) {
        return new ShiftedNoise(p_208297_, DensityFunctions.zero(), p_208298_, p_208299_, 0.0, new DensityFunction.NoiseHolder(p_208300_));
    }

    public static DensityFunction noise(Holder<NormalNoise.NoiseParameters> p_208323_) {
        return DensityFunctions.noise(p_208323_, 1.0, 1.0);
    }

    public static DensityFunction noise(Holder<NormalNoise.NoiseParameters> p_208369_, double p_208370_, double p_208371_) {
        return new Noise(new DensityFunction.NoiseHolder(p_208369_), p_208370_, p_208371_);
    }

    public static DensityFunction noise(Holder<NormalNoise.NoiseParameters> p_208325_, double p_208326_) {
        return DensityFunctions.noise(p_208325_, 1.0, p_208326_);
    }

    public static DensityFunction rangeChoice(DensityFunction p_208288_, double p_208289_, double p_208290_, DensityFunction p_208291_, DensityFunction p_208292_) {
        return new RangeChoice(p_208288_, p_208289_, p_208290_, p_208291_, p_208292_);
    }

    public static DensityFunction shiftA(Holder<NormalNoise.NoiseParameters> p_208367_) {
        return new ShiftA(new DensityFunction.NoiseHolder(p_208367_));
    }

    public static DensityFunction shiftB(Holder<NormalNoise.NoiseParameters> p_208379_) {
        return new ShiftB(new DensityFunction.NoiseHolder(p_208379_));
    }

    public static DensityFunction shift(Holder<NormalNoise.NoiseParameters> p_208386_) {
        return new Shift(new DensityFunction.NoiseHolder(p_208386_));
    }

    public static DensityFunction blendDensity(DensityFunction p_208390_) {
        return new BlendDensity(p_208390_);
    }

    public static DensityFunction endIslands(long p_208272_) {
        return new EndIslandDensityFunction(p_208272_);
    }

    public static DensityFunction weirdScaledSampler(DensityFunction p_208316_, Holder<NormalNoise.NoiseParameters> p_208317_, WeirdScaledSampler.RarityValueMapper p_208318_) {
        return new WeirdScaledSampler(p_208316_, new DensityFunction.NoiseHolder(p_208317_), p_208318_);
    }

    public static DensityFunction add(DensityFunction p_208294_, DensityFunction p_208295_) {
        return TwoArgumentSimpleFunction.create(TwoArgumentSimpleFunction.Type.ADD, p_208294_, p_208295_);
    }

    public static DensityFunction mul(DensityFunction p_208364_, DensityFunction p_208365_) {
        return TwoArgumentSimpleFunction.create(TwoArgumentSimpleFunction.Type.MUL, p_208364_, p_208365_);
    }

    public static DensityFunction min(DensityFunction p_208376_, DensityFunction p_208377_) {
        return TwoArgumentSimpleFunction.create(TwoArgumentSimpleFunction.Type.MIN, p_208376_, p_208377_);
    }

    public static DensityFunction max(DensityFunction p_208383_, DensityFunction p_208384_) {
        return TwoArgumentSimpleFunction.create(TwoArgumentSimpleFunction.Type.MAX, p_208383_, p_208384_);
    }

    public static DensityFunction spline(CubicSpline<Spline.Point, Spline.Coordinate> p_224021_) {
        return new Spline(p_224021_);
    }

    public static DensityFunction zero() {
        return Constant.ZERO;
    }

    public static DensityFunction constant(double p_208265_) {
        return new Constant(p_208265_);
    }

    public static DensityFunction yClampedGradient(int p_208267_, int p_208268_, double p_208269_, double p_208270_) {
        return new YClampedGradient(p_208267_, p_208268_, p_208269_, p_208270_);
    }

    public static DensityFunction map(DensityFunction p_208313_, Mapped.Type p_208314_) {
        return Mapped.create(p_208314_, p_208313_);
    }

    private static DensityFunction mapFromUnitTo(DensityFunction p_208284_, double p_208285_, double p_208286_) {
        double $$3 = (p_208285_ + p_208286_) * 0.5;
        double $$4 = (p_208286_ - p_208285_) * 0.5;
        return DensityFunctions.add(DensityFunctions.constant($$3), DensityFunctions.mul(DensityFunctions.constant($$4), p_208284_));
    }

    public static DensityFunction blendAlpha() {
        return BlendAlpha.INSTANCE;
    }

    public static DensityFunction blendOffset() {
        return BlendOffset.INSTANCE;
    }

    public static DensityFunction lerp(DensityFunction p_208302_, DensityFunction p_208303_, DensityFunction p_208304_) {
        if (p_208303_ instanceof Constant) {
            Constant $$3 = (Constant)p_208303_;
            return DensityFunctions.lerp(p_208302_, $$3.value, p_208304_);
        }
        DensityFunction $$4 = DensityFunctions.cacheOnce(p_208302_);
        DensityFunction $$5 = DensityFunctions.add(DensityFunctions.mul($$4, DensityFunctions.constant(-1.0)), DensityFunctions.constant(1.0));
        return DensityFunctions.add(DensityFunctions.mul(p_208303_, $$5), DensityFunctions.mul(p_208304_, $$4));
    }

    public static DensityFunction lerp(DensityFunction p_224031_, double p_224032_, DensityFunction p_224033_) {
        return DensityFunctions.add(DensityFunctions.mul(p_224031_, DensityFunctions.add(p_224033_, DensityFunctions.constant(-p_224032_))), DensityFunctions.constant(p_224032_));
    }

    protected static enum BlendAlpha implements DensityFunction.SimpleFunction
    {
        INSTANCE;

        public static final KeyDispatchDataCodec<DensityFunction> CODEC;

        @Override
        public double compute(DensityFunction.FunctionContext p_208536_) {
            return 1.0;
        }

        @Override
        public void fillArray(double[] p_208538_, DensityFunction.ContextProvider p_208539_) {
            Arrays.fill(p_208538_, 1.0);
        }

        @Override
        public double minValue() {
            return 1.0;
        }

        @Override
        public double maxValue() {
            return 1.0;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }

        static {
            CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)INSTANCE));
        }
    }

    protected static enum BlendOffset implements DensityFunction.SimpleFunction
    {
        INSTANCE;

        public static final KeyDispatchDataCodec<DensityFunction> CODEC;

        @Override
        public double compute(DensityFunction.FunctionContext p_208573_) {
            return 0.0;
        }

        @Override
        public void fillArray(double[] p_208575_, DensityFunction.ContextProvider p_208576_) {
            Arrays.fill(p_208575_, 0.0);
        }

        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        public double maxValue() {
            return 0.0;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }

        static {
            CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)INSTANCE));
        }
    }

    protected static enum BeardifierMarker implements BeardifierOrMarker
    {
        INSTANCE;


        @Override
        public double compute(DensityFunction.FunctionContext p_208515_) {
            return 0.0;
        }

        @Override
        public void fillArray(double[] p_208517_, DensityFunction.ContextProvider p_208518_) {
            Arrays.fill(p_208517_, 0.0);
        }

        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        public double maxValue() {
            return 0.0;
        }
    }

    protected record Marker(Type type, DensityFunction wrapped) implements MarkerOrMarked
    {
        @Override
        public double compute(DensityFunction.FunctionContext p_208712_) {
            return this.wrapped.compute(p_208712_);
        }

        @Override
        public void fillArray(double[] p_208716_, DensityFunction.ContextProvider p_208717_) {
            this.wrapped.fillArray(p_208716_, p_208717_);
        }

        @Override
        public double minValue() {
            return this.wrapped.minValue();
        }

        @Override
        public double maxValue() {
            return this.wrapped.maxValue();
        }

        static enum Type implements StringRepresentable
        {
            Interpolated("interpolated"),
            FlatCache("flat_cache"),
            Cache2D("cache_2d"),
            CacheOnce("cache_once"),
            CacheAllInCell("cache_all_in_cell");

            private final String name;
            final KeyDispatchDataCodec<MarkerOrMarked> codec = DensityFunctions.singleFunctionArgumentCodec(p_208740_ -> new Marker(this, (DensityFunction)p_208740_), MarkerOrMarked::wrapped);

            private Type(String p_208737_) {
                this.name = p_208737_;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }
        }
    }

    protected record Noise(DensityFunction.NoiseHolder noise, @Deprecated double xzScale, double yScale) implements DensityFunction
    {
        public static final MapCodec<Noise> DATA_CODEC = RecordCodecBuilder.mapCodec(p_208798_ -> p_208798_.group((App)DensityFunction.NoiseHolder.CODEC.fieldOf("noise").forGetter(Noise::noise), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(Noise::xzScale), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(Noise::yScale)).apply((Applicative)p_208798_, Noise::new));
        public static final KeyDispatchDataCodec<Noise> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.FunctionContext p_208800_) {
            return this.noise.getValue((double)p_208800_.blockX() * this.xzScale, (double)p_208800_.blockY() * this.yScale, (double)p_208800_.blockZ() * this.xzScale);
        }

        @Override
        public void fillArray(double[] p_224079_, DensityFunction.ContextProvider p_224080_) {
            p_224080_.fillAllDirectly(p_224079_, this);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_224077_) {
            return p_224077_.apply(new Noise(p_224077_.visitNoise(this.noise), this.xzScale, this.yScale));
        }

        @Override
        public double minValue() {
            return -this.maxValue();
        }

        @Override
        public double maxValue() {
            return this.noise.maxValue();
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected static final class EndIslandDensityFunction
    implements DensityFunction.SimpleFunction {
        public static final KeyDispatchDataCodec<EndIslandDensityFunction> CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)new EndIslandDensityFunction(0L)));
        private static final float ISLAND_THRESHOLD = -0.9f;
        private final SimplexNoise islandNoise;

        public EndIslandDensityFunction(long p_208630_) {
            LegacyRandomSource $$1 = new LegacyRandomSource(p_208630_);
            $$1.consumeCount(17292);
            this.islandNoise = new SimplexNoise($$1);
        }

        private static float getHeightValue(SimplexNoise p_224063_, int p_224064_, int p_224065_) {
            int $$3 = p_224064_ / 2;
            int $$4 = p_224065_ / 2;
            int $$5 = p_224064_ % 2;
            int $$6 = p_224065_ % 2;
            float $$7 = 100.0f - Mth.sqrt(p_224064_ * p_224064_ + p_224065_ * p_224065_) * 8.0f;
            $$7 = Mth.clamp($$7, -100.0f, 80.0f);
            for (int $$8 = -12; $$8 <= 12; ++$$8) {
                for (int $$9 = -12; $$9 <= 12; ++$$9) {
                    long $$10 = $$3 + $$8;
                    long $$11 = $$4 + $$9;
                    if ($$10 * $$10 + $$11 * $$11 <= 4096L || !(p_224063_.getValue($$10, $$11) < (double)-0.9f)) continue;
                    float $$12 = (Mth.abs($$10) * 3439.0f + Mth.abs($$11) * 147.0f) % 13.0f + 9.0f;
                    float $$13 = $$5 - $$8 * 2;
                    float $$14 = $$6 - $$9 * 2;
                    float $$15 = 100.0f - Mth.sqrt($$13 * $$13 + $$14 * $$14) * $$12;
                    $$15 = Mth.clamp($$15, -100.0f, 80.0f);
                    $$7 = Math.max($$7, $$15);
                }
            }
            return $$7;
        }

        @Override
        public double compute(DensityFunction.FunctionContext p_208633_) {
            return ((double)EndIslandDensityFunction.getHeightValue(this.islandNoise, p_208633_.blockX() / 8, p_208633_.blockZ() / 8) - 8.0) / 128.0;
        }

        @Override
        public double minValue() {
            return -0.84375;
        }

        @Override
        public double maxValue() {
            return 0.5625;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record WeirdScaledSampler(DensityFunction input, DensityFunction.NoiseHolder noise, RarityValueMapper rarityValueMapper) implements TransformerWithContext
    {
        private static final MapCodec<WeirdScaledSampler> DATA_CODEC = RecordCodecBuilder.mapCodec(p_208438_ -> p_208438_.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("input").forGetter(WeirdScaledSampler::input), (App)DensityFunction.NoiseHolder.CODEC.fieldOf("noise").forGetter(WeirdScaledSampler::noise), (App)RarityValueMapper.CODEC.fieldOf("rarity_value_mapper").forGetter(WeirdScaledSampler::rarityValueMapper)).apply((Applicative)p_208438_, WeirdScaledSampler::new));
        public static final KeyDispatchDataCodec<WeirdScaledSampler> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double transform(DensityFunction.FunctionContext p_208440_, double p_208441_) {
            double $$2 = this.rarityValueMapper.mapper.get(p_208441_);
            return $$2 * Math.abs(this.noise.getValue((double)p_208440_.blockX() / $$2, (double)p_208440_.blockY() / $$2, (double)p_208440_.blockZ() / $$2));
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208443_) {
            return p_208443_.apply(new WeirdScaledSampler(this.input.mapAll(p_208443_), p_208443_.visitNoise(this.noise), this.rarityValueMapper));
        }

        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        public double maxValue() {
            return this.rarityValueMapper.maxRarity * this.noise.maxValue();
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }

        public static enum RarityValueMapper implements StringRepresentable
        {
            TYPE1("type_1", NoiseRouterData.QuantizedSpaghettiRarity::getSpaghettiRarity3D, 2.0),
            TYPE2("type_2", NoiseRouterData.QuantizedSpaghettiRarity::getSphaghettiRarity2D, 3.0);

            public static final Codec<RarityValueMapper> CODEC;
            private final String name;
            final Double2DoubleFunction mapper;
            final double maxRarity;

            private RarityValueMapper(String p_208470_, Double2DoubleFunction p_208471_, double p_208472_) {
                this.name = p_208470_;
                this.mapper = p_208471_;
                this.maxRarity = p_208472_;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }

            static {
                CODEC = StringRepresentable.fromEnum(RarityValueMapper::values);
            }
        }
    }

    protected record ShiftedNoise(DensityFunction shiftX, DensityFunction shiftY, DensityFunction shiftZ, double xzScale, double yScale, DensityFunction.NoiseHolder noise) implements DensityFunction
    {
        private static final MapCodec<ShiftedNoise> DATA_CODEC = RecordCodecBuilder.mapCodec(p_208943_ -> p_208943_.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_x").forGetter(ShiftedNoise::shiftX), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_y").forGetter(ShiftedNoise::shiftY), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_z").forGetter(ShiftedNoise::shiftZ), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(ShiftedNoise::xzScale), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(ShiftedNoise::yScale), (App)DensityFunction.NoiseHolder.CODEC.fieldOf("noise").forGetter(ShiftedNoise::noise)).apply((Applicative)p_208943_, ShiftedNoise::new));
        public static final KeyDispatchDataCodec<ShiftedNoise> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.FunctionContext p_208945_) {
            double $$1 = (double)p_208945_.blockX() * this.xzScale + this.shiftX.compute(p_208945_);
            double $$2 = (double)p_208945_.blockY() * this.yScale + this.shiftY.compute(p_208945_);
            double $$3 = (double)p_208945_.blockZ() * this.xzScale + this.shiftZ.compute(p_208945_);
            return this.noise.getValue($$1, $$2, $$3);
        }

        @Override
        public void fillArray(double[] p_208956_, DensityFunction.ContextProvider p_208957_) {
            p_208957_.fillAllDirectly(p_208956_, this);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208947_) {
            return p_208947_.apply(new ShiftedNoise(this.shiftX.mapAll(p_208947_), this.shiftY.mapAll(p_208947_), this.shiftZ.mapAll(p_208947_), this.xzScale, this.yScale, p_208947_.visitNoise(this.noise)));
        }

        @Override
        public double minValue() {
            return -this.maxValue();
        }

        @Override
        public double maxValue() {
            return this.noise.maxValue();
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    record RangeChoice(DensityFunction input, double minInclusive, double maxExclusive, DensityFunction whenInRange, DensityFunction whenOutOfRange) implements DensityFunction
    {
        public static final MapCodec<RangeChoice> DATA_CODEC = RecordCodecBuilder.mapCodec(p_208837_ -> p_208837_.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("input").forGetter(RangeChoice::input), (App)NOISE_VALUE_CODEC.fieldOf("min_inclusive").forGetter(RangeChoice::minInclusive), (App)NOISE_VALUE_CODEC.fieldOf("max_exclusive").forGetter(RangeChoice::maxExclusive), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("when_in_range").forGetter(RangeChoice::whenInRange), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("when_out_of_range").forGetter(RangeChoice::whenOutOfRange)).apply((Applicative)p_208837_, RangeChoice::new));
        public static final KeyDispatchDataCodec<RangeChoice> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.FunctionContext p_208839_) {
            double $$1 = this.input.compute(p_208839_);
            if ($$1 >= this.minInclusive && $$1 < this.maxExclusive) {
                return this.whenInRange.compute(p_208839_);
            }
            return this.whenOutOfRange.compute(p_208839_);
        }

        @Override
        public void fillArray(double[] p_208843_, DensityFunction.ContextProvider p_208844_) {
            this.input.fillArray(p_208843_, p_208844_);
            for (int $$2 = 0; $$2 < p_208843_.length; ++$$2) {
                double $$3 = p_208843_[$$2];
                p_208843_[$$2] = $$3 >= this.minInclusive && $$3 < this.maxExclusive ? this.whenInRange.compute(p_208844_.forIndex($$2)) : this.whenOutOfRange.compute(p_208844_.forIndex($$2));
            }
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208841_) {
            return p_208841_.apply(new RangeChoice(this.input.mapAll(p_208841_), this.minInclusive, this.maxExclusive, this.whenInRange.mapAll(p_208841_), this.whenOutOfRange.mapAll(p_208841_)));
        }

        @Override
        public double minValue() {
            return Math.min(this.whenInRange.minValue(), this.whenOutOfRange.minValue());
        }

        @Override
        public double maxValue() {
            return Math.max(this.whenInRange.maxValue(), this.whenOutOfRange.maxValue());
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record ShiftA(DensityFunction.NoiseHolder offsetNoise) implements ShiftNoise
    {
        static final KeyDispatchDataCodec<ShiftA> CODEC = DensityFunctions.singleArgumentCodec(DensityFunction.NoiseHolder.CODEC, ShiftA::new, ShiftA::offsetNoise);

        @Override
        public double compute(DensityFunction.FunctionContext p_208884_) {
            return this.compute(p_208884_.blockX(), 0.0, p_208884_.blockZ());
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_224093_) {
            return p_224093_.apply(new ShiftA(p_224093_.visitNoise(this.offsetNoise)));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record ShiftB(DensityFunction.NoiseHolder offsetNoise) implements ShiftNoise
    {
        static final KeyDispatchDataCodec<ShiftB> CODEC = DensityFunctions.singleArgumentCodec(DensityFunction.NoiseHolder.CODEC, ShiftB::new, ShiftB::offsetNoise);

        @Override
        public double compute(DensityFunction.FunctionContext p_208904_) {
            return this.compute(p_208904_.blockZ(), p_208904_.blockX(), 0.0);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_224099_) {
            return p_224099_.apply(new ShiftB(p_224099_.visitNoise(this.offsetNoise)));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record Shift(DensityFunction.NoiseHolder offsetNoise) implements ShiftNoise
    {
        static final KeyDispatchDataCodec<Shift> CODEC = DensityFunctions.singleArgumentCodec(DensityFunction.NoiseHolder.CODEC, Shift::new, Shift::offsetNoise);

        @Override
        public double compute(DensityFunction.FunctionContext p_208864_) {
            return this.compute(p_208864_.blockX(), p_208864_.blockY(), p_208864_.blockZ());
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_224087_) {
            return p_224087_.apply(new Shift(p_224087_.visitNoise(this.offsetNoise)));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    record BlendDensity(DensityFunction input) implements TransformerWithContext
    {
        static final KeyDispatchDataCodec<BlendDensity> CODEC = DensityFunctions.singleFunctionArgumentCodec(BlendDensity::new, BlendDensity::input);

        @Override
        public double transform(DensityFunction.FunctionContext p_208553_, double p_208554_) {
            return p_208553_.getBlender().blendDensity(p_208553_, p_208554_);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208556_) {
            return p_208556_.apply(new BlendDensity(this.input.mapAll(p_208556_)));
        }

        @Override
        public double minValue() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public double maxValue() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record Clamp(DensityFunction input, double minValue, double maxValue) implements PureTransformer
    {
        private static final MapCodec<Clamp> DATA_CODEC = RecordCodecBuilder.mapCodec(p_208597_ -> p_208597_.group((App)DensityFunction.DIRECT_CODEC.fieldOf("input").forGetter(Clamp::input), (App)NOISE_VALUE_CODEC.fieldOf("min").forGetter(Clamp::minValue), (App)NOISE_VALUE_CODEC.fieldOf("max").forGetter(Clamp::maxValue)).apply((Applicative)p_208597_, Clamp::new));
        public static final KeyDispatchDataCodec<Clamp> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double transform(double p_208595_) {
            return Mth.clamp(p_208595_, this.minValue, this.maxValue);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208599_) {
            return new Clamp(this.input.mapAll(p_208599_), this.minValue, this.maxValue);
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record Mapped(Type type, DensityFunction input, double minValue, double maxValue) implements PureTransformer
    {
        public static Mapped create(Type p_208672_, DensityFunction p_208673_) {
            double $$2 = p_208673_.minValue();
            double $$3 = Mapped.transform(p_208672_, $$2);
            double $$4 = Mapped.transform(p_208672_, p_208673_.maxValue());
            if (p_208672_ == Type.ABS || p_208672_ == Type.SQUARE) {
                return new Mapped(p_208672_, p_208673_, Math.max(0.0, $$2), Math.max($$3, $$4));
            }
            return new Mapped(p_208672_, p_208673_, $$3, $$4);
        }

        private static double transform(Type p_208669_, double p_208670_) {
            return switch (p_208669_.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Math.abs(p_208670_);
                case 1 -> p_208670_ * p_208670_;
                case 2 -> p_208670_ * p_208670_ * p_208670_;
                case 3 -> {
                    if (p_208670_ > 0.0) {
                        yield p_208670_;
                    }
                    yield p_208670_ * 0.5;
                }
                case 4 -> {
                    if (p_208670_ > 0.0) {
                        yield p_208670_;
                    }
                    yield p_208670_ * 0.25;
                }
                case 5 -> {
                    double $$2 = Mth.clamp(p_208670_, -1.0, 1.0);
                    yield $$2 / 2.0 - $$2 * $$2 * $$2 / 24.0;
                }
            };
        }

        @Override
        public double transform(double p_208665_) {
            return Mapped.transform(this.type, p_208665_);
        }

        @Override
        public Mapped mapAll(DensityFunction.Visitor p_208677_) {
            return Mapped.create(this.type, this.input.mapAll(p_208677_));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return this.type.codec;
        }

        @Override
        public /* synthetic */ DensityFunction mapAll(DensityFunction.Visitor visitor) {
            return this.mapAll(visitor);
        }

        static enum Type implements StringRepresentable
        {
            ABS("abs"),
            SQUARE("square"),
            CUBE("cube"),
            HALF_NEGATIVE("half_negative"),
            QUARTER_NEGATIVE("quarter_negative"),
            SQUEEZE("squeeze");

            private final String name;
            final KeyDispatchDataCodec<Mapped> codec = DensityFunctions.singleFunctionArgumentCodec(p_208700_ -> Mapped.create(this, p_208700_), Mapped::input);

            private Type(String p_208697_) {
                this.name = p_208697_;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }
        }
    }

    static interface TwoArgumentSimpleFunction
    extends DensityFunction {
        public static final Logger LOGGER = LogUtils.getLogger();

        public static TwoArgumentSimpleFunction create(Type p_209074_, DensityFunction p_209075_, DensityFunction p_209076_) {
            double $$10;
            double $$3 = p_209075_.minValue();
            double $$4 = p_209076_.minValue();
            double $$5 = p_209075_.maxValue();
            double $$6 = p_209076_.maxValue();
            if (p_209074_ == Type.MIN || p_209074_ == Type.MAX) {
                boolean $$8;
                boolean $$7 = $$3 >= $$6;
                boolean bl = $$8 = $$4 >= $$5;
                if ($$7 || $$8) {
                    LOGGER.warn("Creating a " + String.valueOf(p_209074_) + " function between two non-overlapping inputs: " + String.valueOf(p_209075_) + " and " + String.valueOf(p_209076_));
                }
            }
            double $$9 = switch (p_209074_.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> $$3 + $$4;
                case 3 -> Math.max($$3, $$4);
                case 2 -> Math.min($$3, $$4);
                case 1 -> $$3 > 0.0 && $$4 > 0.0 ? $$3 * $$4 : ($$5 < 0.0 && $$6 < 0.0 ? $$5 * $$6 : Math.min($$3 * $$6, $$5 * $$4));
            };
            switch (p_209074_.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    double d = $$5 + $$6;
                    break;
                }
                case 3: {
                    double d = Math.max($$5, $$6);
                    break;
                }
                case 2: {
                    double d = Math.min($$5, $$6);
                    break;
                }
                case 1: {
                    double d = $$3 > 0.0 && $$4 > 0.0 ? $$5 * $$6 : ($$10 = $$5 < 0.0 && $$6 < 0.0 ? $$3 * $$4 : Math.max($$3 * $$4, $$5 * $$6));
                }
            }
            if (p_209074_ == Type.MUL || p_209074_ == Type.ADD) {
                if (p_209075_ instanceof Constant) {
                    Constant $$11 = (Constant)p_209075_;
                    return new MulOrAdd(p_209074_ == Type.ADD ? MulOrAdd.Type.ADD : MulOrAdd.Type.MUL, p_209076_, $$9, $$10, $$11.value);
                }
                if (p_209076_ instanceof Constant) {
                    Constant $$12 = (Constant)p_209076_;
                    return new MulOrAdd(p_209074_ == Type.ADD ? MulOrAdd.Type.ADD : MulOrAdd.Type.MUL, p_209075_, $$9, $$10, $$12.value);
                }
            }
            return new Ap2(p_209074_, p_209075_, p_209076_, $$9, $$10);
        }

        public Type type();

        public DensityFunction argument1();

        public DensityFunction argument2();

        @Override
        default public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return this.type().codec;
        }

        public static enum Type implements StringRepresentable
        {
            ADD("add"),
            MUL("mul"),
            MIN("min"),
            MAX("max");

            final KeyDispatchDataCodec<TwoArgumentSimpleFunction> codec = DensityFunctions.doubleFunctionArgumentCodec((p_209092_, p_209093_) -> TwoArgumentSimpleFunction.create(this, p_209092_, p_209093_), TwoArgumentSimpleFunction::argument1, TwoArgumentSimpleFunction::argument2);
            private final String name;

            private Type(String p_209089_) {
                this.name = p_209089_;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }
        }
    }

    public record Spline(CubicSpline<Point, Coordinate> spline) implements DensityFunction
    {
        private static final Codec<CubicSpline<Point, Coordinate>> SPLINE_CODEC = CubicSpline.codec(Coordinate.CODEC);
        private static final MapCodec<Spline> DATA_CODEC = SPLINE_CODEC.fieldOf("spline").xmap(Spline::new, Spline::spline);
        public static final KeyDispatchDataCodec<Spline> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.FunctionContext p_211715_) {
            return this.spline.apply(new Point(p_211715_));
        }

        @Override
        public double minValue() {
            return this.spline.minValue();
        }

        @Override
        public double maxValue() {
            return this.spline.maxValue();
        }

        @Override
        public void fillArray(double[] p_211722_, DensityFunction.ContextProvider p_211723_) {
            p_211723_.fillAllDirectly(p_211722_, this);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_211717_) {
            return p_211717_.apply(new Spline(this.spline.mapAll((I p_224119_) -> p_224119_.mapAll(p_211717_))));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }

        public record Point(DensityFunction.FunctionContext context) {
        }

        public record Coordinate(Holder<DensityFunction> function) implements ToFloatFunction<Point>
        {
            public static final Codec<Coordinate> CODEC = DensityFunction.CODEC.xmap(Coordinate::new, Coordinate::function);

            @Override
            public String toString() {
                Optional<ResourceKey<DensityFunction>> $$0 = this.function.unwrapKey();
                if ($$0.isPresent()) {
                    ResourceKey<DensityFunction> $$1 = $$0.get();
                    if ($$1 == NoiseRouterData.CONTINENTS) {
                        return "continents";
                    }
                    if ($$1 == NoiseRouterData.EROSION) {
                        return "erosion";
                    }
                    if ($$1 == NoiseRouterData.RIDGES) {
                        return "weirdness";
                    }
                    if ($$1 == NoiseRouterData.RIDGES_FOLDED) {
                        return "ridges";
                    }
                }
                return "Coordinate[" + String.valueOf(this.function) + "]";
            }

            @Override
            public float apply(Point p_224130_) {
                return (float)this.function.value().compute(p_224130_.context());
            }

            @Override
            public float minValue() {
                return this.function.isBound() ? (float)this.function.value().minValue() : Float.NEGATIVE_INFINITY;
            }

            @Override
            public float maxValue() {
                return this.function.isBound() ? (float)this.function.value().maxValue() : Float.POSITIVE_INFINITY;
            }

            public Coordinate mapAll(DensityFunction.Visitor p_224128_) {
                return new Coordinate(new Holder.Direct<DensityFunction>(this.function.value().mapAll(p_224128_)));
            }
        }
    }

    record Constant(double value) implements DensityFunction.SimpleFunction
    {
        static final KeyDispatchDataCodec<Constant> CODEC = DensityFunctions.singleArgumentCodec(NOISE_VALUE_CODEC, Constant::new, Constant::value);
        static final Constant ZERO = new Constant(0.0);

        @Override
        public double compute(DensityFunction.FunctionContext p_208615_) {
            return this.value;
        }

        @Override
        public void fillArray(double[] p_208617_, DensityFunction.ContextProvider p_208618_) {
            Arrays.fill(p_208617_, this.value);
        }

        @Override
        public double minValue() {
            return this.value;
        }

        @Override
        public double maxValue() {
            return this.value;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    record YClampedGradient(int fromY, int toY, double fromValue, double toValue) implements DensityFunction.SimpleFunction
    {
        private static final MapCodec<YClampedGradient> DATA_CODEC = RecordCodecBuilder.mapCodec(p_208494_ -> p_208494_.group((App)Codec.intRange((int)(DimensionType.MIN_Y * 2), (int)(DimensionType.MAX_Y * 2)).fieldOf("from_y").forGetter(YClampedGradient::fromY), (App)Codec.intRange((int)(DimensionType.MIN_Y * 2), (int)(DimensionType.MAX_Y * 2)).fieldOf("to_y").forGetter(YClampedGradient::toY), (App)NOISE_VALUE_CODEC.fieldOf("from_value").forGetter(YClampedGradient::fromValue), (App)NOISE_VALUE_CODEC.fieldOf("to_value").forGetter(YClampedGradient::toValue)).apply((Applicative)p_208494_, YClampedGradient::new));
        public static final KeyDispatchDataCodec<YClampedGradient> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.FunctionContext p_208496_) {
            return Mth.clampedMap((double)p_208496_.blockY(), (double)this.fromY, (double)this.toY, this.fromValue, this.toValue);
        }

        @Override
        public double minValue() {
            return Math.min(this.fromValue, this.toValue);
        }

        @Override
        public double maxValue() {
            return Math.max(this.fromValue, this.toValue);
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    record Ap2(TwoArgumentSimpleFunction.Type type, DensityFunction argument1, DensityFunction argument2, double minValue, double maxValue) implements TwoArgumentSimpleFunction
    {
        @Override
        public double compute(DensityFunction.FunctionContext p_208410_) {
            double $$1 = this.argument1.compute(p_208410_);
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> $$1 + this.argument2.compute(p_208410_);
                case 1 -> {
                    if ($$1 == 0.0) {
                        yield 0.0;
                    }
                    yield $$1 * this.argument2.compute(p_208410_);
                }
                case 2 -> {
                    if ($$1 < this.argument2.minValue()) {
                        yield $$1;
                    }
                    yield Math.min($$1, this.argument2.compute(p_208410_));
                }
                case 3 -> $$1 > this.argument2.maxValue() ? $$1 : Math.max($$1, this.argument2.compute(p_208410_));
            };
        }

        @Override
        public void fillArray(double[] p_208414_, DensityFunction.ContextProvider p_208415_) {
            this.argument1.fillArray(p_208414_, p_208415_);
            switch (this.type.ordinal()) {
                case 0: {
                    double[] $$2 = new double[p_208414_.length];
                    this.argument2.fillArray($$2, p_208415_);
                    for (int $$3 = 0; $$3 < p_208414_.length; ++$$3) {
                        p_208414_[$$3] = p_208414_[$$3] + $$2[$$3];
                    }
                    break;
                }
                case 1: {
                    for (int $$4 = 0; $$4 < p_208414_.length; ++$$4) {
                        double $$5 = p_208414_[$$4];
                        p_208414_[$$4] = $$5 == 0.0 ? 0.0 : $$5 * this.argument2.compute(p_208415_.forIndex($$4));
                    }
                    break;
                }
                case 2: {
                    double $$6 = this.argument2.minValue();
                    for (int $$7 = 0; $$7 < p_208414_.length; ++$$7) {
                        double $$8 = p_208414_[$$7];
                        p_208414_[$$7] = $$8 < $$6 ? $$8 : Math.min($$8, this.argument2.compute(p_208415_.forIndex($$7)));
                    }
                    break;
                }
                case 3: {
                    double $$9 = this.argument2.maxValue();
                    for (int $$10 = 0; $$10 < p_208414_.length; ++$$10) {
                        double $$11 = p_208414_[$$10];
                        p_208414_[$$10] = $$11 > $$9 ? $$11 : Math.max($$11, this.argument2.compute(p_208415_.forIndex($$10)));
                    }
                    break;
                }
            }
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208412_) {
            return p_208412_.apply(TwoArgumentSimpleFunction.create(this.type, this.argument1.mapAll(p_208412_), this.argument2.mapAll(p_208412_)));
        }
    }

    record MulOrAdd(Type specificType, DensityFunction input, double minValue, double maxValue, double argument) implements PureTransformer,
    TwoArgumentSimpleFunction
    {
        @Override
        public TwoArgumentSimpleFunction.Type type() {
            return this.specificType == Type.MUL ? TwoArgumentSimpleFunction.Type.MUL : TwoArgumentSimpleFunction.Type.ADD;
        }

        @Override
        public DensityFunction argument1() {
            return DensityFunctions.constant(this.argument);
        }

        @Override
        public DensityFunction argument2() {
            return this.input;
        }

        @Override
        public double transform(double p_208759_) {
            return switch (this.specificType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> p_208759_ * this.argument;
                case 1 -> p_208759_ + this.argument;
            };
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208761_) {
            double $$9;
            double $$8;
            DensityFunction $$1 = this.input.mapAll(p_208761_);
            double $$2 = $$1.minValue();
            double $$3 = $$1.maxValue();
            if (this.specificType == Type.ADD) {
                double $$4 = $$2 + this.argument;
                double $$5 = $$3 + this.argument;
            } else if (this.argument >= 0.0) {
                double $$6 = $$2 * this.argument;
                double $$7 = $$3 * this.argument;
            } else {
                $$8 = $$3 * this.argument;
                $$9 = $$2 * this.argument;
            }
            return new MulOrAdd(this.specificType, $$1, $$8, $$9, this.argument);
        }

        static enum Type {
            MUL,
            ADD;

        }
    }

    static interface ShiftNoise
    extends DensityFunction {
        public DensityFunction.NoiseHolder offsetNoise();

        @Override
        default public double minValue() {
            return -this.maxValue();
        }

        @Override
        default public double maxValue() {
            return this.offsetNoise().maxValue() * 4.0;
        }

        default public double compute(double p_208918_, double p_208919_, double p_208920_) {
            return this.offsetNoise().getValue(p_208918_ * 0.25, p_208919_ * 0.25, p_208920_ * 0.25) * 4.0;
        }

        @Override
        default public void fillArray(double[] p_224103_, DensityFunction.ContextProvider p_224104_) {
            p_224104_.fillAllDirectly(p_224103_, this);
        }
    }

    public static interface MarkerOrMarked
    extends DensityFunction {
        public Marker.Type type();

        public DensityFunction wrapped();

        @Override
        default public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return this.type().codec;
        }

        @Override
        default public DensityFunction mapAll(DensityFunction.Visitor p_224070_) {
            return p_224070_.apply(new Marker(this.type(), this.wrapped().mapAll(p_224070_)));
        }
    }

    @VisibleForDebug
    public record HolderHolder(Holder<DensityFunction> function) implements DensityFunction
    {
        @Override
        public double compute(DensityFunction.FunctionContext p_208641_) {
            return this.function.value().compute(p_208641_);
        }

        @Override
        public void fillArray(double[] p_208645_, DensityFunction.ContextProvider p_208646_) {
            this.function.value().fillArray(p_208645_, p_208646_);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208643_) {
            return p_208643_.apply(new HolderHolder(new Holder.Direct<DensityFunction>(this.function.value().mapAll(p_208643_))));
        }

        @Override
        public double minValue() {
            return this.function.isBound() ? this.function.value().minValue() : Double.NEGATIVE_INFINITY;
        }

        @Override
        public double maxValue() {
            return this.function.isBound() ? this.function.value().maxValue() : Double.POSITIVE_INFINITY;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            throw new UnsupportedOperationException("Calling .codec() on HolderHolder");
        }
    }

    public static interface BeardifierOrMarker
    extends DensityFunction.SimpleFunction {
        public static final KeyDispatchDataCodec<DensityFunction> CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)BeardifierMarker.INSTANCE));

        @Override
        default public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    static interface PureTransformer
    extends DensityFunction {
        public DensityFunction input();

        @Override
        default public double compute(DensityFunction.FunctionContext p_208817_) {
            return this.transform(this.input().compute(p_208817_));
        }

        @Override
        default public void fillArray(double[] p_208819_, DensityFunction.ContextProvider p_208820_) {
            this.input().fillArray(p_208819_, p_208820_);
            for (int $$2 = 0; $$2 < p_208819_.length; ++$$2) {
                p_208819_[$$2] = this.transform(p_208819_[$$2]);
            }
        }

        public double transform(double var1);
    }

    static interface TransformerWithContext
    extends DensityFunction {
        public DensityFunction input();

        @Override
        default public double compute(DensityFunction.FunctionContext p_209065_) {
            return this.transform(p_209065_, this.input().compute(p_209065_));
        }

        @Override
        default public void fillArray(double[] p_209069_, DensityFunction.ContextProvider p_209070_) {
            this.input().fillArray(p_209069_, p_209070_);
            for (int $$2 = 0; $$2 < p_209069_.length; ++$$2) {
                p_209069_[$$2] = this.transform(p_209070_.forIndex($$2), p_209069_[$$2]);
            }
        }

        public double transform(DensityFunction.FunctionContext var1, double var2);
    }
}

