/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.LightningBoltPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.RaiderPredicate;
import net.minecraft.advancements.critereon.SheepPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.phys.Vec3;

public class EntitySubPredicates {
    public static final MapCodec<LightningBoltPredicate> LIGHTNING = EntitySubPredicates.register("lightning", LightningBoltPredicate.CODEC);
    public static final MapCodec<FishingHookPredicate> FISHING_HOOK = EntitySubPredicates.register("fishing_hook", FishingHookPredicate.CODEC);
    public static final MapCodec<PlayerPredicate> PLAYER = EntitySubPredicates.register("player", PlayerPredicate.CODEC);
    public static final MapCodec<SlimePredicate> SLIME = EntitySubPredicates.register("slime", SlimePredicate.CODEC);
    public static final MapCodec<RaiderPredicate> RAIDER = EntitySubPredicates.register("raider", RaiderPredicate.CODEC);
    public static final MapCodec<SheepPredicate> SHEEP = EntitySubPredicates.register("sheep", SheepPredicate.CODEC);
    public static final EntityVariantPredicateType<Axolotl.Variant> AXOLOTL = EntitySubPredicates.register("axolotl", EntityVariantPredicateType.create(Axolotl.Variant.CODEC, p_334010_ -> {
        Optional<Object> optional;
        if (p_334010_ instanceof Axolotl) {
            Axolotl $$1 = (Axolotl)p_334010_;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Fox.Variant> FOX = EntitySubPredicates.register("fox", EntityVariantPredicateType.create(Fox.Variant.CODEC, p_359056_ -> {
        Optional<Object> optional;
        if (p_359056_ instanceof Fox) {
            Fox $$1 = (Fox)p_359056_;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<MushroomCow.Variant> MOOSHROOM = EntitySubPredicates.register("mooshroom", EntityVariantPredicateType.create(MushroomCow.Variant.CODEC, p_359055_ -> {
        Optional<Object> optional;
        if (p_359055_ instanceof MushroomCow) {
            MushroomCow $$1 = (MushroomCow)p_359055_;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Rabbit.Variant> RABBIT = EntitySubPredicates.register("rabbit", EntityVariantPredicateType.create(Rabbit.Variant.CODEC, p_334015_ -> {
        Optional<Object> optional;
        if (p_334015_ instanceof Rabbit) {
            Rabbit $$1 = (Rabbit)p_334015_;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Variant> HORSE = EntitySubPredicates.register("horse", EntityVariantPredicateType.create(Variant.CODEC, p_333729_ -> {
        Optional<Object> optional;
        if (p_333729_ instanceof Horse) {
            Horse $$1 = (Horse)p_333729_;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Llama.Variant> LLAMA = EntitySubPredicates.register("llama", EntityVariantPredicateType.create(Llama.Variant.CODEC, p_334050_ -> {
        Optional<Object> optional;
        if (p_334050_ instanceof Llama) {
            Llama $$1 = (Llama)p_334050_;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<VillagerType> VILLAGER = EntitySubPredicates.register("villager", EntityVariantPredicateType.create(BuiltInRegistries.VILLAGER_TYPE.byNameCodec(), p_333711_ -> {
        Optional<Object> optional;
        if (p_333711_ instanceof VillagerDataHolder) {
            VillagerDataHolder $$1 = (VillagerDataHolder)((Object)p_333711_);
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Parrot.Variant> PARROT = EntitySubPredicates.register("parrot", EntityVariantPredicateType.create(Parrot.Variant.CODEC, p_333734_ -> {
        Optional<Object> optional;
        if (p_333734_ instanceof Parrot) {
            Parrot $$1 = (Parrot)p_333734_;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<Salmon.Variant> SALMON = EntitySubPredicates.register("salmon", EntityVariantPredicateType.create(Salmon.Variant.CODEC, p_372501_ -> {
        Optional<Object> optional;
        if (p_372501_ instanceof Salmon) {
            Salmon $$1 = (Salmon)p_372501_;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityVariantPredicateType<TropicalFish.Pattern> TROPICAL_FISH = EntitySubPredicates.register("tropical_fish", EntityVariantPredicateType.create(TropicalFish.Pattern.CODEC, p_333851_ -> {
        Optional<Object> optional;
        if (p_333851_ instanceof TropicalFish) {
            TropicalFish $$1 = (TropicalFish)p_333851_;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityHolderVariantPredicateType<PaintingVariant> PAINTING = EntitySubPredicates.register("painting", EntityHolderVariantPredicateType.create(Registries.PAINTING_VARIANT, p_333823_ -> {
        Optional<Object> optional;
        if (p_333823_ instanceof Painting) {
            Painting $$1 = (Painting)p_333823_;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityHolderVariantPredicateType<CatVariant> CAT = EntitySubPredicates.register("cat", EntityHolderVariantPredicateType.create(Registries.CAT_VARIANT, p_335157_ -> {
        Optional<Object> optional;
        if (p_335157_ instanceof Cat) {
            Cat $$1 = (Cat)p_335157_;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityHolderVariantPredicateType<FrogVariant> FROG = EntitySubPredicates.register("frog", EntityHolderVariantPredicateType.create(Registries.FROG_VARIANT, p_335158_ -> {
        Optional<Object> optional;
        if (p_335158_ instanceof Frog) {
            Frog $$1 = (Frog)p_335158_;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final EntityHolderVariantPredicateType<WolfVariant> WOLF = EntitySubPredicates.register("wolf", EntityHolderVariantPredicateType.create(Registries.WOLF_VARIANT, p_335156_ -> {
        Optional<Object> optional;
        if (p_335156_ instanceof Wolf) {
            Wolf $$1 = (Wolf)p_335156_;
            optional = Optional.of($$1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));

    private static <T extends EntitySubPredicate> MapCodec<T> register(String p_333791_, MapCodec<T> p_333859_) {
        return Registry.register(BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE, p_333791_, p_333859_);
    }

    private static <V> EntityVariantPredicateType<V> register(String p_333838_, EntityVariantPredicateType<V> p_334081_) {
        Registry.register(BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE, p_333838_, p_334081_.codec);
        return p_334081_;
    }

    private static <V> EntityHolderVariantPredicateType<V> register(String p_335408_, EntityHolderVariantPredicateType<V> p_335914_) {
        Registry.register(BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE, p_335408_, p_335914_.codec);
        return p_335914_;
    }

    public static MapCodec<? extends EntitySubPredicate> bootstrap(Registry<MapCodec<? extends EntitySubPredicate>> p_333899_) {
        return LIGHTNING;
    }

    public static EntitySubPredicate catVariant(Holder<CatVariant> p_335907_) {
        return CAT.createPredicate(HolderSet.direct(p_335907_));
    }

    public static EntitySubPredicate frogVariant(Holder<FrogVariant> p_335714_) {
        return FROG.createPredicate(HolderSet.direct(p_335714_));
    }

    public static EntitySubPredicate wolfVariant(HolderSet<WolfVariant> p_341342_) {
        return WOLF.createPredicate(p_341342_);
    }

    public static class EntityVariantPredicateType<V> {
        final MapCodec<Instance> codec;
        final Function<Entity, Optional<V>> getter;

        public static <V> EntityVariantPredicateType<V> create(Registry<V> p_333921_, Function<Entity, Optional<V>> p_334088_) {
            return new EntityVariantPredicateType<V>(p_333921_.byNameCodec(), p_334088_);
        }

        public static <V> EntityVariantPredicateType<V> create(Codec<V> p_333837_, Function<Entity, Optional<V>> p_334017_) {
            return new EntityVariantPredicateType<V>(p_333837_, p_334017_);
        }

        public EntityVariantPredicateType(Codec<V> p_333738_, Function<Entity, Optional<V>> p_333805_) {
            this.getter = p_333805_;
            this.codec = RecordCodecBuilder.mapCodec(p_333719_ -> p_333719_.group((App)p_333738_.fieldOf("variant").forGetter(p_333753_ -> p_333753_.variant)).apply((Applicative)p_333719_, p_333935_ -> new Instance(p_333935_)));
        }

        public EntitySubPredicate createPredicate(V p_333888_) {
            return new Instance(p_333888_);
        }

        class Instance
        implements EntitySubPredicate {
            final V variant;

            Instance(V p_333871_) {
                this.variant = p_333871_;
            }

            public MapCodec<Instance> codec() {
                return EntityVariantPredicateType.this.codec;
            }

            @Override
            public boolean matches(Entity p_334092_, ServerLevel p_333810_, @Nullable Vec3 p_333907_) {
                return EntityVariantPredicateType.this.getter.apply(p_334092_).filter(this.variant::equals).isPresent();
            }
        }
    }

    public static class EntityHolderVariantPredicateType<V> {
        final MapCodec<Instance> codec;
        final Function<Entity, Optional<Holder<V>>> getter;

        public static <V> EntityHolderVariantPredicateType<V> create(ResourceKey<? extends Registry<V>> p_335749_, Function<Entity, Optional<Holder<V>>> p_336155_) {
            return new EntityHolderVariantPredicateType<V>(p_335749_, p_336155_);
        }

        public EntityHolderVariantPredicateType(ResourceKey<? extends Registry<V>> p_336141_, Function<Entity, Optional<Holder<V>>> p_336167_) {
            this.getter = p_336167_;
            this.codec = RecordCodecBuilder.mapCodec(p_335436_ -> p_335436_.group((App)RegistryCodecs.homogeneousList(p_336141_).fieldOf("variant").forGetter(p_335992_ -> p_335992_.variants)).apply((Applicative)p_335436_, p_335927_ -> new Instance(p_335927_)));
        }

        public EntitySubPredicate createPredicate(HolderSet<V> p_335847_) {
            return new Instance(p_335847_);
        }

        class Instance
        implements EntitySubPredicate {
            final HolderSet<V> variants;

            Instance(HolderSet<V> p_335619_) {
                this.variants = p_335619_;
            }

            public MapCodec<Instance> codec() {
                return EntityHolderVariantPredicateType.this.codec;
            }

            @Override
            public boolean matches(Entity p_335756_, ServerLevel p_335539_, @Nullable Vec3 p_336193_) {
                return EntityHolderVariantPredicateType.this.getter.apply(p_335756_).filter(this.variants::contains).isPresent();
            }
        }
    }
}

