/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;

public record SheepPredicate(Optional<Boolean> sheared, Optional<DyeColor> color) implements EntitySubPredicate
{
    public static final MapCodec<SheepPredicate> CODEC = RecordCodecBuilder.mapCodec(p_368666_ -> p_368666_.group((App)Codec.BOOL.optionalFieldOf("sheared").forGetter(SheepPredicate::sheared), (App)DyeColor.CODEC.optionalFieldOf("color").forGetter(SheepPredicate::color)).apply((Applicative)p_368666_, SheepPredicate::new));

    public MapCodec<SheepPredicate> codec() {
        return EntitySubPredicates.SHEEP;
    }

    @Override
    public boolean matches(Entity p_368517_, ServerLevel p_368673_, @Nullable Vec3 p_368505_) {
        if (p_368517_ instanceof Sheep) {
            Sheep $$3 = (Sheep)p_368517_;
            if (this.sheared.isPresent() && $$3.isSheared() != this.sheared.get().booleanValue()) {
                return false;
            }
            return !this.color.isPresent() || $$3.getColor() == this.color.get();
        }
        return false;
    }

    public static SheepPredicate hasWool(DyeColor p_368724_) {
        return new SheepPredicate(Optional.of(false), Optional.of(p_368724_));
    }
}

