/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.gametest.framework.TestCommand;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundCommandsPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.AdvancementCommands;
import net.minecraft.server.commands.AttributeCommand;
import net.minecraft.server.commands.BanIpCommands;
import net.minecraft.server.commands.BanListCommands;
import net.minecraft.server.commands.BanPlayerCommands;
import net.minecraft.server.commands.BossBarCommands;
import net.minecraft.server.commands.ClearInventoryCommands;
import net.minecraft.server.commands.CloneCommands;
import net.minecraft.server.commands.DamageCommand;
import net.minecraft.server.commands.DataPackCommand;
import net.minecraft.server.commands.DeOpCommands;
import net.minecraft.server.commands.DebugCommand;
import net.minecraft.server.commands.DebugConfigCommand;
import net.minecraft.server.commands.DebugMobSpawningCommand;
import net.minecraft.server.commands.DebugPathCommand;
import net.minecraft.server.commands.DefaultGameModeCommands;
import net.minecraft.server.commands.DifficultyCommand;
import net.minecraft.server.commands.EffectCommands;
import net.minecraft.server.commands.EmoteCommands;
import net.minecraft.server.commands.EnchantCommand;
import net.minecraft.server.commands.ExecuteCommand;
import net.minecraft.server.commands.ExperienceCommand;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.commands.FillCommand;
import net.minecraft.server.commands.ForceLoadCommand;
import net.minecraft.server.commands.FunctionCommand;
import net.minecraft.server.commands.GameModeCommand;
import net.minecraft.server.commands.GameRuleCommand;
import net.minecraft.server.commands.GiveCommand;
import net.minecraft.server.commands.HelpCommand;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.JfrCommand;
import net.minecraft.server.commands.KickCommand;
import net.minecraft.server.commands.KillCommand;
import net.minecraft.server.commands.ListPlayersCommand;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.server.commands.LootCommand;
import net.minecraft.server.commands.MsgCommand;
import net.minecraft.server.commands.OpCommand;
import net.minecraft.server.commands.PardonCommand;
import net.minecraft.server.commands.PardonIpCommand;
import net.minecraft.server.commands.ParticleCommand;
import net.minecraft.server.commands.PerfCommand;
import net.minecraft.server.commands.PlaceCommand;
import net.minecraft.server.commands.PlaySoundCommand;
import net.minecraft.server.commands.PublishCommand;
import net.minecraft.server.commands.RaidCommand;
import net.minecraft.server.commands.RandomCommand;
import net.minecraft.server.commands.RecipeCommand;
import net.minecraft.server.commands.ReloadCommand;
import net.minecraft.server.commands.ReturnCommand;
import net.minecraft.server.commands.RideCommand;
import net.minecraft.server.commands.RotateCommand;
import net.minecraft.server.commands.SaveAllCommand;
import net.minecraft.server.commands.SaveOffCommand;
import net.minecraft.server.commands.SaveOnCommand;
import net.minecraft.server.commands.SayCommand;
import net.minecraft.server.commands.ScheduleCommand;
import net.minecraft.server.commands.ScoreboardCommand;
import net.minecraft.server.commands.SeedCommand;
import net.minecraft.server.commands.ServerPackCommand;
import net.minecraft.server.commands.SetBlockCommand;
import net.minecraft.server.commands.SetPlayerIdleTimeoutCommand;
import net.minecraft.server.commands.SetSpawnCommand;
import net.minecraft.server.commands.SetWorldSpawnCommand;
import net.minecraft.server.commands.SpawnArmorTrimsCommand;
import net.minecraft.server.commands.SpectateCommand;
import net.minecraft.server.commands.SpreadPlayersCommand;
import net.minecraft.server.commands.StopCommand;
import net.minecraft.server.commands.StopSoundCommand;
import net.minecraft.server.commands.SummonCommand;
import net.minecraft.server.commands.TagCommand;
import net.minecraft.server.commands.TeamCommand;
import net.minecraft.server.commands.TeamMsgCommand;
import net.minecraft.server.commands.TeleportCommand;
import net.minecraft.server.commands.TellRawCommand;
import net.minecraft.server.commands.TickCommand;
import net.minecraft.server.commands.TimeCommand;
import net.minecraft.server.commands.TitleCommand;
import net.minecraft.server.commands.TransferCommand;
import net.minecraft.server.commands.TriggerCommand;
import net.minecraft.server.commands.WardenSpawnTrackerCommand;
import net.minecraft.server.commands.WeatherCommand;
import net.minecraft.server.commands.WhitelistCommand;
import net.minecraft.server.commands.WorldBorderCommand;
import net.minecraft.server.commands.data.DataCommands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import org.slf4j.Logger;

public class Commands {
    private static final ThreadLocal<ExecutionContext<CommandSourceStack>> CURRENT_EXECUTION_CONTEXT = new ThreadLocal();
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_MODERATORS = 1;
    public static final int LEVEL_GAMEMASTERS = 2;
    public static final int LEVEL_ADMINS = 3;
    public static final int LEVEL_OWNERS = 4;
    private final CommandDispatcher<CommandSourceStack> dispatcher = new CommandDispatcher();

    public Commands(CommandSelection p_230943_, CommandBuildContext p_230944_) {
        AdvancementCommands.register(this.dispatcher);
        AttributeCommand.register(this.dispatcher, p_230944_);
        ExecuteCommand.register(this.dispatcher, p_230944_);
        BossBarCommands.register(this.dispatcher, p_230944_);
        ClearInventoryCommands.register(this.dispatcher, p_230944_);
        CloneCommands.register(this.dispatcher, p_230944_);
        DamageCommand.register(this.dispatcher, p_230944_);
        DataCommands.register(this.dispatcher);
        DataPackCommand.register(this.dispatcher);
        DebugCommand.register(this.dispatcher);
        DefaultGameModeCommands.register(this.dispatcher);
        DifficultyCommand.register(this.dispatcher);
        EffectCommands.register(this.dispatcher, p_230944_);
        EmoteCommands.register(this.dispatcher);
        EnchantCommand.register(this.dispatcher, p_230944_);
        ExperienceCommand.register(this.dispatcher);
        FillCommand.register(this.dispatcher, p_230944_);
        FillBiomeCommand.register(this.dispatcher, p_230944_);
        ForceLoadCommand.register(this.dispatcher);
        FunctionCommand.register(this.dispatcher);
        GameModeCommand.register(this.dispatcher);
        GameRuleCommand.register(this.dispatcher, p_230944_);
        GiveCommand.register(this.dispatcher, p_230944_);
        HelpCommand.register(this.dispatcher);
        ItemCommands.register(this.dispatcher, p_230944_);
        KickCommand.register(this.dispatcher);
        KillCommand.register(this.dispatcher);
        ListPlayersCommand.register(this.dispatcher);
        LocateCommand.register(this.dispatcher, p_230944_);
        LootCommand.register(this.dispatcher, p_230944_);
        MsgCommand.register(this.dispatcher);
        ParticleCommand.register(this.dispatcher, p_230944_);
        PlaceCommand.register(this.dispatcher);
        PlaySoundCommand.register(this.dispatcher);
        RandomCommand.register(this.dispatcher);
        ReloadCommand.register(this.dispatcher);
        RecipeCommand.register(this.dispatcher);
        ReturnCommand.register(this.dispatcher);
        RideCommand.register(this.dispatcher);
        RotateCommand.register(this.dispatcher);
        SayCommand.register(this.dispatcher);
        ScheduleCommand.register(this.dispatcher);
        ScoreboardCommand.register(this.dispatcher, p_230944_);
        SeedCommand.register(this.dispatcher, p_230943_ != CommandSelection.INTEGRATED);
        SetBlockCommand.register(this.dispatcher, p_230944_);
        SetSpawnCommand.register(this.dispatcher);
        SetWorldSpawnCommand.register(this.dispatcher);
        SpectateCommand.register(this.dispatcher);
        SpreadPlayersCommand.register(this.dispatcher);
        StopSoundCommand.register(this.dispatcher);
        SummonCommand.register(this.dispatcher, p_230944_);
        TagCommand.register(this.dispatcher);
        TeamCommand.register(this.dispatcher, p_230944_);
        TeamMsgCommand.register(this.dispatcher);
        TeleportCommand.register(this.dispatcher);
        TellRawCommand.register(this.dispatcher, p_230944_);
        TickCommand.register(this.dispatcher);
        TimeCommand.register(this.dispatcher);
        TitleCommand.register(this.dispatcher, p_230944_);
        TriggerCommand.register(this.dispatcher);
        WeatherCommand.register(this.dispatcher);
        WorldBorderCommand.register(this.dispatcher);
        if (JvmProfiler.INSTANCE.isAvailable()) {
            JfrCommand.register(this.dispatcher);
        }
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            TestCommand.register(this.dispatcher);
            RaidCommand.register(this.dispatcher, p_230944_);
            DebugPathCommand.register(this.dispatcher);
            DebugMobSpawningCommand.register(this.dispatcher);
            WardenSpawnTrackerCommand.register(this.dispatcher);
            SpawnArmorTrimsCommand.register(this.dispatcher);
            ServerPackCommand.register(this.dispatcher);
            if (p_230943_.includeDedicated) {
                DebugConfigCommand.register(this.dispatcher);
            }
        }
        if (p_230943_.includeDedicated) {
            BanIpCommands.register(this.dispatcher);
            BanListCommands.register(this.dispatcher);
            BanPlayerCommands.register(this.dispatcher);
            DeOpCommands.register(this.dispatcher);
            OpCommand.register(this.dispatcher);
            PardonCommand.register(this.dispatcher);
            PardonIpCommand.register(this.dispatcher);
            PerfCommand.register(this.dispatcher);
            SaveAllCommand.register(this.dispatcher);
            SaveOffCommand.register(this.dispatcher);
            SaveOnCommand.register(this.dispatcher);
            SetPlayerIdleTimeoutCommand.register(this.dispatcher);
            StopCommand.register(this.dispatcher);
            TransferCommand.register(this.dispatcher);
            WhitelistCommand.register(this.dispatcher);
        }
        if (p_230943_.includeIntegrated) {
            PublishCommand.register(this.dispatcher);
        }
        this.dispatcher.setConsumer(ExecutionCommandSource.resultConsumer());
    }

    public static <S> ParseResults<S> mapSource(ParseResults<S> p_242928_, UnaryOperator<S> p_242890_) {
        CommandContextBuilder $$2 = p_242928_.getContext();
        CommandContextBuilder $$3 = $$2.withSource(p_242890_.apply($$2.getSource()));
        return new ParseResults($$3, p_242928_.getReader(), p_242928_.getExceptions());
    }

    public void performPrefixedCommand(CommandSourceStack p_230958_, String p_230959_) {
        p_230959_ = p_230959_.startsWith("/") ? p_230959_.substring(1) : p_230959_;
        this.performCommand((ParseResults<CommandSourceStack>)this.dispatcher.parse(p_230959_, (Object)p_230958_), p_230959_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performCommand(ParseResults<CommandSourceStack> p_242844_, String p_242841_) {
        CommandSourceStack $$2 = (CommandSourceStack)p_242844_.getContext().getSource();
        Profiler.get().push(() -> "/" + p_242841_);
        ContextChain<CommandSourceStack> $$3 = Commands.finishParsing(p_242844_, p_242841_, $$2);
        try {
            if ($$3 != null) {
                Commands.executeCommandInContext($$2, p_309417_ -> ExecutionContext.queueInitialCommandExecution(p_309417_, p_242841_, $$3, $$2, CommandResultCallback.EMPTY));
            }
        }
        catch (Exception $$4) {
            MutableComponent $$5 = Component.literal($$4.getMessage() == null ? $$4.getClass().getName() : $$4.getMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("Command exception: /{}", (Object)p_242841_, (Object)$$4);
                StackTraceElement[] $$6 = $$4.getStackTrace();
                for (int $$7 = 0; $$7 < Math.min($$6.length, 3); ++$$7) {
                    $$5.append("\n\n").append($$6[$$7].getMethodName()).append("\n ").append($$6[$$7].getFileName()).append(":").append(String.valueOf($$6[$$7].getLineNumber()));
                }
            }
            $$2.sendFailure(Component.translatable("command.failed").withStyle(p_82137_ -> p_82137_.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, $$5))));
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                $$2.sendFailure(Component.literal(Util.describeError($$4)));
                LOGGER.error("'/{}' threw an exception", (Object)p_242841_, (Object)$$4);
            }
        }
        finally {
            Profiler.get().pop();
        }
    }

    @Nullable
    private static ContextChain<CommandSourceStack> finishParsing(ParseResults<CommandSourceStack> p_307220_, String p_307311_, CommandSourceStack p_307676_) {
        try {
            Commands.validateParseResults(p_307220_);
            return (ContextChain)ContextChain.tryFlatten((CommandContext)p_307220_.getContext().build(p_307311_)).orElseThrow(() -> CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(p_307220_.getReader()));
        }
        catch (CommandSyntaxException $$3) {
            p_307676_.sendFailure(ComponentUtils.fromMessage($$3.getRawMessage()));
            if ($$3.getInput() != null && $$3.getCursor() >= 0) {
                int $$4 = Math.min($$3.getInput().length(), $$3.getCursor());
                MutableComponent $$5 = Component.empty().withStyle(ChatFormatting.GRAY).withStyle(p_82134_ -> p_82134_.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + p_307311_)));
                if ($$4 > 10) {
                    $$5.append(CommonComponents.ELLIPSIS);
                }
                $$5.append($$3.getInput().substring(Math.max(0, $$4 - 10), $$4));
                if ($$4 < $$3.getInput().length()) {
                    MutableComponent $$6 = Component.literal($$3.getInput().substring($$4)).withStyle(ChatFormatting.RED, ChatFormatting.UNDERLINE);
                    $$5.append($$6);
                }
                $$5.append(Component.translatable("command.context.here").withStyle(ChatFormatting.RED, ChatFormatting.ITALIC));
                p_307676_.sendFailure($$5);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeCommandInContext(CommandSourceStack p_306118_, Consumer<ExecutionContext<CommandSourceStack>> p_306332_) {
        block9: {
            boolean $$4;
            MinecraftServer $$2 = p_306118_.getServer();
            ExecutionContext<CommandSourceStack> $$3 = CURRENT_EXECUTION_CONTEXT.get();
            boolean bl = $$4 = $$3 == null;
            if ($$4) {
                int $$5 = Math.max(1, $$2.getGameRules().getInt(GameRules.RULE_MAX_COMMAND_CHAIN_LENGTH));
                int $$6 = $$2.getGameRules().getInt(GameRules.RULE_MAX_COMMAND_FORK_COUNT);
                try (ExecutionContext $$7 = new ExecutionContext($$5, $$6, Profiler.get());){
                    CURRENT_EXECUTION_CONTEXT.set($$7);
                    p_306332_.accept($$7);
                    $$7.runCommandQueue();
                    break block9;
                }
                finally {
                    CURRENT_EXECUTION_CONTEXT.set(null);
                }
            }
            p_306332_.accept($$3);
        }
    }

    public void sendCommands(ServerPlayer p_82096_) {
        HashMap $$1 = Maps.newHashMap();
        RootCommandNode $$2 = new RootCommandNode();
        $$1.put(this.dispatcher.getRoot(), $$2);
        this.fillUsableCommands((CommandNode<CommandSourceStack>)this.dispatcher.getRoot(), (CommandNode<SharedSuggestionProvider>)$$2, p_82096_.createCommandSourceStack(), $$1);
        p_82096_.connection.send(new ClientboundCommandsPacket((RootCommandNode<SharedSuggestionProvider>)$$2));
    }

    private void fillUsableCommands(CommandNode<CommandSourceStack> p_82113_, CommandNode<SharedSuggestionProvider> p_82114_, CommandSourceStack p_82115_, Map<CommandNode<CommandSourceStack>, CommandNode<SharedSuggestionProvider>> p_82116_) {
        for (CommandNode $$4 : p_82113_.getChildren()) {
            RequiredArgumentBuilder $$6;
            if (!$$4.canUse((Object)p_82115_)) continue;
            ArgumentBuilder $$5 = $$4.createBuilder();
            $$5.requires(p_82126_ -> true);
            if ($$5.getCommand() != null) {
                $$5.executes(p_82102_ -> 0);
            }
            if ($$5 instanceof RequiredArgumentBuilder && ($$6 = (RequiredArgumentBuilder)$$5).getSuggestionsProvider() != null) {
                $$6.suggests(SuggestionProviders.safelySwap((SuggestionProvider<SharedSuggestionProvider>)$$6.getSuggestionsProvider()));
            }
            if ($$5.getRedirect() != null) {
                $$5.redirect(p_82116_.get($$5.getRedirect()));
            }
            CommandNode $$7 = $$5.build();
            p_82116_.put((CommandNode<CommandSourceStack>)$$4, (CommandNode<SharedSuggestionProvider>)$$7);
            p_82114_.addChild($$7);
            if ($$4.getChildren().isEmpty()) continue;
            this.fillUsableCommands((CommandNode<CommandSourceStack>)$$4, (CommandNode<SharedSuggestionProvider>)$$7, p_82115_, p_82116_);
        }
    }

    public static LiteralArgumentBuilder<CommandSourceStack> literal(String p_82128_) {
        return LiteralArgumentBuilder.literal((String)p_82128_);
    }

    public static <T> RequiredArgumentBuilder<CommandSourceStack, T> argument(String p_82130_, ArgumentType<T> p_82131_) {
        return RequiredArgumentBuilder.argument((String)p_82130_, p_82131_);
    }

    public static Predicate<String> createValidator(ParseFunction p_82121_) {
        return p_82124_ -> {
            try {
                p_82121_.parse(new StringReader(p_82124_));
                return true;
            }
            catch (CommandSyntaxException $$2) {
                return false;
            }
        };
    }

    public CommandDispatcher<CommandSourceStack> getDispatcher() {
        return this.dispatcher;
    }

    public static <S> void validateParseResults(ParseResults<S> p_306093_) throws CommandSyntaxException {
        CommandSyntaxException $$1 = Commands.getParseException(p_306093_);
        if ($$1 != null) {
            throw $$1;
        }
    }

    @Nullable
    public static <S> CommandSyntaxException getParseException(ParseResults<S> p_82098_) {
        if (!p_82098_.getReader().canRead()) {
            return null;
        }
        if (p_82098_.getExceptions().size() == 1) {
            return (CommandSyntaxException)((Object)p_82098_.getExceptions().values().iterator().next());
        }
        if (p_82098_.getContext().getRange().isEmpty()) {
            return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(p_82098_.getReader());
        }
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(p_82098_.getReader());
    }

    public static CommandBuildContext createValidationContext(final HolderLookup.Provider p_256243_) {
        return new CommandBuildContext(){

            @Override
            public FeatureFlagSet enabledFeatures() {
                return FeatureFlags.REGISTRY.allFlags();
            }

            @Override
            public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
                return p_256243_.listRegistryKeys();
            }

            public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_323467_) {
                return p_256243_.lookup(p_323467_).map(this::createLookup);
            }

            private <T> HolderLookup.RegistryLookup.Delegate<T> createLookup(final HolderLookup.RegistryLookup<T> p_323830_) {
                return new HolderLookup.RegistryLookup.Delegate<T>(this){

                    @Override
                    public HolderLookup.RegistryLookup<T> parent() {
                        return p_323830_;
                    }

                    @Override
                    public Optional<HolderSet.Named<T>> get(TagKey<T> p_255936_) {
                        return Optional.of(this.getOrThrow(p_255936_));
                    }

                    @Override
                    public HolderSet.Named<T> getOrThrow(TagKey<T> p_255953_) {
                        Optional<HolderSet.Named<HolderSet.Named>> $$1 = this.parent().get(p_255953_);
                        return $$1.orElseGet(() -> HolderSet.emptyNamed(this.parent(), p_255953_));
                    }
                };
            }
        };
    }

    public static void validate() {
        CommandBuildContext $$0 = Commands.createValidationContext(VanillaRegistries.createLookup());
        CommandDispatcher<CommandSourceStack> $$1 = new Commands(CommandSelection.ALL, $$0).getDispatcher();
        RootCommandNode $$2 = $$1.getRoot();
        $$1.findAmbiguities((p_230947_, p_230948_, p_230949_, p_230950_) -> LOGGER.warn("Ambiguity between arguments {} and {} with inputs: {}", new Object[]{$$1.getPath(p_230948_), $$1.getPath(p_230949_), p_230950_}));
        Set<ArgumentType<?>> $$3 = ArgumentUtils.findUsedArgumentTypes($$2);
        Set $$4 = $$3.stream().filter(p_339316_ -> !ArgumentTypeInfos.isClassRecognized(p_339316_.getClass())).collect(Collectors.toSet());
        if (!$$4.isEmpty()) {
            LOGGER.warn("Missing type registration for following arguments:\n {}", (Object)$$4.stream().map(p_339315_ -> "\t" + String.valueOf(p_339315_)).collect(Collectors.joining(",\n")));
            throw new IllegalStateException("Unregistered argument types");
        }
    }

    public static enum CommandSelection {
        ALL(true, true),
        DEDICATED(false, true),
        INTEGRATED(true, false);

        final boolean includeIntegrated;
        final boolean includeDedicated;

        private CommandSelection(boolean p_82151_, boolean p_82152_) {
            this.includeIntegrated = p_82151_;
            this.includeDedicated = p_82152_;
        }
    }

    @FunctionalInterface
    public static interface ParseFunction {
        public void parse(StringReader var1) throws CommandSyntaxException;
    }
}

