/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector.options;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.WrappedMinMaxBounds;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Team;

public class EntitySelectorOptions {
    private static final Map<String, Option> OPTIONS = Maps.newHashMap();
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_OPTION = new DynamicCommandExceptionType(p_304141_ -> Component.translatableEscape("argument.entity.options.unknown", p_304141_));
    public static final DynamicCommandExceptionType ERROR_INAPPLICABLE_OPTION = new DynamicCommandExceptionType(p_304138_ -> Component.translatableEscape("argument.entity.options.inapplicable", p_304138_));
    public static final SimpleCommandExceptionType ERROR_RANGE_NEGATIVE = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.options.distance.negative"));
    public static final SimpleCommandExceptionType ERROR_LEVEL_NEGATIVE = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.options.level.negative"));
    public static final SimpleCommandExceptionType ERROR_LIMIT_TOO_SMALL = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.options.limit.toosmall"));
    public static final DynamicCommandExceptionType ERROR_SORT_UNKNOWN = new DynamicCommandExceptionType(p_304139_ -> Component.translatableEscape("argument.entity.options.sort.irreversible", p_304139_));
    public static final DynamicCommandExceptionType ERROR_GAME_MODE_INVALID = new DynamicCommandExceptionType(p_304140_ -> Component.translatableEscape("argument.entity.options.mode.invalid", p_304140_));
    public static final DynamicCommandExceptionType ERROR_ENTITY_TYPE_INVALID = new DynamicCommandExceptionType(p_304137_ -> Component.translatableEscape("argument.entity.options.type.invalid", p_304137_));

    private static void register(String p_121454_, Modifier p_121455_, Predicate<EntitySelectorParser> p_121456_, Component p_121457_) {
        OPTIONS.put(p_121454_, new Option(p_121455_, p_121456_, p_121457_));
    }

    public static void bootStrap() {
        if (!OPTIONS.isEmpty()) {
            return;
        }
        EntitySelectorOptions.register("name", p_360473_ -> {
            int $$1 = p_360473_.getReader().getCursor();
            boolean $$2 = p_360473_.shouldInvertValue();
            String $$3 = p_360473_.getReader().readString();
            if (p_360473_.hasNameNotEquals() && !$$2) {
                p_360473_.getReader().setCursor($$1);
                throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)p_360473_.getReader(), (Object)"name");
            }
            if ($$2) {
                p_360473_.setHasNameNotEquals(true);
            } else {
                p_360473_.setHasNameEquals(true);
            }
            p_360473_.addPredicate(p_175209_ -> p_175209_.getName().getString().equals($$3) != $$2);
        }, p_121423_ -> !p_121423_.hasNameEquals(), Component.translatable("argument.entity.options.name.description"));
        EntitySelectorOptions.register("distance", p_329818_ -> {
            int $$1 = p_329818_.getReader().getCursor();
            MinMaxBounds.Doubles $$2 = MinMaxBounds.Doubles.fromReader(p_329818_.getReader());
            if ($$2.min().isPresent() && $$2.min().get() < 0.0 || $$2.max().isPresent() && $$2.max().get() < 0.0) {
                p_329818_.getReader().setCursor($$1);
                throw ERROR_RANGE_NEGATIVE.createWithContext((ImmutableStringReader)p_329818_.getReader());
            }
            p_329818_.setDistance($$2);
            p_329818_.setWorldLimited();
        }, p_121419_ -> p_121419_.getDistance().isAny(), Component.translatable("argument.entity.options.distance.description"));
        EntitySelectorOptions.register("level", p_121417_ -> {
            int $$1 = p_121417_.getReader().getCursor();
            MinMaxBounds.Ints $$2 = MinMaxBounds.Ints.fromReader(p_121417_.getReader());
            if ($$2.min().isPresent() && $$2.min().get() < 0 || $$2.max().isPresent() && $$2.max().get() < 0) {
                p_121417_.getReader().setCursor($$1);
                throw ERROR_LEVEL_NEGATIVE.createWithContext((ImmutableStringReader)p_121417_.getReader());
            }
            p_121417_.setLevel($$2);
            p_121417_.setIncludesEntities(false);
        }, p_121415_ -> p_121415_.getLevel().isAny(), Component.translatable("argument.entity.options.level.description"));
        EntitySelectorOptions.register("x", p_121413_ -> {
            p_121413_.setWorldLimited();
            p_121413_.setX(p_121413_.getReader().readDouble());
        }, p_121411_ -> p_121411_.getX() == null, Component.translatable("argument.entity.options.x.description"));
        EntitySelectorOptions.register("y", p_121409_ -> {
            p_121409_.setWorldLimited();
            p_121409_.setY(p_121409_.getReader().readDouble());
        }, p_121407_ -> p_121407_.getY() == null, Component.translatable("argument.entity.options.y.description"));
        EntitySelectorOptions.register("z", p_121405_ -> {
            p_121405_.setWorldLimited();
            p_121405_.setZ(p_121405_.getReader().readDouble());
        }, p_121403_ -> p_121403_.getZ() == null, Component.translatable("argument.entity.options.z.description"));
        EntitySelectorOptions.register("dx", p_121401_ -> {
            p_121401_.setWorldLimited();
            p_121401_.setDeltaX(p_121401_.getReader().readDouble());
        }, p_121399_ -> p_121399_.getDeltaX() == null, Component.translatable("argument.entity.options.dx.description"));
        EntitySelectorOptions.register("dy", p_121397_ -> {
            p_121397_.setWorldLimited();
            p_121397_.setDeltaY(p_121397_.getReader().readDouble());
        }, p_121395_ -> p_121395_.getDeltaY() == null, Component.translatable("argument.entity.options.dy.description"));
        EntitySelectorOptions.register("dz", p_121562_ -> {
            p_121562_.setWorldLimited();
            p_121562_.setDeltaZ(p_121562_.getReader().readDouble());
        }, p_121560_ -> p_121560_.getDeltaZ() == null, Component.translatable("argument.entity.options.dz.description"));
        EntitySelectorOptions.register("x_rotation", p_121558_ -> p_121558_.setRotX(WrappedMinMaxBounds.fromReader(p_121558_.getReader(), true, Mth::wrapDegrees)), p_121556_ -> p_121556_.getRotX() == WrappedMinMaxBounds.ANY, Component.translatable("argument.entity.options.x_rotation.description"));
        EntitySelectorOptions.register("y_rotation", p_121554_ -> p_121554_.setRotY(WrappedMinMaxBounds.fromReader(p_121554_.getReader(), true, Mth::wrapDegrees)), p_121552_ -> p_121552_.getRotY() == WrappedMinMaxBounds.ANY, Component.translatable("argument.entity.options.y_rotation.description"));
        EntitySelectorOptions.register("limit", p_121550_ -> {
            int $$1 = p_121550_.getReader().getCursor();
            int $$2 = p_121550_.getReader().readInt();
            if ($$2 < 1) {
                p_121550_.getReader().setCursor($$1);
                throw ERROR_LIMIT_TOO_SMALL.createWithContext((ImmutableStringReader)p_121550_.getReader());
            }
            p_121550_.setMaxResults($$2);
            p_121550_.setLimited(true);
        }, p_121548_ -> !p_121548_.isCurrentEntity() && !p_121548_.isLimited(), Component.translatable("argument.entity.options.limit.description"));
        EntitySelectorOptions.register("sort", p_247983_ -> {
            int $$1 = p_247983_.getReader().getCursor();
            String $$2 = p_247983_.getReader().readUnquotedString();
            p_247983_.setSuggestions((p_175153_, p_175154_) -> SharedSuggestionProvider.suggest(Arrays.asList("nearest", "furthest", "random", "arbitrary"), p_175153_));
            p_247983_.setOrder(switch ($$2) {
                case "nearest" -> EntitySelectorParser.ORDER_NEAREST;
                case "furthest" -> EntitySelectorParser.ORDER_FURTHEST;
                case "random" -> EntitySelectorParser.ORDER_RANDOM;
                case "arbitrary" -> EntitySelector.ORDER_ARBITRARY;
                default -> {
                    p_247983_.getReader().setCursor($$1);
                    throw ERROR_SORT_UNKNOWN.createWithContext((ImmutableStringReader)p_247983_.getReader(), (Object)$$2);
                }
            });
            p_247983_.setSorted(true);
        }, p_121544_ -> !p_121544_.isCurrentEntity() && !p_121544_.isSorted(), Component.translatable("argument.entity.options.sort.description"));
        EntitySelectorOptions.register("gamemode", p_121542_ -> {
            p_121542_.setSuggestions((p_175193_, p_175194_) -> {
                String $$3 = p_175193_.getRemaining().toLowerCase(Locale.ROOT);
                boolean $$4 = !p_121542_.hasGamemodeNotEquals();
                boolean $$5 = true;
                if (!$$3.isEmpty()) {
                    if ($$3.charAt(0) == '!') {
                        $$4 = false;
                        $$3 = $$3.substring(1);
                    } else {
                        $$5 = false;
                    }
                }
                for (GameType $$6 : GameType.values()) {
                    if (!$$6.getName().toLowerCase(Locale.ROOT).startsWith($$3)) continue;
                    if ($$5) {
                        p_175193_.suggest("!" + $$6.getName());
                    }
                    if (!$$4) continue;
                    p_175193_.suggest($$6.getName());
                }
                return p_175193_.buildFuture();
            });
            int $$1 = p_121542_.getReader().getCursor();
            boolean $$2 = p_121542_.shouldInvertValue();
            if (p_121542_.hasGamemodeNotEquals() && !$$2) {
                p_121542_.getReader().setCursor($$1);
                throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)p_121542_.getReader(), (Object)"gamemode");
            }
            String $$3 = p_121542_.getReader().readUnquotedString();
            GameType $$4 = GameType.byName($$3, null);
            if ($$4 == null) {
                p_121542_.getReader().setCursor($$1);
                throw ERROR_GAME_MODE_INVALID.createWithContext((ImmutableStringReader)p_121542_.getReader(), (Object)$$3);
            }
            p_121542_.setIncludesEntities(false);
            p_121542_.addPredicate(p_175190_ -> {
                if (!(p_175190_ instanceof ServerPlayer)) {
                    return false;
                }
                GameType $$3 = ((ServerPlayer)p_175190_).gameMode.getGameModeForPlayer();
                return $$2 ? $$3 != $$4 : $$3 == $$4;
            });
            if ($$2) {
                p_121542_.setHasGamemodeNotEquals(true);
            } else {
                p_121542_.setHasGamemodeEquals(true);
            }
        }, p_121540_ -> !p_121540_.hasGamemodeEquals(), Component.translatable("argument.entity.options.gamemode.description"));
        EntitySelectorOptions.register("team", p_121538_ -> {
            boolean $$1 = p_121538_.shouldInvertValue();
            String $$2 = p_121538_.getReader().readUnquotedString();
            p_121538_.addPredicate(p_305654_ -> {
                if (!(p_305654_ instanceof LivingEntity)) {
                    return false;
                }
                PlayerTeam $$3 = p_305654_.getTeam();
                String $$4 = $$3 == null ? "" : ((Team)$$3).getName();
                return $$4.equals($$2) != $$1;
            });
            if ($$1) {
                p_121538_.setHasTeamNotEquals(true);
            } else {
                p_121538_.setHasTeamEquals(true);
            }
        }, p_121536_ -> !p_121536_.hasTeamEquals(), Component.translatable("argument.entity.options.team.description"));
        EntitySelectorOptions.register("type", p_121534_ -> {
            p_121534_.setSuggestions((p_367798_, p_367799_) -> {
                SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.keySet(), p_367798_, String.valueOf('!'));
                SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.getTags().map(p_359327_ -> p_359327_.key().location()), p_367798_, "!#");
                if (!p_121534_.isTypeLimitedInversely()) {
                    SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.keySet(), p_367798_);
                    SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.getTags().map(p_359326_ -> p_359326_.key().location()), p_367798_, String.valueOf('#'));
                }
                return p_367798_.buildFuture();
            });
            int $$1 = p_121534_.getReader().getCursor();
            boolean $$2 = p_121534_.shouldInvertValue();
            if (p_121534_.isTypeLimitedInversely() && !$$2) {
                p_121534_.getReader().setCursor($$1);
                throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)p_121534_.getReader(), (Object)"type");
            }
            if ($$2) {
                p_121534_.setTypeLimitedInversely();
            }
            if (p_121534_.isTag()) {
                TagKey<EntityType<?>> $$3 = TagKey.create(Registries.ENTITY_TYPE, ResourceLocation.read(p_121534_.getReader()));
                p_121534_.addPredicate(p_205691_ -> p_205691_.getType().is($$3) != $$2);
            } else {
                ResourceLocation $$4 = ResourceLocation.read(p_121534_.getReader());
                EntityType $$5 = (EntityType)BuiltInRegistries.ENTITY_TYPE.getOptional($$4).orElseThrow(() -> {
                    p_121534_.getReader().setCursor($$1);
                    return ERROR_ENTITY_TYPE_INVALID.createWithContext((ImmutableStringReader)p_121534_.getReader(), (Object)$$4.toString());
                });
                if (Objects.equals(EntityType.PLAYER, $$5) && !$$2) {
                    p_121534_.setIncludesEntities(false);
                }
                p_121534_.addPredicate(p_175151_ -> Objects.equals($$5, p_175151_.getType()) != $$2);
                if (!$$2) {
                    p_121534_.limitToType($$5);
                }
            }
        }, p_121532_ -> !p_121532_.isTypeLimited(), Component.translatable("argument.entity.options.type.description"));
        EntitySelectorOptions.register("tag", p_121530_ -> {
            boolean $$1 = p_121530_.shouldInvertValue();
            String $$2 = p_121530_.getReader().readUnquotedString();
            p_121530_.addPredicate(p_175166_ -> {
                if ("".equals($$2)) {
                    return p_175166_.getTags().isEmpty() != $$1;
                }
                return p_175166_.getTags().contains($$2) != $$1;
            });
        }, p_121528_ -> true, Component.translatable("argument.entity.options.tag.description"));
        EntitySelectorOptions.register("nbt", p_121526_ -> {
            boolean $$1 = p_121526_.shouldInvertValue();
            CompoundTag $$2 = new TagParser(p_121526_.getReader()).readStruct();
            p_121526_.addPredicate(p_332177_ -> {
                ServerPlayer $$4;
                ItemStack $$5;
                CompoundTag $$3 = p_332177_.saveWithoutId(new CompoundTag());
                if (p_332177_ instanceof ServerPlayer && !($$5 = ($$4 = (ServerPlayer)p_332177_).getInventory().getSelected()).isEmpty()) {
                    $$3.put("SelectedItem", $$5.save($$4.registryAccess()));
                }
                return NbtUtils.compareNbt($$2, $$3, true) != $$1;
            });
        }, p_121524_ -> true, Component.translatable("argument.entity.options.nbt.description"));
        EntitySelectorOptions.register("scores", p_121522_ -> {
            StringReader $$1 = p_121522_.getReader();
            HashMap $$2 = Maps.newHashMap();
            $$1.expect('{');
            $$1.skipWhitespace();
            while ($$1.canRead() && $$1.peek() != '}') {
                $$1.skipWhitespace();
                String $$3 = $$1.readUnquotedString();
                $$1.skipWhitespace();
                $$1.expect('=');
                $$1.skipWhitespace();
                MinMaxBounds.Ints $$4 = MinMaxBounds.Ints.fromReader($$1);
                $$2.put($$3, $$4);
                $$1.skipWhitespace();
                if (!$$1.canRead() || $$1.peek() != ',') continue;
                $$1.skip();
            }
            $$1.expect('}');
            if (!$$2.isEmpty()) {
                p_121522_.addPredicate(p_313453_ -> {
                    ServerScoreboard $$2 = p_313453_.getServer().getScoreboard();
                    for (Map.Entry $$3 : $$2.entrySet()) {
                        Objective $$4 = $$2.getObjective((String)$$3.getKey());
                        if ($$4 == null) {
                            return false;
                        }
                        ReadOnlyScoreInfo $$5 = $$2.getPlayerScoreInfo((ScoreHolder)p_313453_, $$4);
                        if ($$5 == null) {
                            return false;
                        }
                        if (((MinMaxBounds.Ints)$$3.getValue()).matches($$5.value())) continue;
                        return false;
                    }
                    return true;
                });
            }
            p_121522_.setHasScores(true);
        }, p_121518_ -> !p_121518_.hasScores(), Component.translatable("argument.entity.options.scores.description"));
        EntitySelectorOptions.register("advancements", p_121514_ -> {
            StringReader $$1 = p_121514_.getReader();
            HashMap $$2 = Maps.newHashMap();
            $$1.expect('{');
            $$1.skipWhitespace();
            while ($$1.canRead() && $$1.peek() != '}') {
                $$1.skipWhitespace();
                ResourceLocation $$3 = ResourceLocation.read($$1);
                $$1.skipWhitespace();
                $$1.expect('=');
                $$1.skipWhitespace();
                if ($$1.canRead() && $$1.peek() == '{') {
                    HashMap $$4 = Maps.newHashMap();
                    $$1.skipWhitespace();
                    $$1.expect('{');
                    $$1.skipWhitespace();
                    while ($$1.canRead() && $$1.peek() != '}') {
                        $$1.skipWhitespace();
                        String $$5 = $$1.readUnquotedString();
                        $$1.skipWhitespace();
                        $$1.expect('=');
                        $$1.skipWhitespace();
                        boolean $$6 = $$1.readBoolean();
                        $$4.put($$5, p_175186_ -> p_175186_.isDone() == $$6);
                        $$1.skipWhitespace();
                        if (!$$1.canRead() || $$1.peek() != ',') continue;
                        $$1.skip();
                    }
                    $$1.skipWhitespace();
                    $$1.expect('}');
                    $$1.skipWhitespace();
                    $$2.put($$3, p_175169_ -> {
                        for (Map.Entry $$2 : $$4.entrySet()) {
                            CriterionProgress $$3 = p_175169_.getCriterion((String)$$2.getKey());
                            if ($$3 != null && ((Predicate)$$2.getValue()).test($$3)) continue;
                            return false;
                        }
                        return true;
                    });
                } else {
                    boolean $$7 = $$1.readBoolean();
                    $$2.put($$3, p_175183_ -> p_175183_.isDone() == $$7);
                }
                $$1.skipWhitespace();
                if (!$$1.canRead() || $$1.peek() != ',') continue;
                $$1.skip();
            }
            $$1.expect('}');
            if (!$$2.isEmpty()) {
                p_121514_.addPredicate(p_359325_ -> {
                    void $$3;
                    if (!(p_359325_ instanceof ServerPlayer)) {
                        return false;
                    }
                    ServerPlayer $$2 = (ServerPlayer)p_359325_;
                    PlayerAdvancements $$4 = $$3.getAdvancements();
                    ServerAdvancementManager $$5 = $$3.getServer().getAdvancements();
                    for (Map.Entry $$6 : $$2.entrySet()) {
                        AdvancementHolder $$7 = $$5.get((ResourceLocation)$$6.getKey());
                        if ($$7 != null && ((Predicate)$$6.getValue()).test($$4.getOrStartProgress($$7))) continue;
                        return false;
                    }
                    return true;
                });
                p_121514_.setIncludesEntities(false);
            }
            p_121514_.setHasAdvancements(true);
        }, p_121506_ -> !p_121506_.hasAdvancements(), Component.translatable("argument.entity.options.advancements.description"));
        EntitySelectorOptions.register("predicate", p_335169_ -> {
            boolean $$1 = p_335169_.shouldInvertValue();
            ResourceKey<LootItemCondition> $$2 = ResourceKey.create(Registries.PREDICATE, ResourceLocation.read(p_335169_.getReader()));
            p_335169_.addPredicate(p_367796_ -> {
                if (!(p_367796_.level() instanceof ServerLevel)) {
                    return false;
                }
                ServerLevel $$3 = (ServerLevel)p_367796_.level();
                Optional<LootItemCondition> $$4 = $$3.getServer().reloadableRegistries().lookup().get($$2).map(Holder::value);
                if ($$4.isEmpty()) {
                    return false;
                }
                LootParams $$5 = new LootParams.Builder($$3).withParameter(LootContextParams.THIS_ENTITY, p_367796_).withParameter(LootContextParams.ORIGIN, p_367796_.position()).create(LootContextParamSets.SELECTOR);
                LootContext $$6 = new LootContext.Builder($$5).create(Optional.empty());
                $$6.pushVisitedElement(LootContext.createVisitedEntry($$4.get()));
                return $$1 ^ $$4.get().test($$6);
            });
        }, p_121435_ -> true, Component.translatable("argument.entity.options.predicate.description"));
    }

    public static Modifier get(EntitySelectorParser p_121448_, String p_121449_, int p_121450_) throws CommandSyntaxException {
        Option $$3 = OPTIONS.get(p_121449_);
        if ($$3 != null) {
            if ($$3.canUse.test(p_121448_)) {
                return $$3.modifier;
            }
            throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)p_121448_.getReader(), (Object)p_121449_);
        }
        p_121448_.getReader().setCursor(p_121450_);
        throw ERROR_UNKNOWN_OPTION.createWithContext((ImmutableStringReader)p_121448_.getReader(), (Object)p_121449_);
    }

    public static void suggestNames(EntitySelectorParser p_121441_, SuggestionsBuilder p_121442_) {
        String $$2 = p_121442_.getRemaining().toLowerCase(Locale.ROOT);
        for (Map.Entry<String, Option> $$3 : OPTIONS.entrySet()) {
            if (!$$3.getValue().canUse.test(p_121441_) || !$$3.getKey().toLowerCase(Locale.ROOT).startsWith($$2)) continue;
            p_121442_.suggest($$3.getKey() + "=", (Message)$$3.getValue().description);
        }
    }

    record Option(Modifier modifier, Predicate<EntitySelectorParser> canUse, Component description) {
    }

    public static interface Modifier {
        public void handle(EntitySelectorParser var1) throws CommandSyntaxException;
    }
}

