/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.RandomSource;

public class MappedRegistry<T>
implements WritableRegistry<T> {
    private final ResourceKey<? extends Registry<T>> key;
    private final ObjectList<Holder.Reference<T>> byId = new ObjectArrayList(256);
    private final Reference2IntMap<T> toId = (Reference2IntMap)Util.make(new Reference2IntOpenHashMap(), p_304142_ -> p_304142_.defaultReturnValue(-1));
    private final Map<ResourceLocation, Holder.Reference<T>> byLocation = new HashMap<ResourceLocation, Holder.Reference<T>>();
    private final Map<ResourceKey<T>, Holder.Reference<T>> byKey = new HashMap<ResourceKey<T>, Holder.Reference<T>>();
    private final Map<T, Holder.Reference<T>> byValue = new IdentityHashMap<T, Holder.Reference<T>>();
    private final Map<ResourceKey<T>, RegistrationInfo> registrationInfos = new IdentityHashMap<ResourceKey<T>, RegistrationInfo>();
    private Lifecycle registryLifecycle;
    private final Map<TagKey<T>, HolderSet.Named<T>> frozenTags = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    TagSet<T> allTags = TagSet.unbound();
    private boolean frozen;
    @Nullable
    private Map<T, Holder.Reference<T>> unregisteredIntrusiveHolders;

    @Override
    public Stream<HolderSet.Named<T>> listTags() {
        return this.getTags();
    }

    public MappedRegistry(ResourceKey<? extends Registry<T>> p_249899_, Lifecycle p_252249_) {
        this(p_249899_, p_252249_, false);
    }

    public MappedRegistry(ResourceKey<? extends Registry<T>> p_252132_, Lifecycle p_249215_, boolean p_251014_) {
        this.key = p_252132_;
        this.registryLifecycle = p_249215_;
        if (p_251014_) {
            this.unregisteredIntrusiveHolders = new IdentityHashMap<T, Holder.Reference<T>>();
        }
    }

    @Override
    public ResourceKey<? extends Registry<T>> key() {
        return this.key;
    }

    public String toString() {
        return "Registry[" + String.valueOf(this.key) + " (" + String.valueOf(this.registryLifecycle) + ")]";
    }

    private void validateWrite() {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen");
        }
    }

    private void validateWrite(ResourceKey<T> p_205922_) {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + String.valueOf(p_205922_) + ")");
        }
    }

    @Override
    public Holder.Reference<T> register(ResourceKey<T> p_256252_, T p_256591_, RegistrationInfo p_326235_) {
        Holder.Reference $$4;
        this.validateWrite(p_256252_);
        Objects.requireNonNull(p_256252_);
        Objects.requireNonNull(p_256591_);
        if (this.byLocation.containsKey(p_256252_.location())) {
            throw Util.pauseInIde(new IllegalStateException("Adding duplicate key '" + String.valueOf(p_256252_) + "' to registry"));
        }
        if (this.byValue.containsKey(p_256591_)) {
            throw Util.pauseInIde(new IllegalStateException("Adding duplicate value '" + String.valueOf(p_256591_) + "' to registry"));
        }
        if (this.unregisteredIntrusiveHolders != null) {
            Holder.Reference<T> $$3 = this.unregisteredIntrusiveHolders.remove(p_256591_);
            if ($$3 == null) {
                throw new AssertionError((Object)("Missing intrusive holder for " + String.valueOf(p_256252_) + ":" + String.valueOf(p_256591_)));
            }
            $$3.bindKey(p_256252_);
        } else {
            $$4 = this.byKey.computeIfAbsent(p_256252_, p_367800_ -> Holder.Reference.createStandAlone(this, p_367800_));
        }
        this.byKey.put(p_256252_, $$4);
        this.byLocation.put(p_256252_.location(), $$4);
        this.byValue.put(p_256591_, $$4);
        int $$5 = this.byId.size();
        this.byId.add((Object)$$4);
        this.toId.put(p_256591_, $$5);
        this.registrationInfos.put(p_256252_, p_326235_);
        this.registryLifecycle = this.registryLifecycle.add(p_326235_.lifecycle());
        return $$4;
    }

    @Override
    @Nullable
    public ResourceLocation getKey(T p_122746_) {
        Holder.Reference<T> $$1 = this.byValue.get(p_122746_);
        return $$1 != null ? $$1.key().location() : null;
    }

    @Override
    public Optional<ResourceKey<T>> getResourceKey(T p_122755_) {
        return Optional.ofNullable(this.byValue.get(p_122755_)).map(Holder.Reference::key);
    }

    @Override
    public int getId(@Nullable T p_122706_) {
        return this.toId.getInt(p_122706_);
    }

    @Override
    @Nullable
    public T getValue(@Nullable ResourceKey<T> p_122714_) {
        return MappedRegistry.getValueFromNullable(this.byKey.get(p_122714_));
    }

    @Override
    @Nullable
    public T byId(int p_122684_) {
        if (p_122684_ < 0 || p_122684_ >= this.byId.size()) {
            return null;
        }
        return ((Holder.Reference)this.byId.get(p_122684_)).value();
    }

    @Override
    public Optional<Holder.Reference<T>> get(int p_205907_) {
        if (p_205907_ < 0 || p_205907_ >= this.byId.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable((Holder.Reference)this.byId.get(p_205907_));
    }

    @Override
    public Optional<Holder.Reference<T>> get(ResourceLocation p_316743_) {
        return Optional.ofNullable(this.byLocation.get(p_316743_));
    }

    @Override
    public Optional<Holder.Reference<T>> get(ResourceKey<T> p_205905_) {
        return Optional.ofNullable(this.byKey.get(p_205905_));
    }

    @Override
    public Optional<Holder.Reference<T>> getAny() {
        return this.byId.isEmpty() ? Optional.empty() : Optional.of((Holder.Reference)this.byId.getFirst());
    }

    @Override
    public Holder<T> wrapAsHolder(T p_263356_) {
        Holder.Reference<T> $$1 = this.byValue.get(p_263356_);
        return $$1 != null ? $$1 : Holder.direct(p_263356_);
    }

    Holder.Reference<T> getOrCreateHolderOrThrow(ResourceKey<T> p_248831_) {
        return this.byKey.computeIfAbsent(p_248831_, p_367801_ -> {
            if (this.unregisteredIntrusiveHolders != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.validateWrite((ResourceKey<T>)p_367801_);
            return Holder.Reference.createStandAlone(this, p_367801_);
        });
    }

    @Override
    public int size() {
        return this.byKey.size();
    }

    @Override
    public Optional<RegistrationInfo> registrationInfo(ResourceKey<T> p_326067_) {
        return Optional.ofNullable(this.registrationInfos.get(p_326067_));
    }

    @Override
    public Lifecycle registryLifecycle() {
        return this.registryLifecycle;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform((Iterator)this.byId.iterator(), Holder::value);
    }

    @Override
    @Nullable
    public T getValue(@Nullable ResourceLocation p_122739_) {
        Holder.Reference<T> $$1 = this.byLocation.get(p_122739_);
        return MappedRegistry.getValueFromNullable($$1);
    }

    @Nullable
    private static <T> T getValueFromNullable(@Nullable Holder.Reference<T> p_205866_) {
        return p_205866_ != null ? (T)p_205866_.value() : null;
    }

    @Override
    public Set<ResourceLocation> keySet() {
        return Collections.unmodifiableSet(this.byLocation.keySet());
    }

    @Override
    public Set<ResourceKey<T>> registryKeySet() {
        return Collections.unmodifiableSet(this.byKey.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return Collections.unmodifiableSet(Maps.transformValues(this.byKey, Holder::value).entrySet());
    }

    @Override
    public Stream<Holder.Reference<T>> listElements() {
        return this.byId.stream();
    }

    @Override
    public Stream<HolderSet.Named<T>> getTags() {
        return this.allTags.getTags();
    }

    HolderSet.Named<T> getOrCreateTagForRegistration(TagKey<T> p_364545_) {
        return this.frozenTags.computeIfAbsent(p_364545_, this::createTag);
    }

    private HolderSet.Named<T> createTag(TagKey<T> p_211068_) {
        return new HolderSet.Named<T>(this, p_211068_);
    }

    @Override
    public boolean isEmpty() {
        return this.byKey.isEmpty();
    }

    @Override
    public Optional<Holder.Reference<T>> getRandom(RandomSource p_235716_) {
        return Util.getRandomSafe(this.byId, p_235716_);
    }

    @Override
    public boolean containsKey(ResourceLocation p_122761_) {
        return this.byLocation.containsKey(p_122761_);
    }

    @Override
    public boolean containsKey(ResourceKey<T> p_175392_) {
        return this.byKey.containsKey(p_175392_);
    }

    @Override
    public Registry<T> freeze() {
        if (this.frozen) {
            return this;
        }
        this.frozen = true;
        this.byValue.forEach((? super K p_247989_, ? super V p_247990_) -> p_247990_.bindValue(p_247989_));
        List<ResourceLocation> $$0 = this.byKey.entrySet().stream().filter(p_211055_ -> !((Holder.Reference)p_211055_.getValue()).isBound()).map(p_211794_ -> ((ResourceKey)p_211794_.getKey()).location()).sorted().toList();
        if (!$$0.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + String.valueOf(this.key()) + ": " + String.valueOf($$0));
        }
        if (this.unregisteredIntrusiveHolders != null) {
            if (!this.unregisteredIntrusiveHolders.isEmpty()) {
                throw new IllegalStateException("Some intrusive holders were not registered: " + String.valueOf(this.unregisteredIntrusiveHolders.values()));
            }
            this.unregisteredIntrusiveHolders = null;
        }
        if (this.allTags.isBound()) {
            throw new IllegalStateException("Tags already present before freezing");
        }
        List<ResourceLocation> $$1 = this.frozenTags.entrySet().stream().filter(p_359337_ -> !((HolderSet.Named)p_359337_.getValue()).isBound()).map(p_359338_ -> ((TagKey)p_359338_.getKey()).location()).sorted().toList();
        if (!$$1.isEmpty()) {
            throw new IllegalStateException("Unbound tags in registry " + String.valueOf(this.key()) + ": " + String.valueOf($$1));
        }
        this.allTags = TagSet.fromMap(this.frozenTags);
        this.refreshTagsInHolders();
        return this;
    }

    @Override
    public Holder.Reference<T> createIntrusiveHolder(T p_205915_) {
        if (this.unregisteredIntrusiveHolders == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.validateWrite();
        return this.unregisteredIntrusiveHolders.computeIfAbsent(p_205915_, p_367802_ -> Holder.Reference.createIntrusive(this, p_367802_));
    }

    @Override
    public Optional<HolderSet.Named<T>> get(TagKey<T> p_205909_) {
        return this.allTags.get(p_205909_);
    }

    private Holder.Reference<T> validateAndUnwrapTagElement(TagKey<T> p_361125_, Holder<T> p_363196_) {
        if (!p_363196_.canSerializeIn(this)) {
            throw new IllegalStateException("Can't create named set " + String.valueOf(p_361125_) + " containing value " + String.valueOf(p_363196_) + " from outside registry " + String.valueOf(this));
        }
        if (p_363196_ instanceof Holder.Reference) {
            Holder.Reference $$2 = (Holder.Reference)p_363196_;
            return $$2;
        }
        throw new IllegalStateException("Found direct holder " + String.valueOf(p_363196_) + " value in tag " + String.valueOf(p_361125_));
    }

    @Override
    public void bindTag(TagKey<T> p_363652_, List<Holder<T>> p_360281_) {
        this.validateWrite();
        this.getOrCreateTagForRegistration(p_363652_).bind(p_360281_);
    }

    void refreshTagsInHolders() {
        IdentityHashMap<Holder.Reference, List> $$0 = new IdentityHashMap<Holder.Reference, List>();
        this.byKey.values().forEach(p_211801_ -> $$0.put((Holder.Reference)p_211801_, new ArrayList()));
        this.allTags.forEach((? super TagKey<T> p_359335_, ? super HolderSet.Named<T> p_359336_) -> {
            for (Holder $$3 : p_359336_) {
                Holder.Reference $$4 = this.validateAndUnwrapTagElement((TagKey<T>)p_359335_, $$3);
                ((List)$$0.get($$4)).add(p_359335_);
            }
        });
        $$0.forEach(Holder.Reference::bindTags);
    }

    public void bindAllTagsToEmpty() {
        this.validateWrite();
        this.frozenTags.values().forEach(p_211792_ -> p_211792_.bind(List.of()));
    }

    @Override
    public HolderGetter<T> createRegistrationLookup() {
        this.validateWrite();
        return new HolderGetter<T>(){

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> p_255624_) {
                return Optional.of(this.getOrThrow(p_255624_));
            }

            @Override
            public Holder.Reference<T> getOrThrow(ResourceKey<T> p_368503_) {
                return MappedRegistry.this.getOrCreateHolderOrThrow(p_368503_);
            }

            @Override
            public Optional<HolderSet.Named<T>> get(TagKey<T> p_256277_) {
                return Optional.of(this.getOrThrow(p_256277_));
            }

            @Override
            public HolderSet.Named<T> getOrThrow(TagKey<T> p_368701_) {
                return MappedRegistry.this.getOrCreateTagForRegistration(p_368701_);
            }
        };
    }

    @Override
    public Registry.PendingTags<T> prepareTagReload(TagLoader.LoadResult<T> p_364128_) {
        if (!this.frozen) {
            throw new IllegalStateException("Invalid method used for tag loading");
        }
        ImmutableMap.Builder $$1 = ImmutableMap.builder();
        final HashMap $$2 = new HashMap();
        p_364128_.tags().forEach((? super K p_359332_, ? super V p_359333_) -> {
            HolderSet.Named<T> $$4 = this.frozenTags.get(p_359332_);
            if ($$4 == null) {
                $$4 = this.createTag((TagKey<T>)p_359332_);
            }
            $$1.put(p_359332_, $$4);
            $$2.put(p_359332_, List.copyOf(p_359333_));
        });
        final ImmutableMap $$3 = $$1.build();
        final HolderLookup.RegistryLookup.Delegate $$4 = new HolderLookup.RegistryLookup.Delegate<T>(){

            @Override
            public HolderLookup.RegistryLookup<T> parent() {
                return MappedRegistry.this;
            }

            @Override
            public Optional<HolderSet.Named<T>> get(TagKey<T> p_259486_) {
                return Optional.ofNullable((HolderSet.Named)$$3.get(p_259486_));
            }

            @Override
            public Stream<HolderSet.Named<T>> listTags() {
                return $$3.values().stream();
            }
        };
        return new Registry.PendingTags<T>(){

            @Override
            public ResourceKey<? extends Registry<? extends T>> key() {
                return MappedRegistry.this.key();
            }

            @Override
            public int size() {
                return $$2.size();
            }

            @Override
            public HolderLookup.RegistryLookup<T> lookup() {
                return $$4;
            }

            @Override
            public void apply() {
                $$3.forEach((p_368608_, p_368715_) -> {
                    List $$32 = $$2.getOrDefault(p_368608_, List.of());
                    p_368715_.bind($$32);
                });
                MappedRegistry.this.allTags = TagSet.fromMap($$3);
                MappedRegistry.this.refreshTagsInHolders();
            }
        };
    }

    static interface TagSet<T> {
        public static <T> TagSet<T> unbound() {
            return new TagSet<T>(){

                @Override
                public boolean isBound() {
                    return false;
                }

                @Override
                public Optional<HolderSet.Named<T>> get(TagKey<T> p_363319_) {
                    throw new IllegalStateException("Tags not bound, trying to access " + String.valueOf(p_363319_));
                }

                @Override
                public void forEach(BiConsumer<? super TagKey<T>, ? super HolderSet.Named<T>> p_361880_) {
                    throw new IllegalStateException("Tags not bound");
                }

                @Override
                public Stream<HolderSet.Named<T>> getTags() {
                    throw new IllegalStateException("Tags not bound");
                }
            };
        }

        public static <T> TagSet<T> fromMap(final Map<TagKey<T>, HolderSet.Named<T>> p_360536_) {
            return new TagSet<T>(){

                @Override
                public boolean isBound() {
                    return true;
                }

                @Override
                public Optional<HolderSet.Named<T>> get(TagKey<T> p_362077_) {
                    return Optional.ofNullable((HolderSet.Named)p_360536_.get(p_362077_));
                }

                @Override
                public void forEach(BiConsumer<? super TagKey<T>, ? super HolderSet.Named<T>> p_363215_) {
                    p_360536_.forEach(p_363215_);
                }

                @Override
                public Stream<HolderSet.Named<T>> getTags() {
                    return p_360536_.values().stream();
                }
            };
        }

        public boolean isBound();

        public Optional<HolderSet.Named<T>> get(TagKey<T> var1);

        public void forEach(BiConsumer<? super TagKey<T>, ? super HolderSet.Named<T>> var1);

        public Stream<HolderSet.Named<T>> getTags();
    }
}

