/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class DataComponentPredicate
implements Predicate<DataComponentMap> {
    public static final Codec<DataComponentPredicate> CODEC = DataComponentType.VALUE_MAP_CODEC.xmap(p_330430_ -> new DataComponentPredicate(p_330430_.entrySet().stream().map(TypedDataComponent::fromEntryUnchecked).collect(Collectors.toList())), p_337454_ -> p_337454_.expectedComponents.stream().filter(p_337453_ -> !p_337453_.type().isTransient()).collect(Collectors.toMap(TypedDataComponent::type, TypedDataComponent::value)));
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentPredicate> STREAM_CODEC = TypedDataComponent.STREAM_CODEC.apply(ByteBufCodecs.list()).map(DataComponentPredicate::new, p_331347_ -> p_331347_.expectedComponents);
    public static final DataComponentPredicate EMPTY = new DataComponentPredicate(List.of());
    private final List<TypedDataComponent<?>> expectedComponents;

    DataComponentPredicate(List<TypedDataComponent<?>> p_330446_) {
        this.expectedComponents = p_330446_;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DataComponentPredicate allOf(DataComponentMap p_331623_) {
        return new DataComponentPredicate((List<TypedDataComponent<?>>)ImmutableList.copyOf((Iterable)p_331623_));
    }

    public static DataComponentPredicate someOf(DataComponentMap p_371678_, DataComponentType<?> ... p_371329_) {
        Builder $$2 = new Builder();
        for (DataComponentType<?> $$3 : p_371329_) {
            TypedDataComponent<?> $$4 = p_371678_.getTyped($$3);
            if ($$4 == null) continue;
            $$2.expect($$4);
        }
        return $$2.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_330889_) {
        if (!(p_330889_ instanceof DataComponentPredicate)) return false;
        DataComponentPredicate $$1 = (DataComponentPredicate)p_330889_;
        if (!this.expectedComponents.equals($$1.expectedComponents)) return false;
        return true;
    }

    public int hashCode() {
        return this.expectedComponents.hashCode();
    }

    public String toString() {
        return this.expectedComponents.toString();
    }

    @Override
    public boolean test(DataComponentMap p_331560_) {
        for (TypedDataComponent<?> $$1 : this.expectedComponents) {
            Object $$2 = p_331560_.get($$1.type());
            if (Objects.equals($$1.value(), $$2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean test(DataComponentHolder p_331666_) {
        return this.test(p_331666_.getComponents());
    }

    public boolean alwaysMatches() {
        return this.expectedComponents.isEmpty();
    }

    public DataComponentPatch asPatch() {
        DataComponentPatch.Builder $$0 = DataComponentPatch.builder();
        for (TypedDataComponent<?> $$1 : this.expectedComponents) {
            $$0.set($$1);
        }
        return $$0.build();
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((DataComponentMap)object);
    }

    public static class Builder {
        private final List<TypedDataComponent<?>> expectedComponents = new ArrayList();

        Builder() {
        }

        public <T> Builder expect(TypedDataComponent<T> p_371914_) {
            return this.expect(p_371914_.type(), p_371914_.value());
        }

        public <T> Builder expect(DataComponentType<? super T> p_331861_, T p_330813_) {
            for (TypedDataComponent<?> $$2 : this.expectedComponents) {
                if ($$2.type() != p_331861_) continue;
                throw new IllegalArgumentException("Predicate already has component of type: '" + String.valueOf(p_331861_) + "'");
            }
            this.expectedComponents.add(new TypedDataComponent<T>(p_331861_, p_330813_));
            return this;
        }

        public DataComponentPredicate build() {
            return new DataComponentPredicate(List.copyOf(this.expectedComponents));
        }
    }
}

