/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.advancements.packs;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ChanneledLightningTrigger;
import net.minecraft.advancements.critereon.DamagePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.DistanceTrigger;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.FallAfterExplosionTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemJukeboxPlayablePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.KilledByArrowTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LightningBoltPredicate;
import net.minecraft.advancements.critereon.LightningStrikeTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.LootTableTrigger;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerHurtEntityTrigger;
import net.minecraft.advancements.critereon.PlayerInteractTrigger;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.RecipeCraftedTrigger;
import net.minecraft.advancements.critereon.ShotCrossbowTrigger;
import net.minecraft.advancements.critereon.SlideDownBlockTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.advancements.critereon.SummonedEntityTrigger;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.advancements.critereon.TargetBlockTrigger;
import net.minecraft.advancements.critereon.TradeTrigger;
import net.minecraft.advancements.critereon.UsedTotemTrigger;
import net.minecraft.advancements.critereon.UsingItemTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.data.advancements.packs.VanillaHusbandryAdvancements;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.CopperBulbBlock;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class VanillaAdventureAdvancements
implements AdvancementSubProvider {
    private static final int DISTANCE_FROM_BOTTOM_TO_TOP = 384;
    private static final int Y_COORDINATE_AT_TOP = 320;
    private static final int Y_COORDINATE_AT_BOTTOM = -64;
    private static final int BEDROCK_THICKNESS = 5;
    protected static final List<EntityType<?>> MOBS_TO_KILL = Arrays.asList(EntityType.BLAZE, EntityType.BOGGED, EntityType.BREEZE, EntityType.CAVE_SPIDER, EntityType.CREEPER, EntityType.DROWNED, EntityType.ELDER_GUARDIAN, EntityType.ENDER_DRAGON, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.EVOKER, EntityType.GHAST, EntityType.GUARDIAN, EntityType.HOGLIN, EntityType.HUSK, EntityType.MAGMA_CUBE, EntityType.PHANTOM, EntityType.PIGLIN, EntityType.PIGLIN_BRUTE, EntityType.PILLAGER, EntityType.RAVAGER, EntityType.SHULKER, EntityType.SILVERFISH, EntityType.SKELETON, EntityType.SLIME, EntityType.SPIDER, EntityType.STRAY, EntityType.VEX, EntityType.VINDICATOR, EntityType.WITCH, EntityType.WITHER_SKELETON, EntityType.WITHER, EntityType.ZOGLIN, EntityType.ZOMBIE_VILLAGER, EntityType.ZOMBIE, EntityType.ZOMBIFIED_PIGLIN);

    private static Criterion<LightningStrikeTrigger.TriggerInstance> fireCountAndBystander(MinMaxBounds.Ints p_252298_, Optional<EntityPredicate> p_299106_) {
        return LightningStrikeTrigger.TriggerInstance.lightningStrike(Optional.of(EntityPredicate.Builder.entity().distance(DistancePredicate.absolute(MinMaxBounds.Doubles.atMost(30.0))).subPredicate(LightningBoltPredicate.blockSetOnFire(p_252298_)).build()), p_299106_);
    }

    private static Criterion<UsingItemTrigger.TriggerInstance> lookAtThroughItem(EntityPredicate.Builder p_363976_, ItemPredicate.Builder p_363854_) {
        return UsingItemTrigger.TriggerInstance.lookingAt(EntityPredicate.Builder.entity().subPredicate(PlayerPredicate.Builder.player().setLookingAt(p_363976_).build()), p_363854_);
    }

    @Override
    public void generate(HolderLookup.Provider p_255887_, Consumer<AdvancementHolder> p_256428_) {
        HolderGetter $$2 = p_255887_.lookupOrThrow(Registries.ENTITY_TYPE);
        HolderGetter $$3 = p_255887_.lookupOrThrow(Registries.ITEM);
        HolderGetter $$4 = p_255887_.lookupOrThrow(Registries.BLOCK);
        AdvancementHolder $$5 = Advancement.Builder.advancement().display(Items.MAP, (Component)Component.translatable("advancements.adventure.root.title"), (Component)Component.translatable("advancements.adventure.root.description"), ResourceLocation.withDefaultNamespace("textures/gui/advancements/backgrounds/adventure.png"), AdvancementType.TASK, false, false, false).requirements(AdvancementRequirements.Strategy.OR).addCriterion("killed_something", KilledTrigger.TriggerInstance.playerKilledEntity()).addCriterion("killed_by_something", KilledTrigger.TriggerInstance.entityKilledPlayer()).save(p_256428_, "adventure/root");
        AdvancementHolder $$6 = Advancement.Builder.advancement().parent($$5).display(Blocks.RED_BED, (Component)Component.translatable("advancements.adventure.sleep_in_bed.title"), (Component)Component.translatable("advancements.adventure.sleep_in_bed.description"), null, AdvancementType.TASK, true, true, false).addCriterion("slept_in_bed", PlayerTrigger.TriggerInstance.sleptInBed()).save(p_256428_, "adventure/sleep_in_bed");
        VanillaAdventureAdvancements.createAdventuringTime(p_255887_, p_256428_, $$6, MultiNoiseBiomeSourceParameterList.Preset.OVERWORLD);
        AdvancementHolder $$7 = Advancement.Builder.advancement().parent($$5).display(Items.EMERALD, (Component)Component.translatable("advancements.adventure.trade.title"), (Component)Component.translatable("advancements.adventure.trade.description"), null, AdvancementType.TASK, true, true, false).addCriterion("traded", TradeTrigger.TriggerInstance.tradedWithVillager()).save(p_256428_, "adventure/trade");
        Advancement.Builder.advancement().parent($$7).display(Items.EMERALD, (Component)Component.translatable("advancements.adventure.trade_at_world_height.title"), (Component)Component.translatable("advancements.adventure.trade_at_world_height.description"), null, AdvancementType.TASK, true, true, false).addCriterion("trade_at_world_height", TradeTrigger.TriggerInstance.tradedWithVillager(EntityPredicate.Builder.entity().located(LocationPredicate.Builder.atYLocation(MinMaxBounds.Doubles.atLeast(319.0))))).save(p_256428_, "adventure/trade_at_world_height");
        AdvancementHolder $$8 = VanillaAdventureAdvancements.createMonsterHunterAdvancement($$5, p_256428_, $$2, MOBS_TO_KILL);
        AdvancementHolder $$9 = Advancement.Builder.advancement().parent($$8).display(Items.BOW, (Component)Component.translatable("advancements.adventure.shoot_arrow.title"), (Component)Component.translatable("advancements.adventure.shoot_arrow.description"), null, AdvancementType.TASK, true, true, false).addCriterion("shot_arrow", PlayerHurtEntityTrigger.TriggerInstance.playerHurtEntityWithDamage(DamagePredicate.Builder.damageInstance().type(DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is(DamageTypeTags.IS_PROJECTILE)).direct(EntityPredicate.Builder.entity().of($$2, EntityTypeTags.ARROWS))))).save(p_256428_, "adventure/shoot_arrow");
        AdvancementHolder $$10 = Advancement.Builder.advancement().parent($$8).display(Items.TRIDENT, (Component)Component.translatable("advancements.adventure.throw_trident.title"), (Component)Component.translatable("advancements.adventure.throw_trident.description"), null, AdvancementType.TASK, true, true, false).addCriterion("shot_trident", PlayerHurtEntityTrigger.TriggerInstance.playerHurtEntityWithDamage(DamagePredicate.Builder.damageInstance().type(DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is(DamageTypeTags.IS_PROJECTILE)).direct(EntityPredicate.Builder.entity().of($$2, EntityType.TRIDENT))))).save(p_256428_, "adventure/throw_trident");
        Advancement.Builder.advancement().parent($$10).display(Items.TRIDENT, (Component)Component.translatable("advancements.adventure.very_very_frightening.title"), (Component)Component.translatable("advancements.adventure.very_very_frightening.description"), null, AdvancementType.TASK, true, true, false).addCriterion("struck_villager", ChanneledLightningTrigger.TriggerInstance.channeledLightning(EntityPredicate.Builder.entity().of($$2, EntityType.VILLAGER))).save(p_256428_, "adventure/very_very_frightening");
        Advancement.Builder.advancement().parent($$7).display(Blocks.CARVED_PUMPKIN, (Component)Component.translatable("advancements.adventure.summon_iron_golem.title"), (Component)Component.translatable("advancements.adventure.summon_iron_golem.description"), null, AdvancementType.GOAL, true, true, false).addCriterion("summoned_golem", SummonedEntityTrigger.TriggerInstance.summonedEntity(EntityPredicate.Builder.entity().of($$2, EntityType.IRON_GOLEM))).save(p_256428_, "adventure/summon_iron_golem");
        Advancement.Builder.advancement().parent($$9).display(Items.ARROW, (Component)Component.translatable("advancements.adventure.sniper_duel.title"), (Component)Component.translatable("advancements.adventure.sniper_duel.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience(50)).addCriterion("killed_skeleton", KilledTrigger.TriggerInstance.playerKilledEntity(EntityPredicate.Builder.entity().of($$2, EntityType.SKELETON).distance(DistancePredicate.horizontal(MinMaxBounds.Doubles.atLeast(50.0))), DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is(DamageTypeTags.IS_PROJECTILE)))).save(p_256428_, "adventure/sniper_duel");
        Advancement.Builder.advancement().parent($$8).display(Items.TOTEM_OF_UNDYING, (Component)Component.translatable("advancements.adventure.totem_of_undying.title"), (Component)Component.translatable("advancements.adventure.totem_of_undying.description"), null, AdvancementType.GOAL, true, true, false).addCriterion("used_totem", UsedTotemTrigger.TriggerInstance.usedTotem($$3, Items.TOTEM_OF_UNDYING)).save(p_256428_, "adventure/totem_of_undying");
        AdvancementHolder $$11 = Advancement.Builder.advancement().parent($$5).display(Items.CROSSBOW, (Component)Component.translatable("advancements.adventure.ol_betsy.title"), (Component)Component.translatable("advancements.adventure.ol_betsy.description"), null, AdvancementType.TASK, true, true, false).addCriterion("shot_crossbow", ShotCrossbowTrigger.TriggerInstance.shotCrossbow($$3, Items.CROSSBOW)).save(p_256428_, "adventure/ol_betsy");
        Advancement.Builder.advancement().parent($$11).display(Items.CROSSBOW, (Component)Component.translatable("advancements.adventure.whos_the_pillager_now.title"), (Component)Component.translatable("advancements.adventure.whos_the_pillager_now.description"), null, AdvancementType.TASK, true, true, false).addCriterion("kill_pillager", KilledByArrowTrigger.TriggerInstance.crossbowKilled((HolderGetter<Item>)$$3, EntityPredicate.Builder.entity().of($$2, EntityType.PILLAGER))).save(p_256428_, "adventure/whos_the_pillager_now");
        Advancement.Builder.advancement().parent($$11).display(Items.CROSSBOW, (Component)Component.translatable("advancements.adventure.two_birds_one_arrow.title"), (Component)Component.translatable("advancements.adventure.two_birds_one_arrow.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience(65)).addCriterion("two_birds", KilledByArrowTrigger.TriggerInstance.crossbowKilled((HolderGetter<Item>)$$3, EntityPredicate.Builder.entity().of($$2, EntityType.PHANTOM), EntityPredicate.Builder.entity().of($$2, EntityType.PHANTOM))).save(p_256428_, "adventure/two_birds_one_arrow");
        Advancement.Builder.advancement().parent($$11).display(Items.CROSSBOW, (Component)Component.translatable("advancements.adventure.arbalistic.title"), (Component)Component.translatable("advancements.adventure.arbalistic.description"), null, AdvancementType.CHALLENGE, true, true, true).rewards(AdvancementRewards.Builder.experience(85)).addCriterion("arbalistic", KilledByArrowTrigger.TriggerInstance.crossbowKilled((HolderGetter<Item>)$$3, MinMaxBounds.Ints.exactly(5))).save(p_256428_, "adventure/arbalistic");
        HolderGetter $$12 = p_255887_.lookupOrThrow(Registries.BANNER_PATTERN);
        AdvancementHolder $$13 = Advancement.Builder.advancement().parent($$5).display(Raid.getOminousBannerInstance($$12), (Component)Component.translatable("advancements.adventure.voluntary_exile.title"), (Component)Component.translatable("advancements.adventure.voluntary_exile.description"), null, AdvancementType.TASK, true, true, true).addCriterion("voluntary_exile", KilledTrigger.TriggerInstance.playerKilledEntity(EntityPredicate.Builder.entity().of($$2, EntityTypeTags.RAIDERS).equipment(EntityEquipmentPredicate.captainPredicate($$3, $$12)))).save(p_256428_, "adventure/voluntary_exile");
        Advancement.Builder.advancement().parent($$13).display(Raid.getOminousBannerInstance($$12), (Component)Component.translatable("advancements.adventure.hero_of_the_village.title"), (Component)Component.translatable("advancements.adventure.hero_of_the_village.description"), null, AdvancementType.CHALLENGE, true, true, true).rewards(AdvancementRewards.Builder.experience(100)).addCriterion("hero_of_the_village", PlayerTrigger.TriggerInstance.raidWon()).save(p_256428_, "adventure/hero_of_the_village");
        Advancement.Builder.advancement().parent($$5).display(Blocks.HONEY_BLOCK.asItem(), (Component)Component.translatable("advancements.adventure.honey_block_slide.title"), (Component)Component.translatable("advancements.adventure.honey_block_slide.description"), null, AdvancementType.TASK, true, true, false).addCriterion("honey_block_slide", SlideDownBlockTrigger.TriggerInstance.slidesDownBlock(Blocks.HONEY_BLOCK)).save(p_256428_, "adventure/honey_block_slide");
        Advancement.Builder.advancement().parent($$9).display(Blocks.TARGET.asItem(), (Component)Component.translatable("advancements.adventure.bullseye.title"), (Component)Component.translatable("advancements.adventure.bullseye.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience(50)).addCriterion("bullseye", TargetBlockTrigger.TriggerInstance.targetHit(MinMaxBounds.Ints.exactly(15), Optional.of(EntityPredicate.wrap(EntityPredicate.Builder.entity().distance(DistancePredicate.horizontal(MinMaxBounds.Doubles.atLeast(30.0))))))).save(p_256428_, "adventure/bullseye");
        Advancement.Builder.advancement().parent($$6).display(Items.LEATHER_BOOTS, (Component)Component.translatable("advancements.adventure.walk_on_powder_snow_with_leather_boots.title"), (Component)Component.translatable("advancements.adventure.walk_on_powder_snow_with_leather_boots.description"), null, AdvancementType.TASK, true, true, false).addCriterion("walk_on_powder_snow_with_leather_boots", PlayerTrigger.TriggerInstance.walkOnBlockWithEquipment($$4, $$3, Blocks.POWDER_SNOW, Items.LEATHER_BOOTS)).save(p_256428_, "adventure/walk_on_powder_snow_with_leather_boots");
        Advancement.Builder.advancement().parent($$5).display(Items.LIGHTNING_ROD, (Component)Component.translatable("advancements.adventure.lightning_rod_with_villager_no_fire.title"), (Component)Component.translatable("advancements.adventure.lightning_rod_with_villager_no_fire.description"), null, AdvancementType.TASK, true, true, false).addCriterion("lightning_rod_with_villager_no_fire", VanillaAdventureAdvancements.fireCountAndBystander(MinMaxBounds.Ints.exactly(0), Optional.of(EntityPredicate.Builder.entity().of($$2, EntityType.VILLAGER).build()))).save(p_256428_, "adventure/lightning_rod_with_villager_no_fire");
        AdvancementHolder $$14 = Advancement.Builder.advancement().parent($$5).display(Items.SPYGLASS, (Component)Component.translatable("advancements.adventure.spyglass_at_parrot.title"), (Component)Component.translatable("advancements.adventure.spyglass_at_parrot.description"), null, AdvancementType.TASK, true, true, false).addCriterion("spyglass_at_parrot", VanillaAdventureAdvancements.lookAtThroughItem(EntityPredicate.Builder.entity().of($$2, EntityType.PARROT), ItemPredicate.Builder.item().of((HolderGetter<Item>)$$3, Items.SPYGLASS))).save(p_256428_, "adventure/spyglass_at_parrot");
        AdvancementHolder $$15 = Advancement.Builder.advancement().parent($$14).display(Items.SPYGLASS, (Component)Component.translatable("advancements.adventure.spyglass_at_ghast.title"), (Component)Component.translatable("advancements.adventure.spyglass_at_ghast.description"), null, AdvancementType.TASK, true, true, false).addCriterion("spyglass_at_ghast", VanillaAdventureAdvancements.lookAtThroughItem(EntityPredicate.Builder.entity().of($$2, EntityType.GHAST), ItemPredicate.Builder.item().of((HolderGetter<Item>)$$3, Items.SPYGLASS))).save(p_256428_, "adventure/spyglass_at_ghast");
        Advancement.Builder.advancement().parent($$6).display(Items.JUKEBOX, (Component)Component.translatable("advancements.adventure.play_jukebox_in_meadows.title"), (Component)Component.translatable("advancements.adventure.play_jukebox_in_meadows.description"), null, AdvancementType.TASK, true, true, false).addCriterion("play_jukebox_in_meadows", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock(LocationPredicate.Builder.location().setBiomes(HolderSet.direct(p_255887_.lookupOrThrow(Registries.BIOME).getOrThrow(Biomes.MEADOW))).setBlock(BlockPredicate.Builder.block().of((HolderGetter<Block>)$$4, Blocks.JUKEBOX)), ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.JUKEBOX_PLAYABLE, ItemJukeboxPlayablePredicate.any()))).save(p_256428_, "adventure/play_jukebox_in_meadows");
        Advancement.Builder.advancement().parent($$15).display(Items.SPYGLASS, (Component)Component.translatable("advancements.adventure.spyglass_at_dragon.title"), (Component)Component.translatable("advancements.adventure.spyglass_at_dragon.description"), null, AdvancementType.TASK, true, true, false).addCriterion("spyglass_at_dragon", VanillaAdventureAdvancements.lookAtThroughItem(EntityPredicate.Builder.entity().of($$2, EntityType.ENDER_DRAGON), ItemPredicate.Builder.item().of((HolderGetter<Item>)$$3, Items.SPYGLASS))).save(p_256428_, "adventure/spyglass_at_dragon");
        Advancement.Builder.advancement().parent($$5).display(Items.WATER_BUCKET, (Component)Component.translatable("advancements.adventure.fall_from_world_height.title"), (Component)Component.translatable("advancements.adventure.fall_from_world_height.description"), null, AdvancementType.TASK, true, true, false).addCriterion("fall_from_world_height", DistanceTrigger.TriggerInstance.fallFromHeight(EntityPredicate.Builder.entity().located(LocationPredicate.Builder.atYLocation(MinMaxBounds.Doubles.atMost(-59.0))), DistancePredicate.vertical(MinMaxBounds.Doubles.atLeast(379.0)), LocationPredicate.Builder.atYLocation(MinMaxBounds.Doubles.atLeast(319.0)))).save(p_256428_, "adventure/fall_from_world_height");
        Advancement.Builder.advancement().parent($$8).display(Blocks.SCULK_CATALYST, (Component)Component.translatable("advancements.adventure.kill_mob_near_sculk_catalyst.title"), (Component)Component.translatable("advancements.adventure.kill_mob_near_sculk_catalyst.description"), null, AdvancementType.CHALLENGE, true, true, false).addCriterion("kill_mob_near_sculk_catalyst", KilledTrigger.TriggerInstance.playerKilledEntityNearSculkCatalyst()).save(p_256428_, "adventure/kill_mob_near_sculk_catalyst");
        Advancement.Builder.advancement().parent($$5).display(Blocks.SCULK_SENSOR, (Component)Component.translatable("advancements.adventure.avoid_vibration.title"), (Component)Component.translatable("advancements.adventure.avoid_vibration.description"), null, AdvancementType.TASK, true, true, false).addCriterion("avoid_vibration", PlayerTrigger.TriggerInstance.avoidVibration()).save(p_256428_, "adventure/avoid_vibration");
        AdvancementHolder $$16 = VanillaAdventureAdvancements.respectingTheRemnantsCriterions($$3, Advancement.Builder.advancement()).parent($$5).display(Items.BRUSH, (Component)Component.translatable("advancements.adventure.salvage_sherd.title"), (Component)Component.translatable("advancements.adventure.salvage_sherd.description"), null, AdvancementType.TASK, true, true, false).save(p_256428_, "adventure/salvage_sherd");
        Advancement.Builder.advancement().parent($$16).display(DecoratedPotBlockEntity.createDecoratedPotItem(new PotDecorations(Optional.empty(), Optional.of(Items.HEART_POTTERY_SHERD), Optional.empty(), Optional.of(Items.EXPLORER_POTTERY_SHERD))), (Component)Component.translatable("advancements.adventure.craft_decorated_pot_using_only_sherds.title"), (Component)Component.translatable("advancements.adventure.craft_decorated_pot_using_only_sherds.description"), null, AdvancementType.TASK, true, true, false).addCriterion("pot_crafted_using_only_sherds", RecipeCraftedTrigger.TriggerInstance.craftedItem(ResourceKey.create(Registries.RECIPE, ResourceLocation.withDefaultNamespace("decorated_pot")), List.of(ItemPredicate.Builder.item().of((HolderGetter<Item>)$$3, ItemTags.DECORATED_POT_SHERDS), ItemPredicate.Builder.item().of((HolderGetter<Item>)$$3, ItemTags.DECORATED_POT_SHERDS), ItemPredicate.Builder.item().of((HolderGetter<Item>)$$3, ItemTags.DECORATED_POT_SHERDS), ItemPredicate.Builder.item().of((HolderGetter<Item>)$$3, ItemTags.DECORATED_POT_SHERDS)))).save(p_256428_, "adventure/craft_decorated_pot_using_only_sherds");
        AdvancementHolder $$17 = VanillaAdventureAdvancements.craftingANewLook(Advancement.Builder.advancement()).parent($$5).display(new ItemStack(Items.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE), (Component)Component.translatable("advancements.adventure.trim_with_any_armor_pattern.title"), (Component)Component.translatable("advancements.adventure.trim_with_any_armor_pattern.description"), null, AdvancementType.TASK, true, true, false).save(p_256428_, "adventure/trim_with_any_armor_pattern");
        VanillaAdventureAdvancements.smithingWithStyle(Advancement.Builder.advancement()).parent($$17).display(new ItemStack(Items.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE), (Component)Component.translatable("advancements.adventure.trim_with_all_exclusive_armor_patterns.title"), (Component)Component.translatable("advancements.adventure.trim_with_all_exclusive_armor_patterns.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience(150)).save(p_256428_, "adventure/trim_with_all_exclusive_armor_patterns");
        Advancement.Builder.advancement().parent($$5).display(Items.CHISELED_BOOKSHELF, (Component)Component.translatable("advancements.adventure.read_power_from_chiseled_bookshelf.title"), (Component)Component.translatable("advancements.adventure.read_power_from_chiseled_bookshelf.description"), null, AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.Strategy.OR).addCriterion("chiseled_bookshelf", VanillaAdventureAdvancements.placedBlockReadByComparator($$4, Blocks.CHISELED_BOOKSHELF)).addCriterion("comparator", VanillaAdventureAdvancements.placedComparatorReadingBlock($$4, Blocks.CHISELED_BOOKSHELF)).save(p_256428_, "adventure/read_power_of_chiseled_bookshelf");
        Advancement.Builder.advancement().parent($$5).display(Items.ARMADILLO_SCUTE, (Component)Component.translatable("advancements.adventure.brush_armadillo.title"), (Component)Component.translatable("advancements.adventure.brush_armadillo.description"), null, AdvancementType.TASK, true, true, false).addCriterion("brush_armadillo", PlayerInteractTrigger.TriggerInstance.itemUsedOnEntity(ItemPredicate.Builder.item().of((HolderGetter<Item>)$$3, Items.BRUSH), Optional.of(EntityPredicate.wrap(EntityPredicate.Builder.entity().of($$2, EntityType.ARMADILLO))))).save(p_256428_, "adventure/brush_armadillo");
        AdvancementHolder $$18 = Advancement.Builder.advancement().parent($$5).display(Blocks.CHISELED_TUFF, (Component)Component.translatable("advancements.adventure.minecraft_trials_edition.title"), (Component)Component.translatable("advancements.adventure.minecraft_trials_edition.description"), null, AdvancementType.TASK, true, true, false).addCriterion("minecraft_trials_edition", PlayerTrigger.TriggerInstance.located(LocationPredicate.Builder.inStructure(p_255887_.lookupOrThrow(Registries.STRUCTURE).getOrThrow(BuiltinStructures.TRIAL_CHAMBERS)))).save(p_256428_, "adventure/minecraft_trials_edition");
        Advancement.Builder.advancement().parent($$18).display(Items.COPPER_BULB, (Component)Component.translatable("advancements.adventure.lighten_up.title"), (Component)Component.translatable("advancements.adventure.lighten_up.description"), null, AdvancementType.TASK, true, true, false).addCriterion("lighten_up", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock(LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of((HolderGetter<Block>)$$4, Blocks.OXIDIZED_COPPER_BULB, Blocks.WEATHERED_COPPER_BULB, Blocks.EXPOSED_COPPER_BULB, Blocks.WAXED_OXIDIZED_COPPER_BULB, Blocks.WAXED_WEATHERED_COPPER_BULB, Blocks.WAXED_EXPOSED_COPPER_BULB).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(CopperBulbBlock.LIT, true))), ItemPredicate.Builder.item().of((HolderGetter<Item>)$$3, VanillaHusbandryAdvancements.WAX_SCRAPING_TOOLS))).save(p_256428_, "adventure/lighten_up");
        AdvancementHolder $$19 = Advancement.Builder.advancement().parent($$18).display(Items.TRIAL_KEY, (Component)Component.translatable("advancements.adventure.under_lock_and_key.title"), (Component)Component.translatable("advancements.adventure.under_lock_and_key.description"), null, AdvancementType.TASK, true, true, false).addCriterion("under_lock_and_key", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock(LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of((HolderGetter<Block>)$$4, Blocks.VAULT).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(VaultBlock.OMINOUS, false))), ItemPredicate.Builder.item().of((HolderGetter<Item>)$$3, Items.TRIAL_KEY))).save(p_256428_, "adventure/under_lock_and_key");
        Advancement.Builder.advancement().parent($$19).display(Items.OMINOUS_TRIAL_KEY, (Component)Component.translatable("advancements.adventure.revaulting.title"), (Component)Component.translatable("advancements.adventure.revaulting.description"), null, AdvancementType.GOAL, true, true, false).addCriterion("revaulting", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock(LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of((HolderGetter<Block>)$$4, Blocks.VAULT).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(VaultBlock.OMINOUS, true))), ItemPredicate.Builder.item().of((HolderGetter<Item>)$$3, Items.OMINOUS_TRIAL_KEY))).save(p_256428_, "adventure/revaulting");
        Advancement.Builder.advancement().parent($$18).display(Items.WIND_CHARGE, (Component)Component.translatable("advancements.adventure.blowback.title"), (Component)Component.translatable("advancements.adventure.blowback.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience(40)).addCriterion("blowback", KilledTrigger.TriggerInstance.playerKilledEntity(EntityPredicate.Builder.entity().of($$2, EntityType.BREEZE), DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is(DamageTypeTags.IS_PROJECTILE)).direct(EntityPredicate.Builder.entity().of($$2, EntityType.BREEZE_WIND_CHARGE)))).save(p_256428_, "adventure/blowback");
        Advancement.Builder.advancement().parent($$5).display(Items.CRAFTER, (Component)Component.translatable("advancements.adventure.crafters_crafting_crafters.title"), (Component)Component.translatable("advancements.adventure.crafters_crafting_crafters.description"), null, AdvancementType.TASK, true, true, false).addCriterion("crafter_crafted_crafter", RecipeCraftedTrigger.TriggerInstance.crafterCraftedItem(ResourceKey.create(Registries.RECIPE, ResourceLocation.withDefaultNamespace("crafter")))).save(p_256428_, "adventure/crafters_crafting_crafters");
        Advancement.Builder.advancement().parent($$18).display(Items.WIND_CHARGE, (Component)Component.translatable("advancements.adventure.who_needs_rockets.title"), (Component)Component.translatable("advancements.adventure.who_needs_rockets.description"), null, AdvancementType.TASK, true, true, false).addCriterion("who_needs_rockets", FallAfterExplosionTrigger.TriggerInstance.fallAfterExplosion(DistancePredicate.vertical(MinMaxBounds.Doubles.atLeast(7.0)), EntityPredicate.Builder.entity().of($$2, EntityType.WIND_CHARGE))).save(p_256428_, "adventure/who_needs_rockets");
        Advancement.Builder.advancement().parent($$18).display(Items.MACE, (Component)Component.translatable("advancements.adventure.overoverkill.title"), (Component)Component.translatable("advancements.adventure.overoverkill.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience(50)).addCriterion("overoverkill", PlayerHurtEntityTrigger.TriggerInstance.playerHurtEntityWithDamage(DamagePredicate.Builder.damageInstance().dealtDamage(MinMaxBounds.Doubles.atLeast(100.0)).type(DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is(DamageTypeTags.IS_MACE_SMASH)).direct(EntityPredicate.Builder.entity().of($$2, EntityType.PLAYER).equipment(EntityEquipmentPredicate.Builder.equipment().mainhand(ItemPredicate.Builder.item().of((HolderGetter<Item>)$$3, Items.MACE))))))).save(p_256428_, "adventure/overoverkill");
    }

    public static AdvancementHolder createMonsterHunterAdvancement(AdvancementHolder p_314489_, Consumer<AdvancementHolder> p_314532_, HolderGetter<EntityType<?>> p_364549_, List<EntityType<?>> p_314614_) {
        AdvancementHolder $$4 = VanillaAdventureAdvancements.addMobsToKill(Advancement.Builder.advancement(), p_364549_, p_314614_).parent(p_314489_).display(Items.IRON_SWORD, (Component)Component.translatable("advancements.adventure.kill_a_mob.title"), (Component)Component.translatable("advancements.adventure.kill_a_mob.description"), null, AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.Strategy.OR).save(p_314532_, "adventure/kill_a_mob");
        VanillaAdventureAdvancements.addMobsToKill(Advancement.Builder.advancement(), p_364549_, p_314614_).parent($$4).display(Items.DIAMOND_SWORD, (Component)Component.translatable("advancements.adventure.kill_all_mobs.title"), (Component)Component.translatable("advancements.adventure.kill_all_mobs.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience(100)).save(p_314532_, "adventure/kill_all_mobs");
        return $$4;
    }

    private static Criterion<ItemUsedOnLocationTrigger.TriggerInstance> placedBlockReadByComparator(HolderGetter<Block> p_365029_, Block p_286401_) {
        LootItemCondition.Builder[] $$2 = (LootItemCondition.Builder[])ComparatorBlock.FACING.getPossibleValues().stream().map(p_373700_ -> {
            StatePropertiesPredicate.Builder $$2 = StatePropertiesPredicate.Builder.properties().hasProperty(ComparatorBlock.FACING, p_373700_);
            BlockPredicate.Builder $$3 = BlockPredicate.Builder.block().of(p_365029_, Blocks.COMPARATOR).setProperties($$2);
            return LocationCheck.checkLocation(LocationPredicate.Builder.location().setBlock($$3), new BlockPos(p_373700_.getOpposite().getUnitVec3i()));
        }).toArray(LootItemCondition.Builder[]::new);
        return ItemUsedOnLocationTrigger.TriggerInstance.placedBlock(LootItemBlockStatePropertyCondition.hasBlockStateProperties(p_286401_), AnyOfCondition.anyOf($$2));
    }

    private static Criterion<ItemUsedOnLocationTrigger.TriggerInstance> placedComparatorReadingBlock(HolderGetter<Block> p_362632_, Block p_286250_) {
        LootItemCondition.Builder[] $$2 = (LootItemCondition.Builder[])ComparatorBlock.FACING.getPossibleValues().stream().map(p_359377_ -> {
            StatePropertiesPredicate.Builder $$3 = StatePropertiesPredicate.Builder.properties().hasProperty(ComparatorBlock.FACING, p_359377_);
            LootItemBlockStatePropertyCondition.Builder $$4 = new LootItemBlockStatePropertyCondition.Builder(Blocks.COMPARATOR).setProperties($$3);
            LootItemCondition.Builder $$5 = LocationCheck.checkLocation(LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(p_362632_, p_286250_)), new BlockPos(p_359377_.getUnitVec3i()));
            return AllOfCondition.allOf($$4, $$5);
        }).toArray(LootItemCondition.Builder[]::new);
        return ItemUsedOnLocationTrigger.TriggerInstance.placedBlock(AnyOfCondition.anyOf($$2));
    }

    private static Advancement.Builder smithingWithStyle(Advancement.Builder p_285368_) {
        p_285368_.requirements(AdvancementRequirements.Strategy.AND);
        Set<Item> $$1 = Set.of(Items.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE, Items.RIB_ARMOR_TRIM_SMITHING_TEMPLATE, Items.WARD_ARMOR_TRIM_SMITHING_TEMPLATE, Items.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.VEX_ARMOR_TRIM_SMITHING_TEMPLATE, Items.TIDE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE);
        VanillaRecipeProvider.smithingTrims().filter(p_307140_ -> $$1.contains(p_307140_.template())).forEach(p_380819_ -> p_285368_.addCriterion("armor_trimmed_" + String.valueOf(p_380819_.id().location()), RecipeCraftedTrigger.TriggerInstance.craftedItem(p_380819_.id())));
        return p_285368_;
    }

    private static Advancement.Builder craftingANewLook(Advancement.Builder p_285062_) {
        p_285062_.requirements(AdvancementRequirements.Strategy.OR);
        VanillaRecipeProvider.smithingTrims().map(VanillaRecipeProvider.TrimTemplate::id).forEach(p_380821_ -> p_285062_.addCriterion("armor_trimmed_" + String.valueOf(p_380821_.location()), RecipeCraftedTrigger.TriggerInstance.craftedItem(p_380821_)));
        return p_285062_;
    }

    private static Advancement.Builder respectingTheRemnantsCriterions(HolderGetter<Item> p_362778_, Advancement.Builder p_285170_) {
        List<Pair> $$2 = List.of(Pair.of((Object)"desert_pyramid", LootTableTrigger.TriggerInstance.lootTableUsed(BuiltInLootTables.DESERT_PYRAMID_ARCHAEOLOGY)), Pair.of((Object)"desert_well", LootTableTrigger.TriggerInstance.lootTableUsed(BuiltInLootTables.DESERT_WELL_ARCHAEOLOGY)), Pair.of((Object)"ocean_ruin_cold", LootTableTrigger.TriggerInstance.lootTableUsed(BuiltInLootTables.OCEAN_RUIN_COLD_ARCHAEOLOGY)), Pair.of((Object)"ocean_ruin_warm", LootTableTrigger.TriggerInstance.lootTableUsed(BuiltInLootTables.OCEAN_RUIN_WARM_ARCHAEOLOGY)), Pair.of((Object)"trail_ruins_rare", LootTableTrigger.TriggerInstance.lootTableUsed(BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_RARE)), Pair.of((Object)"trail_ruins_common", LootTableTrigger.TriggerInstance.lootTableUsed(BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON)));
        $$2.forEach(p_307142_ -> p_285170_.addCriterion((String)p_307142_.getFirst(), (Criterion)p_307142_.getSecond()));
        String $$3 = "has_sherd";
        p_285170_.addCriterion("has_sherd", InventoryChangeTrigger.TriggerInstance.hasItems(ItemPredicate.Builder.item().of(p_362778_, ItemTags.DECORATED_POT_SHERDS)));
        p_285170_.requirements(new AdvancementRequirements(List.of($$2.stream().map(Pair::getFirst).toList(), List.of("has_sherd"))));
        return p_285170_;
    }

    protected static void createAdventuringTime(HolderLookup.Provider p_330738_, Consumer<AdvancementHolder> p_275645_, AdvancementHolder p_301274_, MultiNoiseBiomeSourceParameterList.Preset p_275211_) {
        VanillaAdventureAdvancements.addBiomes(Advancement.Builder.advancement(), p_330738_, p_275211_.usedBiomes().toList()).parent(p_301274_).display(Items.DIAMOND_BOOTS, (Component)Component.translatable("advancements.adventure.adventuring_time.title"), (Component)Component.translatable("advancements.adventure.adventuring_time.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience(500)).save(p_275645_, "adventure/adventuring_time");
    }

    private static Advancement.Builder addMobsToKill(Advancement.Builder p_248814_, HolderGetter<EntityType<?>> p_363257_, List<EntityType<?>> p_314428_) {
        p_314428_.forEach(p_359380_ -> p_248814_.addCriterion(BuiltInRegistries.ENTITY_TYPE.getKey((EntityType<?>)p_359380_).toString(), KilledTrigger.TriggerInstance.playerKilledEntity(EntityPredicate.Builder.entity().of(p_363257_, (EntityType<?>)p_359380_))));
        return p_248814_;
    }

    protected static Advancement.Builder addBiomes(Advancement.Builder p_249250_, HolderLookup.Provider p_330401_, List<ResourceKey<Biome>> p_251338_) {
        HolderGetter $$3 = p_330401_.lookupOrThrow(Registries.BIOME);
        for (ResourceKey<Biome> $$4 : p_251338_) {
            p_249250_.addCriterion($$4.location().toString(), PlayerTrigger.TriggerInstance.located(LocationPredicate.Builder.inBiome($$3.getOrThrow($$4))));
        }
        return p_249250_;
    }
}

