/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.FileUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.gametest.framework.GameTestBatch;
import net.minecraft.gametest.framework.GameTestBatchFactory;
import net.minecraft.gametest.framework.GameTestBatchListener;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.gametest.framework.MultipleTestTracker;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureBlockPosFinder;
import net.minecraft.gametest.framework.StructureGridSpawner;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestClassNameArgument;
import net.minecraft.gametest.framework.TestFinder;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.gametest.framework.TestFunctionArgument;
import net.minecraft.gametest.framework.TestFunctionFinder;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

public class TestCommand {
    public static final int STRUCTURE_BLOCK_NEARBY_SEARCH_RADIUS = 15;
    public static final int STRUCTURE_BLOCK_FULL_SEARCH_RADIUS = 200;
    public static final int VERIFY_TEST_GRID_AXIS_SIZE = 10;
    public static final int VERIFY_TEST_BATCH_SIZE = 100;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_CLEAR_RADIUS = 200;
    private static final int MAX_CLEAR_RADIUS = 1024;
    private static final int TEST_POS_Z_OFFSET_FROM_PLAYER = 3;
    private static final int SHOW_POS_DURATION_MS = 10000;
    private static final int DEFAULT_X_SIZE = 5;
    private static final int DEFAULT_Y_SIZE = 5;
    private static final int DEFAULT_Z_SIZE = 5;
    private static final String STRUCTURE_BLOCK_ENTITY_COULD_NOT_BE_FOUND = "Structure block entity could not be found";
    private static final TestFinder.Builder<Runner> testFinder = new TestFinder.Builder<Runner>(Runner::new);

    private static ArgumentBuilder<CommandSourceStack, ?> runWithRetryOptions(ArgumentBuilder<CommandSourceStack, ?> p_320965_, Function<CommandContext<CommandSourceStack>, Runner> p_320702_, Function<ArgumentBuilder<CommandSourceStack, ?>, ArgumentBuilder<CommandSourceStack, ?>> p_320600_) {
        return p_320965_.executes(p_319508_ -> ((Runner)p_320702_.apply(p_319508_)).run()).then(((RequiredArgumentBuilder)Commands.argument("numberOfTimes", IntegerArgumentType.integer((int)0)).executes(p_319503_ -> ((Runner)p_320702_.apply(p_319503_)).run(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)p_319503_, (String)"numberOfTimes"), false)))).then(p_320600_.apply(Commands.argument("untilFailed", BoolArgumentType.bool()).executes(p_319489_ -> ((Runner)p_320702_.apply(p_319489_)).run(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)p_319489_, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)p_319489_, (String)"untilFailed")))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> runWithRetryOptions(ArgumentBuilder<CommandSourceStack, ?> p_320397_, Function<CommandContext<CommandSourceStack>, Runner> p_320472_) {
        return TestCommand.runWithRetryOptions(p_320397_, p_320472_, p_319485_ -> p_319485_);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> runWithRetryOptionsAndBuildInfo(ArgumentBuilder<CommandSourceStack, ?> p_320872_, Function<CommandContext<CommandSourceStack>, Runner> p_320896_) {
        return TestCommand.runWithRetryOptions(p_320872_, p_320896_, p_319482_ -> p_319482_.then(((RequiredArgumentBuilder)Commands.argument("rotationSteps", IntegerArgumentType.integer()).executes(p_319487_ -> ((Runner)p_320896_.apply(p_319487_)).run(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)p_319487_, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)p_319487_, (String)"untilFailed")), IntegerArgumentType.getInteger((CommandContext)p_319487_, (String)"rotationSteps")))).then(Commands.argument("testsPerRow", IntegerArgumentType.integer()).executes(p_319484_ -> ((Runner)p_320896_.apply(p_319484_)).run(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)p_319484_, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)p_319484_, (String)"untilFailed")), IntegerArgumentType.getInteger((CommandContext)p_319484_, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)p_319484_, (String)"testsPerRow"))))));
    }

    public static void register(CommandDispatcher<CommandSourceStack> p_127947_) {
        ArgumentBuilder<CommandSourceStack, ?> $$1 = TestCommand.runWithRetryOptionsAndBuildInfo(Commands.argument("onlyRequiredTests", BoolArgumentType.bool()), p_319498_ -> testFinder.failedTests((CommandContext<CommandSourceStack>)p_319498_, BoolArgumentType.getBool((CommandContext)p_319498_, (String)"onlyRequiredTests")));
        ArgumentBuilder<CommandSourceStack, ?> $$2 = TestCommand.runWithRetryOptionsAndBuildInfo(Commands.argument("testClassName", TestClassNameArgument.testClassName()), p_319490_ -> testFinder.allTestsInClass((CommandContext<CommandSourceStack>)p_319490_, TestClassNameArgument.getTestClassName((CommandContext<CommandSourceStack>)p_319490_, "testClassName")));
        p_127947_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("test").then(Commands.literal("run").then(TestCommand.runWithRetryOptionsAndBuildInfo(Commands.argument("testName", TestFunctionArgument.testFunctionArgument()), p_319494_ -> testFinder.byArgument((CommandContext<CommandSourceStack>)p_319494_, "testName"))))).then(Commands.literal("runmultiple").then(((RequiredArgumentBuilder)Commands.argument("testName", TestFunctionArgument.testFunctionArgument()).executes(p_329852_ -> testFinder.byArgument((CommandContext<CommandSourceStack>)p_329852_, "testName").run())).then(Commands.argument("amount", IntegerArgumentType.integer()).executes(p_329853_ -> testFinder.createMultipleCopies(IntegerArgumentType.getInteger((CommandContext)p_329853_, (String)"amount")).byArgument((CommandContext<CommandSourceStack>)p_329853_, "testName").run()))))).then(TestCommand.runWithRetryOptionsAndBuildInfo(Commands.literal("runall").then($$2), testFinder::allTests))).then(TestCommand.runWithRetryOptions(Commands.literal("runthese"), testFinder::allNearby))).then(TestCommand.runWithRetryOptions(Commands.literal("runclosest"), testFinder::nearest))).then(TestCommand.runWithRetryOptions(Commands.literal("runthat"), testFinder::lookedAt))).then(TestCommand.runWithRetryOptionsAndBuildInfo(Commands.literal("runfailed").then($$1), testFinder::failedTests))).then(Commands.literal("verify").then(Commands.argument("testName", TestFunctionArgument.testFunctionArgument()).executes(p_351716_ -> testFinder.byArgument((CommandContext<CommandSourceStack>)p_351716_, "testName").verify())))).then(Commands.literal("verifyclass").then(Commands.argument("testClassName", TestClassNameArgument.testClassName()).executes(p_351715_ -> testFinder.allTestsInClass((CommandContext<CommandSourceStack>)p_351715_, TestClassNameArgument.getTestClassName((CommandContext<CommandSourceStack>)p_351715_, "testClassName")).verify())))).then(Commands.literal("locate").then(Commands.argument("testName", TestFunctionArgument.testFunctionArgument()).executes(p_340631_ -> testFinder.locateByName((CommandContext<CommandSourceStack>)p_340631_, "minecraft:" + TestFunctionArgument.getTestFunction((CommandContext<CommandSourceStack>)p_340631_, "testName").structureName()).locate())))).then(Commands.literal("resetclosest").executes(p_319479_ -> testFinder.nearest((CommandContext<CommandSourceStack>)p_319479_).reset()))).then(Commands.literal("resetthese").executes(p_319492_ -> testFinder.allNearby((CommandContext<CommandSourceStack>)p_319492_).reset()))).then(Commands.literal("resetthat").executes(p_319478_ -> testFinder.lookedAt((CommandContext<CommandSourceStack>)p_319478_).reset()))).then(Commands.literal("export").then(Commands.argument("testName", StringArgumentType.word()).executes(p_319491_ -> TestCommand.exportTestStructure((CommandSourceStack)p_319491_.getSource(), "minecraft:" + StringArgumentType.getString((CommandContext)p_319491_, (String)"testName")))))).then(Commands.literal("exportclosest").executes(p_319480_ -> testFinder.nearest((CommandContext<CommandSourceStack>)p_319480_).export()))).then(Commands.literal("exportthese").executes(p_319505_ -> testFinder.allNearby((CommandContext<CommandSourceStack>)p_319505_).export()))).then(Commands.literal("exportthat").executes(p_319514_ -> testFinder.lookedAt((CommandContext<CommandSourceStack>)p_319514_).export()))).then(Commands.literal("clearthat").executes(p_319506_ -> testFinder.lookedAt((CommandContext<CommandSourceStack>)p_319506_).clear()))).then(Commands.literal("clearthese").executes(p_319504_ -> testFinder.allNearby((CommandContext<CommandSourceStack>)p_319504_).clear()))).then(((LiteralArgumentBuilder)Commands.literal("clearall").executes(p_319509_ -> testFinder.radius((CommandContext<CommandSourceStack>)p_319509_, 200).clear())).then(Commands.argument("radius", IntegerArgumentType.integer()).executes(p_319493_ -> testFinder.radius((CommandContext<CommandSourceStack>)p_319493_, Mth.clamp(IntegerArgumentType.getInteger((CommandContext)p_319493_, (String)"radius"), 0, 1024)).clear())))).then(Commands.literal("import").then(Commands.argument("testName", StringArgumentType.word()).executes(p_128025_ -> TestCommand.importTestStructure((CommandSourceStack)p_128025_.getSource(), StringArgumentType.getString((CommandContext)p_128025_, (String)"testName")))))).then(Commands.literal("stop").executes(p_319497_ -> TestCommand.stopTests()))).then(((LiteralArgumentBuilder)Commands.literal("pos").executes(p_128023_ -> TestCommand.showPos((CommandSourceStack)p_128023_.getSource(), "pos"))).then(Commands.argument("var", StringArgumentType.word()).executes(p_128021_ -> TestCommand.showPos((CommandSourceStack)p_128021_.getSource(), StringArgumentType.getString((CommandContext)p_128021_, (String)"var")))))).then(Commands.literal("create").then(((RequiredArgumentBuilder)Commands.argument("testName", StringArgumentType.word()).suggests(TestFunctionArgument::suggestTestFunction).executes(p_128019_ -> TestCommand.createNewStructure((CommandSourceStack)p_128019_.getSource(), StringArgumentType.getString((CommandContext)p_128019_, (String)"testName"), 5, 5, 5))).then(((RequiredArgumentBuilder)Commands.argument("width", IntegerArgumentType.integer()).executes(p_128014_ -> TestCommand.createNewStructure((CommandSourceStack)p_128014_.getSource(), StringArgumentType.getString((CommandContext)p_128014_, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)p_128014_, (String)"width"), IntegerArgumentType.getInteger((CommandContext)p_128014_, (String)"width"), IntegerArgumentType.getInteger((CommandContext)p_128014_, (String)"width")))).then(Commands.argument("height", IntegerArgumentType.integer()).then(Commands.argument("depth", IntegerArgumentType.integer()).executes(p_128007_ -> TestCommand.createNewStructure((CommandSourceStack)p_128007_.getSource(), StringArgumentType.getString((CommandContext)p_128007_, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)p_128007_, (String)"width"), IntegerArgumentType.getInteger((CommandContext)p_128007_, (String)"height"), IntegerArgumentType.getInteger((CommandContext)p_128007_, (String)"depth")))))))));
    }

    private static int resetGameTestInfo(GameTestInfo p_320507_) {
        p_320507_.getLevel().getEntities(null, p_320507_.getStructureBounds()).stream().forEach(p_326748_ -> p_326748_.remove(Entity.RemovalReason.DISCARDED));
        p_320507_.getStructureBlockEntity().placeStructure(p_320507_.getLevel());
        StructureUtils.removeBarriers(p_320507_.getStructureBounds(), p_320507_.getLevel());
        TestCommand.say(p_320507_.getLevel(), "Reset succeded for: " + p_320507_.getTestName(), ChatFormatting.GREEN);
        return 1;
    }

    static Stream<GameTestInfo> toGameTestInfos(CommandSourceStack p_320827_, RetryOptions p_320932_, StructureBlockPosFinder p_320543_) {
        return p_320543_.findStructureBlockPos().map(p_319501_ -> TestCommand.createGameTestInfo(p_319501_, p_320827_.getLevel(), p_320932_)).flatMap(Optional::stream);
    }

    static Stream<GameTestInfo> toGameTestInfo(CommandSourceStack p_320465_, RetryOptions p_320183_, TestFunctionFinder p_320598_, int p_320854_) {
        return p_320598_.findTestFunctions().filter(p_319496_ -> TestCommand.verifyStructureExists(p_320465_.getLevel(), p_319496_.structureName())).map(p_319513_ -> new GameTestInfo((TestFunction)p_319513_, StructureUtils.getRotationForRotationSteps(p_320854_), p_320465_.getLevel(), p_320183_));
    }

    private static Optional<GameTestInfo> createGameTestInfo(BlockPos p_320172_, ServerLevel p_320346_, RetryOptions p_320822_) {
        StructureBlockEntity $$3 = (StructureBlockEntity)p_320346_.getBlockEntity(p_320172_);
        if ($$3 == null) {
            TestCommand.say(p_320346_, STRUCTURE_BLOCK_ENTITY_COULD_NOT_BE_FOUND, ChatFormatting.RED);
            return Optional.empty();
        }
        String $$4 = $$3.getMetaData();
        Optional<TestFunction> $$5 = GameTestRegistry.findTestFunction($$4);
        if ($$5.isEmpty()) {
            TestCommand.say(p_320346_, "Test function for test " + $$4 + " could not be found", ChatFormatting.RED);
            return Optional.empty();
        }
        TestFunction $$6 = $$5.get();
        GameTestInfo $$7 = new GameTestInfo($$6, $$3.getRotation(), p_320346_, p_320822_);
        $$7.setStructureBlockPos(p_320172_);
        if (!TestCommand.verifyStructureExists(p_320346_, $$7.getStructureName())) {
            return Optional.empty();
        }
        return Optional.of($$7);
    }

    private static int createNewStructure(CommandSourceStack p_127968_, String p_127969_, int p_127970_, int p_127971_, int p_127972_) {
        if (p_127970_ > 48 || p_127971_ > 48 || p_127972_ > 48) {
            throw new IllegalArgumentException("The structure must be less than 48 blocks big in each axis");
        }
        ServerLevel $$5 = p_127968_.getLevel();
        BlockPos $$6 = TestCommand.createTestPositionAround(p_127968_).below();
        StructureUtils.createNewEmptyStructureBlock(p_127969_.toLowerCase(), $$6, new Vec3i(p_127970_, p_127971_, p_127972_), Rotation.NONE, $$5);
        BlockPos $$7 = $$6.above();
        BlockPos $$8 = $$7.offset(p_127970_ - 1, 0, p_127972_ - 1);
        BlockPos.betweenClosedStream($$7, $$8).forEach(p_326747_ -> $$5.setBlockAndUpdate((BlockPos)p_326747_, Blocks.BEDROCK.defaultBlockState()));
        StructureUtils.addCommandBlockAndButtonToStartTest($$6, new BlockPos(1, 0, -1), Rotation.NONE, $$5);
        return 0;
    }

    private static int showPos(CommandSourceStack p_127960_, String p_127961_) throws CommandSyntaxException {
        ServerLevel $$4;
        BlockHitResult $$2 = (BlockHitResult)p_127960_.getPlayerOrException().pick(10.0, 1.0f, false);
        BlockPos $$3 = $$2.getBlockPos();
        Optional<BlockPos> $$5 = StructureUtils.findStructureBlockContainingPos($$3, 15, $$4 = p_127960_.getLevel());
        if ($$5.isEmpty()) {
            $$5 = StructureUtils.findStructureBlockContainingPos($$3, 200, $$4);
        }
        if ($$5.isEmpty()) {
            p_127960_.sendFailure(Component.literal("Can't find a structure block that contains the targeted pos " + String.valueOf($$3)));
            return 0;
        }
        StructureBlockEntity $$6 = (StructureBlockEntity)$$4.getBlockEntity($$5.get());
        if ($$6 == null) {
            TestCommand.say($$4, STRUCTURE_BLOCK_ENTITY_COULD_NOT_BE_FOUND, ChatFormatting.RED);
            return 0;
        }
        BlockPos $$7 = $$3.subtract($$5.get());
        String $$8 = $$7.getX() + ", " + $$7.getY() + ", " + $$7.getZ();
        String $$9 = $$6.getMetaData();
        MutableComponent $$10 = Component.literal($$8).setStyle(Style.EMPTY.withBold(true).withColor(ChatFormatting.GREEN).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, Component.literal("Click to copy to clipboard"))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, "final BlockPos " + p_127961_ + " = new BlockPos(" + $$8 + ");")));
        p_127960_.sendSuccess(() -> Component.literal("Position relative to " + $$9 + ": ").append($$10), false);
        DebugPackets.sendGameTestAddMarker($$4, new BlockPos($$3), $$8, -2147418368, 10000);
        return 1;
    }

    static int stopTests() {
        GameTestTicker.SINGLETON.clear();
        return 1;
    }

    static int trackAndStartRunner(CommandSourceStack p_320627_, ServerLevel p_320564_, GameTestRunner p_320295_) {
        p_320295_.addListener(new TestBatchSummaryDisplayer(p_320627_));
        MultipleTestTracker $$3 = new MultipleTestTracker(p_320295_.getTestInfos());
        $$3.addListener(new TestSummaryDisplayer(p_320564_, $$3));
        $$3.addFailureListener(p_127992_ -> GameTestRegistry.rememberFailedTest(p_127992_.getTestFunction()));
        p_320295_.start();
        return 1;
    }

    static int saveAndExportTestStructure(CommandSourceStack p_309558_, StructureBlockEntity p_309587_) {
        String $$2 = p_309587_.getStructureName();
        if (!p_309587_.saveStructure(true)) {
            TestCommand.say(p_309558_, "Failed to save structure " + $$2);
        }
        return TestCommand.exportTestStructure(p_309558_, $$2);
    }

    private static int exportTestStructure(CommandSourceStack p_128011_, String p_128012_) {
        Path $$2 = Paths.get(StructureUtils.testStructuresDir, new String[0]);
        ResourceLocation $$3 = ResourceLocation.parse(p_128012_);
        Path $$4 = p_128011_.getLevel().getStructureManager().createAndValidatePathToGeneratedStructure($$3, ".nbt");
        Path $$5 = NbtToSnbt.convertStructure(CachedOutput.NO_CACHE, $$4, $$3.getPath(), $$2);
        if ($$5 == null) {
            TestCommand.say(p_128011_, "Failed to export " + String.valueOf($$4));
            return 1;
        }
        try {
            FileUtil.createDirectoriesSafe($$5.getParent());
        }
        catch (IOException $$6) {
            TestCommand.say(p_128011_, "Could not create folder " + String.valueOf($$5.getParent()));
            LOGGER.error("Could not create export folder", (Throwable)$$6);
            return 1;
        }
        TestCommand.say(p_128011_, "Exported " + p_128012_ + " to " + String.valueOf($$5.toAbsolutePath()));
        return 0;
    }

    private static boolean verifyStructureExists(ServerLevel p_309700_, String p_320698_) {
        if (p_309700_.getStructureManager().get(ResourceLocation.parse(p_320698_)).isEmpty()) {
            TestCommand.say(p_309700_, "Test structure " + p_320698_ + " could not be found", ChatFormatting.RED);
            return false;
        }
        return true;
    }

    static BlockPos createTestPositionAround(CommandSourceStack p_308921_) {
        BlockPos $$1 = BlockPos.containing(p_308921_.getPosition());
        int $$2 = p_308921_.getLevel().getHeightmapPos(Heightmap.Types.WORLD_SURFACE, $$1).getY();
        return new BlockPos($$1.getX(), $$2 + 1, $$1.getZ() + 3);
    }

    static void say(CommandSourceStack p_128004_, String p_128005_) {
        p_128004_.sendSuccess(() -> Component.literal(p_128005_), false);
    }

    private static int importTestStructure(CommandSourceStack p_128016_, String p_128017_) {
        Path $$2 = Paths.get(StructureUtils.testStructuresDir, p_128017_ + ".snbt");
        ResourceLocation $$3 = ResourceLocation.withDefaultNamespace(p_128017_);
        Path $$4 = p_128016_.getLevel().getStructureManager().createAndValidatePathToGeneratedStructure($$3, ".nbt");
        try {
            BufferedReader $$5 = Files.newBufferedReader($$2);
            String $$6 = IOUtils.toString((Reader)$$5);
            Files.createDirectories($$4.getParent(), new FileAttribute[0]);
            try (OutputStream $$7 = Files.newOutputStream($$4, new OpenOption[0]);){
                NbtIo.writeCompressed(NbtUtils.snbtToStructure($$6), $$7);
            }
            p_128016_.getLevel().getStructureManager().remove($$3);
            TestCommand.say(p_128016_, "Imported to " + String.valueOf($$4.toAbsolutePath()));
            return 0;
        }
        catch (CommandSyntaxException | IOException $$8) {
            LOGGER.error("Failed to load structure {}", (Object)p_128017_, (Object)$$8);
            return 1;
        }
    }

    static void say(ServerLevel p_127934_, String p_127935_, ChatFormatting p_127936_) {
        p_127934_.getPlayers(p_127945_ -> true).forEach(p_313469_ -> p_313469_.sendSystemMessage(Component.literal(p_127935_).withStyle(p_127936_)));
    }

    record TestBatchSummaryDisplayer(CommandSourceStack source) implements GameTestBatchListener
    {
        @Override
        public void testBatchStarting(GameTestBatch p_319827_) {
            TestCommand.say(this.source, "Starting batch: " + p_319827_.name());
        }

        @Override
        public void testBatchFinished(GameTestBatch p_320779_) {
        }
    }

    public record TestSummaryDisplayer(ServerLevel level, MultipleTestTracker tracker) implements GameTestListener
    {
        @Override
        public void testStructureLoaded(GameTestInfo p_128064_) {
        }

        @Override
        public void testPassed(GameTestInfo p_177797_, GameTestRunner p_320726_) {
            TestSummaryDisplayer.showTestSummaryIfAllDone(this.level, this.tracker);
        }

        @Override
        public void testFailed(GameTestInfo p_128066_, GameTestRunner p_320567_) {
            TestSummaryDisplayer.showTestSummaryIfAllDone(this.level, this.tracker);
        }

        @Override
        public void testAddedForRerun(GameTestInfo p_319856_, GameTestInfo p_320528_, GameTestRunner p_319832_) {
            this.tracker.addTestToTrack(p_320528_);
        }

        private static void showTestSummaryIfAllDone(ServerLevel p_319899_, MultipleTestTracker p_320682_) {
            if (p_320682_.isDone()) {
                TestCommand.say(p_319899_, "GameTest done! " + p_320682_.getTotalCount() + " tests were run", ChatFormatting.WHITE);
                if (p_320682_.hasFailedRequired()) {
                    TestCommand.say(p_319899_, p_320682_.getFailedRequiredCount() + " required tests failed :(", ChatFormatting.RED);
                } else {
                    TestCommand.say(p_319899_, "All required tests passed :)", ChatFormatting.GREEN);
                }
                if (p_320682_.hasFailedOptional()) {
                    TestCommand.say(p_319899_, p_320682_.getFailedOptionalCount() + " optional tests failed", ChatFormatting.GRAY);
                }
            }
        }
    }

    public static class Runner {
        private final TestFinder<Runner> finder;

        public Runner(TestFinder<Runner> p_320723_) {
            this.finder = p_320723_;
        }

        public int reset() {
            TestCommand.stopTests();
            return TestCommand.toGameTestInfos(this.finder.source(), RetryOptions.noRetries(), this.finder).map(TestCommand::resetGameTestInfo).toList().isEmpty() ? 0 : 1;
        }

        private <T> void logAndRun(Stream<T> p_320016_, ToIntFunction<T> p_319791_, Runnable p_320766_, Consumer<Integer> p_320345_) {
            int $$4 = p_320016_.mapToInt(p_319791_).sum();
            if ($$4 == 0) {
                p_320766_.run();
            } else {
                p_320345_.accept($$4);
            }
        }

        public int clear() {
            TestCommand.stopTests();
            CommandSourceStack $$0 = this.finder.source();
            ServerLevel $$1 = $$0.getLevel();
            GameTestRunner.clearMarkers($$1);
            this.logAndRun(this.finder.findStructureBlockPos(), p_320518_ -> {
                StructureBlockEntity $$2 = (StructureBlockEntity)$$1.getBlockEntity((BlockPos)p_320518_);
                if ($$2 == null) {
                    return 0;
                }
                BoundingBox $$3 = StructureUtils.getStructureBoundingBox($$2);
                StructureUtils.clearSpaceForStructure($$3, $$1);
                return 1;
            }, () -> TestCommand.say($$1, "Could not find any structures to clear", ChatFormatting.RED), p_320503_ -> TestCommand.say($$0, "Cleared " + p_320503_ + " structures"));
            return 1;
        }

        public int export() {
            MutableBoolean $$0 = new MutableBoolean(true);
            CommandSourceStack $$1 = this.finder.source();
            ServerLevel $$2 = $$1.getLevel();
            this.logAndRun(this.finder.findStructureBlockPos(), p_320242_ -> {
                StructureBlockEntity $$4 = (StructureBlockEntity)$$2.getBlockEntity((BlockPos)p_320242_);
                if ($$4 == null) {
                    TestCommand.say($$2, TestCommand.STRUCTURE_BLOCK_ENTITY_COULD_NOT_BE_FOUND, ChatFormatting.RED);
                    $$0.setFalse();
                    return 0;
                }
                if (TestCommand.saveAndExportTestStructure($$1, $$4) != 0) {
                    $$0.setFalse();
                }
                return 1;
            }, () -> TestCommand.say($$2, "Could not find any structures to export", ChatFormatting.RED), p_320666_ -> TestCommand.say($$1, "Exported " + p_320666_ + " structures"));
            return $$0.getValue() != false ? 0 : 1;
        }

        int verify() {
            TestCommand.stopTests();
            CommandSourceStack $$0 = this.finder.source();
            ServerLevel $$1 = $$0.getLevel();
            BlockPos $$2 = TestCommand.createTestPositionAround($$0);
            List<GameTestInfo> $$3 = Stream.concat(TestCommand.toGameTestInfos($$0, RetryOptions.noRetries(), this.finder), TestCommand.toGameTestInfo($$0, RetryOptions.noRetries(), this.finder, 0)).toList();
            GameTestRunner.clearMarkers($$1);
            GameTestRegistry.forgetFailedTests();
            ArrayList<GameTestBatch> $$4 = new ArrayList<GameTestBatch>();
            for (GameTestInfo $$5 : $$3) {
                for (Rotation $$6 : Rotation.values()) {
                    ArrayList<GameTestInfo> $$7 = new ArrayList<GameTestInfo>();
                    for (int $$8 = 0; $$8 < 100; ++$$8) {
                        GameTestInfo $$9 = new GameTestInfo($$5.getTestFunction(), $$6, $$1, new RetryOptions(1, true));
                        $$7.add($$9);
                    }
                    GameTestBatch $$10 = GameTestBatchFactory.toGameTestBatch($$7, $$5.getTestFunction().batchName(), $$6.ordinal());
                    $$4.add($$10);
                }
            }
            StructureGridSpawner $$11 = new StructureGridSpawner($$2, 10, true);
            GameTestRunner $$12 = GameTestRunner.Builder.fromBatches($$4, $$1).batcher(GameTestBatchFactory.fromGameTestInfo(100)).newStructureSpawner($$11).existingStructureSpawner($$11).haltOnError(true).build();
            return TestCommand.trackAndStartRunner($$0, $$1, $$12);
        }

        public int run(RetryOptions p_320091_, int p_320456_, int p_320467_) {
            TestCommand.stopTests();
            CommandSourceStack $$3 = this.finder.source();
            ServerLevel $$4 = $$3.getLevel();
            BlockPos $$5 = TestCommand.createTestPositionAround($$3);
            List<GameTestInfo> $$6 = Stream.concat(TestCommand.toGameTestInfos($$3, p_320091_, this.finder), TestCommand.toGameTestInfo($$3, p_320091_, this.finder, p_320456_)).toList();
            if ($$6.isEmpty()) {
                TestCommand.say($$3, "No tests found");
                return 0;
            }
            GameTestRunner.clearMarkers($$4);
            GameTestRegistry.forgetFailedTests();
            TestCommand.say($$3, "Running " + $$6.size() + " tests...");
            GameTestRunner $$7 = GameTestRunner.Builder.fromInfo($$6, $$4).newStructureSpawner(new StructureGridSpawner($$5, p_320467_, false)).build();
            return TestCommand.trackAndStartRunner($$3, $$4, $$7);
        }

        public int run(int p_320306_, int p_320333_) {
            return this.run(RetryOptions.noRetries(), p_320306_, p_320333_);
        }

        public int run(int p_319859_) {
            return this.run(RetryOptions.noRetries(), p_319859_, 8);
        }

        public int run(RetryOptions p_320906_, int p_320419_) {
            return this.run(p_320906_, p_320419_, 8);
        }

        public int run(RetryOptions p_320034_) {
            return this.run(p_320034_, 0, 8);
        }

        public int run() {
            return this.run(RetryOptions.noRetries());
        }

        public int locate() {
            TestCommand.say(this.finder.source(), "Started locating test structures, this might take a while..");
            MutableInt $$0 = new MutableInt(0);
            BlockPos $$1 = BlockPos.containing(this.finder.source().getPosition());
            this.finder.findStructureBlockPos().forEach(p_340637_ -> {
                StructureBlockEntity $$3 = (StructureBlockEntity)this.finder.source().getLevel().getBlockEntity((BlockPos)p_340637_);
                if ($$3 == null) {
                    return;
                }
                Direction $$4 = $$3.getRotation().rotate(Direction.NORTH);
                BlockPos $$5 = $$3.getBlockPos().relative($$4, 2);
                int $$6 = (int)$$4.getOpposite().toYRot();
                String $$7 = String.format("/tp @s %d %d %d %d 0", $$5.getX(), $$5.getY(), $$5.getZ(), $$6);
                int $$8 = $$1.getX() - p_340637_.getX();
                int $$9 = $$1.getZ() - p_340637_.getZ();
                int $$10 = Mth.floor(Mth.sqrt($$8 * $$8 + $$9 * $$9));
                MutableComponent $$11 = ComponentUtils.wrapInSquareBrackets(Component.translatable("chat.coordinates", p_340637_.getX(), p_340637_.getY(), p_340637_.getZ())).withStyle(p_340633_ -> p_340633_.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, $$7)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, Component.translatable("chat.coordinates.tooltip"))));
                MutableComponent $$12 = Component.literal("Found structure at: ").append($$11).append(" (distance: " + $$10 + ")");
                this.finder.source().sendSuccess(() -> $$12, false);
                $$0.increment();
            });
            int $$2 = $$0.intValue();
            if ($$2 == 0) {
                TestCommand.say(this.finder.source().getLevel(), "No such test structure found", ChatFormatting.RED);
                return 0;
            }
            TestCommand.say(this.finder.source().getLevel(), "Finished locating, found " + $$2 + " structure(s)", ChatFormatting.GREEN);
            return 1;
        }
    }
}

