/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.datafixers.util.Function6;
import com.mojang.datafixers.util.Function7;
import com.mojang.datafixers.util.Function8;
import io.netty.buffer.ByteBuf;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.codec.StreamMemberEncoder;

public interface StreamCodec<B, V>
extends StreamDecoder<B, V>,
StreamEncoder<B, V> {
    public static <B, V> StreamCodec<B, V> of(final StreamEncoder<B, V> p_320243_, final StreamDecoder<B, V> p_320197_) {
        return new StreamCodec<B, V>(){

            @Override
            public V decode(B p_319945_) {
                return p_320197_.decode(p_319945_);
            }

            @Override
            public void encode(B p_320538_, V p_320754_) {
                p_320243_.encode(p_320538_, p_320754_);
            }
        };
    }

    public static <B, V> StreamCodec<B, V> ofMember(final StreamMemberEncoder<B, V> p_320316_, final StreamDecoder<B, V> p_319991_) {
        return new StreamCodec<B, V>(){

            @Override
            public V decode(B p_320797_) {
                return p_319991_.decode(p_320797_);
            }

            @Override
            public void encode(B p_319939_, V p_320568_) {
                p_320316_.encode(p_320568_, p_319939_);
            }
        };
    }

    public static <B, V> StreamCodec<B, V> unit(final V p_320438_) {
        return new StreamCodec<B, V>(){

            @Override
            public V decode(B p_320572_) {
                return p_320438_;
            }

            @Override
            public void encode(B p_320044_, V p_320328_) {
                if (!p_320328_.equals(p_320438_)) {
                    throw new IllegalStateException("Can't encode '" + String.valueOf(p_320328_) + "', expected '" + String.valueOf(p_320438_) + "'");
                }
            }
        };
    }

    default public <O> StreamCodec<B, O> apply(CodecOperation<B, V, O> p_320531_) {
        return p_320531_.apply(this);
    }

    default public <O> StreamCodec<B, O> map(final Function<? super V, ? extends O> p_320812_, final Function<? super O, ? extends V> p_320191_) {
        return new StreamCodec<B, O>(){

            @Override
            public O decode(B p_320534_) {
                return p_320812_.apply(StreamCodec.this.decode(p_320534_));
            }

            @Override
            public void encode(B p_319798_, O p_320273_) {
                StreamCodec.this.encode(p_319798_, p_320191_.apply(p_320273_));
            }
        };
    }

    default public <O extends ByteBuf> StreamCodec<O, V> mapStream(final Function<O, ? extends B> p_320784_) {
        return new StreamCodec<O, V>(){

            @Override
            public V decode(O p_319818_) {
                Object $$1 = p_320784_.apply(p_319818_);
                return StreamCodec.this.decode($$1);
            }

            @Override
            public void encode(O p_319973_, V p_319843_) {
                Object $$2 = p_320784_.apply(p_319973_);
                StreamCodec.this.encode($$2, p_319843_);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((O)((ByteBuf)object), (V)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((O)((ByteBuf)object));
            }
        };
    }

    default public <U> StreamCodec<B, U> dispatch(final Function<? super U, ? extends V> p_320474_, final Function<? super V, ? extends StreamCodec<? super B, ? extends U>> p_320190_) {
        return new StreamCodec<B, U>(){

            @Override
            public U decode(B p_320094_) {
                Object $$1 = StreamCodec.this.decode(p_320094_);
                StreamCodec $$2 = (StreamCodec)p_320190_.apply($$1);
                return $$2.decode(p_320094_);
            }

            @Override
            public void encode(B p_320767_, U p_320010_) {
                Object $$2 = p_320474_.apply(p_320010_);
                StreamCodec $$3 = (StreamCodec)p_320190_.apply($$2);
                StreamCodec.this.encode(p_320767_, $$2);
                $$3.encode(p_320767_, p_320010_);
            }
        };
    }

    public static <B, C, T1> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> p_320179_, final Function<C, T1> p_320085_, final Function<T1, C> p_320672_) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B p_320924_) {
                Object $$1 = p_320179_.decode(p_320924_);
                return p_320672_.apply($$1);
            }

            @Override
            public void encode(B p_320798_, C p_320749_) {
                p_320179_.encode(p_320798_, p_320085_.apply(p_320749_));
            }
        };
    }

    public static <B, C, T1, T2> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> p_320642_, final Function<C, T1> p_320284_, final StreamCodec<? super B, T2> p_320068_, final Function<C, T2> p_319959_, final BiFunction<T1, T2, C> p_320761_) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B p_320168_) {
                Object $$1 = p_320642_.decode(p_320168_);
                Object $$2 = p_320068_.decode(p_320168_);
                return p_320761_.apply($$1, $$2);
            }

            @Override
            public void encode(B p_320592_, C p_320163_) {
                p_320642_.encode(p_320592_, p_320284_.apply(p_320163_));
                p_320068_.encode(p_320592_, p_319959_.apply(p_320163_));
            }
        };
    }

    public static <B, C, T1, T2, T3> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> p_320928_, final Function<C, T1> p_320123_, final StreamCodec<? super B, T2> p_319815_, final Function<C, T2> p_319965_, final StreamCodec<? super B, T3> p_319834_, final Function<C, T3> p_320645_, final Function3<T1, T2, T3, C> p_320386_) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B p_320842_) {
                Object $$1 = p_320928_.decode(p_320842_);
                Object $$2 = p_319815_.decode(p_320842_);
                Object $$3 = p_319834_.decode(p_320842_);
                return p_320386_.apply($$1, $$2, $$3);
            }

            @Override
            public void encode(B p_320737_, C p_320439_) {
                p_320928_.encode(p_320737_, p_320123_.apply(p_320439_));
                p_319815_.encode(p_320737_, p_319965_.apply(p_320439_));
                p_319834_.encode(p_320737_, p_320645_.apply(p_320439_));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> p_323726_, final Function<C, T1> p_324414_, final StreamCodec<? super B, T2> p_323659_, final Function<C, T2> p_323932_, final StreamCodec<? super B, T3> p_323964_, final Function<C, T3> p_324282_, final StreamCodec<? super B, T4> p_323671_, final Function<C, T4> p_324254_, final Function4<T1, T2, T3, T4, C> p_324090_) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B p_323859_) {
                Object $$1 = p_323726_.decode(p_323859_);
                Object $$2 = p_323659_.decode(p_323859_);
                Object $$3 = p_323964_.decode(p_323859_);
                Object $$4 = p_323671_.decode(p_323859_);
                return p_324090_.apply($$1, $$2, $$3, $$4);
            }

            @Override
            public void encode(B p_323667_, C p_323469_) {
                p_323726_.encode(p_323667_, p_324414_.apply(p_323469_));
                p_323659_.encode(p_323667_, p_323932_.apply(p_323469_));
                p_323964_.encode(p_323667_, p_324282_.apply(p_323469_));
                p_323671_.encode(p_323667_, p_324254_.apply(p_323469_));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> p_324413_, final Function<C, T1> p_323568_, final StreamCodec<? super B, T2> p_323835_, final Function<C, T2> p_323513_, final StreamCodec<? super B, T3> p_324112_, final Function<C, T3> p_323815_, final StreamCodec<? super B, T4> p_323483_, final Function<C, T4> p_323725_, final StreamCodec<? super B, T5> p_324486_, final Function<C, T5> p_323518_, final Function5<T1, T2, T3, T4, T5, C> p_324480_) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B p_324610_) {
                Object $$1 = p_324413_.decode(p_324610_);
                Object $$2 = p_323835_.decode(p_324610_);
                Object $$3 = p_324112_.decode(p_324610_);
                Object $$4 = p_323483_.decode(p_324610_);
                Object $$5 = p_324486_.decode(p_324610_);
                return p_324480_.apply($$1, $$2, $$3, $$4, $$5);
            }

            @Override
            public void encode(B p_323786_, C p_323619_) {
                p_324413_.encode(p_323786_, p_323568_.apply(p_323619_));
                p_323835_.encode(p_323786_, p_323513_.apply(p_323619_));
                p_324112_.encode(p_323786_, p_323815_.apply(p_323619_));
                p_323483_.encode(p_323786_, p_323725_.apply(p_323619_));
                p_324486_.encode(p_323786_, p_323518_.apply(p_323619_));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> p_331822_, final Function<C, T1> p_330864_, final StreamCodec<? super B, T2> p_331390_, final Function<C, T2> p_331203_, final StreamCodec<? super B, T3> p_331499_, final Function<C, T3> p_330294_, final StreamCodec<? super B, T4> p_331169_, final Function<C, T4> p_331830_, final StreamCodec<? super B, T5> p_331057_, final Function<C, T5> p_331593_, final StreamCodec<? super B, T6> p_331117_, final Function<C, T6> p_331904_, final Function6<T1, T2, T3, T4, T5, T6, C> p_331335_) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B p_330310_) {
                Object $$1 = p_331822_.decode(p_330310_);
                Object $$2 = p_331390_.decode(p_330310_);
                Object $$3 = p_331499_.decode(p_330310_);
                Object $$4 = p_331169_.decode(p_330310_);
                Object $$5 = p_331057_.decode(p_330310_);
                Object $$6 = p_331117_.decode(p_330310_);
                return p_331335_.apply($$1, $$2, $$3, $$4, $$5, $$6);
            }

            @Override
            public void encode(B p_332052_, C p_331912_) {
                p_331822_.encode(p_332052_, p_330864_.apply(p_331912_));
                p_331390_.encode(p_332052_, p_331203_.apply(p_331912_));
                p_331499_.encode(p_332052_, p_330294_.apply(p_331912_));
                p_331169_.encode(p_332052_, p_331830_.apply(p_331912_));
                p_331057_.encode(p_332052_, p_331593_.apply(p_331912_));
                p_331117_.encode(p_332052_, p_331904_.apply(p_331912_));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> p_373078_, final Function<C, T1> p_372935_, final StreamCodec<? super B, T2> p_372849_, final Function<C, T2> p_372886_, final StreamCodec<? super B, T3> p_372969_, final Function<C, T3> p_372958_, final StreamCodec<? super B, T4> p_373122_, final Function<C, T4> p_372916_, final StreamCodec<? super B, T5> p_373075_, final Function<C, T5> p_373047_, final StreamCodec<? super B, T6> p_372992_, final Function<C, T6> p_372826_, final StreamCodec<? super B, T7> p_372832_, final Function<C, T7> p_373016_, final Function7<T1, T2, T3, T4, T5, T6, T7, C> p_372975_) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B p_330903_) {
                Object $$1 = p_373078_.decode(p_330903_);
                Object $$2 = p_372849_.decode(p_330903_);
                Object $$3 = p_372969_.decode(p_330903_);
                Object $$4 = p_373122_.decode(p_330903_);
                Object $$5 = p_373075_.decode(p_330903_);
                Object $$6 = p_372992_.decode(p_330903_);
                Object $$7 = p_372832_.decode(p_330903_);
                return p_372975_.apply($$1, $$2, $$3, $$4, $$5, $$6, $$7);
            }

            @Override
            public void encode(B p_331641_, C p_330634_) {
                p_373078_.encode(p_331641_, p_372935_.apply(p_330634_));
                p_372849_.encode(p_331641_, p_372886_.apply(p_330634_));
                p_372969_.encode(p_331641_, p_372958_.apply(p_330634_));
                p_373122_.encode(p_331641_, p_372916_.apply(p_330634_));
                p_373075_.encode(p_331641_, p_373047_.apply(p_330634_));
                p_372992_.encode(p_331641_, p_372826_.apply(p_330634_));
                p_372832_.encode(p_331641_, p_373016_.apply(p_330634_));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> p_380960_, final Function<C, T1> p_381028_, final StreamCodec<? super B, T2> p_381002_, final Function<C, T2> p_381159_, final StreamCodec<? super B, T3> p_381128_, final Function<C, T3> p_381004_, final StreamCodec<? super B, T4> p_380994_, final Function<C, T4> p_381101_, final StreamCodec<? super B, T5> p_381073_, final Function<C, T5> p_381117_, final StreamCodec<? super B, T6> p_380957_, final Function<C, T6> p_380996_, final StreamCodec<? super B, T7> p_381122_, final Function<C, T7> p_381050_, final StreamCodec<? super B, T8> p_381110_, final Function<C, T8> p_380986_, final Function8<T1, T2, T3, T4, T5, T6, T7, T8, C> p_381061_) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B p_373035_) {
                Object $$1 = p_380960_.decode(p_373035_);
                Object $$2 = p_381002_.decode(p_373035_);
                Object $$3 = p_381128_.decode(p_373035_);
                Object $$4 = p_380994_.decode(p_373035_);
                Object $$5 = p_381073_.decode(p_373035_);
                Object $$6 = p_380957_.decode(p_373035_);
                Object $$7 = p_381122_.decode(p_373035_);
                Object $$8 = p_381110_.decode(p_373035_);
                return p_381061_.apply($$1, $$2, $$3, $$4, $$5, $$6, $$7, $$8);
            }

            @Override
            public void encode(B p_372928_, C p_372897_) {
                p_380960_.encode(p_372928_, p_381028_.apply(p_372897_));
                p_381002_.encode(p_372928_, p_381159_.apply(p_372897_));
                p_381128_.encode(p_372928_, p_381004_.apply(p_372897_));
                p_380994_.encode(p_372928_, p_381101_.apply(p_372897_));
                p_381073_.encode(p_372928_, p_381117_.apply(p_372897_));
                p_380957_.encode(p_372928_, p_380996_.apply(p_372897_));
                p_381122_.encode(p_372928_, p_381050_.apply(p_372897_));
                p_381110_.encode(p_372928_, p_380986_.apply(p_372897_));
            }
        };
    }

    public static <B, T> StreamCodec<B, T> recursive(final UnaryOperator<StreamCodec<B, T>> p_330470_) {
        return new StreamCodec<B, T>(){
            private final Supplier<StreamCodec<B, T>> inner = Suppliers.memoize(() -> (StreamCodec)p_330470_.apply(this));

            @Override
            public T decode(B p_381156_) {
                return this.inner.get().decode(p_381156_);
            }

            @Override
            public void encode(B p_380991_, T p_381087_) {
                this.inner.get().encode(p_380991_, p_381087_);
            }
        };
    }

    default public <S extends B> StreamCodec<S, V> cast() {
        return this;
    }

    @FunctionalInterface
    public static interface CodecOperation<B, S, T> {
        public StreamCodec<B, T> apply(StreamCodec<B, S> var1);
    }
}

