/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;

public class ClientboundPlayerInfoUpdatePacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundPlayerInfoUpdatePacket> STREAM_CODEC = Packet.codec(ClientboundPlayerInfoUpdatePacket::write, ClientboundPlayerInfoUpdatePacket::new);
    private final EnumSet<Action> actions;
    private final List<Entry> entries;

    public ClientboundPlayerInfoUpdatePacket(EnumSet<Action> p_251739_, Collection<ServerPlayer> p_251579_) {
        this.actions = p_251739_;
        this.entries = p_251579_.stream().map(Entry::new).toList();
    }

    public ClientboundPlayerInfoUpdatePacket(Action p_251648_, ServerPlayer p_252273_) {
        this.actions = EnumSet.of(p_251648_);
        this.entries = List.of(new Entry(p_252273_));
    }

    public static ClientboundPlayerInfoUpdatePacket createPlayerInitializing(Collection<ServerPlayer> p_252314_) {
        EnumSet<Action[]> $$1 = EnumSet.of(Action.ADD_PLAYER, new Action[]{Action.INITIALIZE_CHAT, Action.UPDATE_GAME_MODE, Action.UPDATE_LISTED, Action.UPDATE_LATENCY, Action.UPDATE_DISPLAY_NAME, Action.UPDATE_LIST_ORDER});
        return new ClientboundPlayerInfoUpdatePacket($$1, p_252314_);
    }

    private ClientboundPlayerInfoUpdatePacket(RegistryFriendlyByteBuf p_323822_) {
        this.actions = p_323822_.readEnumSet(Action.class);
        this.entries = p_323822_.readList(p_323148_ -> {
            EntryBuilder $$1 = new EntryBuilder(p_323148_.readUUID());
            for (Action $$2 : this.actions) {
                $$2.reader.read($$1, (RegistryFriendlyByteBuf)((Object)p_323148_));
            }
            return $$1.build();
        });
    }

    private void write(RegistryFriendlyByteBuf p_323752_) {
        p_323752_.writeEnumSet(this.actions, Action.class);
        p_323752_.writeCollection(this.entries, (p_323146_, p_323147_) -> {
            p_323146_.writeUUID(p_323147_.profileId());
            for (Action $$2 : this.actions) {
                $$2.writer.write((RegistryFriendlyByteBuf)((Object)p_323146_), (Entry)p_323147_);
            }
        });
    }

    @Override
    public PacketType<ClientboundPlayerInfoUpdatePacket> type() {
        return GamePacketTypes.CLIENTBOUND_PLAYER_INFO_UPDATE;
    }

    @Override
    public void handle(ClientGamePacketListener p_249935_) {
        p_249935_.handlePlayerInfoUpdate(this);
    }

    public EnumSet<Action> actions() {
        return this.actions;
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public List<Entry> newEntries() {
        return this.actions.contains((Object)Action.ADD_PLAYER) ? this.entries : List.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("actions", this.actions).add("entries", this.entries).toString();
    }

    public record Entry(UUID profileId, @Nullable GameProfile profile, boolean listed, int latency, GameType gameMode, @Nullable Component displayName, int listOrder, @Nullable RemoteChatSession.Data chatSession) {
        Entry(ServerPlayer p_252094_) {
            this(p_252094_.getUUID(), p_252094_.getGameProfile(), true, p_252094_.connection.latency(), p_252094_.gameMode.getGameModeForPlayer(), p_252094_.getTabListDisplayName(), p_252094_.getTabListOrder(), Optionull.map(p_252094_.getChatSession(), RemoteChatSession::asData));
        }
    }

    public static enum Action {
        ADD_PLAYER((p_329872_, p_329873_) -> {
            GameProfile $$2 = new GameProfile(p_329872_.profileId, p_329873_.readUtf(16));
            $$2.getProperties().putAll((Multimap)ByteBufCodecs.GAME_PROFILE_PROPERTIES.decode(p_329873_));
            p_329872_.profile = $$2;
        }, (p_329874_, p_329875_) -> {
            GameProfile $$2 = Objects.requireNonNull(p_329875_.profile());
            p_329874_.writeUtf($$2.getName(), 16);
            ByteBufCodecs.GAME_PROFILE_PROPERTIES.encode(p_329874_, $$2.getProperties());
        }),
        INITIALIZE_CHAT((p_323155_, p_323156_) -> {
            p_323155_.chatSession = p_323156_.readNullable(RemoteChatSession.Data::read);
        }, (p_323151_, p_323152_) -> p_323151_.writeNullable(p_323152_.chatSession, RemoteChatSession.Data::write)),
        UPDATE_GAME_MODE((p_323161_, p_323162_) -> {
            p_323161_.gameMode = GameType.byId(p_323162_.readVarInt());
        }, (p_323157_, p_323158_) -> p_323157_.writeVarInt(p_323158_.gameMode().getId())),
        UPDATE_LISTED((p_323167_, p_323168_) -> {
            p_323167_.listed = p_323168_.readBoolean();
        }, (p_323171_, p_323172_) -> p_323171_.writeBoolean(p_323172_.listed())),
        UPDATE_LATENCY((p_323165_, p_323166_) -> {
            p_323165_.latency = p_323166_.readVarInt();
        }, (p_323153_, p_323154_) -> p_323153_.writeVarInt(p_323154_.latency())),
        UPDATE_DISPLAY_NAME((p_329878_, p_329879_) -> {
            p_329878_.displayName = FriendlyByteBuf.readNullable(p_329879_, ComponentSerialization.TRUSTED_STREAM_CODEC);
        }, (p_329876_, p_329877_) -> FriendlyByteBuf.writeNullable(p_329876_, p_329877_.displayName(), ComponentSerialization.TRUSTED_STREAM_CODEC)),
        UPDATE_LIST_ORDER((p_359476_, p_359477_) -> {
            p_359476_.listOrder = p_359477_.readVarInt();
        }, (p_359474_, p_359475_) -> p_359474_.writeVarInt(p_359475_.listOrder));

        final Reader reader;
        final Writer writer;

        private Action(Reader p_249392_, Writer p_250487_) {
            this.reader = p_249392_;
            this.writer = p_250487_;
        }

        public static interface Reader {
            public void read(EntryBuilder var1, RegistryFriendlyByteBuf var2);
        }

        public static interface Writer {
            public void write(RegistryFriendlyByteBuf var1, Entry var2);
        }
    }

    static class EntryBuilder {
        final UUID profileId;
        @Nullable
        GameProfile profile;
        boolean listed;
        int latency;
        GameType gameMode = GameType.DEFAULT_MODE;
        @Nullable
        Component displayName;
        int listOrder;
        @Nullable
        RemoteChatSession.Data chatSession;

        EntryBuilder(UUID p_251670_) {
            this.profileId = p_251670_;
        }

        Entry build() {
            return new Entry(this.profileId, this.profile, this.listed, this.latency, this.gameMode, this.displayName, this.listOrder, this.chatSession);
        }
    }
}

