/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.recipebook;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.Holder;
import net.minecraft.recipebook.PlaceRecipeHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;

public class ServerPlaceRecipe<R extends Recipe<?>> {
    private static final int ITEM_NOT_FOUND = -1;
    private final Inventory inventory;
    private final CraftingMenuAccess<R> menu;
    private final boolean useMaxItems;
    private final int gridWidth;
    private final int gridHeight;
    private final List<Slot> inputGridSlots;
    private final List<Slot> slotsToClear;

    public static <I extends RecipeInput, R extends Recipe<I>> RecipeBookMenu.PostPlaceAction placeRecipe(CraftingMenuAccess<R> p_361341_, int p_361512_, int p_362929_, List<Slot> p_364825_, List<Slot> p_364661_, Inventory p_364618_, RecipeHolder<R> p_363024_, boolean p_360549_, boolean p_361381_) {
        ServerPlaceRecipe<R> $$9 = new ServerPlaceRecipe<R>(p_361341_, p_364618_, p_360549_, p_361512_, p_362929_, p_364825_, p_364661_);
        if (!p_361381_ && !$$9.testClearGrid()) {
            return RecipeBookMenu.PostPlaceAction.NOTHING;
        }
        StackedItemContents $$10 = new StackedItemContents();
        p_364618_.fillStackedContents($$10);
        p_361341_.fillCraftSlotsStackedContents($$10);
        return $$9.tryPlaceRecipe(p_363024_, $$10);
    }

    private ServerPlaceRecipe(CraftingMenuAccess<R> p_363275_, Inventory p_361371_, boolean p_364633_, int p_362980_, int p_361285_, List<Slot> p_364759_, List<Slot> p_361301_) {
        this.menu = p_363275_;
        this.inventory = p_361371_;
        this.useMaxItems = p_364633_;
        this.gridWidth = p_362980_;
        this.gridHeight = p_361285_;
        this.inputGridSlots = p_364759_;
        this.slotsToClear = p_361301_;
    }

    private RecipeBookMenu.PostPlaceAction tryPlaceRecipe(RecipeHolder<R> p_362187_, StackedItemContents p_361415_) {
        if (p_361415_.canCraft((Recipe<?>)p_362187_.value(), null)) {
            this.placeRecipe(p_362187_, p_361415_);
            this.inventory.setChanged();
            return RecipeBookMenu.PostPlaceAction.NOTHING;
        }
        this.clearGrid();
        this.inventory.setChanged();
        return RecipeBookMenu.PostPlaceAction.PLACE_GHOST_RECIPE;
    }

    private void clearGrid() {
        for (Slot $$0 : this.slotsToClear) {
            ItemStack $$1 = $$0.getItem().copy();
            this.inventory.placeItemBackInInventory($$1, false);
            $$0.set($$1);
        }
        this.menu.clearCraftingContent();
    }

    private void placeRecipe(RecipeHolder<R> p_364551_, StackedItemContents p_362416_) {
        boolean $$2 = this.menu.recipeMatches(p_364551_);
        int $$3 = p_362416_.getBiggestCraftableStack((Recipe<?>)p_364551_.value(), null);
        if ($$2) {
            for (Slot $$4 : this.inputGridSlots) {
                ItemStack $$5 = $$4.getItem();
                if ($$5.isEmpty() || Math.min($$3, $$5.getMaxStackSize()) >= $$5.getCount() + 1) continue;
                return;
            }
        }
        int $$6 = this.calculateAmountToCraft($$3, $$2);
        ArrayList $$7 = new ArrayList();
        if (p_362416_.canCraft((Recipe<?>)p_364551_.value(), $$6, $$7::add)) {
            OptionalInt $$8 = $$7.stream().mapToInt(p_362072_ -> ((Item)p_362072_.value()).getDefaultMaxStackSize()).min();
            if ($$8.isPresent()) {
                $$6 = Math.min($$6, $$8.getAsInt());
            }
            $$7.clear();
            if (p_362416_.canCraft((Recipe<?>)p_364551_.value(), $$6, $$7::add)) {
                this.clearGrid();
                int $$9 = $$6;
                PlaceRecipeHelper.placeRecipe(this.gridWidth, this.gridHeight, p_364551_.value(), p_364551_.value().placementInfo().slotInfo(), (p_361486_, p_362468_, p_361828_, p_361050_) -> {
                    if (p_361486_.isEmpty()) {
                        return;
                    }
                    Slot $$6 = this.inputGridSlots.get(p_362468_);
                    int $$7 = ((PlacementInfo.SlotInfo)p_361486_.get()).placerOutputPosition();
                    int $$8 = $$9;
                    while ($$8 > 0) {
                        Holder $$9 = (Holder)$$7.get($$7);
                        $$8 = this.moveItemToGrid($$6, $$9, $$8);
                        if ($$8 != -1) continue;
                        return;
                    }
                });
            }
        }
    }

    private int calculateAmountToCraft(int p_364430_, boolean p_362919_) {
        if (this.useMaxItems) {
            return p_364430_;
        }
        if (p_362919_) {
            int $$2 = Integer.MAX_VALUE;
            for (Slot $$3 : this.inputGridSlots) {
                ItemStack $$4 = $$3.getItem();
                if ($$4.isEmpty() || $$2 <= $$4.getCount()) continue;
                $$2 = $$4.getCount();
            }
            if ($$2 != Integer.MAX_VALUE) {
                ++$$2;
            }
            return $$2;
        }
        return 1;
    }

    private int moveItemToGrid(Slot p_135439_, Holder<Item> p_360762_, int p_346157_) {
        int $$6;
        int $$3 = this.inventory.findSlotMatchingCraftingIngredient(p_360762_);
        if ($$3 == -1) {
            return -1;
        }
        ItemStack $$4 = this.inventory.getItem($$3);
        if (p_346157_ < $$4.getCount()) {
            this.inventory.removeItem($$3, p_346157_);
            int $$5 = p_346157_;
        } else {
            this.inventory.removeItemNoUpdate($$3);
            $$6 = $$4.getCount();
        }
        if (p_135439_.getItem().isEmpty()) {
            p_135439_.set($$4.copyWithCount($$6));
        } else {
            p_135439_.getItem().grow($$6);
        }
        return p_346157_ - $$6;
    }

    private boolean testClearGrid() {
        ArrayList $$0 = Lists.newArrayList();
        int $$1 = this.getAmountOfFreeSlotsInInventory();
        for (Slot $$2 : this.inputGridSlots) {
            ItemStack $$3 = $$2.getItem().copy();
            if ($$3.isEmpty()) continue;
            int $$4 = this.inventory.getSlotWithRemainingSpace($$3);
            if ($$4 == -1 && $$0.size() <= $$1) {
                for (ItemStack $$5 : $$0) {
                    if (!ItemStack.isSameItem($$5, $$3) || $$5.getCount() == $$5.getMaxStackSize() || $$5.getCount() + $$3.getCount() > $$5.getMaxStackSize()) continue;
                    $$5.grow($$3.getCount());
                    $$3.setCount(0);
                    break;
                }
                if ($$3.isEmpty()) continue;
                if ($$0.size() < $$1) {
                    $$0.add($$3);
                    continue;
                }
                return false;
            }
            if ($$4 != -1) continue;
            return false;
        }
        return true;
    }

    private int getAmountOfFreeSlotsInInventory() {
        int $$0 = 0;
        for (ItemStack $$1 : this.inventory.items) {
            if (!$$1.isEmpty()) continue;
            ++$$0;
        }
        return $$0;
    }

    public static interface CraftingMenuAccess<T extends Recipe<?>> {
        public void fillCraftSlotsStackedContents(StackedItemContents var1);

        public void clearCraftingContent();

        public boolean recipeMatches(RecipeHolder<T> var1);
    }
}

