/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class ExperienceCommand {
    private static final SimpleCommandExceptionType ERROR_SET_POINTS_INVALID = new SimpleCommandExceptionType((Message)Component.translatable("commands.experience.set.points.invalid"));

    public static void register(CommandDispatcher<CommandSourceStack> p_137307_) {
        LiteralCommandNode $$1 = p_137307_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("experience").requires(p_137324_ -> p_137324_.hasPermission(2))).then(Commands.literal("add").then(Commands.argument("target", EntityArgument.players()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("amount", IntegerArgumentType.integer()).executes(p_137341_ -> ExperienceCommand.addExperience((CommandSourceStack)p_137341_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_137341_, "target"), IntegerArgumentType.getInteger((CommandContext)p_137341_, (String)"amount"), Type.POINTS))).then(Commands.literal("points").executes(p_137339_ -> ExperienceCommand.addExperience((CommandSourceStack)p_137339_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_137339_, "target"), IntegerArgumentType.getInteger((CommandContext)p_137339_, (String)"amount"), Type.POINTS)))).then(Commands.literal("levels").executes(p_137337_ -> ExperienceCommand.addExperience((CommandSourceStack)p_137337_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_137337_, "target"), IntegerArgumentType.getInteger((CommandContext)p_137337_, (String)"amount"), Type.LEVELS))))))).then(Commands.literal("set").then(Commands.argument("target", EntityArgument.players()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("amount", IntegerArgumentType.integer((int)0)).executes(p_137335_ -> ExperienceCommand.setExperience((CommandSourceStack)p_137335_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_137335_, "target"), IntegerArgumentType.getInteger((CommandContext)p_137335_, (String)"amount"), Type.POINTS))).then(Commands.literal("points").executes(p_137333_ -> ExperienceCommand.setExperience((CommandSourceStack)p_137333_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_137333_, "target"), IntegerArgumentType.getInteger((CommandContext)p_137333_, (String)"amount"), Type.POINTS)))).then(Commands.literal("levels").executes(p_137331_ -> ExperienceCommand.setExperience((CommandSourceStack)p_137331_.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)p_137331_, "target"), IntegerArgumentType.getInteger((CommandContext)p_137331_, (String)"amount"), Type.LEVELS))))))).then(Commands.literal("query").then(((RequiredArgumentBuilder)Commands.argument("target", EntityArgument.player()).then(Commands.literal("points").executes(p_137322_ -> ExperienceCommand.queryExperience((CommandSourceStack)p_137322_.getSource(), EntityArgument.getPlayer((CommandContext<CommandSourceStack>)p_137322_, "target"), Type.POINTS)))).then(Commands.literal("levels").executes(p_137309_ -> ExperienceCommand.queryExperience((CommandSourceStack)p_137309_.getSource(), EntityArgument.getPlayer((CommandContext<CommandSourceStack>)p_137309_, "target"), Type.LEVELS))))));
        p_137307_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("xp").requires(p_137311_ -> p_137311_.hasPermission(2))).redirect((CommandNode)$$1));
    }

    private static int queryExperience(CommandSourceStack p_137313_, ServerPlayer p_137314_, Type p_137315_) {
        int $$3 = p_137315_.query.applyAsInt(p_137314_);
        p_137313_.sendSuccess(() -> Component.translatable("commands.experience.query." + p_378995_.name, p_137314_.getDisplayName(), $$3), false);
        return $$3;
    }

    private static int addExperience(CommandSourceStack p_137317_, Collection<? extends ServerPlayer> p_137318_, int p_137319_, Type p_137320_) {
        for (ServerPlayer serverPlayer : p_137318_) {
            p_137320_.add.accept(serverPlayer, p_137319_);
        }
        if (p_137318_.size() == 1) {
            p_137317_.sendSuccess(() -> Component.translatable("commands.experience.add." + p_378992_.name + ".success.single", p_137319_, ((ServerPlayer)p_137318_.iterator().next()).getDisplayName()), true);
        } else {
            p_137317_.sendSuccess(() -> Component.translatable("commands.experience.add." + p_288406_.name + ".success.multiple", p_137319_, p_137318_.size()), true);
        }
        return p_137318_.size();
    }

    private static int setExperience(CommandSourceStack p_137326_, Collection<? extends ServerPlayer> p_137327_, int p_137328_, Type p_137329_) throws CommandSyntaxException {
        int $$4 = 0;
        for (ServerPlayer serverPlayer : p_137327_) {
            if (!p_137329_.set.test(serverPlayer, p_137328_)) continue;
            ++$$4;
        }
        if ($$4 == 0) {
            throw ERROR_SET_POINTS_INVALID.create();
        }
        if (p_137327_.size() == 1) {
            p_137326_.sendSuccess(() -> Component.translatable("commands.experience.set." + p_378998_.name + ".success.single", p_137328_, ((ServerPlayer)p_137327_.iterator().next()).getDisplayName()), true);
        } else {
            p_137326_.sendSuccess(() -> Component.translatable("commands.experience.set." + p_288400_.name + ".success.multiple", p_137328_, p_137327_.size()), true);
        }
        return p_137327_.size();
    }

    static enum Type {
        POINTS("points", Player::giveExperiencePoints, (p_381367_, p_381368_) -> {
            if (p_381368_ >= p_381367_.getXpNeededForNextLevel()) {
                return false;
            }
            p_381367_.setExperiencePoints((int)p_381368_);
            return true;
        }, p_381366_ -> Mth.floor(p_381366_.experienceProgress * (float)p_381366_.getXpNeededForNextLevel())),
        LEVELS("levels", ServerPlayer::giveExperienceLevels, (p_137360_, p_137361_) -> {
            p_137360_.setExperienceLevels((int)p_137361_);
            return true;
        }, p_287335_ -> p_287335_.experienceLevel);

        public final BiConsumer<ServerPlayer, Integer> add;
        public final BiPredicate<ServerPlayer, Integer> set;
        public final String name;
        final ToIntFunction<ServerPlayer> query;

        private Type(String p_137353_, BiConsumer<ServerPlayer, Integer> p_137354_, BiPredicate<ServerPlayer, Integer> p_137355_, ToIntFunction<ServerPlayer> p_137356_) {
            this.add = p_137354_;
            this.name = p_137353_;
            this.set = p_137355_;
            this.query = p_137356_;
        }
    }
}

