/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.item.equipment.trim.TrimPatterns;
import net.minecraft.world.level.Level;

public class SpawnArmorTrimsCommand {
    private static final List<ResourceKey<TrimPattern>> VANILLA_TRIM_PATTERNS = List.of(TrimPatterns.SENTRY, TrimPatterns.DUNE, TrimPatterns.COAST, TrimPatterns.WILD, TrimPatterns.WARD, TrimPatterns.EYE, TrimPatterns.VEX, TrimPatterns.TIDE, TrimPatterns.SNOUT, TrimPatterns.RIB, TrimPatterns.SPIRE, TrimPatterns.WAYFINDER, TrimPatterns.SHAPER, TrimPatterns.SILENCE, TrimPatterns.RAISER, TrimPatterns.HOST, TrimPatterns.FLOW, TrimPatterns.BOLT);
    private static final List<ResourceKey<TrimMaterial>> VANILLA_TRIM_MATERIALS = List.of(TrimMaterials.QUARTZ, TrimMaterials.IRON, TrimMaterials.NETHERITE, TrimMaterials.REDSTONE, TrimMaterials.COPPER, TrimMaterials.GOLD, TrimMaterials.EMERALD, TrimMaterials.DIAMOND, TrimMaterials.LAPIS, TrimMaterials.AMETHYST);
    private static final ToIntFunction<ResourceKey<TrimPattern>> TRIM_PATTERN_ORDER = Util.createIndexLookup(VANILLA_TRIM_PATTERNS);
    private static final ToIntFunction<ResourceKey<TrimMaterial>> TRIM_MATERIAL_ORDER = Util.createIndexLookup(VANILLA_TRIM_MATERIALS);

    public static void register(CommandDispatcher<CommandSourceStack> p_266758_) {
        p_266758_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("spawn_armor_trims").requires(p_277270_ -> p_277270_.hasPermission(2))).executes(p_267005_ -> SpawnArmorTrimsCommand.spawnArmorTrims((CommandSourceStack)p_267005_.getSource(), ((CommandSourceStack)p_267005_.getSource()).getPlayerOrException())));
    }

    private static int spawnArmorTrims(CommandSourceStack p_266993_, Player p_266983_) {
        Level $$2 = p_266983_.level();
        NonNullList<ArmorTrim> $$3 = NonNullList.create();
        HolderLookup.RegistryLookup $$4 = $$2.registryAccess().lookupOrThrow(Registries.TRIM_PATTERN);
        HolderLookup.RegistryLookup $$5 = $$2.registryAccess().lookupOrThrow(Registries.TRIM_MATERIAL);
        HolderLookup<Item> $$6 = $$2.holderLookup(Registries.ITEM);
        Map<ResourceLocation, List<Item>> $$7 = $$6.listElements().map(Holder.Reference::value).filter(p_370447_ -> {
            Equippable $$1 = p_370447_.components().get(DataComponents.EQUIPPABLE);
            return $$1 != null && $$1.slot().getType() == EquipmentSlot.Type.HUMANOID_ARMOR && $$1.model().isPresent();
        }).collect(Collectors.groupingBy(p_370448_ -> p_370448_.components().get(DataComponents.EQUIPPABLE).model().get()));
        $$4.stream().sorted(Comparator.comparing(arg_0 -> SpawnArmorTrimsCommand.lambda$spawnArmorTrims$4((Registry)$$4, arg_0))).forEachOrdered(arg_0 -> SpawnArmorTrimsCommand.lambda$spawnArmorTrims$7((Registry)$$5, $$3, (Registry)$$4, arg_0));
        BlockPos $$8 = p_266983_.blockPosition().relative(p_266983_.getDirection(), 5);
        int $$9 = $$7.size() - 1;
        double $$10 = 3.0;
        int $$11 = 0;
        int $$12 = 0;
        for (ArmorTrim $$13 : $$3) {
            for (List<Item> $$14 : $$7.values()) {
                double $$15 = (double)$$8.getX() + 0.5 - (double)($$11 % $$5.size()) * 3.0;
                double $$16 = (double)$$8.getY() + 0.5 + (double)($$12 % $$9) * 3.0;
                double $$17 = (double)$$8.getZ() + 0.5 + (double)($$11 / $$5.size() * 10);
                ArmorStand $$18 = new ArmorStand($$2, $$15, $$16, $$17);
                $$18.setYRot(180.0f);
                $$18.setNoGravity(true);
                for (Item $$19 : $$14) {
                    Equippable $$20 = Objects.requireNonNull($$19.components().get(DataComponents.EQUIPPABLE));
                    ItemStack $$21 = new ItemStack($$19);
                    $$21.set(DataComponents.TRIM, $$13);
                    $$18.setItemSlot($$20.slot(), $$21);
                    if ($$21.is(Items.TURTLE_HELMET)) {
                        $$18.setCustomName($$13.pattern().value().copyWithStyle($$13.material()).copy().append(" ").append($$13.material().value().description()));
                        $$18.setCustomNameVisible(true);
                        continue;
                    }
                    $$18.setInvisible(true);
                }
                $$2.addFreshEntity($$18);
                ++$$12;
            }
            ++$$11;
        }
        p_266993_.sendSuccess(() -> Component.literal("Armorstands with trimmed armor spawned around you"), true);
        return 1;
    }

    private static /* synthetic */ void lambda$spawnArmorTrims$7(Registry p_267195_, NonNullList p_266819_, Registry p_266685_, TrimPattern p_371640_) {
        p_267195_.stream().sorted(Comparator.comparing(p_371790_ -> TRIM_MATERIAL_ORDER.applyAsInt(p_267195_.getResourceKey(p_371790_).orElse(null)))).forEachOrdered(p_370446_ -> p_266819_.add(new ArmorTrim(p_267195_.wrapAsHolder(p_370446_), p_266685_.wrapAsHolder(p_371640_))));
    }

    private static /* synthetic */ Integer lambda$spawnArmorTrims$4(Registry p_267215_, TrimPattern p_371348_) {
        return TRIM_PATTERN_ORDER.applyAsInt(p_267215_.getResourceKey(p_371348_).orElse(null));
    }
}

