/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;

public class TimeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> p_139072_) {
        p_139072_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("time").requires(p_139076_ -> p_139076_.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("set").then(Commands.literal("day").executes(p_139101_ -> TimeCommand.setTime((CommandSourceStack)p_139101_.getSource(), 1000)))).then(Commands.literal("noon").executes(p_139099_ -> TimeCommand.setTime((CommandSourceStack)p_139099_.getSource(), 6000)))).then(Commands.literal("night").executes(p_139097_ -> TimeCommand.setTime((CommandSourceStack)p_139097_.getSource(), 13000)))).then(Commands.literal("midnight").executes(p_139095_ -> TimeCommand.setTime((CommandSourceStack)p_139095_.getSource(), 18000)))).then(Commands.argument("time", TimeArgument.time()).executes(p_139093_ -> TimeCommand.setTime((CommandSourceStack)p_139093_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_139093_, (String)"time")))))).then(Commands.literal("add").then(Commands.argument("time", TimeArgument.time()).executes(p_139091_ -> TimeCommand.addTime((CommandSourceStack)p_139091_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_139091_, (String)"time")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("query").then(Commands.literal("daytime").executes(p_139086_ -> TimeCommand.queryTime((CommandSourceStack)p_139086_.getSource(), TimeCommand.getDayTime(((CommandSourceStack)p_139086_.getSource()).getLevel()))))).then(Commands.literal("gametime").executes(p_379028_ -> TimeCommand.queryTime((CommandSourceStack)p_379028_.getSource(), (int)(((CommandSourceStack)p_379028_.getSource()).getLevel().getGameTime() % Integer.MAX_VALUE))))).then(Commands.literal("day").executes(p_379027_ -> TimeCommand.queryTime((CommandSourceStack)p_379027_.getSource(), (int)(((CommandSourceStack)p_379027_.getSource()).getLevel().getDayTime() / 24000L % Integer.MAX_VALUE))))));
    }

    private static int getDayTime(ServerLevel p_139070_) {
        return (int)(p_139070_.getDayTime() % 24000L);
    }

    private static int queryTime(CommandSourceStack p_139088_, int p_139089_) {
        p_139088_.sendSuccess(() -> Component.translatable("commands.time.query", p_139089_), false);
        return p_139089_;
    }

    public static int setTime(CommandSourceStack p_139078_, int p_139079_) {
        for (ServerLevel $$2 : p_139078_.getServer().getAllLevels()) {
            $$2.setDayTime(p_139079_);
        }
        p_139078_.sendSuccess(() -> Component.translatable("commands.time.set", p_139079_), true);
        return TimeCommand.getDayTime(p_139078_.getLevel());
    }

    public static int addTime(CommandSourceStack p_139083_, int p_139084_) {
        for (ServerLevel $$2 : p_139083_.getServer().getAllLevels()) {
            $$2.setDayTime($$2.getDayTime() + (long)p_139084_);
        }
        int $$3 = TimeCommand.getDayTime(p_139083_.getLevel());
        p_139083_.sendSuccess(() -> Component.translatable("commands.time.set", $$3), true);
        return $$3;
    }
}

