/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTracker;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThrottlingChunkTaskDispatcher;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.thread.TaskScheduler;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import org.slf4j.Logger;

public abstract class DistanceManager {
    static final Logger LOGGER = LogUtils.getLogger();
    static final int PLAYER_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    private static final int INITIAL_TICKET_LIST_CAPACITY = 4;
    final Long2ObjectMap<ObjectSet<ServerPlayer>> playersPerChunk = new Long2ObjectOpenHashMap();
    final Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> tickets = new Long2ObjectOpenHashMap();
    private final ChunkTicketTracker ticketTracker = new ChunkTicketTracker();
    private final FixedPlayerDistanceChunkTracker naturalSpawnChunkCounter = new FixedPlayerDistanceChunkTracker(8);
    private final TickingTracker tickingTicketsTracker = new TickingTracker();
    private final PlayerTicketTracker playerTicketManager = new PlayerTicketTracker(32);
    final Set<ChunkHolder> chunksToUpdateFutures = new ReferenceOpenHashSet();
    final ThrottlingChunkTaskDispatcher ticketDispatcher;
    final LongSet ticketsToRelease = new LongOpenHashSet();
    final Executor mainThreadExecutor;
    private long ticketTickCounter;
    private int simulationDistance = 10;

    protected DistanceManager(Executor p_140774_, Executor p_140775_) {
        TaskScheduler<Runnable> $$2 = TaskScheduler.wrapExecutor("player ticket throttler", p_140775_);
        this.ticketDispatcher = new ThrottlingChunkTaskDispatcher($$2, p_140774_, 4);
        this.mainThreadExecutor = p_140775_;
    }

    protected void purgeStaleTickets() {
        ++this.ticketTickCounter;
        ObjectIterator $$0 = this.tickets.long2ObjectEntrySet().fastIterator();
        while ($$0.hasNext()) {
            Long2ObjectMap.Entry $$1 = (Long2ObjectMap.Entry)$$0.next();
            Iterator $$2 = ((SortedArraySet)$$1.getValue()).iterator();
            boolean $$3 = false;
            while ($$2.hasNext()) {
                Ticket $$4 = (Ticket)$$2.next();
                if (!$$4.timedOut(this.ticketTickCounter)) continue;
                $$2.remove();
                $$3 = true;
                this.tickingTicketsTracker.removeTicket($$1.getLongKey(), $$4);
            }
            if ($$3) {
                this.ticketTracker.update($$1.getLongKey(), DistanceManager.getTicketLevelAt((SortedArraySet)$$1.getValue()), false);
            }
            if (!((SortedArraySet)$$1.getValue()).isEmpty()) continue;
            $$0.remove();
        }
    }

    private static int getTicketLevelAt(SortedArraySet<Ticket<?>> p_140798_) {
        return !p_140798_.isEmpty() ? p_140798_.first().getTicketLevel() : ChunkLevel.MAX_LEVEL + 1;
    }

    protected abstract boolean isChunkToRemove(long var1);

    @Nullable
    protected abstract ChunkHolder getChunk(long var1);

    @Nullable
    protected abstract ChunkHolder updateChunkScheduling(long var1, int var3, @Nullable ChunkHolder var4, int var5);

    public boolean runAllUpdates(ChunkMap p_140806_) {
        boolean $$2;
        this.naturalSpawnChunkCounter.runAllUpdates();
        this.tickingTicketsTracker.runAllUpdates();
        this.playerTicketManager.runAllUpdates();
        int $$1 = Integer.MAX_VALUE - this.ticketTracker.runDistanceUpdates(Integer.MAX_VALUE);
        boolean bl = $$2 = $$1 != 0;
        if ($$2) {
            // empty if block
        }
        if (!this.chunksToUpdateFutures.isEmpty()) {
            for (ChunkHolder $$3 : this.chunksToUpdateFutures) {
                $$3.updateHighestAllowedStatus(p_140806_);
            }
            for (ChunkHolder $$4 : this.chunksToUpdateFutures) {
                $$4.updateFutures(p_140806_, this.mainThreadExecutor);
            }
            this.chunksToUpdateFutures.clear();
            return true;
        }
        if (!this.ticketsToRelease.isEmpty()) {
            LongIterator $$5 = this.ticketsToRelease.iterator();
            while ($$5.hasNext()) {
                long $$6 = $$5.nextLong();
                if (!this.getTickets($$6).stream().anyMatch(p_183910_ -> p_183910_.getType() == TicketType.PLAYER)) continue;
                ChunkHolder $$7 = p_140806_.getUpdatingChunkIfPresent($$6);
                if ($$7 == null) {
                    throw new IllegalStateException();
                }
                CompletableFuture<ChunkResult<LevelChunk>> $$8 = $$7.getEntityTickingChunkFuture();
                $$8.thenAccept(p_331640_ -> this.mainThreadExecutor.execute(() -> this.ticketDispatcher.release($$6, () -> {}, false)));
            }
            this.ticketsToRelease.clear();
        }
        return $$2;
    }

    void addTicket(long p_140785_, Ticket<?> p_140786_) {
        SortedArraySet<Ticket<?>> $$2 = this.getTickets(p_140785_);
        int $$3 = DistanceManager.getTicketLevelAt($$2);
        Ticket<?> $$4 = $$2.addOrGet(p_140786_);
        $$4.setCreatedTick(this.ticketTickCounter);
        if (p_140786_.getTicketLevel() < $$3) {
            this.ticketTracker.update(p_140785_, p_140786_.getTicketLevel(), true);
        }
    }

    void removeTicket(long p_140819_, Ticket<?> p_140820_) {
        SortedArraySet<Ticket<?>> $$2 = this.getTickets(p_140819_);
        if ($$2.remove(p_140820_)) {
            // empty if block
        }
        if ($$2.isEmpty()) {
            this.tickets.remove(p_140819_);
        }
        this.ticketTracker.update(p_140819_, DistanceManager.getTicketLevelAt($$2), false);
    }

    public <T> void addTicket(TicketType<T> p_140793_, ChunkPos p_140794_, int p_140795_, T p_140796_) {
        this.addTicket(p_140794_.toLong(), new Ticket<T>(p_140793_, p_140795_, p_140796_));
    }

    public <T> void removeTicket(TicketType<T> p_140824_, ChunkPos p_140825_, int p_140826_, T p_140827_) {
        Ticket<T> $$4 = new Ticket<T>(p_140824_, p_140826_, p_140827_);
        this.removeTicket(p_140825_.toLong(), $$4);
    }

    public <T> void addRegionTicket(TicketType<T> p_140841_, ChunkPos p_140842_, int p_140843_, T p_140844_) {
        Ticket<T> $$4 = new Ticket<T>(p_140841_, ChunkLevel.byStatus(FullChunkStatus.FULL) - p_140843_, p_140844_);
        long $$5 = p_140842_.toLong();
        this.addTicket($$5, $$4);
        this.tickingTicketsTracker.addTicket($$5, $$4);
    }

    public <T> void removeRegionTicket(TicketType<T> p_140850_, ChunkPos p_140851_, int p_140852_, T p_140853_) {
        Ticket<T> $$4 = new Ticket<T>(p_140850_, ChunkLevel.byStatus(FullChunkStatus.FULL) - p_140852_, p_140853_);
        long $$5 = p_140851_.toLong();
        this.removeTicket($$5, $$4);
        this.tickingTicketsTracker.removeTicket($$5, $$4);
    }

    private SortedArraySet<Ticket<?>> getTickets(long p_140858_) {
        return (SortedArraySet)this.tickets.computeIfAbsent(p_140858_, p_183923_ -> SortedArraySet.create(4));
    }

    protected void updateChunkForced(ChunkPos p_140800_, boolean p_140801_) {
        Ticket<ChunkPos> $$2 = new Ticket<ChunkPos>(TicketType.FORCED, ChunkMap.FORCED_TICKET_LEVEL, p_140800_);
        long $$3 = p_140800_.toLong();
        if (p_140801_) {
            this.addTicket($$3, $$2);
            this.tickingTicketsTracker.addTicket($$3, $$2);
        } else {
            this.removeTicket($$3, $$2);
            this.tickingTicketsTracker.removeTicket($$3, $$2);
        }
    }

    public void addPlayer(SectionPos p_140803_, ServerPlayer p_140804_) {
        ChunkPos $$2 = p_140803_.chunk();
        long $$3 = $$2.toLong();
        ((ObjectSet)this.playersPerChunk.computeIfAbsent($$3, p_183921_ -> new ObjectOpenHashSet())).add((Object)p_140804_);
        this.naturalSpawnChunkCounter.update($$3, 0, true);
        this.playerTicketManager.update($$3, 0, true);
        this.tickingTicketsTracker.addTicket(TicketType.PLAYER, $$2, this.getPlayerTicketLevel(), $$2);
    }

    public void removePlayer(SectionPos p_140829_, ServerPlayer p_140830_) {
        ChunkPos $$2 = p_140829_.chunk();
        long $$3 = $$2.toLong();
        ObjectSet $$4 = (ObjectSet)this.playersPerChunk.get($$3);
        $$4.remove((Object)p_140830_);
        if ($$4.isEmpty()) {
            this.playersPerChunk.remove($$3);
            this.naturalSpawnChunkCounter.update($$3, Integer.MAX_VALUE, false);
            this.playerTicketManager.update($$3, Integer.MAX_VALUE, false);
            this.tickingTicketsTracker.removeTicket(TicketType.PLAYER, $$2, this.getPlayerTicketLevel(), $$2);
        }
    }

    private int getPlayerTicketLevel() {
        return Math.max(0, ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING) - this.simulationDistance);
    }

    public boolean inEntityTickingRange(long p_183914_) {
        return ChunkLevel.isEntityTicking(this.tickingTicketsTracker.getLevel(p_183914_));
    }

    public boolean inBlockTickingRange(long p_183917_) {
        return ChunkLevel.isBlockTicking(this.tickingTicketsTracker.getLevel(p_183917_));
    }

    protected String getTicketDebugString(long p_140839_) {
        SortedArraySet $$1 = (SortedArraySet)this.tickets.get(p_140839_);
        if ($$1 == null || $$1.isEmpty()) {
            return "no_ticket";
        }
        return ((Ticket)$$1.first()).toString();
    }

    protected void updatePlayerTickets(int p_140778_) {
        this.playerTicketManager.updateViewDistance(p_140778_);
    }

    public void updateSimulationDistance(int p_183912_) {
        if (p_183912_ != this.simulationDistance) {
            this.simulationDistance = p_183912_;
            this.tickingTicketsTracker.replacePlayerTicketsLevel(this.getPlayerTicketLevel());
        }
    }

    public int getNaturalSpawnChunkCount() {
        this.naturalSpawnChunkCounter.runAllUpdates();
        return this.naturalSpawnChunkCounter.chunks.size();
    }

    public boolean hasPlayersNearby(long p_140848_) {
        this.naturalSpawnChunkCounter.runAllUpdates();
        return this.naturalSpawnChunkCounter.chunks.containsKey(p_140848_);
    }

    public LongIterator getSpawnCandidateChunks() {
        this.naturalSpawnChunkCounter.runAllUpdates();
        return this.naturalSpawnChunkCounter.chunks.keySet().iterator();
    }

    public String getDebugStatus() {
        return this.ticketDispatcher.getDebugStatus();
    }

    private void dumpTickets(String p_143208_) {
        try (FileOutputStream $$1 = new FileOutputStream(new File(p_143208_));){
            for (Long2ObjectMap.Entry $$2 : this.tickets.long2ObjectEntrySet()) {
                ChunkPos $$3 = new ChunkPos($$2.getLongKey());
                for (Ticket $$4 : (SortedArraySet)$$2.getValue()) {
                    $$1.write(($$3.x + "\t" + $$3.z + "\t" + String.valueOf($$4.getType()) + "\t" + $$4.getTicketLevel() + "\t\n").getBytes(StandardCharsets.UTF_8));
                }
            }
        }
        catch (IOException $$5) {
            LOGGER.error("Failed to dump tickets to {}", (Object)p_143208_, (Object)$$5);
        }
    }

    @VisibleForTesting
    TickingTracker tickingTracker() {
        return this.tickingTicketsTracker;
    }

    public LongSet getTickingChunks() {
        return this.tickingTicketsTracker.getTickingChunks();
    }

    public void removeTicketsOnClosing() {
        ImmutableSet $$0 = ImmutableSet.of(TicketType.UNKNOWN, TicketType.POST_TELEPORT);
        ObjectIterator $$1 = this.tickets.long2ObjectEntrySet().fastIterator();
        while ($$1.hasNext()) {
            Long2ObjectMap.Entry $$2 = (Long2ObjectMap.Entry)$$1.next();
            Iterator $$3 = ((SortedArraySet)$$2.getValue()).iterator();
            boolean $$4 = false;
            while ($$3.hasNext()) {
                Ticket $$5 = (Ticket)$$3.next();
                if ($$0.contains($$5.getType())) continue;
                $$3.remove();
                $$4 = true;
                this.tickingTicketsTracker.removeTicket($$2.getLongKey(), $$5);
            }
            if ($$4) {
                this.ticketTracker.update($$2.getLongKey(), DistanceManager.getTicketLevelAt((SortedArraySet)$$2.getValue()), false);
            }
            if (!((SortedArraySet)$$2.getValue()).isEmpty()) continue;
            $$1.remove();
        }
    }

    public boolean hasTickets() {
        return !this.tickets.isEmpty();
    }

    class ChunkTicketTracker
    extends ChunkTracker {
        private static final int MAX_LEVEL = ChunkLevel.MAX_LEVEL + 1;

        public ChunkTicketTracker() {
            super(MAX_LEVEL + 1, 16, 256);
        }

        @Override
        protected int getLevelFromSource(long p_140883_) {
            SortedArraySet $$1 = (SortedArraySet)DistanceManager.this.tickets.get(p_140883_);
            if ($$1 == null) {
                return Integer.MAX_VALUE;
            }
            if ($$1.isEmpty()) {
                return Integer.MAX_VALUE;
            }
            return ((Ticket)$$1.first()).getTicketLevel();
        }

        @Override
        protected int getLevel(long p_140885_) {
            ChunkHolder $$1;
            if (!DistanceManager.this.isChunkToRemove(p_140885_) && ($$1 = DistanceManager.this.getChunk(p_140885_)) != null) {
                return $$1.getTicketLevel();
            }
            return MAX_LEVEL;
        }

        @Override
        protected void setLevel(long p_140880_, int p_140881_) {
            int $$3;
            ChunkHolder $$2 = DistanceManager.this.getChunk(p_140880_);
            int n = $$3 = $$2 == null ? MAX_LEVEL : $$2.getTicketLevel();
            if ($$3 == p_140881_) {
                return;
            }
            if (($$2 = DistanceManager.this.updateChunkScheduling(p_140880_, p_140881_, $$2, $$3)) != null) {
                DistanceManager.this.chunksToUpdateFutures.add($$2);
            }
        }

        public int runDistanceUpdates(int p_140878_) {
            return this.runUpdates(p_140878_);
        }
    }

    class FixedPlayerDistanceChunkTracker
    extends ChunkTracker {
        protected final Long2ByteMap chunks;
        protected final int maxDistance;

        protected FixedPlayerDistanceChunkTracker(int p_140891_) {
            super(p_140891_ + 2, 16, 256);
            this.chunks = new Long2ByteOpenHashMap();
            this.maxDistance = p_140891_;
            this.chunks.defaultReturnValue((byte)(p_140891_ + 2));
        }

        @Override
        protected int getLevel(long p_140901_) {
            return this.chunks.get(p_140901_);
        }

        @Override
        protected void setLevel(long p_140893_, int p_140894_) {
            byte $$3;
            if (p_140894_ > this.maxDistance) {
                byte $$2 = this.chunks.remove(p_140893_);
            } else {
                $$3 = this.chunks.put(p_140893_, (byte)p_140894_);
            }
            this.onLevelChange(p_140893_, $$3, p_140894_);
        }

        protected void onLevelChange(long p_140895_, int p_140896_, int p_140897_) {
        }

        @Override
        protected int getLevelFromSource(long p_140899_) {
            return this.havePlayer(p_140899_) ? 0 : Integer.MAX_VALUE;
        }

        private boolean havePlayer(long p_140903_) {
            ObjectSet $$1 = (ObjectSet)DistanceManager.this.playersPerChunk.get(p_140903_);
            return $$1 != null && !$$1.isEmpty();
        }

        public void runAllUpdates() {
            this.runUpdates(Integer.MAX_VALUE);
        }

        private void dumpChunks(String p_143213_) {
            try (FileOutputStream $$1 = new FileOutputStream(new File(p_143213_));){
                for (Long2ByteMap.Entry $$2 : this.chunks.long2ByteEntrySet()) {
                    ChunkPos $$3 = new ChunkPos($$2.getLongKey());
                    String $$4 = Byte.toString($$2.getByteValue());
                    $$1.write(($$3.x + "\t" + $$3.z + "\t" + $$4 + "\n").getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException $$5) {
                LOGGER.error("Failed to dump chunks to {}", (Object)p_143213_, (Object)$$5);
            }
        }
    }

    class PlayerTicketTracker
    extends FixedPlayerDistanceChunkTracker {
        private int viewDistance;
        private final Long2IntMap queueLevels;
        private final LongSet toUpdate;

        protected PlayerTicketTracker(int p_140910_) {
            super(p_140910_);
            this.queueLevels = Long2IntMaps.synchronize((Long2IntMap)new Long2IntOpenHashMap());
            this.toUpdate = new LongOpenHashSet();
            this.viewDistance = 0;
            this.queueLevels.defaultReturnValue(p_140910_ + 2);
        }

        @Override
        protected void onLevelChange(long p_140915_, int p_140916_, int p_140917_) {
            this.toUpdate.add(p_140915_);
        }

        public void updateViewDistance(int p_140913_) {
            for (Long2ByteMap.Entry $$1 : this.chunks.long2ByteEntrySet()) {
                byte $$2 = $$1.getByteValue();
                long $$3 = $$1.getLongKey();
                this.onLevelChange($$3, $$2, this.haveTicketFor($$2), $$2 <= p_140913_);
            }
            this.viewDistance = p_140913_;
        }

        private void onLevelChange(long p_140919_, int p_140920_, boolean p_140921_, boolean p_140922_) {
            if (p_140921_ != p_140922_) {
                Ticket<ChunkPos> $$4 = new Ticket<ChunkPos>(TicketType.PLAYER, PLAYER_TICKET_LEVEL, new ChunkPos(p_140919_));
                if (p_140922_) {
                    DistanceManager.this.ticketDispatcher.submit(() -> DistanceManager.this.mainThreadExecutor.execute(() -> {
                        if (this.haveTicketFor(this.getLevel(p_140919_))) {
                            DistanceManager.this.addTicket(p_140919_, $$4);
                            DistanceManager.this.ticketsToRelease.add(p_140919_);
                        } else {
                            DistanceManager.this.ticketDispatcher.release(p_140919_, () -> {}, false);
                        }
                    }), p_140919_, () -> p_140920_);
                } else {
                    DistanceManager.this.ticketDispatcher.release(p_140919_, () -> DistanceManager.this.mainThreadExecutor.execute(() -> DistanceManager.this.removeTicket(p_140919_, $$4)), true);
                }
            }
        }

        @Override
        public void runAllUpdates() {
            super.runAllUpdates();
            if (!this.toUpdate.isEmpty()) {
                LongIterator $$0 = this.toUpdate.iterator();
                while ($$0.hasNext()) {
                    int $$3;
                    long $$1 = $$0.nextLong();
                    int $$2 = this.queueLevels.get($$1);
                    if ($$2 == ($$3 = this.getLevel($$1))) continue;
                    DistanceManager.this.ticketDispatcher.onLevelChange(new ChunkPos($$1), () -> this.queueLevels.get($$1), $$3, p_140928_ -> {
                        if (p_140928_ >= this.queueLevels.defaultReturnValue()) {
                            this.queueLevels.remove($$1);
                        } else {
                            this.queueLevels.put($$1, p_140928_);
                        }
                    });
                    this.onLevelChange($$1, $$3, this.haveTicketFor($$2), this.haveTicketFor($$3));
                }
                this.toUpdate.clear();
            }
        }

        private boolean haveTicketFor(int p_140933_) {
            return p_140933_ <= this.viewDistance;
        }
    }
}

