/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class ServerPlayerGameMode {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected ServerLevel level;
    protected final ServerPlayer player;
    private GameType gameModeForPlayer = GameType.DEFAULT_MODE;
    @Nullable
    private GameType previousGameModeForPlayer;
    private boolean isDestroyingBlock;
    private int destroyProgressStart;
    private BlockPos destroyPos = BlockPos.ZERO;
    private int gameTicks;
    private boolean hasDelayedDestroy;
    private BlockPos delayedDestroyPos = BlockPos.ZERO;
    private int delayedTickStart;
    private int lastSentState = -1;

    public ServerPlayerGameMode(ServerPlayer p_143472_) {
        this.player = p_143472_;
        this.level = p_143472_.serverLevel();
    }

    public boolean changeGameModeForPlayer(GameType p_143474_) {
        if (p_143474_ == this.gameModeForPlayer) {
            return false;
        }
        this.setGameModeForPlayer(p_143474_, this.previousGameModeForPlayer);
        this.player.onUpdateAbilities();
        this.player.server.getPlayerList().broadcastAll(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_GAME_MODE, this.player));
        this.level.updateSleepingPlayerList();
        if (p_143474_ == GameType.CREATIVE) {
            this.player.resetCurrentImpulseContext();
        }
        return true;
    }

    protected void setGameModeForPlayer(GameType p_9274_, @Nullable GameType p_9275_) {
        this.previousGameModeForPlayer = p_9275_;
        this.gameModeForPlayer = p_9274_;
        p_9274_.updatePlayerAbilities(this.player.getAbilities());
    }

    public GameType getGameModeForPlayer() {
        return this.gameModeForPlayer;
    }

    @Nullable
    public GameType getPreviousGameModeForPlayer() {
        return this.previousGameModeForPlayer;
    }

    public boolean isSurvival() {
        return this.gameModeForPlayer.isSurvival();
    }

    public boolean isCreative() {
        return this.gameModeForPlayer.isCreative();
    }

    public void tick() {
        ++this.gameTicks;
        if (this.hasDelayedDestroy) {
            BlockState $$0 = this.level.getBlockState(this.delayedDestroyPos);
            if ($$0.isAir()) {
                this.hasDelayedDestroy = false;
            } else {
                float $$1 = this.incrementDestroyProgress($$0, this.delayedDestroyPos, this.delayedTickStart);
                if ($$1 >= 1.0f) {
                    this.hasDelayedDestroy = false;
                    this.destroyBlock(this.delayedDestroyPos);
                }
            }
        } else if (this.isDestroyingBlock) {
            BlockState $$2 = this.level.getBlockState(this.destroyPos);
            if ($$2.isAir()) {
                this.level.destroyBlockProgress(this.player.getId(), this.destroyPos, -1);
                this.lastSentState = -1;
                this.isDestroyingBlock = false;
            } else {
                this.incrementDestroyProgress($$2, this.destroyPos, this.destroyProgressStart);
            }
        }
    }

    private float incrementDestroyProgress(BlockState p_9277_, BlockPos p_9278_, int p_9279_) {
        int $$3 = this.gameTicks - p_9279_;
        float $$4 = p_9277_.getDestroyProgress(this.player, this.player.level(), p_9278_) * (float)($$3 + 1);
        int $$5 = (int)($$4 * 10.0f);
        if ($$5 != this.lastSentState) {
            this.level.destroyBlockProgress(this.player.getId(), p_9278_, $$5);
            this.lastSentState = $$5;
        }
        return $$4;
    }

    private void debugLogging(BlockPos p_215126_, boolean p_215127_, int p_215128_, String p_215129_) {
    }

    public void handleBlockBreakAction(BlockPos p_215120_, ServerboundPlayerActionPacket.Action p_215121_, Direction p_215122_, int p_215123_, int p_215124_) {
        if (!this.player.canInteractWithBlock(p_215120_, 1.0)) {
            this.debugLogging(p_215120_, false, p_215124_, "too far");
            return;
        }
        if (p_215120_.getY() > p_215123_) {
            this.player.connection.send(new ClientboundBlockUpdatePacket(p_215120_, this.level.getBlockState(p_215120_)));
            this.debugLogging(p_215120_, false, p_215124_, "too high");
            return;
        }
        if (p_215121_ == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK) {
            if (!this.level.mayInteract(this.player, p_215120_)) {
                this.player.connection.send(new ClientboundBlockUpdatePacket(p_215120_, this.level.getBlockState(p_215120_)));
                this.debugLogging(p_215120_, false, p_215124_, "may not interact");
                return;
            }
            if (this.isCreative()) {
                this.destroyAndAck(p_215120_, p_215124_, "creative destroy");
                return;
            }
            if (this.player.blockActionRestricted(this.level, p_215120_, this.gameModeForPlayer)) {
                this.player.connection.send(new ClientboundBlockUpdatePacket(p_215120_, this.level.getBlockState(p_215120_)));
                this.debugLogging(p_215120_, false, p_215124_, "block action restricted");
                return;
            }
            this.destroyProgressStart = this.gameTicks;
            float $$5 = 1.0f;
            BlockState $$6 = this.level.getBlockState(p_215120_);
            if (!$$6.isAir()) {
                EnchantmentHelper.onHitBlock(this.level, this.player.getMainHandItem(), this.player, this.player, EquipmentSlot.MAINHAND, Vec3.atCenterOf(p_215120_), $$6, p_348149_ -> this.player.onEquippedItemBroken((Item)p_348149_, EquipmentSlot.MAINHAND));
                $$6.attack(this.level, p_215120_, this.player);
                $$5 = $$6.getDestroyProgress(this.player, this.player.level(), p_215120_);
            }
            if (!$$6.isAir() && $$5 >= 1.0f) {
                this.destroyAndAck(p_215120_, p_215124_, "insta mine");
            } else {
                if (this.isDestroyingBlock) {
                    this.player.connection.send(new ClientboundBlockUpdatePacket(this.destroyPos, this.level.getBlockState(this.destroyPos)));
                    this.debugLogging(p_215120_, false, p_215124_, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.isDestroyingBlock = true;
                this.destroyPos = p_215120_.immutable();
                int $$7 = (int)($$5 * 10.0f);
                this.level.destroyBlockProgress(this.player.getId(), p_215120_, $$7);
                this.debugLogging(p_215120_, true, p_215124_, "actual start of destroying");
                this.lastSentState = $$7;
            }
        } else if (p_215121_ == ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK) {
            if (p_215120_.equals(this.destroyPos)) {
                int $$8 = this.gameTicks - this.destroyProgressStart;
                BlockState $$9 = this.level.getBlockState(p_215120_);
                if (!$$9.isAir()) {
                    float $$10 = $$9.getDestroyProgress(this.player, this.player.level(), p_215120_) * (float)($$8 + 1);
                    if ($$10 >= 0.7f) {
                        this.isDestroyingBlock = false;
                        this.level.destroyBlockProgress(this.player.getId(), p_215120_, -1);
                        this.destroyAndAck(p_215120_, p_215124_, "destroyed");
                        return;
                    }
                    if (!this.hasDelayedDestroy) {
                        this.isDestroyingBlock = false;
                        this.hasDelayedDestroy = true;
                        this.delayedDestroyPos = p_215120_;
                        this.delayedTickStart = this.destroyProgressStart;
                    }
                }
            }
            this.debugLogging(p_215120_, true, p_215124_, "stopped destroying");
        } else if (p_215121_ == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK) {
            this.isDestroyingBlock = false;
            if (!Objects.equals(this.destroyPos, p_215120_)) {
                LOGGER.warn("Mismatch in destroy block pos: {} {}", (Object)this.destroyPos, (Object)p_215120_);
                this.level.destroyBlockProgress(this.player.getId(), this.destroyPos, -1);
                this.debugLogging(p_215120_, true, p_215124_, "aborted mismatched destroying");
            }
            this.level.destroyBlockProgress(this.player.getId(), p_215120_, -1);
            this.debugLogging(p_215120_, true, p_215124_, "aborted destroying");
        }
    }

    public void destroyAndAck(BlockPos p_215117_, int p_215118_, String p_215119_) {
        if (this.destroyBlock(p_215117_)) {
            this.debugLogging(p_215117_, true, p_215118_, p_215119_);
        } else {
            this.player.connection.send(new ClientboundBlockUpdatePacket(p_215117_, this.level.getBlockState(p_215117_)));
            this.debugLogging(p_215117_, false, p_215118_, p_215119_);
        }
    }

    public boolean destroyBlock(BlockPos p_9281_) {
        BlockState $$1 = this.level.getBlockState(p_9281_);
        if (!this.player.getMainHandItem().getItem().canAttackBlock($$1, this.level, p_9281_, this.player)) {
            return false;
        }
        BlockEntity $$2 = this.level.getBlockEntity(p_9281_);
        Block $$3 = $$1.getBlock();
        if ($$3 instanceof GameMasterBlock && !this.player.canUseGameMasterBlocks()) {
            this.level.sendBlockUpdated(p_9281_, $$1, $$1, 3);
            return false;
        }
        if (this.player.blockActionRestricted(this.level, p_9281_, this.gameModeForPlayer)) {
            return false;
        }
        BlockState $$4 = $$3.playerWillDestroy(this.level, p_9281_, $$1, this.player);
        boolean $$5 = this.level.removeBlock(p_9281_, false);
        if ($$5) {
            $$3.destroy(this.level, p_9281_, $$4);
        }
        if (this.isCreative()) {
            return true;
        }
        ItemStack $$6 = this.player.getMainHandItem();
        ItemStack $$7 = $$6.copy();
        boolean $$8 = this.player.hasCorrectToolForDrops($$4);
        $$6.mineBlock(this.level, $$4, p_9281_, this.player);
        if ($$5 && $$8) {
            $$3.playerDestroy(this.level, this.player, p_9281_, $$4, $$2, $$7);
        }
        return true;
    }

    public InteractionResult useItem(ServerPlayer p_9262_, Level p_9263_, ItemStack p_9264_, InteractionHand p_9265_) {
        ItemStack $$9;
        if (this.gameModeForPlayer == GameType.SPECTATOR) {
            return InteractionResult.PASS;
        }
        if (p_9262_.getCooldowns().isOnCooldown(p_9264_)) {
            return InteractionResult.PASS;
        }
        int $$4 = p_9264_.getCount();
        int $$5 = p_9264_.getDamageValue();
        InteractionResult $$6 = p_9264_.use(p_9263_, p_9262_, p_9265_);
        if ($$6 instanceof InteractionResult.Success) {
            InteractionResult.Success $$7 = (InteractionResult.Success)$$6;
            ItemStack $$8 = Objects.requireNonNullElse($$7.heldItemTransformedTo(), p_9262_.getItemInHand(p_9265_));
        } else {
            $$9 = p_9262_.getItemInHand(p_9265_);
        }
        if ($$9 == p_9264_ && $$9.getCount() == $$4 && $$9.getUseDuration(p_9262_) <= 0 && $$9.getDamageValue() == $$5) {
            return $$6;
        }
        if ($$6 instanceof InteractionResult.Fail && $$9.getUseDuration(p_9262_) > 0 && !p_9262_.isUsingItem()) {
            return $$6;
        }
        if (p_9264_ != $$9) {
            p_9262_.setItemInHand(p_9265_, $$9);
        }
        if ($$9.isEmpty()) {
            p_9262_.setItemInHand(p_9265_, ItemStack.EMPTY);
        }
        if (!p_9262_.isUsingItem()) {
            p_9262_.inventoryMenu.sendAllDataToRemote();
        }
        return $$6;
    }

    public InteractionResult useItemOn(ServerPlayer p_9266_, Level p_9267_, ItemStack p_9268_, InteractionHand p_9269_, BlockHitResult p_9270_) {
        InteractionResult $$16;
        BlockPos $$5 = p_9270_.getBlockPos();
        BlockState $$6 = p_9267_.getBlockState($$5);
        if (!$$6.getBlock().isEnabled(p_9267_.enabledFeatures())) {
            return InteractionResult.FAIL;
        }
        if (this.gameModeForPlayer == GameType.SPECTATOR) {
            MenuProvider $$7 = $$6.getMenuProvider(p_9267_, $$5);
            if ($$7 != null) {
                p_9266_.openMenu($$7);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        boolean $$8 = !p_9266_.getMainHandItem().isEmpty() || !p_9266_.getOffhandItem().isEmpty();
        boolean $$9 = p_9266_.isSecondaryUseActive() && $$8;
        ItemStack $$10 = p_9268_.copy();
        if (!$$9) {
            InteractionResult $$12;
            InteractionResult $$11 = $$6.useItemOn(p_9266_.getItemInHand(p_9269_), p_9267_, p_9266_, p_9269_, p_9270_);
            if ($$11.consumesAction()) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(p_9266_, $$5, $$10);
                return $$11;
            }
            if ($$11 instanceof InteractionResult.TryEmptyHandInteraction && p_9269_ == InteractionHand.MAIN_HAND && ($$12 = $$6.useWithoutItem(p_9267_, p_9266_, p_9270_)).consumesAction()) {
                CriteriaTriggers.DEFAULT_BLOCK_USE.trigger(p_9266_, $$5);
                return $$12;
            }
        }
        if (p_9268_.isEmpty() || p_9266_.getCooldowns().isOnCooldown(p_9268_)) {
            return InteractionResult.PASS;
        }
        UseOnContext $$13 = new UseOnContext(p_9266_, p_9269_, p_9270_);
        if (this.isCreative()) {
            int $$14 = p_9268_.getCount();
            InteractionResult $$15 = p_9268_.useOn($$13);
            p_9268_.setCount($$14);
        } else {
            $$16 = p_9268_.useOn($$13);
        }
        if ($$16.consumesAction()) {
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(p_9266_, $$5, $$10);
        }
        return $$16;
    }

    public void setLevel(ServerLevel p_9261_) {
        this.level = p_9261_;
    }
}

