/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackDetector;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import org.slf4j.Logger;

public class FolderRepositorySource
implements RepositorySource {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final PackSelectionConfig DISCOVERED_PACK_SELECTION_CONFIG = new PackSelectionConfig(false, Pack.Position.TOP, false);
    private final Path folder;
    private final PackType packType;
    private final PackSource packSource;
    private final DirectoryValidator validator;

    public FolderRepositorySource(Path p_251796_, PackType p_251664_, PackSource p_250854_, DirectoryValidator p_296354_) {
        this.folder = p_251796_;
        this.packType = p_251664_;
        this.packSource = p_250854_;
        this.validator = p_296354_;
    }

    private static String nameFromPath(Path p_248745_) {
        return p_248745_.getFileName().toString();
    }

    @Override
    public void loadPacks(Consumer<Pack> p_250965_) {
        try {
            FileUtil.createDirectoriesSafe(this.folder);
            FolderRepositorySource.discoverPacks(this.folder, this.validator, (p_325639_, p_325640_) -> {
                PackLocationInfo $$3 = this.createDiscoveredFilePackInfo((Path)p_325639_);
                Pack $$4 = Pack.readMetaAndCreate($$3, p_325640_, this.packType, DISCOVERED_PACK_SELECTION_CONFIG);
                if ($$4 != null) {
                    p_250965_.accept($$4);
                }
            });
        }
        catch (IOException $$1) {
            LOGGER.warn("Failed to list packs in {}", (Object)this.folder, (Object)$$1);
        }
    }

    private PackLocationInfo createDiscoveredFilePackInfo(Path p_326163_) {
        String $$1 = FolderRepositorySource.nameFromPath(p_326163_);
        return new PackLocationInfo("file/" + $$1, Component.literal($$1), this.packSource, Optional.empty());
    }

    public static void discoverPacks(Path p_248794_, DirectoryValidator p_294483_, BiConsumer<Path, Pack.ResourcesSupplier> p_248580_) throws IOException {
        FolderPackDetector $$3 = new FolderPackDetector(p_294483_);
        try (DirectoryStream<Path> $$4 = Files.newDirectoryStream(p_248794_);){
            for (Path $$5 : $$4) {
                try {
                    ArrayList<ForbiddenSymlinkInfo> $$6 = new ArrayList<ForbiddenSymlinkInfo>();
                    Pack.ResourcesSupplier $$7 = (Pack.ResourcesSupplier)$$3.detectPackResources($$5, $$6);
                    if (!$$6.isEmpty()) {
                        LOGGER.warn("Ignoring potential pack entry: {}", (Object)ContentValidationException.getMessage($$5, $$6));
                        continue;
                    }
                    if ($$7 != null) {
                        p_248580_.accept($$5, $$7);
                        continue;
                    }
                    LOGGER.info("Found non-pack entry '{}', ignoring", (Object)$$5);
                }
                catch (IOException $$8) {
                    LOGGER.warn("Failed to read properties of '{}', ignoring", (Object)$$5, (Object)$$8);
                }
            }
        }
    }

    static class FolderPackDetector
    extends PackDetector<Pack.ResourcesSupplier> {
        protected FolderPackDetector(DirectoryValidator p_296420_) {
            super(p_296420_);
        }

        @Override
        @Nullable
        protected Pack.ResourcesSupplier createZipPack(Path p_294522_) {
            FileSystem $$1 = p_294522_.getFileSystem();
            if ($$1 == FileSystems.getDefault() || $$1 instanceof LinkFileSystem) {
                return new FilePackResources.FileResourcesSupplier(p_294522_);
            }
            LOGGER.info("Can't open pack archive at {}", (Object)p_294522_);
            return null;
        }

        @Override
        protected Pack.ResourcesSupplier createDirectoryPack(Path p_295493_) {
            return new PathPackResources.PathResourcesSupplier(p_295493_);
        }

        @Override
        protected /* synthetic */ Object createDirectoryPack(Path path) throws IOException {
            return this.createDirectoryPack(path);
        }

        @Override
        @Nullable
        protected /* synthetic */ Object createZipPack(Path path) throws IOException {
            return this.createZipPack(path);
        }
    }
}

