/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.Util;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadInstance;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class ProfiledReloadInstance
extends SimpleReloadInstance<State> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Stopwatch total = Stopwatch.createUnstarted();

    public ProfiledReloadInstance(ResourceManager p_10649_, List<PreparableReloadListener> p_10650_, Executor p_10651_, Executor p_10652_, CompletableFuture<Unit> p_10653_) {
        super(p_10651_, p_10652_, p_10649_, p_10650_, (p_372674_, p_372675_, p_372676_, p_372677_, p_372678_) -> {
            AtomicLong $$6 = new AtomicLong();
            AtomicLong $$7 = new AtomicLong();
            CompletableFuture<Void> $$8 = p_372676_.reload(p_372674_, p_372675_, ProfiledReloadInstance.profiledExecutor(p_372677_, $$6, p_372676_.getName()), ProfiledReloadInstance.profiledExecutor(p_372678_, $$7, p_372676_.getName()));
            return $$8.thenApplyAsync(p_372682_ -> {
                LOGGER.debug("Finished reloading {}", (Object)p_372676_.getName());
                return new State(p_372676_.getName(), $$6, $$7);
            }, p_10652_);
        }, p_10653_);
        this.total.start();
        this.allDone = this.allDone.thenApplyAsync(this::finish, p_10652_);
    }

    private static Executor profiledExecutor(Executor p_373101_, AtomicLong p_373001_, String p_372795_) {
        return p_372689_ -> p_373101_.execute(() -> {
            ProfilerFiller $$3 = Profiler.get();
            $$3.push(p_372795_);
            long $$4 = Util.getNanos();
            p_372689_.run();
            p_373001_.addAndGet(Util.getNanos() - $$4);
            $$3.pop();
        });
    }

    private List<State> finish(List<State> p_215484_) {
        this.total.stop();
        long $$1 = 0L;
        LOGGER.info("Resource reload finished after {} ms", (Object)this.total.elapsed(TimeUnit.MILLISECONDS));
        for (State $$2 : p_215484_) {
            long $$3 = TimeUnit.NANOSECONDS.toMillis($$2.preparationNanos.get());
            long $$4 = TimeUnit.NANOSECONDS.toMillis($$2.reloadNanos.get());
            long $$5 = $$3 + $$4;
            String $$6 = $$2.name;
            LOGGER.info("{} took approximately {} ms ({} ms preparing, {} ms applying)", new Object[]{$$6, $$5, $$3, $$4});
            $$1 += $$4;
        }
        LOGGER.info("Total blocking time: {} ms", (Object)$$1);
        return p_215484_;
    }

    public record State(String name, AtomicLong preparationNanos, AtomicLong reloadNanos) {
    }
}

