/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public abstract class SimpleJsonResourceReloadListener<T>
extends SimplePreparableReloadListener<Map<ResourceLocation, T>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DynamicOps<JsonElement> ops;
    private final Codec<T> codec;
    private final String directory;

    protected SimpleJsonResourceReloadListener(HolderLookup.Provider p_371387_, Codec<T> p_371214_, String p_371271_) {
        this(p_371387_.createSerializationContext(JsonOps.INSTANCE), p_371214_, p_371271_);
    }

    protected SimpleJsonResourceReloadListener(Codec<T> p_371490_, String p_371917_) {
        this((DynamicOps<JsonElement>)JsonOps.INSTANCE, p_371490_, p_371917_);
    }

    private SimpleJsonResourceReloadListener(DynamicOps<JsonElement> p_371600_, Codec<T> p_371393_, String p_10769_) {
        this.ops = p_371600_;
        this.codec = p_371393_;
        this.directory = p_10769_;
    }

    @Override
    protected Map<ResourceLocation, T> prepare(ResourceManager p_10771_, ProfilerFiller p_10772_) {
        HashMap $$2 = new HashMap();
        SimpleJsonResourceReloadListener.scanDirectory(p_10771_, this.directory, this.ops, this.codec, $$2);
        return $$2;
    }

    public static <T> void scanDirectory(ResourceManager p_279308_, String p_279131_, DynamicOps<JsonElement> p_371830_, Codec<T> p_371493_, Map<ResourceLocation, T> p_279404_) {
        FileToIdConverter $$5 = FileToIdConverter.json(p_279131_);
        for (Map.Entry<ResourceLocation, Resource> $$6 : $$5.listMatchingResources(p_279308_).entrySet()) {
            ResourceLocation $$7 = $$6.getKey();
            ResourceLocation $$8 = $$5.fileToId($$7);
            try {
                BufferedReader $$9 = $$6.getValue().openAsReader();
                try {
                    p_371493_.parse(p_371830_, (Object)JsonParser.parseReader((Reader)$$9)).ifSuccess(p_371454_ -> {
                        if (p_279404_.putIfAbsent($$8, p_371454_) != null) {
                            throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf($$8));
                        }
                    }).ifError(p_371566_ -> LOGGER.error("Couldn't parse data file '{}' from '{}': {}", new Object[]{$$8, $$7, p_371566_}));
                }
                finally {
                    if ($$9 == null) continue;
                    ((Reader)$$9).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException $$10) {
                LOGGER.error("Couldn't parse data file '{}' from '{}'", new Object[]{$$8, $$7, $$10});
            }
        }
    }

    @Override
    protected /* synthetic */ Object prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        return this.prepare(resourceManager, profilerFiller);
    }
}

