/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ResourceLocationException;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookRemovePacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookSettingsPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.RecipeBookSettings;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import org.slf4j.Logger;

public class ServerRecipeBook
extends RecipeBook {
    public static final String RECIPE_BOOK_TAG = "recipeBook";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DisplayResolver displayResolver;
    @VisibleForTesting
    protected final Set<ResourceKey<Recipe<?>>> known = Sets.newIdentityHashSet();
    @VisibleForTesting
    protected final Set<ResourceKey<Recipe<?>>> highlight = Sets.newIdentityHashSet();

    public ServerRecipeBook(DisplayResolver p_380166_) {
        this.displayResolver = p_380166_;
    }

    public void add(ResourceKey<Recipe<?>> p_379734_) {
        this.known.add(p_379734_);
    }

    public boolean contains(ResourceKey<Recipe<?>> p_379388_) {
        return this.known.contains(p_379388_);
    }

    public void remove(ResourceKey<Recipe<?>> p_380355_) {
        this.known.remove(p_380355_);
        this.highlight.remove(p_380355_);
    }

    public void removeHighlight(ResourceKey<Recipe<?>> p_380137_) {
        this.highlight.remove(p_380137_);
    }

    private void addHighlight(ResourceKey<Recipe<?>> p_379380_) {
        this.highlight.add(p_379380_);
    }

    public int addRecipes(Collection<RecipeHolder<?>> p_12792_, ServerPlayer p_12793_) {
        ArrayList<ClientboundRecipeBookAddPacket.Entry> $$2 = new ArrayList<ClientboundRecipeBookAddPacket.Entry>();
        for (RecipeHolder<?> $$3 : p_12792_) {
            ResourceKey<Recipe<?>> $$4 = $$3.id();
            if (this.known.contains($$4) || $$3.value().isSpecial()) continue;
            this.add($$4);
            this.addHighlight($$4);
            this.displayResolver.displaysForRecipe($$4, p_379913_ -> $$2.add(new ClientboundRecipeBookAddPacket.Entry((RecipeDisplayEntry)p_379913_, $$3.value().showNotification(), true)));
            CriteriaTriggers.RECIPE_UNLOCKED.trigger(p_12793_, $$3);
        }
        if (!$$2.isEmpty()) {
            p_12793_.connection.send(new ClientboundRecipeBookAddPacket($$2, false));
        }
        return $$2.size();
    }

    public int removeRecipes(Collection<RecipeHolder<?>> p_12807_, ServerPlayer p_12808_) {
        ArrayList $$2 = Lists.newArrayList();
        for (RecipeHolder<?> $$3 : p_12807_) {
            ResourceKey<Recipe<?>> $$4 = $$3.id();
            if (!this.known.contains($$4)) continue;
            this.remove($$4);
            this.displayResolver.displaysForRecipe($$4, p_379363_ -> $$2.add(p_379363_.id()));
        }
        if (!$$2.isEmpty()) {
            p_12808_.connection.send(new ClientboundRecipeBookRemovePacket($$2));
        }
        return $$2.size();
    }

    public CompoundTag toNbt() {
        CompoundTag $$0 = new CompoundTag();
        this.getBookSettings().write($$0);
        ListTag $$1 = new ListTag();
        for (ResourceKey<Recipe<?>> $$2 : this.known) {
            $$1.add(StringTag.valueOf($$2.location().toString()));
        }
        $$0.put("recipes", $$1);
        ListTag $$3 = new ListTag();
        for (ResourceKey<Recipe<?>> $$4 : this.highlight) {
            $$3.add(StringTag.valueOf($$4.location().toString()));
        }
        $$0.put("toBeDisplayed", $$3);
        return $$0;
    }

    public void fromNbt(CompoundTag p_12795_, Predicate<ResourceKey<Recipe<?>>> p_379369_) {
        this.setBookSettings(RecipeBookSettings.read(p_12795_));
        ListTag $$2 = p_12795_.getList("recipes", 8);
        this.loadRecipes($$2, this::add, p_379369_);
        ListTag $$3 = p_12795_.getList("toBeDisplayed", 8);
        this.loadRecipes($$3, this::addHighlight, p_379369_);
    }

    private void loadRecipes(ListTag p_12798_, Consumer<ResourceKey<Recipe<?>>> p_12799_, Predicate<ResourceKey<Recipe<?>>> p_379754_) {
        for (int $$3 = 0; $$3 < p_12798_.size(); ++$$3) {
            String $$4 = p_12798_.getString($$3);
            try {
                ResourceKey<Recipe<?>> $$5 = ResourceKey.create(Registries.RECIPE, ResourceLocation.parse($$4));
                if (!p_379754_.test($$5)) {
                    LOGGER.error("Tried to load unrecognized recipe: {} removed now.", $$5);
                    continue;
                }
                p_12799_.accept($$5);
                continue;
            }
            catch (ResourceLocationException $$6) {
                LOGGER.error("Tried to load improperly formatted recipe: {} removed now.", (Object)$$4);
            }
        }
    }

    public void sendInitialRecipeBook(ServerPlayer p_12790_) {
        p_12790_.connection.send(new ClientboundRecipeBookSettingsPacket(this.getBookSettings()));
        ArrayList<ClientboundRecipeBookAddPacket.Entry> $$1 = new ArrayList<ClientboundRecipeBookAddPacket.Entry>(this.known.size());
        for (ResourceKey<Recipe<?>> $$2 : this.known) {
            this.displayResolver.displaysForRecipe($$2, p_379992_ -> $$1.add(new ClientboundRecipeBookAddPacket.Entry((RecipeDisplayEntry)p_379992_, false, this.highlight.contains($$2))));
        }
        p_12790_.connection.send(new ClientboundRecipeBookAddPacket($$1, true));
    }

    public void copyOverData(ServerRecipeBook p_379645_) {
        this.known.clear();
        this.highlight.clear();
        this.bookSettings.replaceFrom(p_379645_.bookSettings);
        this.known.addAll(p_379645_.known);
        this.highlight.addAll(p_379645_.highlight);
    }

    @FunctionalInterface
    public static interface DisplayResolver {
        public void displaysForRecipe(ResourceKey<Recipe<?>> var1, Consumer<RecipeDisplayEntry> var2);
    }
}

