/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ARGB {
    public static int alpha(int p_360646_) {
        return p_360646_ >>> 24;
    }

    public static int red(int p_365322_) {
        return p_365322_ >> 16 & 0xFF;
    }

    public static int green(int p_364426_) {
        return p_364426_ >> 8 & 0xFF;
    }

    public static int blue(int p_365014_) {
        return p_365014_ & 0xFF;
    }

    public static int color(int p_364075_, int p_361505_, int p_364686_, int p_361326_) {
        return p_364075_ << 24 | p_361505_ << 16 | p_364686_ << 8 | p_361326_;
    }

    public static int color(int p_364209_, int p_361249_, int p_362935_) {
        return ARGB.color(255, p_364209_, p_361249_, p_362935_);
    }

    public static int color(Vec3 p_362659_) {
        return ARGB.color(ARGB.as8BitChannel((float)p_362659_.x()), ARGB.as8BitChannel((float)p_362659_.y()), ARGB.as8BitChannel((float)p_362659_.z()));
    }

    public static int multiply(int p_365204_, int p_362101_) {
        if (p_365204_ == -1) {
            return p_362101_;
        }
        if (p_362101_ == -1) {
            return p_365204_;
        }
        return ARGB.color(ARGB.alpha(p_365204_) * ARGB.alpha(p_362101_) / 255, ARGB.red(p_365204_) * ARGB.red(p_362101_) / 255, ARGB.green(p_365204_) * ARGB.green(p_362101_) / 255, ARGB.blue(p_365204_) * ARGB.blue(p_362101_) / 255);
    }

    public static int scaleRGB(int p_365021_, float p_363883_) {
        return ARGB.scaleRGB(p_365021_, p_363883_, p_363883_, p_363883_);
    }

    public static int scaleRGB(int p_379627_, float p_379288_, float p_380277_, float p_380015_) {
        return ARGB.color(ARGB.alpha(p_379627_), Math.clamp((long)((int)((float)ARGB.red(p_379627_) * p_379288_)), 0, 255), Math.clamp((long)((int)((float)ARGB.green(p_379627_) * p_380277_)), 0, 255), Math.clamp((long)((int)((float)ARGB.blue(p_379627_) * p_380015_)), 0, 255));
    }

    public static int scaleRGB(int p_360775_, int p_363230_) {
        return ARGB.color(ARGB.alpha(p_360775_), Math.clamp((long)ARGB.red(p_360775_) * (long)p_363230_ / 255L, 0, 255), Math.clamp((long)ARGB.green(p_360775_) * (long)p_363230_ / 255L, 0, 255), Math.clamp((long)ARGB.blue(p_360775_) * (long)p_363230_ / 255L, 0, 255));
    }

    public static int greyscale(int p_363419_) {
        int $$1 = (int)((float)ARGB.red(p_363419_) * 0.3f + (float)ARGB.green(p_363419_) * 0.59f + (float)ARGB.blue(p_363419_) * 0.11f);
        return ARGB.color($$1, $$1, $$1);
    }

    public static int lerp(float p_361174_, int p_362196_, int p_364079_) {
        int $$3 = Mth.lerpInt(p_361174_, ARGB.alpha(p_362196_), ARGB.alpha(p_364079_));
        int $$4 = Mth.lerpInt(p_361174_, ARGB.red(p_362196_), ARGB.red(p_364079_));
        int $$5 = Mth.lerpInt(p_361174_, ARGB.green(p_362196_), ARGB.green(p_364079_));
        int $$6 = Mth.lerpInt(p_361174_, ARGB.blue(p_362196_), ARGB.blue(p_364079_));
        return ARGB.color($$3, $$4, $$5, $$6);
    }

    public static int opaque(int p_363279_) {
        return p_363279_ | 0xFF000000;
    }

    public static int transparent(int p_361588_) {
        return p_361588_ & 0xFFFFFF;
    }

    public static int color(int p_360598_, int p_363344_) {
        return p_360598_ << 24 | p_363344_ & 0xFFFFFF;
    }

    public static int white(float p_361517_) {
        return ARGB.as8BitChannel(p_361517_) << 24 | 0xFFFFFF;
    }

    public static int colorFromFloat(float p_361263_, float p_361756_, float p_363770_, float p_362317_) {
        return ARGB.color(ARGB.as8BitChannel(p_361263_), ARGB.as8BitChannel(p_361756_), ARGB.as8BitChannel(p_363770_), ARGB.as8BitChannel(p_362317_));
    }

    public static Vector3f vector3fFromRGB24(int p_381022_) {
        float $$1 = (float)ARGB.red(p_381022_) / 255.0f;
        float $$2 = (float)ARGB.green(p_381022_) / 255.0f;
        float $$3 = (float)ARGB.blue(p_381022_) / 255.0f;
        return new Vector3f($$1, $$2, $$3);
    }

    public static int average(int p_363294_, int p_365166_) {
        return ARGB.color((ARGB.alpha(p_363294_) + ARGB.alpha(p_365166_)) / 2, (ARGB.red(p_363294_) + ARGB.red(p_365166_)) / 2, (ARGB.green(p_363294_) + ARGB.green(p_365166_)) / 2, (ARGB.blue(p_363294_) + ARGB.blue(p_365166_)) / 2);
    }

    public static int as8BitChannel(float p_362531_) {
        return Mth.floor(p_362531_ * 255.0f);
    }

    public static float from8BitChannel(int p_362888_) {
        return (float)p_362888_ / 255.0f;
    }

    public static int toABGR(int p_364127_) {
        return p_364127_ & 0xFF00FF00 | (p_364127_ & 0xFF0000) >> 16 | (p_364127_ & 0xFF) << 16;
    }

    public static int fromABGR(int p_362222_) {
        return ARGB.toABGR(p_362222_);
    }
}

