/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class EffectDurationFix
extends DataFix {
    private static final Set<String> POTION_ITEMS = Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow");

    public EffectDurationFix(Schema p_267976_) {
        super(p_267976_, false);
    }

    protected TypeRewriteRule makeRule() {
        Schema $$0 = this.getInputSchema();
        Type $$1 = this.getInputSchema().getType(References.ITEM_STACK);
        OpticFinder $$2 = DSL.fieldFinder((String)"id", (Type)DSL.named((String)References.ITEM_NAME.typeName(), NamespacedSchema.namespacedString()));
        OpticFinder $$3 = $$1.findField("tag");
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("EffectDurationEntity", $$0.getType(References.ENTITY), p_268118_ -> p_268118_.update(DSL.remainderFinder(), this::updateEntity)), (TypeRewriteRule[])new TypeRewriteRule[]{this.fixTypeEverywhereTyped("EffectDurationPlayer", $$0.getType(References.PLAYER), p_268326_ -> p_268326_.update(DSL.remainderFinder(), this::updateEntity)), this.fixTypeEverywhereTyped("EffectDurationItem", $$1, p_379071_ -> {
            Optional $$3;
            if (p_379071_.getOptional($$2).filter(p_379072_ -> POTION_ITEMS.contains(p_379072_.getSecond())).isPresent() && ($$3 = p_379071_.getOptionalTyped($$3)).isPresent()) {
                Dynamic $$4 = (Dynamic)((Typed)$$3.get()).get(DSL.remainderFinder());
                Typed $$5 = ((Typed)$$3.get()).set(DSL.remainderFinder(), (Object)$$4.update("CustomPotionEffects", this::fix));
                return p_379071_.set($$3, $$5);
            }
            return p_379071_;
        })});
    }

    private Dynamic<?> fixEffect(Dynamic<?> p_267989_) {
        return p_267989_.update("FactorCalculationData", p_268051_ -> {
            int $$2 = p_268051_.get("effect_changed_timestamp").asInt(-1);
            p_268051_ = p_268051_.remove("effect_changed_timestamp");
            int $$3 = p_267989_.get("Duration").asInt(-1);
            int $$4 = $$2 - $$3;
            return p_268051_.set("ticks_active", p_268051_.createInt($$4));
        });
    }

    private Dynamic<?> fix(Dynamic<?> p_268201_) {
        return p_268201_.createList(p_268201_.asStream().map(this::fixEffect));
    }

    private Dynamic<?> updateEntity(Dynamic<?> p_268005_) {
        p_268005_ = p_268005_.update("Effects", this::fix);
        p_268005_ = p_268005_.update("ActiveEffects", this::fix);
        p_268005_ = p_268005_.update("CustomPotionEffects", this::fix);
        return p_268005_;
    }
}

