/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.datafixers.util.Pair;
import net.minecraft.util.datafix.ComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class OminousBannerRarityFix
extends DataFix {
    public OminousBannerRarityFix(Schema p_364363_) {
        super(p_364363_, false);
    }

    public TypeRewriteRule makeRule() {
        Type $$0 = this.getInputSchema().getType(References.BLOCK_ENTITY);
        Type $$1 = this.getInputSchema().getType(References.ITEM_STACK);
        TaggedChoice.TaggedChoiceType $$2 = this.getInputSchema().findChoiceType(References.BLOCK_ENTITY);
        OpticFinder $$3 = DSL.fieldFinder((String)"id", (Type)DSL.named((String)References.ITEM_NAME.typeName(), NamespacedSchema.namespacedString()));
        OpticFinder $$4 = $$0.findField("components");
        OpticFinder $$5 = $$1.findField("components");
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("Ominous Banner block entity common rarity to uncommon rarity fix", $$0, p_363323_ -> {
            Object $$3 = ((Pair)p_363323_.get($$2.finder())).getFirst();
            return $$3.equals("minecraft:banner") ? this.fix((Typed<?>)p_363323_, (OpticFinder<?>)$$4) : p_363323_;
        }), (TypeRewriteRule)this.fixTypeEverywhereTyped("Ominous Banner item stack common rarity to uncommon rarity fix", $$1, p_360501_ -> {
            String $$3 = p_360501_.getOptional($$3).map(Pair::getSecond).orElse("");
            return $$3.equals("minecraft:white_banner") ? this.fix((Typed<?>)p_360501_, (OpticFinder<?>)$$5) : p_360501_;
        }));
    }

    private Typed<?> fix(Typed<?> p_363320_, OpticFinder<?> p_362991_) {
        return p_363320_.updateTyped(p_362991_, p_363204_ -> p_363204_.update(DSL.remainderFinder(), p_365422_ -> {
            boolean $$1 = p_365422_.get("minecraft:item_name").asString().result().flatMap(ComponentDataFixUtils::extractTranslationString).filter(p_363017_ -> p_363017_.equals("block.minecraft.ominous_banner")).isPresent();
            if ($$1) {
                return p_365422_.set("minecraft:rarity", p_365422_.createString("uncommon")).set("minecraft:item_name", ComponentDataFixUtils.createTranslatableComponent(p_365422_.getOps(), "block.minecraft.ominous_banner"));
            }
            return p_365422_;
        }));
    }
}

