/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.util.Brightness;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.slf4j.Logger;

public abstract class Display
extends Entity {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final int NO_BRIGHTNESS_OVERRIDE = -1;
    private static final EntityDataAccessor<Integer> DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_POS_ROT_INTERPOLATION_DURATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Vector3f> DATA_TRANSLATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.VECTOR3);
    private static final EntityDataAccessor<Vector3f> DATA_SCALE_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.VECTOR3);
    private static final EntityDataAccessor<Quaternionf> DATA_LEFT_ROTATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.QUATERNION);
    private static final EntityDataAccessor<Quaternionf> DATA_RIGHT_ROTATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.QUATERNION);
    private static final EntityDataAccessor<Byte> DATA_BILLBOARD_RENDER_CONSTRAINTS_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> DATA_BRIGHTNESS_OVERRIDE_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATA_VIEW_RANGE_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_SHADOW_RADIUS_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_SHADOW_STRENGTH_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_WIDTH_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_HEIGHT_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_GLOW_COLOR_OVERRIDE_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final IntSet RENDER_STATE_IDS = IntSet.of((int[])new int[]{DATA_TRANSLATION_ID.id(), DATA_SCALE_ID.id(), DATA_LEFT_ROTATION_ID.id(), DATA_RIGHT_ROTATION_ID.id(), DATA_BILLBOARD_RENDER_CONSTRAINTS_ID.id(), DATA_BRIGHTNESS_OVERRIDE_ID.id(), DATA_SHADOW_RADIUS_ID.id(), DATA_SHADOW_STRENGTH_ID.id()});
    private static final float INITIAL_SHADOW_RADIUS = 0.0f;
    private static final float INITIAL_SHADOW_STRENGTH = 1.0f;
    private static final int NO_GLOW_COLOR_OVERRIDE = -1;
    public static final String TAG_POS_ROT_INTERPOLATION_DURATION = "teleport_duration";
    public static final String TAG_TRANSFORMATION_INTERPOLATION_DURATION = "interpolation_duration";
    public static final String TAG_TRANSFORMATION_START_INTERPOLATION = "start_interpolation";
    public static final String TAG_TRANSFORMATION = "transformation";
    public static final String TAG_BILLBOARD = "billboard";
    public static final String TAG_BRIGHTNESS = "brightness";
    public static final String TAG_VIEW_RANGE = "view_range";
    public static final String TAG_SHADOW_RADIUS = "shadow_radius";
    public static final String TAG_SHADOW_STRENGTH = "shadow_strength";
    public static final String TAG_WIDTH = "width";
    public static final String TAG_HEIGHT = "height";
    public static final String TAG_GLOW_COLOR_OVERRIDE = "glow_color_override";
    private long interpolationStartClientTick = Integer.MIN_VALUE;
    private int interpolationDuration;
    private float lastProgress;
    private AABB cullingBoundingBox;
    private boolean noCulling = true;
    protected boolean updateRenderState;
    private boolean updateStartTick;
    private boolean updateInterpolationDuration;
    @Nullable
    private RenderState renderState;
    @Nullable
    private PosRotInterpolationTarget posRotInterpolationTarget;

    public Display(EntityType<?> p_270360_, Level p_270280_) {
        super(p_270360_, p_270280_);
        this.noPhysics = true;
        this.cullingBoundingBox = this.getBoundingBox();
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_270275_) {
        super.onSyncedDataUpdated(p_270275_);
        if (DATA_HEIGHT_ID.equals(p_270275_) || DATA_WIDTH_ID.equals(p_270275_)) {
            this.updateCulling();
        }
        if (DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID.equals(p_270275_)) {
            this.updateStartTick = true;
        }
        if (DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID.equals(p_270275_)) {
            this.updateInterpolationDuration = true;
        }
        if (RENDER_STATE_IDS.contains(p_270275_.id())) {
            this.updateRenderState = true;
        }
    }

    @Override
    public final boolean hurtServer(ServerLevel p_376368_, DamageSource p_376135_, float p_376332_) {
        return false;
    }

    private static Transformation createTransformation(SynchedEntityData p_270278_) {
        Vector3f $$1 = p_270278_.get(DATA_TRANSLATION_ID);
        Quaternionf $$2 = p_270278_.get(DATA_LEFT_ROTATION_ID);
        Vector3f $$3 = p_270278_.get(DATA_SCALE_ID);
        Quaternionf $$4 = p_270278_.get(DATA_RIGHT_ROTATION_ID);
        return new Transformation($$1, $$2, $$3, $$4);
    }

    @Override
    public void tick() {
        Entity $$0 = this.getVehicle();
        if ($$0 != null && $$0.isRemoved()) {
            this.stopRiding();
        }
        if (this.level().isClientSide) {
            if (this.updateStartTick) {
                this.updateStartTick = false;
                int $$1 = this.getTransformationInterpolationDelay();
                this.interpolationStartClientTick = this.tickCount + $$1;
            }
            if (this.updateInterpolationDuration) {
                this.updateInterpolationDuration = false;
                this.interpolationDuration = this.getTransformationInterpolationDuration();
            }
            if (this.updateRenderState) {
                this.updateRenderState = false;
                boolean $$2 = this.interpolationDuration != 0;
                this.renderState = $$2 && this.renderState != null ? this.createInterpolatedRenderState(this.renderState, this.lastProgress) : this.createFreshRenderState();
                this.updateRenderSubState($$2, this.lastProgress);
            }
            if (this.posRotInterpolationTarget != null) {
                if (this.posRotInterpolationTarget.steps == 0) {
                    this.posRotInterpolationTarget.applyTargetPosAndRot(this);
                    this.setOldPosAndRot();
                    this.posRotInterpolationTarget = null;
                } else {
                    this.posRotInterpolationTarget.applyLerpStep(this);
                    --this.posRotInterpolationTarget.steps;
                    if (this.posRotInterpolationTarget.steps == 0) {
                        this.posRotInterpolationTarget = null;
                    }
                }
            }
        }
    }

    protected abstract void updateRenderSubState(boolean var1, float var2);

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_325924_) {
        p_325924_.define(DATA_POS_ROT_INTERPOLATION_DURATION_ID, 0);
        p_325924_.define(DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID, 0);
        p_325924_.define(DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID, 0);
        p_325924_.define(DATA_TRANSLATION_ID, new Vector3f());
        p_325924_.define(DATA_SCALE_ID, new Vector3f(1.0f, 1.0f, 1.0f));
        p_325924_.define(DATA_RIGHT_ROTATION_ID, new Quaternionf());
        p_325924_.define(DATA_LEFT_ROTATION_ID, new Quaternionf());
        p_325924_.define(DATA_BILLBOARD_RENDER_CONSTRAINTS_ID, BillboardConstraints.FIXED.getId());
        p_325924_.define(DATA_BRIGHTNESS_OVERRIDE_ID, -1);
        p_325924_.define(DATA_VIEW_RANGE_ID, Float.valueOf(1.0f));
        p_325924_.define(DATA_SHADOW_RADIUS_ID, Float.valueOf(0.0f));
        p_325924_.define(DATA_SHADOW_STRENGTH_ID, Float.valueOf(1.0f));
        p_325924_.define(DATA_WIDTH_ID, Float.valueOf(0.0f));
        p_325924_.define(DATA_HEIGHT_ID, Float.valueOf(0.0f));
        p_325924_.define(DATA_GLOW_COLOR_OVERRIDE_ID, -1);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag p_270854_) {
        if (p_270854_.contains(TAG_TRANSFORMATION)) {
            Transformation.EXTENDED_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)p_270854_.get(TAG_TRANSFORMATION)).resultOrPartial(Util.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(p_270952_ -> this.setTransformation((Transformation)p_270952_.getFirst()));
        }
        if (p_270854_.contains(TAG_TRANSFORMATION_INTERPOLATION_DURATION, 99)) {
            int $$1 = p_270854_.getInt(TAG_TRANSFORMATION_INTERPOLATION_DURATION);
            this.setTransformationInterpolationDuration($$1);
        }
        if (p_270854_.contains(TAG_TRANSFORMATION_START_INTERPOLATION, 99)) {
            int $$2 = p_270854_.getInt(TAG_TRANSFORMATION_START_INTERPOLATION);
            this.setTransformationInterpolationDelay($$2);
        }
        if (p_270854_.contains(TAG_POS_ROT_INTERPOLATION_DURATION, 99)) {
            int $$3 = p_270854_.getInt(TAG_POS_ROT_INTERPOLATION_DURATION);
            this.setPosRotInterpolationDuration(Mth.clamp($$3, 0, 59));
        }
        if (p_270854_.contains(TAG_BILLBOARD, 8)) {
            BillboardConstraints.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)p_270854_.get(TAG_BILLBOARD)).resultOrPartial(Util.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(p_270691_ -> this.setBillboardConstraints((BillboardConstraints)p_270691_.getFirst()));
        }
        if (p_270854_.contains(TAG_VIEW_RANGE, 99)) {
            this.setViewRange(p_270854_.getFloat(TAG_VIEW_RANGE));
        }
        if (p_270854_.contains(TAG_SHADOW_RADIUS, 99)) {
            this.setShadowRadius(p_270854_.getFloat(TAG_SHADOW_RADIUS));
        }
        if (p_270854_.contains(TAG_SHADOW_STRENGTH, 99)) {
            this.setShadowStrength(p_270854_.getFloat(TAG_SHADOW_STRENGTH));
        }
        if (p_270854_.contains(TAG_WIDTH, 99)) {
            this.setWidth(p_270854_.getFloat(TAG_WIDTH));
        }
        if (p_270854_.contains(TAG_HEIGHT, 99)) {
            this.setHeight(p_270854_.getFloat(TAG_HEIGHT));
        }
        if (p_270854_.contains(TAG_GLOW_COLOR_OVERRIDE, 99)) {
            this.setGlowColorOverride(p_270854_.getInt(TAG_GLOW_COLOR_OVERRIDE));
        }
        if (p_270854_.contains(TAG_BRIGHTNESS, 10)) {
            Brightness.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)p_270854_.get(TAG_BRIGHTNESS)).resultOrPartial(Util.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(p_270247_ -> this.setBrightnessOverride((Brightness)p_270247_.getFirst()));
        } else {
            this.setBrightnessOverride(null);
        }
    }

    private void setTransformation(Transformation p_270186_) {
        this.entityData.set(DATA_TRANSLATION_ID, p_270186_.getTranslation());
        this.entityData.set(DATA_LEFT_ROTATION_ID, p_270186_.getLeftRotation());
        this.entityData.set(DATA_SCALE_ID, p_270186_.getScale());
        this.entityData.set(DATA_RIGHT_ROTATION_ID, p_270186_.getRightRotation());
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag p_270779_) {
        Transformation.EXTENDED_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)Display.createTransformation(this.entityData)).ifSuccess(p_270528_ -> p_270779_.put(TAG_TRANSFORMATION, (Tag)p_270528_));
        BillboardConstraints.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getBillboardConstraints()).ifSuccess(p_270227_ -> p_270779_.put(TAG_BILLBOARD, (Tag)p_270227_));
        p_270779_.putInt(TAG_TRANSFORMATION_INTERPOLATION_DURATION, this.getTransformationInterpolationDuration());
        p_270779_.putInt(TAG_POS_ROT_INTERPOLATION_DURATION, this.getPosRotInterpolationDuration());
        p_270779_.putFloat(TAG_VIEW_RANGE, this.getViewRange());
        p_270779_.putFloat(TAG_SHADOW_RADIUS, this.getShadowRadius());
        p_270779_.putFloat(TAG_SHADOW_STRENGTH, this.getShadowStrength());
        p_270779_.putFloat(TAG_WIDTH, this.getWidth());
        p_270779_.putFloat(TAG_HEIGHT, this.getHeight());
        p_270779_.putInt(TAG_GLOW_COLOR_OVERRIDE, this.getGlowColorOverride());
        Brightness $$1 = this.getBrightnessOverride();
        if ($$1 != null) {
            Brightness.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)$$1).ifSuccess(p_270121_ -> p_270779_.put(TAG_BRIGHTNESS, (Tag)p_270121_));
        }
    }

    @Override
    public void cancelLerp() {
        this.posRotInterpolationTarget = null;
    }

    @Override
    public void lerpTo(double p_296267_, double p_295427_, double p_295172_, float p_294570_, float p_295085_, int p_295553_) {
        int $$6 = this.getPosRotInterpolationDuration();
        this.posRotInterpolationTarget = new PosRotInterpolationTarget($$6, p_296267_, p_295427_, p_295172_, p_294570_, p_295085_);
    }

    @Override
    public double lerpTargetX() {
        return this.posRotInterpolationTarget != null ? this.posRotInterpolationTarget.targetX : this.getX();
    }

    @Override
    public double lerpTargetY() {
        return this.posRotInterpolationTarget != null ? this.posRotInterpolationTarget.targetY : this.getY();
    }

    @Override
    public double lerpTargetZ() {
        return this.posRotInterpolationTarget != null ? this.posRotInterpolationTarget.targetZ : this.getZ();
    }

    @Override
    public float lerpTargetXRot() {
        return this.posRotInterpolationTarget != null ? (float)this.posRotInterpolationTarget.targetXRot : this.getXRot();
    }

    @Override
    public float lerpTargetYRot() {
        return this.posRotInterpolationTarget != null ? (float)this.posRotInterpolationTarget.targetYRot : this.getYRot();
    }

    public AABB getBoundingBoxForCulling() {
        return this.cullingBoundingBox;
    }

    public boolean affectedByCulling() {
        return !this.noCulling;
    }

    @Override
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Nullable
    public RenderState renderState() {
        return this.renderState;
    }

    private void setTransformationInterpolationDuration(int p_295945_) {
        this.entityData.set(DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID, p_295945_);
    }

    private int getTransformationInterpolationDuration() {
        return this.entityData.get(DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID);
    }

    private void setTransformationInterpolationDelay(int p_296116_) {
        this.entityData.set(DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID, p_296116_, true);
    }

    private int getTransformationInterpolationDelay() {
        return this.entityData.get(DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID);
    }

    private void setPosRotInterpolationDuration(int p_295015_) {
        this.entityData.set(DATA_POS_ROT_INTERPOLATION_DURATION_ID, p_295015_);
    }

    private int getPosRotInterpolationDuration() {
        return this.entityData.get(DATA_POS_ROT_INTERPOLATION_DURATION_ID);
    }

    private void setBillboardConstraints(BillboardConstraints p_270345_) {
        this.entityData.set(DATA_BILLBOARD_RENDER_CONSTRAINTS_ID, p_270345_.getId());
    }

    private BillboardConstraints getBillboardConstraints() {
        return BillboardConstraints.BY_ID.apply(this.entityData.get(DATA_BILLBOARD_RENDER_CONSTRAINTS_ID).byteValue());
    }

    private void setBrightnessOverride(@Nullable Brightness p_270461_) {
        this.entityData.set(DATA_BRIGHTNESS_OVERRIDE_ID, p_270461_ != null ? p_270461_.pack() : -1);
    }

    @Nullable
    private Brightness getBrightnessOverride() {
        int $$0 = this.entityData.get(DATA_BRIGHTNESS_OVERRIDE_ID);
        return $$0 != -1 ? Brightness.unpack($$0) : null;
    }

    private int getPackedBrightnessOverride() {
        return this.entityData.get(DATA_BRIGHTNESS_OVERRIDE_ID);
    }

    private void setViewRange(float p_270907_) {
        this.entityData.set(DATA_VIEW_RANGE_ID, Float.valueOf(p_270907_));
    }

    private float getViewRange() {
        return this.entityData.get(DATA_VIEW_RANGE_ID).floatValue();
    }

    private void setShadowRadius(float p_270122_) {
        this.entityData.set(DATA_SHADOW_RADIUS_ID, Float.valueOf(p_270122_));
    }

    private float getShadowRadius() {
        return this.entityData.get(DATA_SHADOW_RADIUS_ID).floatValue();
    }

    private void setShadowStrength(float p_270866_) {
        this.entityData.set(DATA_SHADOW_STRENGTH_ID, Float.valueOf(p_270866_));
    }

    private float getShadowStrength() {
        return this.entityData.get(DATA_SHADOW_STRENGTH_ID).floatValue();
    }

    private void setWidth(float p_270741_) {
        this.entityData.set(DATA_WIDTH_ID, Float.valueOf(p_270741_));
    }

    private float getWidth() {
        return this.entityData.get(DATA_WIDTH_ID).floatValue();
    }

    private void setHeight(float p_270716_) {
        this.entityData.set(DATA_HEIGHT_ID, Float.valueOf(p_270716_));
    }

    private int getGlowColorOverride() {
        return this.entityData.get(DATA_GLOW_COLOR_OVERRIDE_ID);
    }

    private void setGlowColorOverride(int p_270784_) {
        this.entityData.set(DATA_GLOW_COLOR_OVERRIDE_ID, p_270784_);
    }

    public float calculateInterpolationProgress(float p_272675_) {
        float $$4;
        int $$1 = this.interpolationDuration;
        if ($$1 <= 0) {
            return 1.0f;
        }
        float $$2 = (long)this.tickCount - this.interpolationStartClientTick;
        float $$3 = $$2 + p_272675_;
        this.lastProgress = $$4 = Mth.clamp(Mth.inverseLerp($$3, 0.0f, $$1), 0.0f, 1.0f);
        return $$4;
    }

    private float getHeight() {
        return this.entityData.get(DATA_HEIGHT_ID).floatValue();
    }

    @Override
    public void setPos(double p_270091_, double p_270983_, double p_270419_) {
        super.setPos(p_270091_, p_270983_, p_270419_);
        this.updateCulling();
    }

    private void updateCulling() {
        float $$0 = this.getWidth();
        float $$1 = this.getHeight();
        this.noCulling = $$0 == 0.0f || $$1 == 0.0f;
        float $$2 = $$0 / 2.0f;
        double $$3 = this.getX();
        double $$4 = this.getY();
        double $$5 = this.getZ();
        this.cullingBoundingBox = new AABB($$3 - (double)$$2, $$4, $$5 - (double)$$2, $$3 + (double)$$2, $$4 + (double)$$1, $$5 + (double)$$2);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double p_270991_) {
        return p_270991_ < Mth.square((double)this.getViewRange() * 64.0 * Display.getViewScale());
    }

    @Override
    public int getTeamColor() {
        int $$0 = this.getGlowColorOverride();
        return $$0 != -1 ? $$0 : super.getTeamColor();
    }

    private RenderState createFreshRenderState() {
        return new RenderState(GenericInterpolator.constant(Display.createTransformation(this.entityData)), this.getBillboardConstraints(), this.getPackedBrightnessOverride(), FloatInterpolator.constant(this.getShadowRadius()), FloatInterpolator.constant(this.getShadowStrength()), this.getGlowColorOverride());
    }

    private RenderState createInterpolatedRenderState(RenderState p_277365_, float p_277948_) {
        Transformation $$2 = p_277365_.transformation.get(p_277948_);
        float $$3 = p_277365_.shadowRadius.get(p_277948_);
        float $$4 = p_277365_.shadowStrength.get(p_277948_);
        return new RenderState(new TransformationInterpolator($$2, Display.createTransformation(this.entityData)), this.getBillboardConstraints(), this.getPackedBrightnessOverride(), new LinearFloatInterpolator($$3, this.getShadowRadius()), new LinearFloatInterpolator($$4, this.getShadowStrength()), this.getGlowColorOverride());
    }

    public record RenderState(GenericInterpolator<Transformation> transformation, BillboardConstraints billboardConstraints, int brightnessOverride, FloatInterpolator shadowRadius, FloatInterpolator shadowStrength, int glowColorOverride) {
    }

    static class PosRotInterpolationTarget {
        int steps;
        final double targetX;
        final double targetY;
        final double targetZ;
        final double targetYRot;
        final double targetXRot;

        PosRotInterpolationTarget(int p_294253_, double p_294234_, double p_295719_, double p_294808_, double p_295750_, double p_295305_) {
            this.steps = p_294253_;
            this.targetX = p_294234_;
            this.targetY = p_295719_;
            this.targetZ = p_294808_;
            this.targetYRot = p_295750_;
            this.targetXRot = p_295305_;
        }

        void applyTargetPosAndRot(Entity p_294993_) {
            p_294993_.setPos(this.targetX, this.targetY, this.targetZ);
            p_294993_.setRot((float)this.targetYRot, (float)this.targetXRot);
        }

        void applyLerpStep(Entity p_294423_) {
            p_294423_.lerpPositionAndRotationStep(this.steps, this.targetX, this.targetY, this.targetZ, this.targetYRot, this.targetXRot);
        }
    }

    public static enum BillboardConstraints implements StringRepresentable
    {
        FIXED(0, "fixed"),
        VERTICAL(1, "vertical"),
        HORIZONTAL(2, "horizontal"),
        CENTER(3, "center");

        public static final Codec<BillboardConstraints> CODEC;
        public static final IntFunction<BillboardConstraints> BY_ID;
        private final byte id;
        private final String name;

        private BillboardConstraints(byte p_270785_, String p_270544_) {
            this.name = p_270544_;
            this.id = p_270785_;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        byte getId() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(BillboardConstraints::values);
            BY_ID = ByIdMap.continuous(BillboardConstraints::getId, BillboardConstraints.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    @FunctionalInterface
    public static interface GenericInterpolator<T> {
        public static <T> GenericInterpolator<T> constant(T p_277718_) {
            return p_277907_ -> p_277718_;
        }

        public T get(float var1);
    }

    @FunctionalInterface
    public static interface FloatInterpolator {
        public static FloatInterpolator constant(float p_277894_) {
            return p_278040_ -> p_277894_;
        }

        public float get(float var1);
    }

    record TransformationInterpolator(Transformation previous, Transformation current) implements GenericInterpolator<Transformation>
    {
        @Override
        public Transformation get(float p_278027_) {
            if ((double)p_278027_ >= 1.0) {
                return this.current;
            }
            return this.previous.slerp(this.current, p_278027_);
        }

        @Override
        public /* synthetic */ Object get(float f) {
            return this.get(f);
        }
    }

    record LinearFloatInterpolator(float previous, float current) implements FloatInterpolator
    {
        @Override
        public float get(float p_277511_) {
            return Mth.lerp(p_277511_, this.previous, this.current);
        }
    }

    record ColorInterpolator(int previous, int current) implements IntInterpolator
    {
        @Override
        public int get(float p_278012_) {
            return ARGB.lerp(p_278012_, this.previous, this.current);
        }
    }

    record LinearIntInterpolator(int previous, int current) implements IntInterpolator
    {
        @Override
        public int get(float p_277960_) {
            return Mth.lerpInt(p_277960_, this.previous, this.current);
        }
    }

    @FunctionalInterface
    public static interface IntInterpolator {
        public static IntInterpolator constant(int p_277348_) {
            return p_277356_ -> p_277348_;
        }

        public int get(float var1);
    }

    public static class TextDisplay
    extends Display {
        public static final String TAG_TEXT = "text";
        private static final String TAG_LINE_WIDTH = "line_width";
        private static final String TAG_TEXT_OPACITY = "text_opacity";
        private static final String TAG_BACKGROUND_COLOR = "background";
        private static final String TAG_SHADOW = "shadow";
        private static final String TAG_SEE_THROUGH = "see_through";
        private static final String TAG_USE_DEFAULT_BACKGROUND = "default_background";
        private static final String TAG_ALIGNMENT = "alignment";
        public static final byte FLAG_SHADOW = 1;
        public static final byte FLAG_SEE_THROUGH = 2;
        public static final byte FLAG_USE_DEFAULT_BACKGROUND = 4;
        public static final byte FLAG_ALIGN_LEFT = 8;
        public static final byte FLAG_ALIGN_RIGHT = 16;
        private static final byte INITIAL_TEXT_OPACITY = -1;
        public static final int INITIAL_BACKGROUND = 0x40000000;
        private static final EntityDataAccessor<Component> DATA_TEXT_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.COMPONENT);
        private static final EntityDataAccessor<Integer> DATA_LINE_WIDTH_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.INT);
        private static final EntityDataAccessor<Integer> DATA_BACKGROUND_COLOR_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.INT);
        private static final EntityDataAccessor<Byte> DATA_TEXT_OPACITY_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.BYTE);
        private static final EntityDataAccessor<Byte> DATA_STYLE_FLAGS_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.BYTE);
        private static final IntSet TEXT_RENDER_STATE_IDS = IntSet.of((int[])new int[]{DATA_TEXT_ID.id(), DATA_LINE_WIDTH_ID.id(), DATA_BACKGROUND_COLOR_ID.id(), DATA_TEXT_OPACITY_ID.id(), DATA_STYLE_FLAGS_ID.id()});
        @Nullable
        private CachedInfo clientDisplayCache;
        @Nullable
        private TextRenderState textRenderState;

        public TextDisplay(EntityType<?> p_270708_, Level p_270736_) {
            super(p_270708_, p_270736_);
        }

        @Override
        protected void defineSynchedData(SynchedEntityData.Builder p_326450_) {
            super.defineSynchedData(p_326450_);
            p_326450_.define(DATA_TEXT_ID, Component.empty());
            p_326450_.define(DATA_LINE_WIDTH_ID, 200);
            p_326450_.define(DATA_BACKGROUND_COLOR_ID, 0x40000000);
            p_326450_.define(DATA_TEXT_OPACITY_ID, (byte)-1);
            p_326450_.define(DATA_STYLE_FLAGS_ID, (byte)0);
        }

        @Override
        public void onSyncedDataUpdated(EntityDataAccessor<?> p_270797_) {
            super.onSyncedDataUpdated(p_270797_);
            if (TEXT_RENDER_STATE_IDS.contains(p_270797_.id())) {
                this.updateRenderState = true;
            }
        }

        private Component getText() {
            return this.entityData.get(DATA_TEXT_ID);
        }

        private void setText(Component p_270902_) {
            this.entityData.set(DATA_TEXT_ID, p_270902_);
        }

        private int getLineWidth() {
            return this.entityData.get(DATA_LINE_WIDTH_ID);
        }

        private void setLineWidth(int p_270545_) {
            this.entityData.set(DATA_LINE_WIDTH_ID, p_270545_);
        }

        private byte getTextOpacity() {
            return this.entityData.get(DATA_TEXT_OPACITY_ID);
        }

        private void setTextOpacity(byte p_270583_) {
            this.entityData.set(DATA_TEXT_OPACITY_ID, p_270583_);
        }

        private int getBackgroundColor() {
            return this.entityData.get(DATA_BACKGROUND_COLOR_ID);
        }

        private void setBackgroundColor(int p_270241_) {
            this.entityData.set(DATA_BACKGROUND_COLOR_ID, p_270241_);
        }

        private byte getFlags() {
            return this.entityData.get(DATA_STYLE_FLAGS_ID);
        }

        private void setFlags(byte p_270855_) {
            this.entityData.set(DATA_STYLE_FLAGS_ID, p_270855_);
        }

        private static byte loadFlag(byte p_270219_, CompoundTag p_270994_, String p_270958_, byte p_270701_) {
            if (p_270994_.getBoolean(p_270958_)) {
                return (byte)(p_270219_ | p_270701_);
            }
            return p_270219_;
        }

        @Override
        protected void readAdditionalSaveData(CompoundTag p_270714_) {
            super.readAdditionalSaveData(p_270714_);
            if (p_270714_.contains(TAG_LINE_WIDTH, 99)) {
                this.setLineWidth(p_270714_.getInt(TAG_LINE_WIDTH));
            }
            if (p_270714_.contains(TAG_TEXT_OPACITY, 99)) {
                this.setTextOpacity(p_270714_.getByte(TAG_TEXT_OPACITY));
            }
            if (p_270714_.contains(TAG_BACKGROUND_COLOR, 99)) {
                this.setBackgroundColor(p_270714_.getInt(TAG_BACKGROUND_COLOR));
            }
            byte $$1 = TextDisplay.loadFlag((byte)0, p_270714_, TAG_SHADOW, (byte)1);
            $$1 = TextDisplay.loadFlag($$1, p_270714_, TAG_SEE_THROUGH, (byte)2);
            $$1 = TextDisplay.loadFlag($$1, p_270714_, TAG_USE_DEFAULT_BACKGROUND, (byte)4);
            Optional<Align> $$2 = Align.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)p_270714_.get(TAG_ALIGNMENT)).resultOrPartial(Util.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).map(Pair::getFirst);
            if ($$2.isPresent()) {
                $$1 = switch ($$2.get().ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> $$1;
                    case 1 -> (byte)($$1 | 8);
                    case 2 -> (byte)($$1 | 0x10);
                };
            }
            this.setFlags($$1);
            if (p_270714_.contains(TAG_TEXT, 8)) {
                String $$3 = p_270714_.getString(TAG_TEXT);
                try {
                    Level level;
                    MutableComponent $$4 = Component.Serializer.fromJson($$3, (HolderLookup.Provider)this.registryAccess());
                    if ($$4 != null && (level = this.level()) instanceof ServerLevel) {
                        ServerLevel $$5 = (ServerLevel)level;
                        CommandSourceStack $$6 = this.createCommandSourceStackForNameResolution($$5).withPermission(2);
                        MutableComponent $$7 = ComponentUtils.updateForEntity($$6, $$4, (Entity)this, 0);
                        this.setText($$7);
                    } else {
                        this.setText(Component.empty());
                    }
                }
                catch (Exception $$8) {
                    LOGGER.warn("Failed to parse display entity text {}", (Object)$$3, (Object)$$8);
                }
            }
        }

        private static void storeFlag(byte p_270879_, CompoundTag p_270177_, String p_270294_, byte p_270853_) {
            p_270177_.putBoolean(p_270294_, (p_270879_ & p_270853_) != 0);
        }

        @Override
        protected void addAdditionalSaveData(CompoundTag p_270268_) {
            super.addAdditionalSaveData(p_270268_);
            p_270268_.putString(TAG_TEXT, Component.Serializer.toJson(this.getText(), this.registryAccess()));
            p_270268_.putInt(TAG_LINE_WIDTH, this.getLineWidth());
            p_270268_.putInt(TAG_BACKGROUND_COLOR, this.getBackgroundColor());
            p_270268_.putByte(TAG_TEXT_OPACITY, this.getTextOpacity());
            byte $$1 = this.getFlags();
            TextDisplay.storeFlag($$1, p_270268_, TAG_SHADOW, (byte)1);
            TextDisplay.storeFlag($$1, p_270268_, TAG_SEE_THROUGH, (byte)2);
            TextDisplay.storeFlag($$1, p_270268_, TAG_USE_DEFAULT_BACKGROUND, (byte)4);
            Align.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)TextDisplay.getAlign($$1)).ifSuccess(p_271001_ -> p_270268_.put(TAG_ALIGNMENT, (Tag)p_271001_));
        }

        @Override
        protected void updateRenderSubState(boolean p_277565_, float p_277967_) {
            this.textRenderState = p_277565_ && this.textRenderState != null ? this.createInterpolatedTextRenderState(this.textRenderState, p_277967_) : this.createFreshTextRenderState();
            this.clientDisplayCache = null;
        }

        @Nullable
        public TextRenderState textRenderState() {
            return this.textRenderState;
        }

        private TextRenderState createFreshTextRenderState() {
            return new TextRenderState(this.getText(), this.getLineWidth(), IntInterpolator.constant(this.getTextOpacity()), IntInterpolator.constant(this.getBackgroundColor()), this.getFlags());
        }

        private TextRenderState createInterpolatedTextRenderState(TextRenderState p_278000_, float p_277646_) {
            int $$2 = p_278000_.backgroundColor.get(p_277646_);
            int $$3 = p_278000_.textOpacity.get(p_277646_);
            return new TextRenderState(this.getText(), this.getLineWidth(), new LinearIntInterpolator($$3, this.getTextOpacity()), new ColorInterpolator($$2, this.getBackgroundColor()), this.getFlags());
        }

        public CachedInfo cacheDisplay(LineSplitter p_270682_) {
            if (this.clientDisplayCache == null) {
                this.clientDisplayCache = this.textRenderState != null ? p_270682_.split(this.textRenderState.text(), this.textRenderState.lineWidth()) : new CachedInfo(List.of(), 0);
            }
            return this.clientDisplayCache;
        }

        public static Align getAlign(byte p_270911_) {
            if ((p_270911_ & 8) != 0) {
                return Align.LEFT;
            }
            if ((p_270911_ & 0x10) != 0) {
                return Align.RIGHT;
            }
            return Align.CENTER;
        }

        public static enum Align implements StringRepresentable
        {
            CENTER("center"),
            LEFT("left"),
            RIGHT("right");

            public static final Codec<Align> CODEC;
            private final String name;

            private Align(String p_270554_) {
                this.name = p_270554_;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }

            static {
                CODEC = StringRepresentable.fromEnum(Align::values);
            }
        }

        public record TextRenderState(Component text, int lineWidth, IntInterpolator textOpacity, IntInterpolator backgroundColor, byte flags) {
        }

        public record CachedInfo(List<CachedLine> lines, int width) {
        }

        @FunctionalInterface
        public static interface LineSplitter {
            public CachedInfo split(Component var1, int var2);
        }

        public record CachedLine(FormattedCharSequence contents, int width) {
        }
    }

    public static class BlockDisplay
    extends Display {
        public static final String TAG_BLOCK_STATE = "block_state";
        private static final EntityDataAccessor<BlockState> DATA_BLOCK_STATE_ID = SynchedEntityData.defineId(BlockDisplay.class, EntityDataSerializers.BLOCK_STATE);
        @Nullable
        private BlockRenderState blockRenderState;

        public BlockDisplay(EntityType<?> p_271022_, Level p_270442_) {
            super(p_271022_, p_270442_);
        }

        @Override
        protected void defineSynchedData(SynchedEntityData.Builder p_326452_) {
            super.defineSynchedData(p_326452_);
            p_326452_.define(DATA_BLOCK_STATE_ID, Blocks.AIR.defaultBlockState());
        }

        @Override
        public void onSyncedDataUpdated(EntityDataAccessor<?> p_277476_) {
            super.onSyncedDataUpdated(p_277476_);
            if (p_277476_.equals(DATA_BLOCK_STATE_ID)) {
                this.updateRenderState = true;
            }
        }

        private BlockState getBlockState() {
            return this.entityData.get(DATA_BLOCK_STATE_ID);
        }

        private void setBlockState(BlockState p_270267_) {
            this.entityData.set(DATA_BLOCK_STATE_ID, p_270267_);
        }

        @Override
        protected void readAdditionalSaveData(CompoundTag p_270139_) {
            super.readAdditionalSaveData(p_270139_);
            this.setBlockState(NbtUtils.readBlockState(this.level().holderLookup(Registries.BLOCK), p_270139_.getCompound(TAG_BLOCK_STATE)));
        }

        @Override
        protected void addAdditionalSaveData(CompoundTag p_270469_) {
            super.addAdditionalSaveData(p_270469_);
            p_270469_.put(TAG_BLOCK_STATE, NbtUtils.writeBlockState(this.getBlockState()));
        }

        @Nullable
        public BlockRenderState blockRenderState() {
            return this.blockRenderState;
        }

        @Override
        protected void updateRenderSubState(boolean p_277802_, float p_277688_) {
            this.blockRenderState = new BlockRenderState(this.getBlockState());
        }

        public record BlockRenderState(BlockState blockState) {
        }
    }

    public static class ItemDisplay
    extends Display {
        private static final String TAG_ITEM = "item";
        private static final String TAG_ITEM_DISPLAY = "item_display";
        private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK_ID = SynchedEntityData.defineId(ItemDisplay.class, EntityDataSerializers.ITEM_STACK);
        private static final EntityDataAccessor<Byte> DATA_ITEM_DISPLAY_ID = SynchedEntityData.defineId(ItemDisplay.class, EntityDataSerializers.BYTE);
        private final SlotAccess slot = SlotAccess.of(this::getItemStack, this::setItemStack);
        @Nullable
        private ItemRenderState itemRenderState;

        public ItemDisplay(EntityType<?> p_270104_, Level p_270735_) {
            super(p_270104_, p_270735_);
        }

        @Override
        protected void defineSynchedData(SynchedEntityData.Builder p_325946_) {
            super.defineSynchedData(p_325946_);
            p_325946_.define(DATA_ITEM_STACK_ID, ItemStack.EMPTY);
            p_325946_.define(DATA_ITEM_DISPLAY_ID, ItemDisplayContext.NONE.getId());
        }

        @Override
        public void onSyncedDataUpdated(EntityDataAccessor<?> p_277793_) {
            super.onSyncedDataUpdated(p_277793_);
            if (DATA_ITEM_STACK_ID.equals(p_277793_) || DATA_ITEM_DISPLAY_ID.equals(p_277793_)) {
                this.updateRenderState = true;
            }
        }

        private ItemStack getItemStack() {
            return this.entityData.get(DATA_ITEM_STACK_ID);
        }

        private void setItemStack(ItemStack p_270310_) {
            this.entityData.set(DATA_ITEM_STACK_ID, p_270310_);
        }

        private void setItemTransform(ItemDisplayContext p_270370_) {
            this.entityData.set(DATA_ITEM_DISPLAY_ID, p_270370_.getId());
        }

        private ItemDisplayContext getItemTransform() {
            return ItemDisplayContext.BY_ID.apply(this.entityData.get(DATA_ITEM_DISPLAY_ID).byteValue());
        }

        @Override
        protected void readAdditionalSaveData(CompoundTag p_270713_) {
            super.readAdditionalSaveData(p_270713_);
            if (p_270713_.contains(TAG_ITEM)) {
                this.setItemStack(ItemStack.parse(this.registryAccess(), p_270713_.getCompound(TAG_ITEM)).orElse(ItemStack.EMPTY));
            } else {
                this.setItemStack(ItemStack.EMPTY);
            }
            if (p_270713_.contains(TAG_ITEM_DISPLAY, 8)) {
                ItemDisplayContext.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)p_270713_.get(TAG_ITEM_DISPLAY)).resultOrPartial(Util.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(p_270456_ -> this.setItemTransform((ItemDisplayContext)p_270456_.getFirst()));
            }
        }

        @Override
        protected void addAdditionalSaveData(CompoundTag p_270669_) {
            super.addAdditionalSaveData(p_270669_);
            if (!this.getItemStack().isEmpty()) {
                p_270669_.put(TAG_ITEM, this.getItemStack().save(this.registryAccess()));
            }
            ItemDisplayContext.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getItemTransform()).ifSuccess(p_270615_ -> p_270669_.put(TAG_ITEM_DISPLAY, (Tag)p_270615_));
        }

        @Override
        public SlotAccess getSlot(int p_270599_) {
            if (p_270599_ == 0) {
                return this.slot;
            }
            return SlotAccess.NULL;
        }

        @Nullable
        public ItemRenderState itemRenderState() {
            return this.itemRenderState;
        }

        @Override
        protected void updateRenderSubState(boolean p_277976_, float p_277708_) {
            ItemStack $$2 = this.getItemStack();
            $$2.setEntityRepresentation(this);
            this.itemRenderState = new ItemRenderState($$2, this.getItemTransform());
        }

        public record ItemRenderState(ItemStack itemStack, ItemDisplayContext itemTransform) {
        }
    }
}

