/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public class Interaction
extends Entity
implements Attackable,
Targeting {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Float> DATA_WIDTH_ID = SynchedEntityData.defineId(Interaction.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_HEIGHT_ID = SynchedEntityData.defineId(Interaction.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> DATA_RESPONSE_ID = SynchedEntityData.defineId(Interaction.class, EntityDataSerializers.BOOLEAN);
    private static final String TAG_WIDTH = "width";
    private static final String TAG_HEIGHT = "height";
    private static final String TAG_ATTACK = "attack";
    private static final String TAG_INTERACTION = "interaction";
    private static final String TAG_RESPONSE = "response";
    @Nullable
    private PlayerAction attack;
    @Nullable
    private PlayerAction interaction;

    public Interaction(EntityType<?> p_273319_, Level p_272713_) {
        super(p_273319_, p_272713_);
        this.noPhysics = true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326193_) {
        p_326193_.define(DATA_WIDTH_ID, Float.valueOf(1.0f));
        p_326193_.define(DATA_HEIGHT_ID, Float.valueOf(1.0f));
        p_326193_.define(DATA_RESPONSE_ID, false);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag p_272702_) {
        if (p_272702_.contains(TAG_WIDTH, 99)) {
            this.setWidth(p_272702_.getFloat(TAG_WIDTH));
        }
        if (p_272702_.contains(TAG_HEIGHT, 99)) {
            this.setHeight(p_272702_.getFloat(TAG_HEIGHT));
        }
        if (p_272702_.contains(TAG_ATTACK)) {
            PlayerAction.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)p_272702_.get(TAG_ATTACK)).resultOrPartial(Util.prefix("Interaction entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(p_273699_ -> {
                this.attack = (PlayerAction)p_273699_.getFirst();
            });
        } else {
            this.attack = null;
        }
        if (p_272702_.contains(TAG_INTERACTION)) {
            PlayerAction.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)p_272702_.get(TAG_INTERACTION)).resultOrPartial(Util.prefix("Interaction entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(p_273686_ -> {
                this.interaction = (PlayerAction)p_273686_.getFirst();
            });
        } else {
            this.interaction = null;
        }
        this.setResponse(p_272702_.getBoolean(TAG_RESPONSE));
        this.setBoundingBox(this.makeBoundingBox());
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag p_273772_) {
        p_273772_.putFloat(TAG_WIDTH, this.getWidth());
        p_273772_.putFloat(TAG_HEIGHT, this.getHeight());
        if (this.attack != null) {
            PlayerAction.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.attack).ifSuccess(p_272806_ -> p_273772_.put(TAG_ATTACK, (Tag)p_272806_));
        }
        if (this.interaction != null) {
            PlayerAction.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.interaction).ifSuccess(p_272925_ -> p_273772_.put(TAG_INTERACTION, (Tag)p_272925_));
        }
        p_273772_.putBoolean(TAG_RESPONSE, this.getResponse());
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_272722_) {
        super.onSyncedDataUpdated(p_272722_);
        if (DATA_HEIGHT_ID.equals(p_272722_) || DATA_WIDTH_ID.equals(p_272722_)) {
            this.refreshDimensions();
        }
    }

    @Override
    public boolean canBeHitByProjectile() {
        return false;
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Override
    public boolean skipAttackInteraction(Entity p_273553_) {
        if (p_273553_ instanceof Player) {
            Player $$1 = (Player)p_273553_;
            this.attack = new PlayerAction($$1.getUUID(), this.level().getGameTime());
            if ($$1 instanceof ServerPlayer) {
                ServerPlayer $$2 = (ServerPlayer)$$1;
                CriteriaTriggers.PLAYER_HURT_ENTITY.trigger($$2, this, $$1.damageSources().generic(), 1.0f, 1.0f, false);
            }
            return !this.getResponse();
        }
        return false;
    }

    @Override
    public final boolean hurtServer(ServerLevel p_376324_, DamageSource p_376830_, float p_376086_) {
        return false;
    }

    @Override
    public InteractionResult interact(Player p_273507_, InteractionHand p_273048_) {
        if (this.level().isClientSide) {
            return this.getResponse() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        this.interaction = new PlayerAction(p_273507_.getUUID(), this.level().getGameTime());
        return InteractionResult.CONSUME;
    }

    @Override
    public void tick() {
    }

    @Override
    @Nullable
    public LivingEntity getLastAttacker() {
        if (this.attack != null) {
            return this.level().getPlayerByUUID(this.attack.player());
        }
        return null;
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        if (this.interaction != null) {
            return this.level().getPlayerByUUID(this.interaction.player());
        }
        return null;
    }

    private void setWidth(float p_273385_) {
        this.entityData.set(DATA_WIDTH_ID, Float.valueOf(p_273385_));
    }

    private float getWidth() {
        return this.entityData.get(DATA_WIDTH_ID).floatValue();
    }

    private void setHeight(float p_273733_) {
        this.entityData.set(DATA_HEIGHT_ID, Float.valueOf(p_273733_));
    }

    private float getHeight() {
        return this.entityData.get(DATA_HEIGHT_ID).floatValue();
    }

    private void setResponse(boolean p_273657_) {
        this.entityData.set(DATA_RESPONSE_ID, p_273657_);
    }

    private boolean getResponse() {
        return this.entityData.get(DATA_RESPONSE_ID);
    }

    private EntityDimensions getDimensions() {
        return EntityDimensions.scalable(this.getWidth(), this.getHeight());
    }

    @Override
    public EntityDimensions getDimensions(Pose p_273111_) {
        return this.getDimensions();
    }

    @Override
    protected AABB makeBoundingBox() {
        return this.getDimensions().makeBoundingBox(this.position());
    }

    record PlayerAction(UUID player, long timestamp) {
        public static final Codec<PlayerAction> CODEC = RecordCodecBuilder.create(p_273237_ -> p_273237_.group((App)UUIDUtil.CODEC.fieldOf("player").forGetter(PlayerAction::player), (App)Codec.LONG.fieldOf("timestamp").forGetter(PlayerAction::timestamp)).apply((Applicative)p_273237_, PlayerAction::new));
    }
}

