/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public interface Leashable {
    public static final String LEASH_TAG = "leash";
    public static final double LEASH_TOO_FAR_DIST = 10.0;
    public static final double LEASH_ELASTIC_DIST = 6.0;

    @Nullable
    public LeashData getLeashData();

    public void setLeashData(@Nullable LeashData var1);

    default public boolean isLeashed() {
        return this.getLeashData() != null && this.getLeashData().leashHolder != null;
    }

    default public boolean mayBeLeashed() {
        return this.getLeashData() != null;
    }

    default public boolean canHaveALeashAttachedToIt() {
        return this.canBeLeashed() && !this.isLeashed();
    }

    default public boolean canBeLeashed() {
        return true;
    }

    default public void setDelayedLeashHolderId(int p_352387_) {
        this.setLeashData(new LeashData(p_352387_));
        Leashable.dropLeash((Entity)((Object)this), false, false);
    }

    @Nullable
    default public LeashData readLeashData(CompoundTag p_352410_) {
        Either $$1;
        if (p_352410_.contains(LEASH_TAG, 10)) {
            return new LeashData((Either<UUID, BlockPos>)Either.left((Object)p_352410_.getCompound(LEASH_TAG).getUUID("UUID")));
        }
        if (p_352410_.contains(LEASH_TAG, 11) && ($$1 = (Either)NbtUtils.readBlockPos(p_352410_, LEASH_TAG).map(Either::right).orElse(null)) != null) {
            return new LeashData((Either<UUID, BlockPos>)$$1);
        }
        return null;
    }

    default public void writeLeashData(CompoundTag p_352349_, @Nullable LeashData p_352363_) {
        if (p_352363_ == null) {
            return;
        }
        Either $$2 = p_352363_.delayedLeashInfo;
        Entity entity = p_352363_.leashHolder;
        if (entity instanceof LeashFenceKnotEntity) {
            LeashFenceKnotEntity $$3 = (LeashFenceKnotEntity)entity;
            $$2 = Either.right((Object)$$3.getPos());
        } else if (p_352363_.leashHolder != null) {
            $$2 = Either.left((Object)p_352363_.leashHolder.getUUID());
        }
        if ($$2 == null) {
            return;
        }
        p_352349_.put(LEASH_TAG, (Tag)$$2.map(p_352326_ -> {
            CompoundTag $$1 = new CompoundTag();
            $$1.putUUID("UUID", (UUID)p_352326_);
            return $$1;
        }, NbtUtils::writeBlockPos));
    }

    private static <E extends Entity> void restoreLeashFromSave(E p_352354_, LeashData p_352106_) {
        Level level;
        if (p_352106_.delayedLeashInfo != null && (level = p_352354_.level()) instanceof ServerLevel) {
            ServerLevel $$2 = (ServerLevel)level;
            Optional $$3 = p_352106_.delayedLeashInfo.left();
            Optional $$4 = p_352106_.delayedLeashInfo.right();
            if ($$3.isPresent()) {
                Entity $$5 = $$2.getEntity((UUID)$$3.get());
                if ($$5 != null) {
                    Leashable.setLeashedTo(p_352354_, $$5, true);
                    return;
                }
            } else if ($$4.isPresent()) {
                Leashable.setLeashedTo(p_352354_, LeashFenceKnotEntity.getOrCreateKnot($$2, (BlockPos)$$4.get()), true);
                return;
            }
            if (p_352354_.tickCount > 100) {
                p_352354_.spawnAtLocation($$2, Items.LEAD);
                ((Leashable)((Object)p_352354_)).setLeashData(null);
            }
        }
    }

    default public void dropLeash(boolean p_352294_, boolean p_352456_) {
        Leashable.dropLeash((Entity)((Object)this), p_352294_, p_352456_);
    }

    private static <E extends Entity> void dropLeash(E p_352163_, boolean p_352286_, boolean p_352272_) {
        LeashData $$3 = ((Leashable)((Object)p_352163_)).getLeashData();
        if ($$3 != null && $$3.leashHolder != null) {
            ((Leashable)((Object)p_352163_)).setLeashData(null);
            Level level = p_352163_.level();
            if (level instanceof ServerLevel) {
                ServerLevel $$4 = (ServerLevel)level;
                if (p_352272_) {
                    p_352163_.spawnAtLocation($$4, Items.LEAD);
                }
                if (p_352286_) {
                    $$4.getChunkSource().broadcast(p_352163_, new ClientboundSetEntityLinkPacket(p_352163_, null));
                }
            }
        }
    }

    public static <E extends Entity> void tickLeash(ServerLevel p_376374_, E p_352082_) {
        Entity $$3;
        LeashData $$2 = ((Leashable)((Object)p_352082_)).getLeashData();
        if ($$2 != null && $$2.delayedLeashInfo != null) {
            Leashable.restoreLeashFromSave(p_352082_, $$2);
        }
        if ($$2 == null || $$2.leashHolder == null) {
            return;
        }
        if (!p_352082_.isAlive() || !$$2.leashHolder.isAlive()) {
            Leashable.dropLeash(p_352082_, true, p_376374_.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS));
        }
        if (($$3 = ((Leashable)((Object)p_352082_)).getLeashHolder()) != null && $$3.level() == p_352082_.level()) {
            float $$4 = p_352082_.distanceTo($$3);
            if (!((Leashable)((Object)p_352082_)).handleLeashAtDistance($$3, $$4)) {
                return;
            }
            if ((double)$$4 > 10.0) {
                ((Leashable)((Object)p_352082_)).leashTooFarBehaviour();
            } else if ((double)$$4 > 6.0) {
                ((Leashable)((Object)p_352082_)).elasticRangeLeashBehaviour($$3, $$4);
                p_352082_.checkSlowFallDistance();
            } else {
                ((Leashable)((Object)p_352082_)).closeRangeLeashBehaviour($$3);
            }
        }
    }

    default public boolean handleLeashAtDistance(Entity p_352458_, float p_352101_) {
        return true;
    }

    default public void leashTooFarBehaviour() {
        this.dropLeash(true, true);
    }

    default public void closeRangeLeashBehaviour(Entity p_352073_) {
    }

    default public void elasticRangeLeashBehaviour(Entity p_353036_, float p_353047_) {
        Leashable.legacyElasticRangeLeashBehaviour((Entity)((Object)this), p_353036_, p_353047_);
    }

    private static <E extends Entity> void legacyElasticRangeLeashBehaviour(E p_353048_, Entity p_353039_, float p_353053_) {
        double $$3 = (p_353039_.getX() - p_353048_.getX()) / (double)p_353053_;
        double $$4 = (p_353039_.getY() - p_353048_.getY()) / (double)p_353053_;
        double $$5 = (p_353039_.getZ() - p_353048_.getZ()) / (double)p_353053_;
        p_353048_.setDeltaMovement(p_353048_.getDeltaMovement().add(Math.copySign($$3 * $$3 * 0.4, $$3), Math.copySign($$4 * $$4 * 0.4, $$4), Math.copySign($$5 * $$5 * 0.4, $$5)));
    }

    default public void setLeashedTo(Entity p_352411_, boolean p_352183_) {
        Leashable.setLeashedTo((Entity)((Object)this), p_352411_, p_352183_);
    }

    private static <E extends Entity> void setLeashedTo(E p_352280_, Entity p_352109_, boolean p_352239_) {
        Level level;
        LeashData $$3 = ((Leashable)((Object)p_352280_)).getLeashData();
        if ($$3 == null) {
            $$3 = new LeashData(p_352109_);
            ((Leashable)((Object)p_352280_)).setLeashData($$3);
        } else {
            $$3.setLeashHolder(p_352109_);
        }
        if (p_352239_ && (level = p_352280_.level()) instanceof ServerLevel) {
            ServerLevel $$4 = (ServerLevel)level;
            $$4.getChunkSource().broadcast(p_352280_, new ClientboundSetEntityLinkPacket(p_352280_, p_352109_));
        }
        if (p_352280_.isPassenger()) {
            p_352280_.stopRiding();
        }
    }

    @Nullable
    default public Entity getLeashHolder() {
        return Leashable.getLeashHolder((Entity)((Object)this));
    }

    @Nullable
    private static <E extends Entity> Entity getLeashHolder(E p_352466_) {
        Entity entity;
        LeashData $$1 = ((Leashable)((Object)p_352466_)).getLeashData();
        if ($$1 == null) {
            return null;
        }
        if ($$1.delayedLeashHolderId != 0 && p_352466_.level().isClientSide && (entity = p_352466_.level().getEntity($$1.delayedLeashHolderId)) instanceof Entity) {
            Entity $$2 = entity;
            $$1.setLeashHolder($$2);
        }
        return $$1.leashHolder;
    }

    public static final class LeashData {
        int delayedLeashHolderId;
        @Nullable
        public Entity leashHolder;
        @Nullable
        public Either<UUID, BlockPos> delayedLeashInfo;

        LeashData(Either<UUID, BlockPos> p_352282_) {
            this.delayedLeashInfo = p_352282_;
        }

        LeashData(Entity p_352066_) {
            this.leashHolder = p_352066_;
        }

        LeashData(int p_352297_) {
            this.delayedLeashHolderId = p_352297_;
        }

        public void setLeashHolder(Entity p_352464_) {
            this.leashHolder = p_352464_;
            this.delayedLeashInfo = null;
            this.delayedLeashHolderId = 0;
        }
    }
}

