/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;

public record PositionMoveRotation(Vec3 position, Vec3 deltaMovement, float yRot, float xRot) {
    public static final StreamCodec<FriendlyByteBuf, PositionMoveRotation> STREAM_CODEC = StreamCodec.composite(Vec3.STREAM_CODEC, PositionMoveRotation::position, Vec3.STREAM_CODEC, PositionMoveRotation::deltaMovement, ByteBufCodecs.FLOAT, PositionMoveRotation::yRot, ByteBufCodecs.FLOAT, PositionMoveRotation::xRot, PositionMoveRotation::new);

    public static PositionMoveRotation of(Entity p_371737_) {
        return new PositionMoveRotation(p_371737_.position(), p_371737_.getKnownMovement(), p_371737_.getYRot(), p_371737_.getXRot());
    }

    public static PositionMoveRotation ofEntityUsingLerpTarget(Entity p_379415_) {
        return new PositionMoveRotation(new Vec3(p_379415_.lerpTargetX(), p_379415_.lerpTargetY(), p_379415_.lerpTargetZ()), p_379415_.getKnownMovement(), p_379415_.getYRot(), p_379415_.getXRot());
    }

    public static PositionMoveRotation of(TeleportTransition p_379436_) {
        return new PositionMoveRotation(p_379436_.position(), p_379436_.deltaMovement(), p_379436_.yRot(), p_379436_.xRot());
    }

    public static PositionMoveRotation calculateAbsolute(PositionMoveRotation p_371265_, PositionMoveRotation p_371276_, Set<Relative> p_371779_) {
        double $$3 = p_371779_.contains((Object)Relative.X) ? p_371265_.position.x : 0.0;
        double $$4 = p_371779_.contains((Object)Relative.Y) ? p_371265_.position.y : 0.0;
        double $$5 = p_371779_.contains((Object)Relative.Z) ? p_371265_.position.z : 0.0;
        float $$6 = p_371779_.contains((Object)Relative.Y_ROT) ? p_371265_.yRot : 0.0f;
        float $$7 = p_371779_.contains((Object)Relative.X_ROT) ? p_371265_.xRot : 0.0f;
        Vec3 $$8 = new Vec3($$3 + p_371276_.position.x, $$4 + p_371276_.position.y, $$5 + p_371276_.position.z);
        float $$9 = $$6 + p_371276_.yRot;
        float $$10 = $$7 + p_371276_.xRot;
        Vec3 $$11 = p_371265_.deltaMovement;
        if (p_371779_.contains((Object)Relative.ROTATE_DELTA)) {
            float $$12 = p_371265_.yRot - $$9;
            float $$13 = p_371265_.xRot - $$10;
            $$11 = $$11.xRot((float)Math.toRadians($$13));
            $$11 = $$11.yRot((float)Math.toRadians($$12));
        }
        Vec3 $$14 = new Vec3(PositionMoveRotation.calculateDelta($$11.x, p_371276_.deltaMovement.x, p_371779_, Relative.DELTA_X), PositionMoveRotation.calculateDelta($$11.y, p_371276_.deltaMovement.y, p_371779_, Relative.DELTA_Y), PositionMoveRotation.calculateDelta($$11.z, p_371276_.deltaMovement.z, p_371779_, Relative.DELTA_Z));
        return new PositionMoveRotation($$8, $$14, $$9, $$10);
    }

    private static double calculateDelta(double p_371633_, double p_371363_, Set<Relative> p_371682_, Relative p_371585_) {
        return p_371682_.contains((Object)p_371585_) ? p_371633_ + p_371363_ : p_371363_;
    }
}

