/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.targeting;

import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class TargetingConditions {
    public static final TargetingConditions DEFAULT = TargetingConditions.forCombat();
    private static final double MIN_VISIBILITY_DISTANCE_FOR_INVISIBLE_TARGET = 2.0;
    private final boolean isCombat;
    private double range = -1.0;
    private boolean checkLineOfSight = true;
    private boolean testInvisible = true;
    @Nullable
    private Selector selector;

    private TargetingConditions(boolean p_148351_) {
        this.isCombat = p_148351_;
    }

    public static TargetingConditions forCombat() {
        return new TargetingConditions(true);
    }

    public static TargetingConditions forNonCombat() {
        return new TargetingConditions(false);
    }

    public TargetingConditions copy() {
        TargetingConditions $$0 = this.isCombat ? TargetingConditions.forCombat() : TargetingConditions.forNonCombat();
        $$0.range = this.range;
        $$0.checkLineOfSight = this.checkLineOfSight;
        $$0.testInvisible = this.testInvisible;
        $$0.selector = this.selector;
        return $$0;
    }

    public TargetingConditions range(double p_26884_) {
        this.range = p_26884_;
        return this;
    }

    public TargetingConditions ignoreLineOfSight() {
        this.checkLineOfSight = false;
        return this;
    }

    public TargetingConditions ignoreInvisibilityTesting() {
        this.testInvisible = false;
        return this;
    }

    public TargetingConditions selector(@Nullable Selector p_376314_) {
        this.selector = p_376314_;
        return this;
    }

    public boolean test(ServerLevel p_376690_, @Nullable LivingEntity p_26886_, LivingEntity p_26887_) {
        if (p_26886_ == p_26887_) {
            return false;
        }
        if (!p_26887_.canBeSeenByAnyone()) {
            return false;
        }
        if (this.selector != null && !this.selector.test(p_26887_, p_376690_)) {
            return false;
        }
        if (p_26886_ == null) {
            if (this.isCombat && (!p_26887_.canBeSeenAsEnemy() || p_376690_.getDifficulty() == Difficulty.PEACEFUL)) {
                return false;
            }
        } else {
            Mob $$6;
            if (this.isCombat && (!p_26886_.canAttack(p_26887_) || !p_26886_.canAttackType(p_26887_.getType()) || p_26886_.isAlliedTo(p_26887_))) {
                return false;
            }
            if (this.range > 0.0) {
                double $$3 = this.testInvisible ? p_26887_.getVisibilityPercent(p_26886_) : 1.0;
                double $$4 = Math.max(this.range * $$3, 2.0);
                double $$5 = p_26886_.distanceToSqr(p_26887_.getX(), p_26887_.getY(), p_26887_.getZ());
                if ($$5 > $$4 * $$4) {
                    return false;
                }
            }
            if (this.checkLineOfSight && p_26886_ instanceof Mob && !($$6 = (Mob)p_26886_).getSensing().hasLineOfSight(p_26887_)) {
                return false;
            }
        }
        return true;
    }

    @FunctionalInterface
    public static interface Selector {
        public boolean test(LivingEntity var1, ServerLevel var2);
    }
}

