/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ambient;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class Bat
extends AmbientCreature {
    public static final float FLAP_LENGTH_SECONDS = 0.5f;
    public static final float TICKS_PER_FLAP = 10.0f;
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.defineId(Bat.class, EntityDataSerializers.BYTE);
    private static final int FLAG_RESTING = 1;
    private static final TargetingConditions BAT_RESTING_TARGETING = TargetingConditions.forNonCombat().range(4.0);
    public final AnimationState flyAnimationState = new AnimationState();
    public final AnimationState restAnimationState = new AnimationState();
    @Nullable
    private BlockPos targetPosition;

    public Bat(EntityType<? extends Bat> p_27412_, Level p_27413_) {
        super((EntityType<? extends AmbientCreature>)p_27412_, p_27413_);
        if (!p_27413_.isClientSide) {
            this.setResting(true);
        }
    }

    @Override
    public boolean isFlapping() {
        return !this.isResting() && (float)this.tickCount % 10.0f == 0.0f;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326297_) {
        super.defineSynchedData(p_326297_);
        p_326297_.define(DATA_ID_FLAGS, (byte)0);
    }

    @Override
    protected float getSoundVolume() {
        return 0.1f;
    }

    @Override
    public float getVoicePitch() {
        return super.getVoicePitch() * 0.95f;
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound() {
        if (this.isResting() && this.random.nextInt(4) != 0) {
            return null;
        }
        return SoundEvents.BAT_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_27451_) {
        return SoundEvents.BAT_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.BAT_DEATH;
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    protected void doPush(Entity p_27415_) {
    }

    @Override
    protected void pushEntities() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0);
    }

    public boolean isResting() {
        return (this.entityData.get(DATA_ID_FLAGS) & 1) != 0;
    }

    public void setResting(boolean p_27457_) {
        byte $$1 = this.entityData.get(DATA_ID_FLAGS);
        if (p_27457_) {
            this.entityData.set(DATA_ID_FLAGS, (byte)($$1 | 1));
        } else {
            this.entityData.set(DATA_ID_FLAGS, (byte)($$1 & 0xFFFFFFFE));
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isResting()) {
            this.setDeltaMovement(Vec3.ZERO);
            this.setPosRaw(this.getX(), (double)Mth.floor(this.getY()) + 1.0 - (double)this.getBbHeight(), this.getZ());
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
        }
        this.setupAnimationStates();
    }

    @Override
    protected void customServerAiStep(ServerLevel p_376388_) {
        super.customServerAiStep(p_376388_);
        BlockPos $$1 = this.blockPosition();
        BlockPos $$2 = $$1.above();
        if (this.isResting()) {
            boolean $$3 = this.isSilent();
            if (p_376388_.getBlockState($$2).isRedstoneConductor(p_376388_, $$1)) {
                if (this.random.nextInt(200) == 0) {
                    this.yHeadRot = this.random.nextInt(360);
                }
                if (p_376388_.getNearestPlayer(BAT_RESTING_TARGETING, this) != null) {
                    this.setResting(false);
                    if (!$$3) {
                        p_376388_.levelEvent(null, 1025, $$1, 0);
                    }
                }
            } else {
                this.setResting(false);
                if (!$$3) {
                    p_376388_.levelEvent(null, 1025, $$1, 0);
                }
            }
        } else {
            if (!(this.targetPosition == null || p_376388_.isEmptyBlock(this.targetPosition) && this.targetPosition.getY() > p_376388_.getMinY())) {
                this.targetPosition = null;
            }
            if (this.targetPosition == null || this.random.nextInt(30) == 0 || this.targetPosition.closerToCenterThan(this.position(), 2.0)) {
                this.targetPosition = BlockPos.containing(this.getX() + (double)this.random.nextInt(7) - (double)this.random.nextInt(7), this.getY() + (double)this.random.nextInt(6) - 2.0, this.getZ() + (double)this.random.nextInt(7) - (double)this.random.nextInt(7));
            }
            double $$4 = (double)this.targetPosition.getX() + 0.5 - this.getX();
            double $$5 = (double)this.targetPosition.getY() + 0.1 - this.getY();
            double $$6 = (double)this.targetPosition.getZ() + 0.5 - this.getZ();
            Vec3 $$7 = this.getDeltaMovement();
            Vec3 $$8 = $$7.add((Math.signum($$4) * 0.5 - $$7.x) * (double)0.1f, (Math.signum($$5) * (double)0.7f - $$7.y) * (double)0.1f, (Math.signum($$6) * 0.5 - $$7.z) * (double)0.1f);
            this.setDeltaMovement($$8);
            float $$9 = (float)(Mth.atan2($$8.z, $$8.x) * 57.2957763671875) - 90.0f;
            float $$10 = Mth.wrapDegrees($$9 - this.getYRot());
            this.zza = 0.5f;
            this.setYRot(this.getYRot() + $$10);
            if (this.random.nextInt(100) == 0 && p_376388_.getBlockState($$2).isRedstoneConductor(p_376388_, $$2)) {
                this.setResting(true);
            }
        }
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void checkFallDamage(double p_27419_, boolean p_27420_, BlockState p_27421_, BlockPos p_27422_) {
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Override
    public boolean hurtServer(ServerLevel p_376275_, DamageSource p_376205_, float p_376647_) {
        if (this.isInvulnerableTo(p_376275_, p_376205_)) {
            return false;
        }
        if (this.isResting()) {
            this.setResting(false);
        }
        return super.hurtServer(p_376275_, p_376205_, p_376647_);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_27427_) {
        super.readAdditionalSaveData(p_27427_);
        this.entityData.set(DATA_ID_FLAGS, p_27427_.getByte("BatFlags"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_27443_) {
        super.addAdditionalSaveData(p_27443_);
        p_27443_.putByte("BatFlags", this.entityData.get(DATA_ID_FLAGS));
    }

    public static boolean checkBatSpawnRules(EntityType<Bat> p_218099_, LevelAccessor p_218100_, EntitySpawnReason p_362198_, BlockPos p_218102_, RandomSource p_218103_) {
        if (p_218102_.getY() >= p_218100_.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, p_218102_).getY()) {
            return false;
        }
        int $$5 = p_218100_.getMaxLocalRawBrightness(p_218102_);
        int $$6 = 4;
        if (Bat.isHalloween()) {
            $$6 = 7;
        } else if (p_218103_.nextBoolean()) {
            return false;
        }
        if ($$5 > p_218103_.nextInt($$6)) {
            return false;
        }
        if (!p_218100_.getBlockState(p_218102_.below()).is(BlockTags.BATS_SPAWNABLE_ON)) {
            return false;
        }
        return Bat.checkMobSpawnRules(p_218099_, p_218100_, p_362198_, p_218102_, p_218103_);
    }

    private static boolean isHalloween() {
        LocalDate $$0 = LocalDate.now();
        int $$1 = $$0.get(ChronoField.DAY_OF_MONTH);
        int $$2 = $$0.get(ChronoField.MONTH_OF_YEAR);
        return $$2 == 10 && $$1 >= 20 || $$2 == 11 && $$1 <= 3;
    }

    private void setupAnimationStates() {
        if (this.isResting()) {
            this.flyAnimationState.stop();
            this.restAnimationState.startIfStopped(this.tickCount);
        } else {
            this.restAnimationState.stop();
            this.flyAnimationState.startIfStopped(this.tickCount);
        }
    }
}

