/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public interface Bucketable {
    public boolean fromBucket();

    public void setFromBucket(boolean var1);

    public void saveToBucketTag(ItemStack var1);

    public void loadFromBucketTag(CompoundTag var1);

    public ItemStack getBucketItemStack();

    public SoundEvent getPickupSound();

    @Deprecated
    public static void saveDefaultDataToBucketTag(Mob p_148823_, ItemStack p_148824_) {
        p_148824_.set(DataComponents.CUSTOM_NAME, p_148823_.getCustomName());
        CustomData.update(DataComponents.BUCKET_ENTITY_DATA, p_148824_, p_331213_ -> {
            if (p_148823_.isNoAi()) {
                p_331213_.putBoolean("NoAI", p_148823_.isNoAi());
            }
            if (p_148823_.isSilent()) {
                p_331213_.putBoolean("Silent", p_148823_.isSilent());
            }
            if (p_148823_.isNoGravity()) {
                p_331213_.putBoolean("NoGravity", p_148823_.isNoGravity());
            }
            if (p_148823_.hasGlowingTag()) {
                p_331213_.putBoolean("Glowing", p_148823_.hasGlowingTag());
            }
            if (p_148823_.isInvulnerable()) {
                p_331213_.putBoolean("Invulnerable", p_148823_.isInvulnerable());
            }
            p_331213_.putFloat("Health", p_148823_.getHealth());
        });
    }

    @Deprecated
    public static void loadDefaultDataFromBucketTag(Mob p_148826_, CompoundTag p_148827_) {
        if (p_148827_.contains("NoAI")) {
            p_148826_.setNoAi(p_148827_.getBoolean("NoAI"));
        }
        if (p_148827_.contains("Silent")) {
            p_148826_.setSilent(p_148827_.getBoolean("Silent"));
        }
        if (p_148827_.contains("NoGravity")) {
            p_148826_.setNoGravity(p_148827_.getBoolean("NoGravity"));
        }
        if (p_148827_.contains("Glowing")) {
            p_148826_.setGlowingTag(p_148827_.getBoolean("Glowing"));
        }
        if (p_148827_.contains("Invulnerable")) {
            p_148826_.setInvulnerable(p_148827_.getBoolean("Invulnerable"));
        }
        if (p_148827_.contains("Health", 99)) {
            p_148826_.setHealth(p_148827_.getFloat("Health"));
        }
    }

    public static <T extends LivingEntity> Optional<InteractionResult> bucketMobPickup(Player p_148829_, InteractionHand p_148830_, T p_148831_) {
        ItemStack $$3 = p_148829_.getItemInHand(p_148830_);
        if ($$3.getItem() == Items.WATER_BUCKET && p_148831_.isAlive()) {
            p_148831_.playSound(((Bucketable)((Object)p_148831_)).getPickupSound(), 1.0f, 1.0f);
            ItemStack $$4 = ((Bucketable)((Object)p_148831_)).getBucketItemStack();
            ((Bucketable)((Object)p_148831_)).saveToBucketTag($$4);
            ItemStack $$5 = ItemUtils.createFilledResult($$3, p_148829_, $$4, false);
            p_148829_.setItemInHand(p_148830_, $$5);
            Level $$6 = p_148831_.level();
            if (!$$6.isClientSide) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)p_148829_, $$4);
            }
            p_148831_.discard();
            return Optional.of(InteractionResult.SUCCESS);
        }
        return Optional.empty();
    }
}

