/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.StrollThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class Fox
extends Animal
implements VariantHolder<Variant> {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.defineId(Fox.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(Fox.class, EntityDataSerializers.BYTE);
    private static final int FLAG_SITTING = 1;
    public static final int FLAG_CROUCHING = 4;
    public static final int FLAG_INTERESTED = 8;
    public static final int FLAG_POUNCING = 16;
    private static final int FLAG_SLEEPING = 32;
    private static final int FLAG_FACEPLANTED = 64;
    private static final int FLAG_DEFENDING = 128;
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_0 = SynchedEntityData.defineId(Fox.class, EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_1 = SynchedEntityData.defineId(Fox.class, EntityDataSerializers.OPTIONAL_UUID);
    static final Predicate<ItemEntity> ALLOWED_ITEMS = p_375802_ -> !p_375802_.hasPickUpDelay() && p_375802_.isAlive();
    private static final Predicate<Entity> TRUSTED_TARGET_SELECTOR = p_287481_ -> {
        if (p_287481_ instanceof LivingEntity) {
            LivingEntity $$1 = (LivingEntity)p_287481_;
            return $$1.getLastHurtMob() != null && $$1.getLastHurtMobTimestamp() < $$1.tickCount + 600;
        }
        return false;
    };
    static final Predicate<Entity> STALKABLE_PREY = p_28498_ -> p_28498_ instanceof Chicken || p_28498_ instanceof Rabbit;
    private static final Predicate<Entity> AVOID_PLAYERS = p_28463_ -> !p_28463_.isDiscrete() && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test((Entity)p_28463_);
    private static final int MIN_TICKS_BEFORE_EAT = 600;
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.FOX.getDimensions().scale(0.5f).withEyeHeight(0.2975f);
    private Goal landTargetGoal;
    private Goal turtleEggTargetGoal;
    private Goal fishTargetGoal;
    private float interestedAngle;
    private float interestedAngleO;
    float crouchAmount;
    float crouchAmountO;
    private int ticksSinceEaten;

    public Fox(EntityType<? extends Fox> p_28451_, Level p_28452_) {
        super((EntityType<? extends Animal>)p_28451_, p_28452_);
        this.lookControl = new FoxLookControl();
        this.moveControl = new FoxMoveControl();
        this.setPathfindingMalus(PathType.DANGER_OTHER, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, 0.0f);
        this.setCanPickUpLoot(true);
        this.getNavigation().setRequiredPathLength(32.0f);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326335_) {
        super.defineSynchedData(p_326335_);
        p_326335_.define(DATA_TRUSTED_ID_0, Optional.empty());
        p_326335_.define(DATA_TRUSTED_ID_1, Optional.empty());
        p_326335_.define(DATA_TYPE_ID, 0);
        p_326335_.define(DATA_FLAGS_ID, (byte)0);
    }

    @Override
    protected void registerGoals() {
        this.landTargetGoal = new NearestAttackableTargetGoal<Animal>(this, Animal.class, 10, false, false, (p_28604_, p_376681_) -> p_28604_ instanceof Chicken || p_28604_ instanceof Rabbit);
        this.turtleEggTargetGoal = new NearestAttackableTargetGoal<Turtle>(this, Turtle.class, 10, false, false, Turtle.BABY_ON_LAND_SELECTOR);
        this.fishTargetGoal = new NearestAttackableTargetGoal<AbstractFish>(this, AbstractFish.class, 20, false, false, (p_28600_, p_376887_) -> p_28600_ instanceof AbstractSchoolingFish);
        this.goalSelector.addGoal(0, new FoxFloatGoal());
        this.goalSelector.addGoal(0, new ClimbOnTopOfPowderSnowGoal(this, this.level()));
        this.goalSelector.addGoal(1, new FaceplantGoal());
        this.goalSelector.addGoal(2, new FoxPanicGoal(2.2));
        this.goalSelector.addGoal(3, new FoxBreedGoal(this, 1.0));
        this.goalSelector.addGoal(4, new AvoidEntityGoal<Player>(this, Player.class, 16.0f, 1.6, 1.4, p_375804_ -> AVOID_PLAYERS.test((Entity)p_375804_) && !this.trusts(p_375804_.getUUID()) && !this.isDefending()));
        this.goalSelector.addGoal(4, new AvoidEntityGoal<Wolf>(this, Wolf.class, 8.0f, 1.6, 1.4, p_379157_ -> !((Wolf)p_379157_).isTame() && !this.isDefending()));
        this.goalSelector.addGoal(4, new AvoidEntityGoal<PolarBear>(this, PolarBear.class, 8.0f, 1.6, 1.4, p_28585_ -> !this.isDefending()));
        this.goalSelector.addGoal(5, new StalkPreyGoal());
        this.goalSelector.addGoal(6, new FoxPounceGoal());
        this.goalSelector.addGoal(6, new SeekShelterGoal(1.25));
        this.goalSelector.addGoal(7, new FoxMeleeAttackGoal((double)1.2f, true));
        this.goalSelector.addGoal(7, new SleepGoal());
        this.goalSelector.addGoal(8, new FoxFollowParentGoal(this, this, 1.25));
        this.goalSelector.addGoal(9, new FoxStrollThroughVillageGoal(32, 200));
        this.goalSelector.addGoal(10, new FoxEatBerriesGoal((double)1.2f, 12, 1));
        this.goalSelector.addGoal(10, new LeapAtTargetGoal(this, 0.4f));
        this.goalSelector.addGoal(11, new WaterAvoidingRandomStrollGoal(this, 1.0));
        this.goalSelector.addGoal(11, new FoxSearchForItemsGoal());
        this.goalSelector.addGoal(12, new FoxLookAtPlayerGoal(this, Player.class, 24.0f));
        this.goalSelector.addGoal(13, new PerchAndSearchGoal());
        this.targetSelector.addGoal(3, new DefendTrustedTargetGoal(LivingEntity.class, false, false, (p_375800_, p_375801_) -> TRUSTED_TARGET_SELECTOR.test(p_375800_) && !this.trusts(p_375800_.getUUID())));
    }

    @Override
    public void aiStep() {
        if (!this.level().isClientSide && this.isAlive() && this.isEffectiveAi()) {
            LivingEntity $$2;
            ++this.ticksSinceEaten;
            ItemStack $$0 = this.getItemBySlot(EquipmentSlot.MAINHAND);
            if (this.canEat($$0)) {
                if (this.ticksSinceEaten > 600) {
                    ItemStack $$1 = $$0.finishUsingItem(this.level(), this);
                    if (!$$1.isEmpty()) {
                        this.setItemSlot(EquipmentSlot.MAINHAND, $$1);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.random.nextFloat() < 0.1f) {
                    this.playEatingSound();
                    this.level().broadcastEntityEvent(this, (byte)45);
                }
            }
            if (($$2 = this.getTarget()) == null || !$$2.isAlive()) {
                this.setIsCrouching(false);
                this.setIsInterested(false);
            }
        }
        if (this.isSleeping() || this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        }
        super.aiStep();
        if (this.isDefending() && this.random.nextFloat() < 0.05f) {
            this.playSound(SoundEvents.FOX_AGGRO, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean isImmobile() {
        return this.isDeadOrDying();
    }

    private boolean canEat(ItemStack p_28598_) {
        return p_28598_.has(DataComponents.FOOD) && this.getTarget() == null && this.onGround() && !this.isSleeping();
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource p_218171_, DifficultyInstance p_218172_) {
        if (p_218171_.nextFloat() < 0.2f) {
            ItemStack $$8;
            float $$2 = p_218171_.nextFloat();
            if ($$2 < 0.05f) {
                ItemStack $$3 = new ItemStack(Items.EMERALD);
            } else if ($$2 < 0.2f) {
                ItemStack $$4 = new ItemStack(Items.EGG);
            } else if ($$2 < 0.4f) {
                ItemStack $$5 = p_218171_.nextBoolean() ? new ItemStack(Items.RABBIT_FOOT) : new ItemStack(Items.RABBIT_HIDE);
            } else if ($$2 < 0.6f) {
                ItemStack $$6 = new ItemStack(Items.WHEAT);
            } else if ($$2 < 0.8f) {
                ItemStack $$7 = new ItemStack(Items.LEATHER);
            } else {
                $$8 = new ItemStack(Items.FEATHER);
            }
            this.setItemSlot(EquipmentSlot.MAINHAND, $$8);
        }
    }

    @Override
    public void handleEntityEvent(byte p_28456_) {
        if (p_28456_ == 45) {
            ItemStack $$1 = this.getItemBySlot(EquipmentSlot.MAINHAND);
            if (!$$1.isEmpty()) {
                for (int $$2 = 0; $$2 < 8; ++$$2) {
                    Vec3 $$3 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).xRot(-this.getXRot() * ((float)Math.PI / 180)).yRot(-this.getYRot() * ((float)Math.PI / 180));
                    this.level().addParticle(new ItemParticleOption(ParticleTypes.ITEM, $$1), this.getX() + this.getLookAngle().x / 2.0, this.getY(), this.getZ() + this.getLookAngle().z / 2.0, $$3.x, $$3.y + 0.05, $$3.z);
                }
            }
        } else {
            super.handleEntityEvent(p_28456_);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MOVEMENT_SPEED, 0.3f).add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.SAFE_FALL_DISTANCE, 5.0).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    @Override
    @Nullable
    public Fox getBreedOffspring(ServerLevel p_148912_, AgeableMob p_148913_) {
        Fox $$2 = EntityType.FOX.create(p_148912_, EntitySpawnReason.BREEDING);
        if ($$2 != null) {
            $$2.setVariant(this.random.nextBoolean() ? this.getVariant() : ((Fox)p_148913_).getVariant());
        }
        return $$2;
    }

    public static boolean checkFoxSpawnRules(EntityType<Fox> p_218176_, LevelAccessor p_218177_, EntitySpawnReason p_365199_, BlockPos p_218179_, RandomSource p_218180_) {
        return p_218177_.getBlockState(p_218179_.below()).is(BlockTags.FOXES_SPAWNABLE_ON) && Fox.isBrightEnoughToSpawn(p_218177_, p_218179_);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_28487_, DifficultyInstance p_28488_, EntitySpawnReason p_363726_, @Nullable SpawnGroupData p_28490_) {
        Holder<Biome> $$4 = p_28487_.getBiome(this.blockPosition());
        Variant $$5 = Variant.byBiome($$4);
        boolean $$6 = false;
        if (p_28490_ instanceof FoxGroupData) {
            FoxGroupData $$7 = (FoxGroupData)p_28490_;
            $$5 = $$7.variant;
            if ($$7.getGroupSize() >= 2) {
                $$6 = true;
            }
        } else {
            p_28490_ = new FoxGroupData($$5);
        }
        this.setVariant($$5);
        if ($$6) {
            this.setAge(-24000);
        }
        if (p_28487_ instanceof ServerLevel) {
            this.setTargetGoals();
        }
        this.populateDefaultEquipmentSlots(p_28487_.getRandom(), p_28488_);
        return super.finalizeSpawn(p_28487_, p_28488_, p_363726_, p_28490_);
    }

    private void setTargetGoals() {
        if (this.getVariant() == Variant.RED) {
            this.targetSelector.addGoal(4, this.landTargetGoal);
            this.targetSelector.addGoal(4, this.turtleEggTargetGoal);
            this.targetSelector.addGoal(6, this.fishTargetGoal);
        } else {
            this.targetSelector.addGoal(4, this.fishTargetGoal);
            this.targetSelector.addGoal(6, this.landTargetGoal);
            this.targetSelector.addGoal(6, this.turtleEggTargetGoal);
        }
    }

    @Override
    protected void playEatingSound() {
        this.playSound(SoundEvents.FOX_EAT, 1.0f, 1.0f);
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose p_316477_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_316477_);
    }

    @Override
    public Variant getVariant() {
        return Variant.byId(this.entityData.get(DATA_TYPE_ID));
    }

    @Override
    public void setVariant(Variant p_364650_) {
        this.entityData.set(DATA_TYPE_ID, p_364650_.getId());
    }

    List<UUID> getTrustedUUIDs() {
        Optional<UUID> $$0 = this.entityData.get(DATA_TRUSTED_ID_0);
        Optional<UUID> $$1 = this.entityData.get(DATA_TRUSTED_ID_1);
        if ($$0.isPresent() && $$1.isPresent()) {
            return List.of($$0.get(), $$1.get());
        }
        if ($$0.isPresent()) {
            return List.of($$0.get());
        }
        if ($$1.isPresent()) {
            return List.of($$1.get());
        }
        return List.of();
    }

    void addTrustedUUID(@Nullable UUID p_28516_) {
        if (this.entityData.get(DATA_TRUSTED_ID_0).isPresent()) {
            this.entityData.set(DATA_TRUSTED_ID_1, Optional.ofNullable(p_28516_));
        } else {
            this.entityData.set(DATA_TRUSTED_ID_0, Optional.ofNullable(p_28516_));
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_28518_) {
        super.addAdditionalSaveData(p_28518_);
        List<UUID> $$1 = this.getTrustedUUIDs();
        ListTag $$2 = new ListTag();
        for (UUID $$3 : $$1) {
            $$2.add(NbtUtils.createUUID($$3));
        }
        p_28518_.put("Trusted", $$2);
        p_28518_.putBoolean("Sleeping", this.isSleeping());
        p_28518_.putString("Type", this.getVariant().getSerializedName());
        p_28518_.putBoolean("Sitting", this.isSitting());
        p_28518_.putBoolean("Crouching", this.isCrouching());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_28493_) {
        super.readAdditionalSaveData(p_28493_);
        ListTag $$1 = p_28493_.getList("Trusted", 11);
        for (Tag $$2 : $$1) {
            this.addTrustedUUID(NbtUtils.loadUUID($$2));
        }
        this.setSleeping(p_28493_.getBoolean("Sleeping"));
        this.setVariant(Variant.byName(p_28493_.getString("Type")));
        this.setSitting(p_28493_.getBoolean("Sitting"));
        this.setIsCrouching(p_28493_.getBoolean("Crouching"));
        if (this.level() instanceof ServerLevel) {
            this.setTargetGoals();
        }
    }

    public boolean isSitting() {
        return this.getFlag(1);
    }

    public void setSitting(boolean p_28611_) {
        this.setFlag(1, p_28611_);
    }

    public boolean isFaceplanted() {
        return this.getFlag(64);
    }

    void setFaceplanted(boolean p_28619_) {
        this.setFlag(64, p_28619_);
    }

    boolean isDefending() {
        return this.getFlag(128);
    }

    void setDefending(boolean p_28623_) {
        this.setFlag(128, p_28623_);
    }

    @Override
    public boolean isSleeping() {
        return this.getFlag(32);
    }

    void setSleeping(boolean p_28627_) {
        this.setFlag(32, p_28627_);
    }

    private void setFlag(int p_28533_, boolean p_28534_) {
        if (p_28534_) {
            this.entityData.set(DATA_FLAGS_ID, (byte)(this.entityData.get(DATA_FLAGS_ID) | p_28533_));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (byte)(this.entityData.get(DATA_FLAGS_ID) & ~p_28533_));
        }
    }

    private boolean getFlag(int p_28609_) {
        return (this.entityData.get(DATA_FLAGS_ID) & p_28609_) != 0;
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EquipmentSlot p_371942_) {
        return p_371942_ == EquipmentSlot.MAINHAND && this.canPickUpLoot();
    }

    @Override
    public boolean canHoldItem(ItemStack p_28578_) {
        ItemStack $$1 = this.getItemBySlot(EquipmentSlot.MAINHAND);
        return $$1.isEmpty() || this.ticksSinceEaten > 0 && p_28578_.has(DataComponents.FOOD) && !$$1.has(DataComponents.FOOD);
    }

    private void spitOutItem(ItemStack p_28602_) {
        if (p_28602_.isEmpty() || this.level().isClientSide) {
            return;
        }
        ItemEntity $$1 = new ItemEntity(this.level(), this.getX() + this.getLookAngle().x, this.getY() + 1.0, this.getZ() + this.getLookAngle().z, p_28602_);
        $$1.setPickUpDelay(40);
        $$1.setThrower(this);
        this.playSound(SoundEvents.FOX_SPIT, 1.0f, 1.0f);
        this.level().addFreshEntity($$1);
    }

    private void dropItemStack(ItemStack p_28606_) {
        ItemEntity $$1 = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), p_28606_);
        this.level().addFreshEntity($$1);
    }

    @Override
    protected void pickUpItem(ServerLevel p_376527_, ItemEntity p_28514_) {
        ItemStack $$2 = p_28514_.getItem();
        if (this.canHoldItem($$2)) {
            int $$3 = $$2.getCount();
            if ($$3 > 1) {
                this.dropItemStack($$2.split($$3 - 1));
            }
            this.spitOutItem(this.getItemBySlot(EquipmentSlot.MAINHAND));
            this.onItemPickup(p_28514_);
            this.setItemSlot(EquipmentSlot.MAINHAND, $$2.split(1));
            this.setGuaranteedDrop(EquipmentSlot.MAINHAND);
            this.take(p_28514_, $$2.getCount());
            p_28514_.discard();
            this.ticksSinceEaten = 0;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isEffectiveAi()) {
            boolean $$0 = this.isInWater();
            if ($$0 || this.getTarget() != null || this.level().isThundering()) {
                this.wakeUp();
            }
            if ($$0 || this.isSleeping()) {
                this.setSitting(false);
            }
            if (this.isFaceplanted() && this.level().random.nextFloat() < 0.2f) {
                BlockPos $$1 = this.blockPosition();
                BlockState $$2 = this.level().getBlockState($$1);
                this.level().levelEvent(2001, $$1, Block.getId($$2));
            }
        }
        this.interestedAngleO = this.interestedAngle;
        this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
        this.crouchAmountO = this.crouchAmount;
        if (this.isCrouching()) {
            this.crouchAmount += 0.2f;
            if (this.crouchAmount > 3.0f) {
                this.crouchAmount = 3.0f;
            }
        } else {
            this.crouchAmount = 0.0f;
        }
    }

    @Override
    public boolean isFood(ItemStack p_28594_) {
        return p_28594_.is(ItemTags.FOX_FOOD);
    }

    @Override
    protected void onOffspringSpawnedFromEgg(Player p_28481_, Mob p_28482_) {
        ((Fox)p_28482_).addTrustedUUID(p_28481_.getUUID());
    }

    public boolean isPouncing() {
        return this.getFlag(16);
    }

    public void setIsPouncing(boolean p_28613_) {
        this.setFlag(16, p_28613_);
    }

    public boolean isJumping() {
        return this.jumping;
    }

    public boolean isFullyCrouched() {
        return this.crouchAmount == 3.0f;
    }

    public void setIsCrouching(boolean p_28615_) {
        this.setFlag(4, p_28615_);
    }

    @Override
    public boolean isCrouching() {
        return this.getFlag(4);
    }

    public void setIsInterested(boolean p_28617_) {
        this.setFlag(8, p_28617_);
    }

    public boolean isInterested() {
        return this.getFlag(8);
    }

    public float getHeadRollAngle(float p_28621_) {
        return Mth.lerp(p_28621_, this.interestedAngleO, this.interestedAngle) * 0.11f * (float)Math.PI;
    }

    public float getCrouchAmount(float p_28625_) {
        return Mth.lerp(p_28625_, this.crouchAmountO, this.crouchAmount);
    }

    @Override
    public void setTarget(@Nullable LivingEntity p_28574_) {
        if (this.isDefending() && p_28574_ == null) {
            this.setDefending(false);
        }
        super.setTarget(p_28574_);
    }

    void wakeUp() {
        this.setSleeping(false);
    }

    void clearStates() {
        this.setIsInterested(false);
        this.setIsCrouching(false);
        this.setSitting(false);
        this.setSleeping(false);
        this.setDefending(false);
        this.setFaceplanted(false);
    }

    boolean canMove() {
        return !this.isSleeping() && !this.isSitting() && !this.isFaceplanted();
    }

    @Override
    public void playAmbientSound() {
        SoundEvent $$0 = this.getAmbientSound();
        if ($$0 == SoundEvents.FOX_SCREECH) {
            this.playSound($$0, 2.0f, this.getVoicePitch());
        } else {
            super.playAmbientSound();
        }
    }

    @Override
    @Nullable
    protected SoundEvent getAmbientSound() {
        List<Entity> $$0;
        if (this.isSleeping()) {
            return SoundEvents.FOX_SLEEP;
        }
        if (!this.level().isDay() && this.random.nextFloat() < 0.1f && ($$0 = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(16.0, 16.0, 16.0), EntitySelector.NO_SPECTATORS)).isEmpty()) {
            return SoundEvents.FOX_SCREECH;
        }
        return SoundEvents.FOX_AMBIENT;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource p_28548_) {
        return SoundEvents.FOX_HURT;
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.FOX_DEATH;
    }

    boolean trusts(UUID p_28530_) {
        return this.getTrustedUUIDs().contains(p_28530_);
    }

    @Override
    protected void dropAllDeathLoot(ServerLevel p_348640_, DamageSource p_28536_) {
        ItemStack $$2 = this.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!$$2.isEmpty()) {
            this.spawnAtLocation(p_348640_, $$2);
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
        super.dropAllDeathLoot(p_348640_, p_28536_);
    }

    public static boolean isPathClear(Fox p_28472_, LivingEntity p_28473_) {
        double $$2 = p_28473_.getZ() - p_28472_.getZ();
        double $$3 = p_28473_.getX() - p_28472_.getX();
        double $$4 = $$2 / $$3;
        int $$5 = 6;
        for (int $$6 = 0; $$6 < 6; ++$$6) {
            double $$7 = $$4 == 0.0 ? 0.0 : $$2 * (double)((float)$$6 / 6.0f);
            double $$8 = $$4 == 0.0 ? $$3 * (double)((float)$$6 / 6.0f) : $$7 / $$4;
            for (int $$9 = 1; $$9 < 4; ++$$9) {
                if (p_28472_.level().getBlockState(BlockPos.containing(p_28472_.getX() + $$8, p_28472_.getY() + (double)$$9, p_28472_.getZ() + $$7)).canBeReplaced()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.55f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    @Override
    @Nullable
    public /* synthetic */ AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this.getBreedOffspring(serverLevel, ageableMob);
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    public class FoxLookControl
    extends LookControl {
        public FoxLookControl() {
            super(Fox.this);
        }

        @Override
        public void tick() {
            if (!Fox.this.isSleeping()) {
                super.tick();
            }
        }

        @Override
        protected boolean resetXRotOnTick() {
            return !Fox.this.isPouncing() && !Fox.this.isCrouching() && !Fox.this.isInterested() && !Fox.this.isFaceplanted();
        }
    }

    class FoxMoveControl
    extends MoveControl {
        public FoxMoveControl() {
            super(Fox.this);
        }

        @Override
        public void tick() {
            if (Fox.this.canMove()) {
                super.tick();
            }
        }
    }

    class FoxFloatGoal
    extends FloatGoal {
        public FoxFloatGoal() {
            super(Fox.this);
        }

        @Override
        public void start() {
            super.start();
            Fox.this.clearStates();
        }

        @Override
        public boolean canUse() {
            return Fox.this.isInWater() && Fox.this.getFluidHeight(FluidTags.WATER) > 0.25 || Fox.this.isInLava();
        }
    }

    class FaceplantGoal
    extends Goal {
        int countdown;

        public FaceplantGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        @Override
        public boolean canUse() {
            return Fox.this.isFaceplanted();
        }

        @Override
        public boolean canContinueToUse() {
            return this.canUse() && this.countdown > 0;
        }

        @Override
        public void start() {
            this.countdown = this.adjustedTickDelay(40);
        }

        @Override
        public void stop() {
            Fox.this.setFaceplanted(false);
        }

        @Override
        public void tick() {
            --this.countdown;
        }
    }

    class FoxPanicGoal
    extends PanicGoal {
        public FoxPanicGoal(double p_28734_) {
            super(Fox.this, p_28734_);
        }

        @Override
        public boolean shouldPanic() {
            return !Fox.this.isDefending() && super.shouldPanic();
        }
    }

    class FoxBreedGoal
    extends BreedGoal {
        public FoxBreedGoal(Fox fox, double p_28668_) {
            super(fox, p_28668_);
        }

        @Override
        public void start() {
            ((Fox)this.animal).clearStates();
            ((Fox)this.partner).clearStates();
            super.start();
        }

        @Override
        protected void breed() {
            ServerLevel $$0 = this.level;
            Fox $$1 = (Fox)this.animal.getBreedOffspring($$0, this.partner);
            if ($$1 == null) {
                return;
            }
            ServerPlayer $$2 = this.animal.getLoveCause();
            ServerPlayer $$3 = this.partner.getLoveCause();
            ServerPlayer $$4 = $$2;
            if ($$2 != null) {
                $$1.addTrustedUUID($$2.getUUID());
            } else {
                $$4 = $$3;
            }
            if ($$3 != null && $$2 != $$3) {
                $$1.addTrustedUUID($$3.getUUID());
            }
            if ($$4 != null) {
                $$4.awardStat(Stats.ANIMALS_BRED);
                CriteriaTriggers.BRED_ANIMALS.trigger($$4, this.animal, this.partner, $$1);
            }
            this.animal.setAge(6000);
            this.partner.setAge(6000);
            this.animal.resetLove();
            this.partner.resetLove();
            $$1.setAge(-24000);
            $$1.moveTo(this.animal.getX(), this.animal.getY(), this.animal.getZ(), 0.0f, 0.0f);
            $$0.addFreshEntityWithPassengers($$1);
            this.level.broadcastEntityEvent(this.animal, (byte)18);
            if ($$0.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                this.level.addFreshEntity(new ExperienceOrb(this.level, this.animal.getX(), this.animal.getY(), this.animal.getZ(), this.animal.getRandom().nextInt(7) + 1));
            }
        }
    }

    class StalkPreyGoal
    extends Goal {
        public StalkPreyGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean canUse() {
            if (Fox.this.isSleeping()) {
                return false;
            }
            LivingEntity $$0 = Fox.this.getTarget();
            return $$0 != null && $$0.isAlive() && STALKABLE_PREY.test($$0) && Fox.this.distanceToSqr($$0) > 36.0 && !Fox.this.isCrouching() && !Fox.this.isInterested() && !Fox.this.jumping;
        }

        @Override
        public void start() {
            Fox.this.setSitting(false);
            Fox.this.setFaceplanted(false);
        }

        @Override
        public void stop() {
            LivingEntity $$0 = Fox.this.getTarget();
            if ($$0 != null && Fox.isPathClear(Fox.this, $$0)) {
                Fox.this.setIsInterested(true);
                Fox.this.setIsCrouching(true);
                Fox.this.getNavigation().stop();
                Fox.this.getLookControl().setLookAt($$0, Fox.this.getMaxHeadYRot(), Fox.this.getMaxHeadXRot());
            } else {
                Fox.this.setIsInterested(false);
                Fox.this.setIsCrouching(false);
            }
        }

        @Override
        public void tick() {
            LivingEntity $$0 = Fox.this.getTarget();
            if ($$0 == null) {
                return;
            }
            Fox.this.getLookControl().setLookAt($$0, Fox.this.getMaxHeadYRot(), Fox.this.getMaxHeadXRot());
            if (Fox.this.distanceToSqr($$0) <= 36.0) {
                Fox.this.setIsInterested(true);
                Fox.this.setIsCrouching(true);
                Fox.this.getNavigation().stop();
            } else {
                Fox.this.getNavigation().moveTo($$0, 1.5);
            }
        }
    }

    public class FoxPounceGoal
    extends JumpGoal {
        @Override
        public boolean canUse() {
            if (!Fox.this.isFullyCrouched()) {
                return false;
            }
            LivingEntity $$0 = Fox.this.getTarget();
            if ($$0 == null || !$$0.isAlive()) {
                return false;
            }
            if ($$0.getMotionDirection() != $$0.getDirection()) {
                return false;
            }
            boolean $$1 = Fox.isPathClear(Fox.this, $$0);
            if (!$$1) {
                Fox.this.getNavigation().createPath($$0, 0);
                Fox.this.setIsCrouching(false);
                Fox.this.setIsInterested(false);
            }
            return $$1;
        }

        @Override
        public boolean canContinueToUse() {
            LivingEntity $$0 = Fox.this.getTarget();
            if ($$0 == null || !$$0.isAlive()) {
                return false;
            }
            double $$1 = Fox.this.getDeltaMovement().y;
            return !($$1 * $$1 < (double)0.05f && Math.abs(Fox.this.getXRot()) < 15.0f && Fox.this.onGround() || Fox.this.isFaceplanted());
        }

        @Override
        public boolean isInterruptable() {
            return false;
        }

        @Override
        public void start() {
            Fox.this.setJumping(true);
            Fox.this.setIsPouncing(true);
            Fox.this.setIsInterested(false);
            LivingEntity $$0 = Fox.this.getTarget();
            if ($$0 != null) {
                Fox.this.getLookControl().setLookAt($$0, 60.0f, 30.0f);
                Vec3 $$1 = new Vec3($$0.getX() - Fox.this.getX(), $$0.getY() - Fox.this.getY(), $$0.getZ() - Fox.this.getZ()).normalize();
                Fox.this.setDeltaMovement(Fox.this.getDeltaMovement().add($$1.x * 0.8, 0.9, $$1.z * 0.8));
            }
            Fox.this.getNavigation().stop();
        }

        @Override
        public void stop() {
            Fox.this.setIsCrouching(false);
            Fox.this.crouchAmount = 0.0f;
            Fox.this.crouchAmountO = 0.0f;
            Fox.this.setIsInterested(false);
            Fox.this.setIsPouncing(false);
        }

        @Override
        public void tick() {
            LivingEntity $$0 = Fox.this.getTarget();
            if ($$0 != null) {
                Fox.this.getLookControl().setLookAt($$0, 60.0f, 30.0f);
            }
            if (!Fox.this.isFaceplanted()) {
                Vec3 $$1 = Fox.this.getDeltaMovement();
                if ($$1.y * $$1.y < (double)0.03f && Fox.this.getXRot() != 0.0f) {
                    Fox.this.setXRot(Mth.rotLerp(0.2f, Fox.this.getXRot(), 0.0f));
                } else {
                    double $$2 = $$1.horizontalDistance();
                    double $$3 = Math.signum(-$$1.y) * Math.acos($$2 / $$1.length()) * 57.2957763671875;
                    Fox.this.setXRot((float)$$3);
                }
            }
            if ($$0 != null && Fox.this.distanceTo($$0) <= 2.0f) {
                Fox.this.doHurtTarget(FoxPounceGoal.getServerLevel(Fox.this.level()), $$0);
            } else if (Fox.this.getXRot() > 0.0f && Fox.this.onGround() && (float)Fox.this.getDeltaMovement().y != 0.0f && Fox.this.level().getBlockState(Fox.this.blockPosition()).is(Blocks.SNOW)) {
                Fox.this.setXRot(60.0f);
                Fox.this.setTarget(null);
                Fox.this.setFaceplanted(true);
            }
        }
    }

    class SeekShelterGoal
    extends FleeSunGoal {
        private int interval;

        public SeekShelterGoal(double p_28777_) {
            super(Fox.this, p_28777_);
            this.interval = SeekShelterGoal.reducedTickDelay(100);
        }

        @Override
        public boolean canUse() {
            if (Fox.this.isSleeping() || this.mob.getTarget() != null) {
                return false;
            }
            if (Fox.this.level().isThundering() && Fox.this.level().canSeeSky(this.mob.blockPosition())) {
                return this.setWantedPos();
            }
            if (this.interval > 0) {
                --this.interval;
                return false;
            }
            this.interval = 100;
            BlockPos $$0 = this.mob.blockPosition();
            return Fox.this.level().isDay() && Fox.this.level().canSeeSky($$0) && !((ServerLevel)Fox.this.level()).isVillage($$0) && this.setWantedPos();
        }

        @Override
        public void start() {
            Fox.this.clearStates();
            super.start();
        }
    }

    class FoxMeleeAttackGoal
    extends MeleeAttackGoal {
        public FoxMeleeAttackGoal(double p_28720_, boolean p_28721_) {
            super(Fox.this, p_28720_, p_28721_);
        }

        @Override
        protected void checkAndPerformAttack(LivingEntity p_28724_) {
            if (this.canPerformAttack(p_28724_)) {
                this.resetAttackCooldown();
                this.mob.doHurtTarget(FoxMeleeAttackGoal.getServerLevel(this.mob), p_28724_);
                Fox.this.playSound(SoundEvents.FOX_BITE, 1.0f, 1.0f);
            }
        }

        @Override
        public void start() {
            Fox.this.setIsInterested(false);
            super.start();
        }

        @Override
        public boolean canUse() {
            return !Fox.this.isSitting() && !Fox.this.isSleeping() && !Fox.this.isCrouching() && !Fox.this.isFaceplanted() && super.canUse();
        }
    }

    class SleepGoal
    extends FoxBehaviorGoal {
        private static final int WAIT_TIME_BEFORE_SLEEP = SleepGoal.reducedTickDelay(140);
        private int countdown;

        public SleepGoal() {
            this.countdown = Fox.this.random.nextInt(WAIT_TIME_BEFORE_SLEEP);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        public boolean canUse() {
            if (Fox.this.xxa != 0.0f || Fox.this.yya != 0.0f || Fox.this.zza != 0.0f) {
                return false;
            }
            return this.canSleep() || Fox.this.isSleeping();
        }

        @Override
        public boolean canContinueToUse() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return Fox.this.level().isDay() && this.hasShelter() && !this.alertable() && !Fox.this.isInPowderSnow;
        }

        @Override
        public void stop() {
            this.countdown = Fox.this.random.nextInt(WAIT_TIME_BEFORE_SLEEP);
            Fox.this.clearStates();
        }

        @Override
        public void start() {
            Fox.this.setSitting(false);
            Fox.this.setIsCrouching(false);
            Fox.this.setIsInterested(false);
            Fox.this.setJumping(false);
            Fox.this.setSleeping(true);
            Fox.this.getNavigation().stop();
            Fox.this.getMoveControl().setWantedPosition(Fox.this.getX(), Fox.this.getY(), Fox.this.getZ(), 0.0);
        }
    }

    class FoxFollowParentGoal
    extends FollowParentGoal {
        private final Fox fox;

        public FoxFollowParentGoal(Fox fox, Fox p_28696_, double p_28697_) {
            super(p_28696_, p_28697_);
            this.fox = p_28696_;
        }

        @Override
        public boolean canUse() {
            return !this.fox.isDefending() && super.canUse();
        }

        @Override
        public boolean canContinueToUse() {
            return !this.fox.isDefending() && super.canContinueToUse();
        }

        @Override
        public void start() {
            this.fox.clearStates();
            super.start();
        }
    }

    class FoxStrollThroughVillageGoal
    extends StrollThroughVillageGoal {
        public FoxStrollThroughVillageGoal(int p_28754_, int p_28755_) {
            super(Fox.this, p_28755_);
        }

        @Override
        public void start() {
            Fox.this.clearStates();
            super.start();
        }

        @Override
        public boolean canUse() {
            return super.canUse() && this.canFoxMove();
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.canFoxMove();
        }

        private boolean canFoxMove() {
            return !Fox.this.isSleeping() && !Fox.this.isSitting() && !Fox.this.isDefending() && Fox.this.getTarget() == null;
        }
    }

    public class FoxEatBerriesGoal
    extends MoveToBlockGoal {
        private static final int WAIT_TICKS = 40;
        protected int ticksWaited;

        public FoxEatBerriesGoal(double p_28675_, int p_28676_, int p_28677_) {
            super(Fox.this, p_28675_, p_28676_, p_28677_);
        }

        @Override
        public double acceptedDistance() {
            return 2.0;
        }

        @Override
        public boolean shouldRecalculatePath() {
            return this.tryTicks % 100 == 0;
        }

        @Override
        protected boolean isValidTarget(LevelReader p_28680_, BlockPos p_28681_) {
            BlockState $$2 = p_28680_.getBlockState(p_28681_);
            return $$2.is(Blocks.SWEET_BERRY_BUSH) && $$2.getValue(SweetBerryBushBlock.AGE) >= 2 || CaveVines.hasGlowBerries($$2);
        }

        @Override
        public void tick() {
            if (this.isReachedTarget()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            } else if (!this.isReachedTarget() && Fox.this.random.nextFloat() < 0.05f) {
                Fox.this.playSound(SoundEvents.FOX_SNIFF, 1.0f, 1.0f);
            }
            super.tick();
        }

        protected void onReachedTarget() {
            if (!FoxEatBerriesGoal.getServerLevel(Fox.this.level()).getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                return;
            }
            BlockState $$0 = Fox.this.level().getBlockState(this.blockPos);
            if ($$0.is(Blocks.SWEET_BERRY_BUSH)) {
                this.pickSweetBerries($$0);
            } else if (CaveVines.hasGlowBerries($$0)) {
                this.pickGlowBerry($$0);
            }
        }

        private void pickGlowBerry(BlockState p_148927_) {
            CaveVines.use(Fox.this, p_148927_, Fox.this.level(), this.blockPos);
        }

        private void pickSweetBerries(BlockState p_148929_) {
            int $$1 = p_148929_.getValue(SweetBerryBushBlock.AGE);
            p_148929_.setValue(SweetBerryBushBlock.AGE, 1);
            int $$2 = 1 + Fox.this.level().random.nextInt(2) + ($$1 == 3 ? 1 : 0);
            ItemStack $$3 = Fox.this.getItemBySlot(EquipmentSlot.MAINHAND);
            if ($$3.isEmpty()) {
                Fox.this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(Items.SWEET_BERRIES));
                --$$2;
            }
            if ($$2 > 0) {
                Block.popResource(Fox.this.level(), this.blockPos, new ItemStack(Items.SWEET_BERRIES, $$2));
            }
            Fox.this.playSound(SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, 1.0f, 1.0f);
            Fox.this.level().setBlock(this.blockPos, (BlockState)p_148929_.setValue(SweetBerryBushBlock.AGE, 1), 2);
            Fox.this.level().gameEvent(GameEvent.BLOCK_CHANGE, this.blockPos, GameEvent.Context.of(Fox.this));
        }

        @Override
        public boolean canUse() {
            return !Fox.this.isSleeping() && super.canUse();
        }

        @Override
        public void start() {
            this.ticksWaited = 0;
            Fox.this.setSitting(false);
            super.start();
        }
    }

    class FoxSearchForItemsGoal
    extends Goal {
        public FoxSearchForItemsGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canUse() {
            if (!Fox.this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
                return false;
            }
            if (Fox.this.getTarget() != null || Fox.this.getLastHurtByMob() != null) {
                return false;
            }
            if (!Fox.this.canMove()) {
                return false;
            }
            if (Fox.this.getRandom().nextInt(FoxSearchForItemsGoal.reducedTickDelay(10)) != 0) {
                return false;
            }
            List<ItemEntity> $$0 = Fox.this.level().getEntitiesOfClass(ItemEntity.class, Fox.this.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            return !$$0.isEmpty() && Fox.this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty();
        }

        @Override
        public void tick() {
            List<ItemEntity> $$0 = Fox.this.level().getEntitiesOfClass(ItemEntity.class, Fox.this.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            ItemStack $$1 = Fox.this.getItemBySlot(EquipmentSlot.MAINHAND);
            if ($$1.isEmpty() && !$$0.isEmpty()) {
                Fox.this.getNavigation().moveTo($$0.get(0), (double)1.2f);
            }
        }

        @Override
        public void start() {
            List<ItemEntity> $$0 = Fox.this.level().getEntitiesOfClass(ItemEntity.class, Fox.this.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!$$0.isEmpty()) {
                Fox.this.getNavigation().moveTo($$0.get(0), (double)1.2f);
            }
        }
    }

    class FoxLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public FoxLookAtPlayerGoal(Mob p_28707_, Class<? extends LivingEntity> p_28708_, float p_28709_) {
            super(p_28707_, p_28708_, p_28709_);
        }

        @Override
        public boolean canUse() {
            return super.canUse() && !Fox.this.isFaceplanted() && !Fox.this.isInterested();
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && !Fox.this.isFaceplanted() && !Fox.this.isInterested();
        }
    }

    class PerchAndSearchGoal
    extends FoxBehaviorGoal {
        private double relX;
        private double relZ;
        private int lookTime;
        private int looksRemaining;

        public PerchAndSearchGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean canUse() {
            return Fox.this.getLastHurtByMob() == null && Fox.this.getRandom().nextFloat() < 0.02f && !Fox.this.isSleeping() && Fox.this.getTarget() == null && Fox.this.getNavigation().isDone() && !this.alertable() && !Fox.this.isPouncing() && !Fox.this.isCrouching();
        }

        @Override
        public boolean canContinueToUse() {
            return this.looksRemaining > 0;
        }

        @Override
        public void start() {
            this.resetLook();
            this.looksRemaining = 2 + Fox.this.getRandom().nextInt(3);
            Fox.this.setSitting(true);
            Fox.this.getNavigation().stop();
        }

        @Override
        public void stop() {
            Fox.this.setSitting(false);
        }

        @Override
        public void tick() {
            --this.lookTime;
            if (this.lookTime <= 0) {
                --this.looksRemaining;
                this.resetLook();
            }
            Fox.this.getLookControl().setLookAt(Fox.this.getX() + this.relX, Fox.this.getEyeY(), Fox.this.getZ() + this.relZ, Fox.this.getMaxHeadYRot(), Fox.this.getMaxHeadXRot());
        }

        private void resetLook() {
            double $$0 = Math.PI * 2 * Fox.this.getRandom().nextDouble();
            this.relX = Math.cos($$0);
            this.relZ = Math.sin($$0);
            this.lookTime = this.adjustedTickDelay(80 + Fox.this.getRandom().nextInt(20));
        }
    }

    class DefendTrustedTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        @Nullable
        private LivingEntity trustedLastHurtBy;
        @Nullable
        private LivingEntity trustedLastHurt;
        private int timestamp;

        public DefendTrustedTargetGoal(Class<LivingEntity> p_28634_, boolean p_28635_, @Nullable boolean p_28636_, TargetingConditions.Selector p_376538_) {
            super(Fox.this, p_28634_, 10, p_28635_, p_28636_, p_376538_);
        }

        @Override
        public boolean canUse() {
            if (this.randomInterval > 0 && this.mob.getRandom().nextInt(this.randomInterval) != 0) {
                return false;
            }
            ServerLevel $$0 = DefendTrustedTargetGoal.getServerLevel(Fox.this.level());
            for (UUID $$1 : Fox.this.getTrustedUUIDs()) {
                LivingEntity $$3;
                Entity $$2 = $$0.getEntity($$1);
                if (!($$2 instanceof LivingEntity)) continue;
                this.trustedLastHurt = $$3 = (LivingEntity)$$2;
                this.trustedLastHurtBy = $$3.getLastHurtByMob();
                int $$4 = $$3.getLastHurtByMobTimestamp();
                return $$4 != this.timestamp && this.canAttack(this.trustedLastHurtBy, this.targetConditions);
            }
            return false;
        }

        @Override
        public void start() {
            this.setTarget(this.trustedLastHurtBy);
            this.target = this.trustedLastHurtBy;
            if (this.trustedLastHurt != null) {
                this.timestamp = this.trustedLastHurt.getLastHurtByMobTimestamp();
            }
            Fox.this.playSound(SoundEvents.FOX_AGGRO, 1.0f, 1.0f);
            Fox.this.setDefending(true);
            Fox.this.wakeUp();
            super.start();
        }
    }

    public static enum Variant implements StringRepresentable
    {
        RED(0, "red"),
        SNOW(1, "snow");

        public static final StringRepresentable.EnumCodec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        private final int id;
        private final String name;

        private Variant(int p_361355_, String p_362831_) {
            this.id = p_361355_;
            this.name = p_362831_;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byName(String p_363376_) {
            return CODEC.byName(p_363376_, RED);
        }

        public static Variant byId(int p_361087_) {
            return BY_ID.apply(p_361087_);
        }

        public static Variant byBiome(Holder<Biome> p_360860_) {
            return p_360860_.is(BiomeTags.SPAWNS_SNOW_FOXES) ? SNOW : RED;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Variant::values);
            BY_ID = ByIdMap.continuous(Variant::getId, Variant.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    public static class FoxGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Variant variant;

        public FoxGroupData(Variant p_360759_) {
            super(false);
            this.variant = p_360759_;
        }
    }

    abstract class FoxBehaviorGoal
    extends Goal {
        private final TargetingConditions alertableTargeting;

        FoxBehaviorGoal() {
            this.alertableTargeting = TargetingConditions.forCombat().range(12.0).ignoreLineOfSight().selector(new FoxAlertableEntitiesSelector());
        }

        protected boolean hasShelter() {
            BlockPos $$0 = BlockPos.containing(Fox.this.getX(), Fox.this.getBoundingBox().maxY, Fox.this.getZ());
            return !Fox.this.level().canSeeSky($$0) && Fox.this.getWalkTargetValue($$0) >= 0.0f;
        }

        protected boolean alertable() {
            return !FoxBehaviorGoal.getServerLevel(Fox.this.level()).getNearbyEntities(LivingEntity.class, this.alertableTargeting, Fox.this, Fox.this.getBoundingBox().inflate(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class FoxAlertableEntitiesSelector
    implements TargetingConditions.Selector {
        @Override
        public boolean test(LivingEntity p_28653_, ServerLevel p_376835_) {
            if (p_28653_ instanceof Fox) {
                return false;
            }
            if (p_28653_ instanceof Chicken || p_28653_ instanceof Rabbit || p_28653_ instanceof Monster) {
                return true;
            }
            if (p_28653_ instanceof TamableAnimal) {
                return !((TamableAnimal)p_28653_).isTame();
            }
            if (p_28653_ instanceof Player && (p_28653_.isSpectator() || ((Player)p_28653_).isCreative())) {
                return false;
            }
            if (Fox.this.trusts(p_28653_.getUUID())) {
                return false;
            }
            return !p_28653_.isSleeping() && !p_28653_.isDiscrete();
        }
    }
}

