/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class TropicalFish
extends AbstractSchoolingFish
implements VariantHolder<Pattern> {
    public static final String BUCKET_VARIANT_TAG = "BucketVariantTag";
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(TropicalFish.class, EntityDataSerializers.INT);
    public static final List<Variant> COMMON_VARIANTS = List.of(new Variant(Pattern.STRIPEY, DyeColor.ORANGE, DyeColor.GRAY), new Variant(Pattern.FLOPPER, DyeColor.GRAY, DyeColor.GRAY), new Variant(Pattern.FLOPPER, DyeColor.GRAY, DyeColor.BLUE), new Variant(Pattern.CLAYFISH, DyeColor.WHITE, DyeColor.GRAY), new Variant(Pattern.SUNSTREAK, DyeColor.BLUE, DyeColor.GRAY), new Variant(Pattern.KOB, DyeColor.ORANGE, DyeColor.WHITE), new Variant(Pattern.SPOTTY, DyeColor.PINK, DyeColor.LIGHT_BLUE), new Variant(Pattern.BLOCKFISH, DyeColor.PURPLE, DyeColor.YELLOW), new Variant(Pattern.CLAYFISH, DyeColor.WHITE, DyeColor.RED), new Variant(Pattern.SPOTTY, DyeColor.WHITE, DyeColor.YELLOW), new Variant(Pattern.GLITTER, DyeColor.WHITE, DyeColor.GRAY), new Variant(Pattern.CLAYFISH, DyeColor.WHITE, DyeColor.ORANGE), new Variant(Pattern.DASHER, DyeColor.CYAN, DyeColor.PINK), new Variant(Pattern.BRINELY, DyeColor.LIME, DyeColor.LIGHT_BLUE), new Variant(Pattern.BETTY, DyeColor.RED, DyeColor.WHITE), new Variant(Pattern.SNOOPER, DyeColor.GRAY, DyeColor.RED), new Variant(Pattern.BLOCKFISH, DyeColor.RED, DyeColor.WHITE), new Variant(Pattern.FLOPPER, DyeColor.WHITE, DyeColor.YELLOW), new Variant(Pattern.KOB, DyeColor.RED, DyeColor.WHITE), new Variant(Pattern.SUNSTREAK, DyeColor.GRAY, DyeColor.WHITE), new Variant(Pattern.DASHER, DyeColor.CYAN, DyeColor.YELLOW), new Variant(Pattern.FLOPPER, DyeColor.YELLOW, DyeColor.YELLOW));
    private boolean isSchool = true;

    public TropicalFish(EntityType<? extends TropicalFish> p_30015_, Level p_30016_) {
        super((EntityType<? extends AbstractSchoolingFish>)p_30015_, p_30016_);
    }

    public static String getPredefinedName(int p_30031_) {
        return "entity.minecraft.tropical_fish.predefined." + p_30031_;
    }

    static int packVariant(Pattern p_262598_, DyeColor p_262618_, DyeColor p_262683_) {
        return p_262598_.getPackedId() & 0xFFFF | (p_262618_.getId() & 0xFF) << 16 | (p_262683_.getId() & 0xFF) << 24;
    }

    public static DyeColor getBaseColor(int p_30051_) {
        return DyeColor.byId(p_30051_ >> 16 & 0xFF);
    }

    public static DyeColor getPatternColor(int p_30053_) {
        return DyeColor.byId(p_30053_ >> 24 & 0xFF);
    }

    public static Pattern getPattern(int p_262604_) {
        return Pattern.byId(p_262604_ & 0xFFFF);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326026_) {
        super.defineSynchedData(p_326026_);
        p_326026_.define(DATA_ID_TYPE_VARIANT, 0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_30033_) {
        super.addAdditionalSaveData(p_30033_);
        p_30033_.putInt("Variant", this.getPackedVariant());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_30029_) {
        super.readAdditionalSaveData(p_30029_);
        this.setPackedVariant(p_30029_.getInt("Variant"));
    }

    private void setPackedVariant(int p_30057_) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, p_30057_);
    }

    @Override
    public boolean isMaxGroupSizeReached(int p_30035_) {
        return !this.isSchool;
    }

    private int getPackedVariant() {
        return this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    public DyeColor getBaseColor() {
        return TropicalFish.getBaseColor(this.getPackedVariant());
    }

    public DyeColor getPatternColor() {
        return TropicalFish.getPatternColor(this.getPackedVariant());
    }

    @Override
    public Pattern getVariant() {
        return TropicalFish.getPattern(this.getPackedVariant());
    }

    @Override
    public void setVariant(Pattern p_262594_) {
        int $$1 = this.getPackedVariant();
        DyeColor $$2 = TropicalFish.getBaseColor($$1);
        DyeColor $$3 = TropicalFish.getPatternColor($$1);
        this.setPackedVariant(TropicalFish.packVariant(p_262594_, $$2, $$3));
    }

    @Override
    public void saveToBucketTag(ItemStack p_30049_) {
        super.saveToBucketTag(p_30049_);
        CustomData.update(DataComponents.BUCKET_ENTITY_DATA, p_30049_, p_331150_ -> p_331150_.putInt(BUCKET_VARIANT_TAG, this.getPackedVariant()));
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack(Items.TROPICAL_FISH_BUCKET);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.TROPICAL_FISH_AMBIENT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.TROPICAL_FISH_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_30039_) {
        return SoundEvents.TROPICAL_FISH_HURT;
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.TROPICAL_FISH_FLOP;
    }

    @Override
    public void loadFromBucketTag(CompoundTag p_323573_) {
        super.loadFromBucketTag(p_323573_);
        if (p_323573_.contains(BUCKET_VARIANT_TAG, 3)) {
            this.setPackedVariant(p_323573_.getInt(BUCKET_VARIANT_TAG));
        }
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_30023_, DifficultyInstance p_30024_, EntitySpawnReason p_362528_, @Nullable SpawnGroupData p_30026_) {
        Variant $$13;
        p_30026_ = super.finalizeSpawn(p_30023_, p_30024_, p_362528_, p_30026_);
        RandomSource $$4 = p_30023_.getRandom();
        if (p_30026_ instanceof TropicalFishGroupData) {
            TropicalFishGroupData $$5 = (TropicalFishGroupData)p_30026_;
            Variant $$6 = $$5.variant;
        } else if ((double)$$4.nextFloat() < 0.9) {
            Variant $$7 = Util.getRandom(COMMON_VARIANTS, $$4);
            p_30026_ = new TropicalFishGroupData(this, $$7);
        } else {
            this.isSchool = false;
            Pattern[] $$8 = Pattern.values();
            DyeColor[] $$9 = DyeColor.values();
            Pattern $$10 = Util.getRandom($$8, $$4);
            DyeColor $$11 = Util.getRandom($$9, $$4);
            DyeColor $$12 = Util.getRandom($$9, $$4);
            $$13 = new Variant($$10, $$11, $$12);
        }
        this.setPackedVariant($$13.getPackedId());
        return p_30026_;
    }

    public static boolean checkTropicalFishSpawnRules(EntityType<TropicalFish> p_218267_, LevelAccessor p_218268_, EntitySpawnReason p_362646_, BlockPos p_218270_, RandomSource p_218271_) {
        return p_218268_.getFluidState(p_218270_.below()).is(FluidTags.WATER) && p_218268_.getBlockState(p_218270_.above()).is(Blocks.WATER) && (p_218268_.getBiome(p_218270_).is(BiomeTags.ALLOWS_TROPICAL_FISH_SPAWNS_AT_ANY_HEIGHT) || WaterAnimal.checkSurfaceWaterAnimalSpawnRules(p_218267_, p_218268_, p_362646_, p_218270_, p_218271_));
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    public static enum Pattern implements StringRepresentable
    {
        KOB("kob", Base.SMALL, 0),
        SUNSTREAK("sunstreak", Base.SMALL, 1),
        SNOOPER("snooper", Base.SMALL, 2),
        DASHER("dasher", Base.SMALL, 3),
        BRINELY("brinely", Base.SMALL, 4),
        SPOTTY("spotty", Base.SMALL, 5),
        FLOPPER("flopper", Base.LARGE, 0),
        STRIPEY("stripey", Base.LARGE, 1),
        GLITTER("glitter", Base.LARGE, 2),
        BLOCKFISH("blockfish", Base.LARGE, 3),
        BETTY("betty", Base.LARGE, 4),
        CLAYFISH("clayfish", Base.LARGE, 5);

        public static final Codec<Pattern> CODEC;
        private static final IntFunction<Pattern> BY_ID;
        private final String name;
        private final Component displayName;
        private final Base base;
        private final int packedId;

        private Pattern(String p_262625_, Base p_262680_, int p_262584_) {
            this.name = p_262625_;
            this.base = p_262680_;
            this.packedId = p_262680_.id | p_262584_ << 8;
            this.displayName = Component.translatable("entity.minecraft.tropical_fish.type." + this.name);
        }

        public static Pattern byId(int p_262653_) {
            return BY_ID.apply(p_262653_);
        }

        public Base base() {
            return this.base;
        }

        public int getPackedId() {
            return this.packedId;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public Component displayName() {
            return this.displayName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Pattern::values);
            BY_ID = ByIdMap.sparse(Pattern::getPackedId, Pattern.values(), KOB);
        }
    }

    static class TropicalFishGroupData
    extends AbstractSchoolingFish.SchoolSpawnGroupData {
        final Variant variant;

        TropicalFishGroupData(TropicalFish p_262626_, Variant p_262579_) {
            super(p_262626_);
            this.variant = p_262579_;
        }
    }

    public record Variant(Pattern pattern, DyeColor baseColor, DyeColor patternColor) {
        public static final Codec<Variant> CODEC = Codec.INT.xmap(Variant::new, Variant::getPackedId);

        public Variant(int p_331552_) {
            this(TropicalFish.getPattern(p_331552_), TropicalFish.getBaseColor(p_331552_), TropicalFish.getPatternColor(p_331552_));
        }

        public int getPackedId() {
            return TropicalFish.packVariant(this.pattern, this.baseColor, this.patternColor);
        }
    }

    public static enum Base {
        SMALL(0),
        LARGE(1);

        final int id;

        private Base(int p_262648_) {
            this.id = p_262648_;
        }
    }
}

