/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class FallingBlockEntity
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private BlockState blockState = Blocks.SAND.defaultBlockState();
    public int time;
    public boolean dropItem = true;
    private boolean cancelDrop;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance;
    @Nullable
    public CompoundTag blockData;
    public boolean forceTickAfterTeleportToDuplicate;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.defineId(FallingBlockEntity.class, EntityDataSerializers.BLOCK_POS);

    public FallingBlockEntity(EntityType<? extends FallingBlockEntity> p_31950_, Level p_31951_) {
        super(p_31950_, p_31951_);
    }

    private FallingBlockEntity(Level p_31953_, double p_31954_, double p_31955_, double p_31956_, BlockState p_31957_) {
        this((EntityType<? extends FallingBlockEntity>)EntityType.FALLING_BLOCK, p_31953_);
        this.blockState = p_31957_;
        this.blocksBuilding = true;
        this.setPos(p_31954_, p_31955_, p_31956_);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = p_31954_;
        this.yo = p_31955_;
        this.zo = p_31956_;
        this.setStartPos(this.blockPosition());
    }

    public static FallingBlockEntity fall(Level p_201972_, BlockPos p_201973_, BlockState p_201974_) {
        FallingBlockEntity $$3 = new FallingBlockEntity(p_201972_, (double)p_201973_.getX() + 0.5, p_201973_.getY(), (double)p_201973_.getZ() + 0.5, p_201974_.hasProperty(BlockStateProperties.WATERLOGGED) ? (BlockState)p_201974_.setValue(BlockStateProperties.WATERLOGGED, false) : p_201974_);
        p_201972_.setBlock(p_201973_, p_201974_.getFluidState().createLegacyBlock(), 3);
        p_201972_.addFreshEntity($$3);
        return $$3;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    public final boolean hurtServer(ServerLevel p_376184_, DamageSource p_376594_, float p_376175_) {
        if (!this.isInvulnerableToBase(p_376594_)) {
            this.markHurt();
        }
        return false;
    }

    public void setStartPos(BlockPos p_31960_) {
        this.entityData.set(DATA_START_POS, p_31960_);
    }

    public BlockPos getStartPos() {
        return this.entityData.get(DATA_START_POS);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326465_) {
        p_326465_.define(DATA_START_POS, BlockPos.ZERO);
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    public void tick() {
        if (this.blockState.isAir()) {
            this.discard();
            return;
        }
        Block $$0 = this.blockState.getBlock();
        ++this.time;
        this.applyGravity();
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.applyEffectsFromBlocks();
        this.handlePortal();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$1 = (ServerLevel)level;
            if (this.isAlive() || this.forceTickAfterTeleportToDuplicate) {
                BlockHitResult $$6;
                BlockPos $$2 = this.blockPosition();
                boolean $$3 = this.blockState.getBlock() instanceof ConcretePowderBlock;
                boolean $$4 = $$3 && this.level().getFluidState($$2).is(FluidTags.WATER);
                double $$5 = this.getDeltaMovement().lengthSqr();
                if ($$3 && $$5 > 1.0 && ($$6 = this.level().clip(new ClipContext(new Vec3(this.xo, this.yo, this.zo), this.position(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, this))).getType() != HitResult.Type.MISS && this.level().getFluidState($$6.getBlockPos()).is(FluidTags.WATER)) {
                    $$2 = $$6.getBlockPos();
                    $$4 = true;
                }
                if (this.onGround() || $$4) {
                    BlockState $$7 = this.level().getBlockState($$2);
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
                    if (!$$7.is(Blocks.MOVING_PISTON)) {
                        if (!this.cancelDrop) {
                            boolean $$10;
                            boolean $$8 = $$7.canBeReplaced(new DirectionalPlaceContext(this.level(), $$2, Direction.DOWN, ItemStack.EMPTY, Direction.UP));
                            boolean $$9 = FallingBlock.isFree(this.level().getBlockState($$2.below())) && (!$$3 || !$$4);
                            boolean bl = $$10 = this.blockState.canSurvive(this.level(), $$2) && !$$9;
                            if ($$8 && $$10) {
                                if (this.blockState.hasProperty(BlockStateProperties.WATERLOGGED) && this.level().getFluidState($$2).getType() == Fluids.WATER) {
                                    this.blockState = (BlockState)this.blockState.setValue(BlockStateProperties.WATERLOGGED, true);
                                }
                                if (this.level().setBlock($$2, this.blockState, 3)) {
                                    BlockEntity $$11;
                                    ((ServerLevel)this.level()).getChunkSource().chunkMap.broadcast(this, new ClientboundBlockUpdatePacket($$2, this.level().getBlockState($$2)));
                                    this.discard();
                                    if ($$0 instanceof Fallable) {
                                        ((Fallable)((Object)$$0)).onLand(this.level(), $$2, this.blockState, $$7, this);
                                    }
                                    if (this.blockData != null && this.blockState.hasBlockEntity() && ($$11 = this.level().getBlockEntity($$2)) != null) {
                                        CompoundTag $$12 = $$11.saveWithoutMetadata(this.level().registryAccess());
                                        for (String $$13 : this.blockData.getAllKeys()) {
                                            $$12.put($$13, this.blockData.get($$13).copy());
                                        }
                                        try {
                                            $$11.loadWithComponents($$12, this.level().registryAccess());
                                        }
                                        catch (Exception $$14) {
                                            LOGGER.error("Failed to load block entity from falling block", (Throwable)$$14);
                                        }
                                        $$11.setChanged();
                                    }
                                } else if (this.dropItem && $$1.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                    this.discard();
                                    this.callOnBrokenAfterFall($$0, $$2);
                                    this.spawnAtLocation($$1, $$0);
                                }
                            } else {
                                this.discard();
                                if (this.dropItem && $$1.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                    this.callOnBrokenAfterFall($$0, $$2);
                                    this.spawnAtLocation($$1, $$0);
                                }
                            }
                        } else {
                            this.discard();
                            this.callOnBrokenAfterFall($$0, $$2);
                        }
                    }
                } else if (this.time > 100 && ($$2.getY() <= this.level().getMinY() || $$2.getY() > this.level().getMaxY()) || this.time > 600) {
                    if (this.dropItem && $$1.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                        this.spawnAtLocation($$1, $$0);
                    }
                    this.discard();
                }
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
    }

    public void callOnBrokenAfterFall(Block p_149651_, BlockPos p_149652_) {
        if (p_149651_ instanceof Fallable) {
            ((Fallable)((Object)p_149651_)).onBrokenAfterFall(this.level(), p_149652_, this);
        }
    }

    @Override
    public boolean causeFallDamage(float p_149643_, float p_149644_, DamageSource p_149645_) {
        DamageSource damageSource;
        if (!this.hurtEntities) {
            return false;
        }
        int $$3 = Mth.ceil(p_149643_ - 1.0f);
        if ($$3 < 0) {
            return false;
        }
        Predicate<Entity> $$4 = EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE);
        Block block = this.blockState.getBlock();
        if (block instanceof Fallable) {
            Fallable $$5 = (Fallable)((Object)block);
            damageSource = $$5.getFallDamageSource(this);
        } else {
            damageSource = this.damageSources().fallingBlock(this);
        }
        DamageSource $$6 = damageSource;
        float $$7 = Math.min(Mth.floor((float)$$3 * this.fallDamagePerDistance), this.fallDamageMax);
        this.level().getEntities(this, this.getBoundingBox(), $$4).forEach(p_375871_ -> p_375871_.hurt($$6, $$7));
        boolean $$8 = this.blockState.is(BlockTags.ANVIL);
        if ($$8 && $$7 > 0.0f && this.random.nextFloat() < 0.05f + (float)$$3 * 0.05f) {
            BlockState $$9 = AnvilBlock.damage(this.blockState);
            if ($$9 == null) {
                this.cancelDrop = true;
            } else {
                this.blockState = $$9;
            }
        }
        return false;
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag p_31973_) {
        p_31973_.put("BlockState", NbtUtils.writeBlockState(this.blockState));
        p_31973_.putInt("Time", this.time);
        p_31973_.putBoolean("DropItem", this.dropItem);
        p_31973_.putBoolean("HurtEntities", this.hurtEntities);
        p_31973_.putFloat("FallHurtAmount", this.fallDamagePerDistance);
        p_31973_.putInt("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            p_31973_.put("TileEntityData", this.blockData);
        }
        p_31973_.putBoolean("CancelDrop", this.cancelDrop);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag p_31964_) {
        this.blockState = NbtUtils.readBlockState(this.level().holderLookup(Registries.BLOCK), p_31964_.getCompound("BlockState"));
        this.time = p_31964_.getInt("Time");
        if (p_31964_.contains("HurtEntities", 99)) {
            this.hurtEntities = p_31964_.getBoolean("HurtEntities");
            this.fallDamagePerDistance = p_31964_.getFloat("FallHurtAmount");
            this.fallDamageMax = p_31964_.getInt("FallHurtMax");
        } else if (this.blockState.is(BlockTags.ANVIL)) {
            this.hurtEntities = true;
        }
        if (p_31964_.contains("DropItem", 99)) {
            this.dropItem = p_31964_.getBoolean("DropItem");
        }
        if (p_31964_.contains("TileEntityData", 10)) {
            this.blockData = p_31964_.getCompound("TileEntityData").copy();
        }
        this.cancelDrop = p_31964_.getBoolean("CancelDrop");
        if (this.blockState.isAir()) {
            this.blockState = Blocks.SAND.defaultBlockState();
        }
    }

    public void setHurtsEntities(float p_149657_, int p_149658_) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = p_149657_;
        this.fallDamageMax = p_149658_;
    }

    public void disableDrop() {
        this.cancelDrop = true;
    }

    @Override
    public boolean displayFireAnimation() {
        return false;
    }

    @Override
    public void fillCrashReportCategory(CrashReportCategory p_31962_) {
        super.fillCrashReportCategory(p_31962_);
        p_31962_.setDetail("Immitating BlockState", this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    @Override
    protected Component getTypeName() {
        return Component.translatable("entity.minecraft.falling_block_type", this.blockState.getBlock().getName());
    }

    @Override
    public boolean onlyOpCanSetNbt() {
        return true;
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_352287_) {
        return new ClientboundAddEntityPacket((Entity)this, p_352287_, Block.getId(this.getBlockState()));
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket p_149654_) {
        super.recreateFromPacket(p_149654_);
        this.blockState = Block.stateById(p_149654_.getData());
        this.blocksBuilding = true;
        double $$1 = p_149654_.getX();
        double $$2 = p_149654_.getY();
        double $$3 = p_149654_.getZ();
        this.setPos($$1, $$2, $$3);
        this.setStartPos(this.blockPosition());
    }

    @Override
    @Nullable
    public Entity teleport(TeleportTransition p_379492_) {
        ResourceKey<Level> $$1 = p_379492_.newLevel().dimension();
        ResourceKey<Level> $$2 = this.level().dimension();
        boolean $$3 = ($$2 == Level.END || $$1 == Level.END) && $$2 != $$1;
        Entity $$4 = super.teleport(p_379492_);
        this.forceTickAfterTeleportToDuplicate = $$4 != null && $$3;
        return $$4;
    }
}

