/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public abstract class PatrollingMonster
extends Monster {
    @Nullable
    private BlockPos patrolTarget;
    private boolean patrolLeader;
    private boolean patrolling;

    protected PatrollingMonster(EntityType<? extends PatrollingMonster> p_33046_, Level p_33047_) {
        super((EntityType<? extends Monster>)p_33046_, p_33047_);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(4, new LongDistancePatrolGoal<PatrollingMonster>(this, 0.7, 0.595));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_33063_) {
        super.addAdditionalSaveData(p_33063_);
        if (this.patrolTarget != null) {
            p_33063_.put("patrol_target", NbtUtils.writeBlockPos(this.patrolTarget));
        }
        p_33063_.putBoolean("PatrolLeader", this.patrolLeader);
        p_33063_.putBoolean("Patrolling", this.patrolling);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_33055_) {
        super.readAdditionalSaveData(p_33055_);
        NbtUtils.readBlockPos(p_33055_, "patrol_target").ifPresent(p_326234_ -> {
            this.patrolTarget = p_326234_;
        });
        this.patrolLeader = p_33055_.getBoolean("PatrolLeader");
        this.patrolling = p_33055_.getBoolean("Patrolling");
    }

    public boolean canBeLeader() {
        return true;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_33049_, DifficultyInstance p_33050_, EntitySpawnReason p_364305_, @Nullable SpawnGroupData p_33052_) {
        if (p_364305_ != EntitySpawnReason.PATROL && p_364305_ != EntitySpawnReason.EVENT && p_364305_ != EntitySpawnReason.STRUCTURE && p_33049_.getRandom().nextFloat() < 0.06f && this.canBeLeader()) {
            this.patrolLeader = true;
        }
        if (this.isPatrolLeader()) {
            this.setItemSlot(EquipmentSlot.HEAD, Raid.getOminousBannerInstance(this.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
            this.setDropChance(EquipmentSlot.HEAD, 2.0f);
        }
        if (p_364305_ == EntitySpawnReason.PATROL) {
            this.patrolling = true;
        }
        return super.finalizeSpawn(p_33049_, p_33050_, p_364305_, p_33052_);
    }

    public static boolean checkPatrollingMonsterSpawnRules(EntityType<? extends PatrollingMonster> p_219026_, LevelAccessor p_219027_, EntitySpawnReason p_361513_, BlockPos p_219029_, RandomSource p_219030_) {
        if (p_219027_.getBrightness(LightLayer.BLOCK, p_219029_) > 8) {
            return false;
        }
        return PatrollingMonster.checkAnyLightMonsterSpawnRules(p_219026_, p_219027_, p_361513_, p_219029_, p_219030_);
    }

    @Override
    public boolean removeWhenFarAway(double p_33073_) {
        return !this.patrolling || p_33073_ > 16384.0;
    }

    public void setPatrolTarget(BlockPos p_33071_) {
        this.patrolTarget = p_33071_;
        this.patrolling = true;
    }

    public BlockPos getPatrolTarget() {
        return this.patrolTarget;
    }

    public boolean hasPatrolTarget() {
        return this.patrolTarget != null;
    }

    public void setPatrolLeader(boolean p_33076_) {
        this.patrolLeader = p_33076_;
        this.patrolling = true;
    }

    public boolean isPatrolLeader() {
        return this.patrolLeader;
    }

    public boolean canJoinPatrol() {
        return true;
    }

    public void findPatrolTarget() {
        this.patrolTarget = this.blockPosition().offset(-500 + this.random.nextInt(1000), 0, -500 + this.random.nextInt(1000));
        this.patrolling = true;
    }

    protected boolean isPatrolling() {
        return this.patrolling;
    }

    protected void setPatrolling(boolean p_33078_) {
        this.patrolling = p_33078_;
    }

    public static class LongDistancePatrolGoal<T extends PatrollingMonster>
    extends Goal {
        private static final int NAVIGATION_FAILED_COOLDOWN = 200;
        private final T mob;
        private final double speedModifier;
        private final double leaderSpeedModifier;
        private long cooldownUntil;

        public LongDistancePatrolGoal(T p_33084_, double p_33085_, double p_33086_) {
            this.mob = p_33084_;
            this.speedModifier = p_33085_;
            this.leaderSpeedModifier = p_33086_;
            this.cooldownUntil = -1L;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canUse() {
            boolean $$0 = ((Entity)this.mob).level().getGameTime() < this.cooldownUntil;
            return ((PatrollingMonster)this.mob).isPatrolling() && ((Mob)this.mob).getTarget() == null && !((Entity)this.mob).hasControllingPassenger() && ((PatrollingMonster)this.mob).hasPatrolTarget() && !$$0;
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public void tick() {
            boolean $$0 = ((PatrollingMonster)this.mob).isPatrolLeader();
            PathNavigation $$1 = ((Mob)this.mob).getNavigation();
            if ($$1.isDone()) {
                List<PatrollingMonster> $$2 = this.findPatrolCompanions();
                if (((PatrollingMonster)this.mob).isPatrolling() && $$2.isEmpty()) {
                    ((PatrollingMonster)this.mob).setPatrolling(false);
                } else if (!$$0 || !((PatrollingMonster)this.mob).getPatrolTarget().closerToCenterThan(((Entity)this.mob).position(), 10.0)) {
                    Vec3 $$3 = Vec3.atBottomCenterOf(((PatrollingMonster)this.mob).getPatrolTarget());
                    Vec3 $$4 = ((Entity)this.mob).position();
                    Vec3 $$5 = $$4.subtract($$3);
                    $$3 = $$5.yRot(90.0f).scale(0.4).add($$3);
                    Vec3 $$6 = $$3.subtract($$4).normalize().scale(10.0).add($$4);
                    BlockPos $$7 = BlockPos.containing($$6);
                    $$7 = ((Entity)this.mob).level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, $$7);
                    if (!$$1.moveTo($$7.getX(), $$7.getY(), $$7.getZ(), $$0 ? this.leaderSpeedModifier : this.speedModifier)) {
                        this.moveRandomly();
                        this.cooldownUntil = ((Entity)this.mob).level().getGameTime() + 200L;
                    } else if ($$0) {
                        for (PatrollingMonster $$8 : $$2) {
                            $$8.setPatrolTarget($$7);
                        }
                    }
                } else {
                    ((PatrollingMonster)this.mob).findPatrolTarget();
                }
            }
        }

        private List<PatrollingMonster> findPatrolCompanions() {
            return ((Entity)this.mob).level().getEntitiesOfClass(PatrollingMonster.class, ((Entity)this.mob).getBoundingBox().inflate(16.0), p_359927_ -> p_359927_.canJoinPatrol() && !p_359927_.is((Entity)this.mob));
        }

        private boolean moveRandomly() {
            RandomSource $$0 = ((Entity)this.mob).getRandom();
            BlockPos $$1 = ((Entity)this.mob).level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ((Entity)this.mob).blockPosition().offset(-8 + $$0.nextInt(16), 0, -8 + $$0.nextInt(16)));
            return ((Mob)this.mob).getNavigation().moveTo($$1.getX(), $$1.getY(), $$1.getZ(), this.speedModifier);
        }
    }
}

