/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RemoveBlockGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class Zombie
extends Monster {
    private static final ResourceLocation SPEED_MODIFIER_BABY_ID = ResourceLocation.withDefaultNamespace("baby");
    private static final AttributeModifier SPEED_MODIFIER_BABY = new AttributeModifier(SPEED_MODIFIER_BABY_ID, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final ResourceLocation REINFORCEMENT_CALLER_CHARGE_ID = ResourceLocation.withDefaultNamespace("reinforcement_caller_charge");
    private static final AttributeModifier ZOMBIE_REINFORCEMENT_CALLEE_CHARGE = new AttributeModifier(ResourceLocation.withDefaultNamespace("reinforcement_callee_charge"), -0.05f, AttributeModifier.Operation.ADD_VALUE);
    private static final ResourceLocation LEADER_ZOMBIE_BONUS_ID = ResourceLocation.withDefaultNamespace("leader_zombie_bonus");
    private static final ResourceLocation ZOMBIE_RANDOM_SPAWN_BONUS_ID = ResourceLocation.withDefaultNamespace("zombie_random_spawn_bonus");
    private static final EntityDataAccessor<Boolean> DATA_BABY_ID = SynchedEntityData.defineId(Zombie.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_SPECIAL_TYPE_ID = SynchedEntityData.defineId(Zombie.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_DROWNED_CONVERSION_ID = SynchedEntityData.defineId(Zombie.class, EntityDataSerializers.BOOLEAN);
    public static final float ZOMBIE_LEADER_CHANCE = 0.05f;
    public static final int REINFORCEMENT_ATTEMPTS = 50;
    public static final int REINFORCEMENT_RANGE_MAX = 40;
    public static final int REINFORCEMENT_RANGE_MIN = 7;
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.ZOMBIE.getDimensions().scale(0.5f).withEyeHeight(0.93f);
    private static final float BREAK_DOOR_CHANCE = 0.1f;
    private static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = p_34284_ -> p_34284_ == Difficulty.HARD;
    private final BreakDoorGoal breakDoorGoal = new BreakDoorGoal(this, DOOR_BREAKING_PREDICATE);
    private boolean canBreakDoors;
    private int inWaterTime;
    private int conversionTime;

    public Zombie(EntityType<? extends Zombie> p_34271_, Level p_34272_) {
        super((EntityType<? extends Monster>)p_34271_, p_34272_);
    }

    public Zombie(Level p_34274_) {
        this((EntityType<? extends Zombie>)EntityType.ZOMBIE, p_34274_);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(4, new ZombieAttackTurtleEggGoal((PathfinderMob)this, 1.0, 3));
        this.goalSelector.addGoal(8, new LookAtPlayerGoal(this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, new RandomLookAroundGoal(this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(2, new ZombieAttackGoal(this, 1.0, false));
        this.goalSelector.addGoal(6, new MoveThroughVillageGoal(this, 1.0, true, 4, this::canBreakDoors));
        this.goalSelector.addGoal(7, new WaterAvoidingRandomStrollGoal(this, 1.0));
        this.targetSelector.addGoal(1, new HurtByTargetGoal(this, new Class[0]).setAlertOthers(ZombifiedPiglin.class));
        this.targetSelector.addGoal(2, new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, new NearestAttackableTargetGoal<AbstractVillager>((Mob)this, AbstractVillager.class, false));
        this.targetSelector.addGoal(3, new NearestAttackableTargetGoal<IronGolem>((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(5, new NearestAttackableTargetGoal<Turtle>(this, Turtle.class, 10, true, false, Turtle.BABY_ON_LAND_SELECTOR));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.23f).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ARMOR, 2.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326435_) {
        super.defineSynchedData(p_326435_);
        p_326435_.define(DATA_BABY_ID, false);
        p_326435_.define(DATA_SPECIAL_TYPE_ID, 0);
        p_326435_.define(DATA_DROWNED_CONVERSION_ID, false);
    }

    public boolean isUnderWaterConverting() {
        return this.getEntityData().get(DATA_DROWNED_CONVERSION_ID);
    }

    public boolean canBreakDoors() {
        return this.canBreakDoors;
    }

    public void setCanBreakDoors(boolean p_34337_) {
        if (GoalUtils.hasGroundPathNavigation(this)) {
            if (this.canBreakDoors != p_34337_) {
                this.canBreakDoors = p_34337_;
                ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(p_34337_);
                if (p_34337_) {
                    this.goalSelector.addGoal(1, this.breakDoorGoal);
                } else {
                    this.goalSelector.removeGoal(this.breakDoorGoal);
                }
            }
        } else if (this.canBreakDoors) {
            this.goalSelector.removeGoal(this.breakDoorGoal);
            this.canBreakDoors = false;
        }
    }

    @Override
    public boolean isBaby() {
        return this.getEntityData().get(DATA_BABY_ID);
    }

    @Override
    protected int getBaseExperienceReward(ServerLevel p_376355_) {
        if (this.isBaby()) {
            this.xpReward = (int)((double)this.xpReward * 2.5);
        }
        return super.getBaseExperienceReward(p_376355_);
    }

    @Override
    public void setBaby(boolean p_34309_) {
        this.getEntityData().set(DATA_BABY_ID, p_34309_);
        if (this.level() != null && !this.level().isClientSide) {
            AttributeInstance $$1 = this.getAttribute(Attributes.MOVEMENT_SPEED);
            $$1.removeModifier(SPEED_MODIFIER_BABY_ID);
            if (p_34309_) {
                $$1.addTransientModifier(SPEED_MODIFIER_BABY);
            }
        }
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_34307_) {
        if (DATA_BABY_ID.equals(p_34307_)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(p_34307_);
    }

    protected boolean convertsInWater() {
        return true;
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide && this.isAlive() && !this.isNoAi()) {
            if (this.isUnderWaterConverting()) {
                --this.conversionTime;
                if (this.conversionTime < 0) {
                    this.doUnderWaterConversion();
                }
            } else if (this.convertsInWater()) {
                if (this.isEyeInFluid(FluidTags.WATER)) {
                    ++this.inWaterTime;
                    if (this.inWaterTime >= 600) {
                        this.startUnderWaterConversion(300);
                    }
                } else {
                    this.inWaterTime = -1;
                }
            }
        }
        super.tick();
    }

    @Override
    public void aiStep() {
        if (this.isAlive()) {
            boolean $$0;
            boolean bl = $$0 = this.isSunSensitive() && this.isSunBurnTick();
            if ($$0) {
                ItemStack $$1 = this.getItemBySlot(EquipmentSlot.HEAD);
                if (!$$1.isEmpty()) {
                    if ($$1.isDamageableItem()) {
                        Item $$2 = $$1.getItem();
                        $$1.setDamageValue($$1.getDamageValue() + this.random.nextInt(2));
                        if ($$1.getDamageValue() >= $$1.getMaxDamage()) {
                            this.onEquippedItemBroken($$2, EquipmentSlot.HEAD);
                            this.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
                        }
                    }
                    $$0 = false;
                }
                if ($$0) {
                    this.igniteForSeconds(8.0f);
                }
            }
        }
        super.aiStep();
    }

    private void startUnderWaterConversion(int p_34279_) {
        this.conversionTime = p_34279_;
        this.getEntityData().set(DATA_DROWNED_CONVERSION_ID, true);
    }

    protected void doUnderWaterConversion() {
        this.convertToZombieType(EntityType.DROWNED);
        if (!this.isSilent()) {
            this.level().levelEvent(null, 1040, this.blockPosition(), 0);
        }
    }

    protected void convertToZombieType(EntityType<? extends Zombie> p_34311_) {
        this.convertTo(p_34311_, ConversionParams.single(this, true, true), p_381517_ -> p_381517_.handleAttributes(p_381517_.level().getCurrentDifficultyAt(p_381517_.blockPosition()).getSpecialMultiplier()));
    }

    @VisibleForTesting
    public boolean convertVillagerToZombieVillager(ServerLevel p_371466_, Villager p_371444_) {
        ZombieVillager $$2 = p_371444_.convertTo(EntityType.ZOMBIE_VILLAGER, ConversionParams.single(p_371444_, true, true), p_370686_ -> {
            p_370686_.finalizeSpawn(p_371466_, p_371466_.getCurrentDifficultyAt(p_370686_.blockPosition()), EntitySpawnReason.CONVERSION, new ZombieGroupData(false, true));
            p_370686_.setVillagerData(p_371444_.getVillagerData());
            p_370686_.setGossips(p_371444_.getGossips().store(NbtOps.INSTANCE));
            p_370686_.setTradeOffers(p_371444_.getOffers().copy());
            p_370686_.setVillagerXp(p_371444_.getVillagerXp());
            if (!this.isSilent()) {
                p_371466_.levelEvent(null, 1026, this.blockPosition(), 0);
            }
        });
        return $$2 != null;
    }

    protected boolean isSunSensitive() {
        return true;
    }

    @Override
    public boolean hurtServer(ServerLevel p_376886_, DamageSource p_376124_, float p_376398_) {
        if (!super.hurtServer(p_376886_, p_376124_, p_376398_)) {
            return false;
        }
        LivingEntity $$3 = this.getTarget();
        if ($$3 == null && p_376124_.getEntity() instanceof LivingEntity) {
            $$3 = (LivingEntity)p_376124_.getEntity();
        }
        if ($$3 != null && p_376886_.getDifficulty() == Difficulty.HARD && (double)this.random.nextFloat() < this.getAttributeValue(Attributes.SPAWN_REINFORCEMENTS_CHANCE) && p_376886_.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            int $$4 = Mth.floor(this.getX());
            int $$5 = Mth.floor(this.getY());
            int $$6 = Mth.floor(this.getZ());
            EntityType<? extends Zombie> $$7 = this.getType();
            Zombie $$8 = $$7.create(p_376886_, EntitySpawnReason.REINFORCEMENT);
            if ($$8 == null) {
                return true;
            }
            for (int $$9 = 0; $$9 < 50; ++$$9) {
                int $$12;
                int $$11;
                int $$10 = $$4 + Mth.nextInt(this.random, 7, 40) * Mth.nextInt(this.random, -1, 1);
                BlockPos $$13 = new BlockPos($$10, $$11 = $$5 + Mth.nextInt(this.random, 7, 40) * Mth.nextInt(this.random, -1, 1), $$12 = $$6 + Mth.nextInt(this.random, 7, 40) * Mth.nextInt(this.random, -1, 1));
                if (!SpawnPlacements.isSpawnPositionOk($$7, p_376886_, $$13) || !SpawnPlacements.checkSpawnRules($$7, p_376886_, EntitySpawnReason.REINFORCEMENT, $$13, p_376886_.random)) continue;
                $$8.setPos($$10, $$11, $$12);
                if (p_376886_.hasNearbyAlivePlayer($$10, $$11, $$12, 7.0) || !p_376886_.isUnobstructed($$8) || !p_376886_.noCollision($$8) || !$$8.canSpawnInLiquids() && p_376886_.containsAnyLiquid($$8.getBoundingBox())) continue;
                $$8.setTarget($$3);
                $$8.finalizeSpawn(p_376886_, p_376886_.getCurrentDifficultyAt($$8.blockPosition()), EntitySpawnReason.REINFORCEMENT, null);
                p_376886_.addFreshEntityWithPassengers($$8);
                AttributeInstance $$14 = this.getAttribute(Attributes.SPAWN_REINFORCEMENTS_CHANCE);
                AttributeModifier $$15 = $$14.getModifier(REINFORCEMENT_CALLER_CHARGE_ID);
                double $$16 = $$15 != null ? $$15.amount() : 0.0;
                $$14.removeModifier(REINFORCEMENT_CALLER_CHARGE_ID);
                $$14.addPermanentModifier(new AttributeModifier(REINFORCEMENT_CALLER_CHARGE_ID, $$16 - 0.05, AttributeModifier.Operation.ADD_VALUE));
                $$8.getAttribute(Attributes.SPAWN_REINFORCEMENTS_CHANCE).addPermanentModifier(ZOMBIE_REINFORCEMENT_CALLEE_CHARGE);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean doHurtTarget(ServerLevel p_376343_, Entity p_34276_) {
        boolean $$2 = super.doHurtTarget(p_376343_, p_34276_);
        if ($$2) {
            float $$3 = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            if (this.getMainHandItem().isEmpty() && this.isOnFire() && this.random.nextFloat() < $$3 * 0.3f) {
                p_34276_.igniteForSeconds(2 * (int)$$3);
            }
        }
        return $$2;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ZOMBIE_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return SoundEvents.ZOMBIE_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_DEATH;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    @Override
    protected void playStepSound(BlockPos p_34316_, BlockState p_34317_) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    public EntityType<? extends Zombie> getType() {
        return super.getType();
    }

    protected boolean canSpawnInLiquids() {
        return false;
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource p_219165_, DifficultyInstance p_219166_) {
        super.populateDefaultEquipmentSlots(p_219165_, p_219166_);
        float f = p_219165_.nextFloat();
        float f2 = this.level().getDifficulty() == Difficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            int $$2 = p_219165_.nextInt(3);
            if ($$2 == 0) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(Items.IRON_SWORD));
            } else {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(Items.IRON_SHOVEL));
            }
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_34319_) {
        super.addAdditionalSaveData(p_34319_);
        p_34319_.putBoolean("IsBaby", this.isBaby());
        p_34319_.putBoolean("CanBreakDoors", this.canBreakDoors());
        p_34319_.putInt("InWaterTime", this.isInWater() ? this.inWaterTime : -1);
        p_34319_.putInt("DrownedConversionTime", this.isUnderWaterConverting() ? this.conversionTime : -1);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_34305_) {
        super.readAdditionalSaveData(p_34305_);
        this.setBaby(p_34305_.getBoolean("IsBaby"));
        this.setCanBreakDoors(p_34305_.getBoolean("CanBreakDoors"));
        this.inWaterTime = p_34305_.getInt("InWaterTime");
        if (p_34305_.contains("DrownedConversionTime", 99) && p_34305_.getInt("DrownedConversionTime") > -1) {
            this.startUnderWaterConversion(p_34305_.getInt("DrownedConversionTime"));
        }
    }

    @Override
    public boolean killedEntity(ServerLevel p_219160_, LivingEntity p_219161_) {
        boolean $$2 = super.killedEntity(p_219160_, p_219161_);
        if ((p_219160_.getDifficulty() == Difficulty.NORMAL || p_219160_.getDifficulty() == Difficulty.HARD) && p_219161_ instanceof Villager) {
            Villager $$3 = (Villager)p_219161_;
            if (p_219160_.getDifficulty() != Difficulty.HARD && this.random.nextBoolean()) {
                return $$2;
            }
            if (this.convertVillagerToZombieVillager(p_219160_, $$3)) {
                $$2 = false;
            }
        }
        return $$2;
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose p_316771_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_316771_);
    }

    @Override
    public boolean canHoldItem(ItemStack p_34332_) {
        if (p_34332_.is(Items.EGG) && this.isBaby() && this.isPassenger()) {
            return false;
        }
        return super.canHoldItem(p_34332_);
    }

    @Override
    public boolean wantsToPickUp(ServerLevel p_376535_, ItemStack p_182400_) {
        if (p_182400_.is(Items.GLOW_INK_SAC)) {
            return false;
        }
        return super.wantsToPickUp(p_376535_, p_182400_);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_34297_, DifficultyInstance p_34298_, EntitySpawnReason p_362602_, @Nullable SpawnGroupData p_34300_) {
        RandomSource $$4 = p_34297_.getRandom();
        p_34300_ = super.finalizeSpawn(p_34297_, p_34298_, p_362602_, p_34300_);
        float $$5 = p_34298_.getSpecialMultiplier();
        if (p_362602_ != EntitySpawnReason.CONVERSION) {
            this.setCanPickUpLoot($$4.nextFloat() < 0.55f * $$5);
        }
        if (p_34300_ == null) {
            p_34300_ = new ZombieGroupData(Zombie.getSpawnAsBabyOdds($$4), true);
        }
        if (p_34300_ instanceof ZombieGroupData) {
            ZombieGroupData $$6 = (ZombieGroupData)p_34300_;
            if ($$6.isBaby) {
                this.setBaby(true);
                if ($$6.canSpawnJockey) {
                    Chicken $$9;
                    if ((double)$$4.nextFloat() < 0.05) {
                        List<Entity> $$7 = p_34297_.getEntitiesOfClass(Chicken.class, this.getBoundingBox().inflate(5.0, 3.0, 5.0), EntitySelector.ENTITY_NOT_BEING_RIDDEN);
                        if (!$$7.isEmpty()) {
                            Chicken $$8 = (Chicken)$$7.get(0);
                            $$8.setChickenJockey(true);
                            this.startRiding($$8);
                        }
                    } else if ((double)$$4.nextFloat() < 0.05 && ($$9 = EntityType.CHICKEN.create(this.level(), EntitySpawnReason.JOCKEY)) != null) {
                        $$9.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                        $$9.finalizeSpawn(p_34297_, p_34298_, EntitySpawnReason.JOCKEY, null);
                        $$9.setChickenJockey(true);
                        this.startRiding($$9);
                        p_34297_.addFreshEntity($$9);
                    }
                }
            }
            this.setCanBreakDoors($$4.nextFloat() < $$5 * 0.1f);
            if (p_362602_ != EntitySpawnReason.CONVERSION) {
                this.populateDefaultEquipmentSlots($$4, p_34298_);
                this.populateDefaultEquipmentEnchantments(p_34297_, $$4, p_34298_);
            }
        }
        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            LocalDate $$10 = LocalDate.now();
            int $$11 = $$10.get(ChronoField.DAY_OF_MONTH);
            int $$12 = $$10.get(ChronoField.MONTH_OF_YEAR);
            if ($$12 == 10 && $$11 == 31 && $$4.nextFloat() < 0.25f) {
                this.setItemSlot(EquipmentSlot.HEAD, new ItemStack($$4.nextFloat() < 0.1f ? Blocks.JACK_O_LANTERN : Blocks.CARVED_PUMPKIN));
                this.armorDropChances[EquipmentSlot.HEAD.getIndex()] = 0.0f;
            }
        }
        this.handleAttributes($$5);
        return p_34300_;
    }

    @VisibleForTesting
    public void setInWaterTime(int p_371332_) {
        this.inWaterTime = p_371332_;
    }

    @VisibleForTesting
    public void setConversionTime(int p_371791_) {
        this.conversionTime = p_371791_;
    }

    public static boolean getSpawnAsBabyOdds(RandomSource p_219163_) {
        return p_219163_.nextFloat() < 0.05f;
    }

    protected void handleAttributes(float p_34340_) {
        this.randomizeReinforcementsChance();
        this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).addOrReplacePermanentModifier(new AttributeModifier(RANDOM_SPAWN_BONUS_ID, this.random.nextDouble() * (double)0.05f, AttributeModifier.Operation.ADD_VALUE));
        double $$1 = this.random.nextDouble() * 1.5 * (double)p_34340_;
        if ($$1 > 1.0) {
            this.getAttribute(Attributes.FOLLOW_RANGE).addOrReplacePermanentModifier(new AttributeModifier(ZOMBIE_RANDOM_SPAWN_BONUS_ID, $$1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        if (this.random.nextFloat() < p_34340_ * 0.05f) {
            this.getAttribute(Attributes.SPAWN_REINFORCEMENTS_CHANCE).addOrReplacePermanentModifier(new AttributeModifier(LEADER_ZOMBIE_BONUS_ID, this.random.nextDouble() * 0.25 + 0.5, AttributeModifier.Operation.ADD_VALUE));
            this.getAttribute(Attributes.MAX_HEALTH).addOrReplacePermanentModifier(new AttributeModifier(LEADER_ZOMBIE_BONUS_ID, this.random.nextDouble() * 3.0 + 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            this.setCanBreakDoors(true);
        }
    }

    protected void randomizeReinforcementsChance() {
        this.getAttribute(Attributes.SPAWN_REINFORCEMENTS_CHANCE).setBaseValue(this.random.nextDouble() * (double)0.1f);
    }

    @Override
    protected void dropCustomDeathLoot(ServerLevel p_348597_, DamageSource p_34291_, boolean p_34293_) {
        ItemStack $$5;
        Creeper $$4;
        super.dropCustomDeathLoot(p_348597_, p_34291_, p_34293_);
        Entity $$3 = p_34291_.getEntity();
        if ($$3 instanceof Creeper && ($$4 = (Creeper)$$3).canDropMobsSkull() && !($$5 = this.getSkull()).isEmpty()) {
            $$4.increaseDroppedSkulls();
            this.spawnAtLocation(p_348597_, $$5);
        }
    }

    protected ItemStack getSkull() {
        return new ItemStack(Items.ZOMBIE_HEAD);
    }

    class ZombieAttackTurtleEggGoal
    extends RemoveBlockGoal {
        ZombieAttackTurtleEggGoal(PathfinderMob p_34344_, double p_34345_, int p_34346_) {
            super(Blocks.TURTLE_EGG, p_34344_, p_34345_, p_34346_);
        }

        @Override
        public void playDestroyProgressSound(LevelAccessor p_34351_, BlockPos p_34352_) {
            p_34351_.playSound(null, p_34352_, SoundEvents.ZOMBIE_DESTROY_EGG, SoundSource.HOSTILE, 0.5f, 0.9f + Zombie.this.random.nextFloat() * 0.2f);
        }

        @Override
        public void playBreakSound(Level p_34348_, BlockPos p_34349_) {
            p_34348_.playSound(null, p_34349_, SoundEvents.TURTLE_EGG_BREAK, SoundSource.BLOCKS, 0.7f, 0.9f + p_34348_.random.nextFloat() * 0.2f);
        }

        @Override
        public double acceptedDistance() {
            return 1.14;
        }
    }

    public static class ZombieGroupData
    implements SpawnGroupData {
        public final boolean isBaby;
        public final boolean canSpawnJockey;

        public ZombieGroupData(boolean p_34357_, boolean p_34358_) {
            this.isBaby = p_34357_;
            this.canSpawnJockey = p_34358_;
        }
    }
}

