/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.breeze;

import com.mojang.serialization.Dynamic;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.breeze.BreezeAi;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class Breeze
extends Monster {
    private static final int SLIDE_PARTICLES_AMOUNT = 20;
    private static final int IDLE_PARTICLES_AMOUNT = 1;
    private static final int JUMP_DUST_PARTICLES_AMOUNT = 20;
    private static final int JUMP_TRAIL_PARTICLES_AMOUNT = 3;
    private static final int JUMP_TRAIL_DURATION_TICKS = 5;
    private static final int JUMP_CIRCLE_DISTANCE_Y = 10;
    private static final float FALL_DISTANCE_SOUND_TRIGGER_THRESHOLD = 3.0f;
    private static final int WHIRL_SOUND_FREQUENCY_MIN = 1;
    private static final int WHIRL_SOUND_FREQUENCY_MAX = 80;
    public AnimationState idle = new AnimationState();
    public AnimationState slide = new AnimationState();
    public AnimationState slideBack = new AnimationState();
    public AnimationState longJump = new AnimationState();
    public AnimationState shoot = new AnimationState();
    public AnimationState inhale = new AnimationState();
    private int jumpTrailStartedTick = 0;
    private int soundTick = 0;
    private static final ProjectileDeflection PROJECTILE_DEFLECTION = (p_344345_, p_344346_, p_344347_) -> {
        p_344346_.level().playSound(null, p_344346_, SoundEvents.BREEZE_DEFLECT, p_344346_.getSoundSource(), 1.0f, 1.0f);
        ProjectileDeflection.REVERSE.deflect(p_344345_, p_344346_, p_344347_);
    };

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.63f).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public Breeze(EntityType<? extends Monster> p_312213_, Level p_312377_) {
        super(p_312213_, p_312377_);
        this.setPathfindingMalus(PathType.DANGER_TRAPDOOR, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.xpReward = 10;
    }

    @Override
    protected Brain<?> makeBrain(Dynamic<?> p_312201_) {
        return BreezeAi.makeBrain(this, this.brainProvider().makeBrain(p_312201_));
    }

    public Brain<Breeze> getBrain() {
        return super.getBrain();
    }

    protected Brain.Provider<Breeze> brainProvider() {
        return Brain.provider(BreezeAi.MEMORY_TYPES, BreezeAi.SENSOR_TYPES);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_312373_) {
        if (this.level().isClientSide() && DATA_POSE.equals(p_312373_)) {
            this.resetAnimations();
            Pose $$1 = this.getPose();
            switch ($$1) {
                case SHOOTING: {
                    this.shoot.startIfStopped(this.tickCount);
                    break;
                }
                case INHALING: {
                    this.inhale.startIfStopped(this.tickCount);
                    break;
                }
                case SLIDING: {
                    this.slide.startIfStopped(this.tickCount);
                }
            }
        }
        super.onSyncedDataUpdated(p_312373_);
    }

    private void resetAnimations() {
        this.shoot.stop();
        this.idle.stop();
        this.inhale.stop();
        this.longJump.stop();
    }

    @Override
    public void tick() {
        Pose $$0 = this.getPose();
        switch ($$0) {
            case SLIDING: {
                this.emitGroundParticles(20);
                break;
            }
            case SHOOTING: 
            case INHALING: 
            case STANDING: {
                this.resetJumpTrail().emitGroundParticles(1 + this.getRandom().nextInt(1));
                break;
            }
            case LONG_JUMPING: {
                this.longJump.startIfStopped(this.tickCount);
                this.emitJumpTrailParticles();
            }
        }
        if ($$0 != Pose.SLIDING && this.slide.isStarted()) {
            this.slideBack.start(this.tickCount);
            this.slide.stop();
        }
        if ($$0 == Pose.STANDING) {
            this.idle.startIfStopped(this.tickCount);
        }
        int n = this.soundTick = this.soundTick == 0 ? this.random.nextIntBetweenInclusive(1, 80) : this.soundTick - 1;
        if (this.soundTick == 0) {
            this.playWhirlSound();
        }
        super.tick();
    }

    public Breeze resetJumpTrail() {
        this.jumpTrailStartedTick = 0;
        return this;
    }

    public void emitJumpTrailParticles() {
        if (++this.jumpTrailStartedTick > 5) {
            return;
        }
        BlockState $$0 = !this.getInBlockState().isAir() ? this.getInBlockState() : this.getBlockStateOn();
        Vec3 $$1 = this.getDeltaMovement();
        Vec3 $$2 = this.position().add($$1).add(0.0, 0.1f, 0.0);
        for (int $$3 = 0; $$3 < 3; ++$$3) {
            this.level().addParticle(new BlockParticleOption(ParticleTypes.BLOCK, $$0), $$2.x, $$2.y, $$2.z, 0.0, 0.0, 0.0);
        }
    }

    public void emitGroundParticles(int p_312637_) {
        BlockState $$3;
        if (this.isPassenger()) {
            return;
        }
        Vec3 $$1 = this.getBoundingBox().getCenter();
        Vec3 $$2 = new Vec3($$1.x, this.position().y, $$1.z);
        BlockState blockState = $$3 = !this.getInBlockState().isAir() ? this.getInBlockState() : this.getBlockStateOn();
        if ($$3.getRenderShape() == RenderShape.INVISIBLE) {
            return;
        }
        for (int $$4 = 0; $$4 < p_312637_; ++$$4) {
            this.level().addParticle(new BlockParticleOption(ParticleTypes.BLOCK, $$3), $$2.x, $$2.y, $$2.z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void playAmbientSound() {
        if (this.getTarget() != null && this.onGround()) {
            return;
        }
        this.level().playLocalSound(this, this.getAmbientSound(), this.getSoundSource(), 1.0f, 1.0f);
    }

    public void playWhirlSound() {
        float $$0 = 0.7f + 0.4f * this.random.nextFloat();
        float $$1 = 0.8f + 0.2f * this.random.nextFloat();
        this.level().playLocalSound(this, SoundEvents.BREEZE_WHIRL, this.getSoundSource(), $$1, $$0);
    }

    @Override
    public ProjectileDeflection deflection(Projectile p_320843_) {
        if (p_320843_.getType() == EntityType.BREEZE_WIND_CHARGE || p_320843_.getType() == EntityType.WIND_CHARGE) {
            return ProjectileDeflection.NONE;
        }
        return this.getType().is(EntityTypeTags.DEFLECTS_PROJECTILES) ? PROJECTILE_DEFLECTION : ProjectileDeflection.NONE;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.BREEZE_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_312252_) {
        return SoundEvents.BREEZE_HURT;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return this.onGround() ? SoundEvents.BREEZE_IDLE_GROUND : SoundEvents.BREEZE_IDLE_AIR;
    }

    public Optional<LivingEntity> getHurtBy() {
        return this.getBrain().getMemory(MemoryModuleType.HURT_BY).map(DamageSource::getEntity).filter(p_321467_ -> p_321467_ instanceof LivingEntity).map(p_321468_ -> (LivingEntity)p_321468_);
    }

    public boolean withinInnerCircleRange(Vec3 p_312331_) {
        Vec3 $$1 = this.blockPosition().getCenter();
        return p_312331_.closerThan($$1, 4.0, 10.0);
    }

    @Override
    protected void customServerAiStep(ServerLevel p_376422_) {
        ProfilerFiller $$1 = Profiler.get();
        $$1.push("breezeBrain");
        this.getBrain().tick(p_376422_, this);
        $$1.popPush("breezeActivityUpdate");
        BreezeAi.updateActivity(this);
        $$1.pop();
        super.customServerAiStep(p_376422_);
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain(this);
        DebugPackets.sendBreezeInfo(this);
    }

    @Override
    public boolean canAttackType(EntityType<?> p_312806_) {
        return p_312806_ == EntityType.PLAYER || p_312806_ == EntityType.IRON_GOLEM;
    }

    @Override
    public int getMaxHeadYRot() {
        return 30;
    }

    @Override
    public int getHeadRotSpeed() {
        return 25;
    }

    public double getFiringYPosition() {
        return this.getY() + (double)(this.getBbHeight() / 2.0f) + (double)0.3f;
    }

    @Override
    public boolean isInvulnerableTo(ServerLevel p_376278_, DamageSource p_312691_) {
        return p_312691_.getEntity() instanceof Breeze || super.isInvulnerableTo(p_376278_, p_312691_);
    }

    @Override
    public double getFluidJumpThreshold() {
        return this.getEyeHeight();
    }

    @Override
    public boolean causeFallDamage(float p_312702_, float p_312120_, DamageSource p_312076_) {
        if (p_312702_ > 3.0f) {
            this.playSound(SoundEvents.BREEZE_LAND, 1.0f, 1.0f);
        }
        return super.causeFallDamage(p_312702_, p_312120_, p_312076_);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        return this.getTargetFromBrain();
    }
}

