/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.creaking;

import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.creaking.CreakingAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class Creaking
extends Monster {
    private static final EntityDataAccessor<Boolean> CAN_MOVE = SynchedEntityData.defineId(Creaking.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_ACTIVE = SynchedEntityData.defineId(Creaking.class, EntityDataSerializers.BOOLEAN);
    private static final int ATTACK_ANIMATION_DURATION = 20;
    private static final int MAX_HEALTH = 1;
    private static final float ATTACK_DAMAGE = 2.0f;
    private static final float FOLLOW_RANGE = 32.0f;
    private static final float ACTIVATION_RANGE_SQ = 144.0f;
    public static final int ATTACK_INTERVAL = 40;
    private static final float MOVEMENT_SPEED_WHEN_FIGHTING = 0.3f;
    public static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.2f;
    public static final int CREAKING_ORANGE = 16545810;
    public static final int CREAKING_GRAY = 0x5F5F5F;
    private int attackAnimationRemainingTicks;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState invulnerabilityAnimationState = new AnimationState();

    public Creaking(EntityType<? extends Creaking> p_380212_, Level p_379294_) {
        super((EntityType<? extends Monster>)p_380212_, p_379294_);
        this.lookControl = new CreakingLookControl(this);
        this.moveControl = new CreakingMoveControl(this);
        this.jumpControl = new CreakingJumpControl(this);
        GroundPathNavigation $$2 = (GroundPathNavigation)this.getNavigation();
        $$2.setCanFloat(true);
        this.xpReward = 0;
    }

    @Override
    protected BodyRotationControl createBodyControl() {
        return new CreakingBodyRotationControl(this);
    }

    protected Brain.Provider<Creaking> brainProvider() {
        return CreakingAi.brainProvider();
    }

    @Override
    protected Brain<?> makeBrain(Dynamic<?> p_380078_) {
        return CreakingAi.makeBrain(this.brainProvider().makeBrain(p_380078_));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_379982_) {
        super.defineSynchedData(p_379982_);
        p_379982_.define(CAN_MOVE, true);
        p_379982_.define(IS_ACTIVE, false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, 0.3f).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public boolean canMove() {
        return this.entityData.get(CAN_MOVE);
    }

    @Override
    public boolean doHurtTarget(ServerLevel p_379943_, Entity p_379911_) {
        if (!(p_379911_ instanceof LivingEntity)) {
            return false;
        }
        this.attackAnimationRemainingTicks = 20;
        this.level().broadcastEntityEvent(this, (byte)4);
        return super.doHurtTarget(p_379943_, p_379911_);
    }

    @Override
    public boolean isPushable() {
        return super.isPushable() && this.canMove();
    }

    public Brain<Creaking> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void customServerAiStep(ServerLevel p_379858_) {
        ProfilerFiller $$1 = Profiler.get();
        $$1.push("creakingBrain");
        this.getBrain().tick((ServerLevel)this.level(), this);
        $$1.pop();
        CreakingAi.updateActivity(this);
    }

    @Override
    public void aiStep() {
        if (this.attackAnimationRemainingTicks > 0) {
            --this.attackAnimationRemainingTicks;
        }
        if (!this.level().isClientSide) {
            boolean $$0 = this.entityData.get(CAN_MOVE);
            boolean $$1 = this.checkCanMove();
            if ($$1 != $$0) {
                this.gameEvent(GameEvent.ENTITY_ACTION);
                if ($$1) {
                    this.makeSound(SoundEvents.CREAKING_UNFREEZE);
                } else {
                    this.stopInPlace();
                    this.makeSound(SoundEvents.CREAKING_FREEZE);
                }
            }
            this.entityData.set(CAN_MOVE, $$1);
        }
        super.aiStep();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        this.attackAnimationState.animateWhen(this.attackAnimationRemainingTicks > 0, this.tickCount);
    }

    @Override
    public void handleEntityEvent(byte p_379620_) {
        if (p_379620_ == 4) {
            this.attackAnimationRemainingTicks = 20;
            this.playAttackSound();
        } else {
            super.handleEntityEvent(p_379620_);
        }
    }

    @Override
    public void playAttackSound() {
        this.makeSound(SoundEvents.CREAKING_ATTACK);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        if (this.isActive()) {
            return null;
        }
        return SoundEvents.CREAKING_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_380378_) {
        return SoundEvents.CREAKING_SWAY;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.CREAKING_DEATH;
    }

    @Override
    protected void playStepSound(BlockPos p_379428_, BlockState p_380060_) {
        this.playSound(SoundEvents.CREAKING_STEP, 0.15f, 1.0f);
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        return this.getTargetFromBrain();
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain(this);
    }

    @Override
    public void knockback(double p_379489_, double p_380324_, double p_379735_) {
        if (!this.canMove()) {
            return;
        }
        super.knockback(p_379489_, p_380324_, p_379735_);
    }

    public boolean checkCanMove() {
        List $$0 = this.brain.getMemory(MemoryModuleType.NEAREST_PLAYERS).orElse(List.of());
        if ($$0.isEmpty()) {
            if (this.isActive()) {
                this.gameEvent(GameEvent.ENTITY_ACTION);
                this.makeSound(SoundEvents.CREAKING_DEACTIVATE);
                this.setIsActive(false);
            }
            return true;
        }
        Predicate<LivingEntity> $$1 = this.isActive() ? LivingEntity.PLAYER_NOT_WEARING_DISGUISE_ITEM : p_380174_ -> true;
        for (Player $$2 : $$0) {
            if ($$2.isCreative() || !this.isLookingAtMe($$2, 0.5, false, true, $$1, this::getEyeY, this::getY, () -> (this.getEyeY() + this.getY()) / 2.0)) continue;
            if (this.isActive()) {
                return false;
            }
            if (!($$2.distanceToSqr(this) < 144.0)) continue;
            this.gameEvent(GameEvent.ENTITY_ACTION);
            this.makeSound(SoundEvents.CREAKING_ACTIVATE);
            this.setIsActive(true);
            this.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, $$2);
            return false;
        }
        return true;
    }

    public void setIsActive(boolean p_379949_) {
        this.entityData.set(IS_ACTIVE, p_379949_);
    }

    public boolean isActive() {
        return this.entityData.get(IS_ACTIVE);
    }

    @Override
    public float getWalkTargetValue(BlockPos p_379756_, LevelReader p_380102_) {
        return 0.0f;
    }

    class CreakingLookControl
    extends LookControl {
        public CreakingLookControl(Creaking p_379883_) {
            super(p_379883_);
        }

        @Override
        public void tick() {
            if (Creaking.this.canMove()) {
                super.tick();
            }
        }
    }

    class CreakingMoveControl
    extends MoveControl {
        public CreakingMoveControl(Creaking p_380148_) {
            super(p_380148_);
        }

        @Override
        public void tick() {
            if (Creaking.this.canMove()) {
                super.tick();
            }
        }
    }

    class CreakingJumpControl
    extends JumpControl {
        public CreakingJumpControl(Creaking p_379900_) {
            super(p_379900_);
        }

        @Override
        public void tick() {
            if (Creaking.this.canMove()) {
                super.tick();
            } else {
                Creaking.this.setJumping(false);
            }
        }
    }

    class CreakingBodyRotationControl
    extends BodyRotationControl {
        public CreakingBodyRotationControl(Creaking p_380382_) {
            super(p_380382_);
        }

        @Override
        public void clientTick() {
            if (Creaking.this.canMove()) {
                super.clientTick();
            }
        }
    }
}

