/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.creaking;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CreakingTransient
extends Creaking {
    public static final int INVULNERABILITY_ANIMATION_DURATION = 8;
    private int invulnerabilityAnimationRemainingTicks;
    @Nullable
    BlockPos homePos;

    public CreakingTransient(EntityType<? extends Creaking> p_380027_, Level p_379345_) {
        super(p_380027_, p_379345_);
    }

    public void bindToCreakingHeart(BlockPos p_379862_) {
        this.homePos = p_379862_;
    }

    @Override
    public boolean hurtServer(ServerLevel p_379707_, DamageSource p_379518_, float p_380298_) {
        CreakingHeartBlockEntity $$3;
        if (this.level().isClientSide) {
            return super.hurtServer(p_379707_, p_379518_, p_380298_);
        }
        if (p_379518_.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurtServer(p_379707_, p_379518_, p_380298_);
        }
        if (this.isInvulnerableTo(p_379707_, p_379518_) || this.invulnerabilityAnimationRemainingTicks > 0) {
            return false;
        }
        this.invulnerabilityAnimationRemainingTicks = 8;
        this.level().broadcastEntityEvent(this, (byte)66);
        BlockEntity blockEntity = this.level().getBlockEntity(this.homePos);
        if (blockEntity instanceof CreakingHeartBlockEntity && ($$3 = (CreakingHeartBlockEntity)blockEntity).isProtector(this)) {
            if (p_379518_.getEntity() instanceof Player) {
                $$3.creakingHurt();
            }
            this.playHurtSound(p_379518_);
        }
        return true;
    }

    @Override
    public void aiStep() {
        if (this.invulnerabilityAnimationRemainingTicks > 0) {
            --this.invulnerabilityAnimationRemainingTicks;
        }
        super.aiStep();
    }

    @Override
    public void tick() {
        CreakingHeartBlockEntity $$0;
        BlockEntity blockEntity;
        if (!(this.level().isClientSide || this.homePos != null && (blockEntity = this.level().getBlockEntity(this.homePos)) instanceof CreakingHeartBlockEntity && ($$0 = (CreakingHeartBlockEntity)blockEntity).isProtector(this))) {
            this.setRemoved(Entity.RemovalReason.DISCARDED);
            return;
        }
        super.tick();
        if (this.level().isClientSide) {
            this.setupAnimationStates();
        }
    }

    @Override
    public void handleEntityEvent(byte p_379783_) {
        if (p_379783_ == 66) {
            this.invulnerabilityAnimationRemainingTicks = 8;
            this.playHurtSound(this.damageSources().generic());
        } else {
            super.handleEntityEvent(p_379783_);
        }
    }

    private void setupAnimationStates() {
        this.invulnerabilityAnimationState.animateWhen(this.invulnerabilityAnimationRemainingTicks > 0, this.tickCount);
    }

    public void tearDown(@Nullable DamageSource p_379304_) {
        Object object = this.level();
        if (object instanceof ServerLevel) {
            ServerLevel $$1 = (ServerLevel)object;
            AABB $$2 = this.getBoundingBox();
            Vec3 $$3 = $$2.getCenter();
            double $$4 = $$2.getXsize() * 0.3;
            double $$5 = $$2.getYsize() * 0.3;
            double $$6 = $$2.getZsize() * 0.3;
            $$1.sendParticles(new BlockParticleOption(ParticleTypes.BLOCK_CRUMBLE, Blocks.PALE_OAK_WOOD.defaultBlockState()), $$3.x, $$3.y, $$3.z, 100, $$4, $$5, $$6, 0.0);
            $$1.sendParticles(new BlockParticleOption(ParticleTypes.BLOCK_CRUMBLE, (BlockState)Blocks.CREAKING_HEART.defaultBlockState().setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.CreakingHeartState.ACTIVE)), $$3.x, $$3.y, $$3.z, 10, $$4, $$5, $$6, 0.0);
        }
        this.makeSound(this.getDeathSound());
        if (this.deathScore >= 0 && p_379304_ != null && (object = p_379304_.getEntity()) instanceof LivingEntity) {
            LivingEntity $$7 = (LivingEntity)object;
            $$7.awardKillScore(this, this.deathScore, p_379304_);
        }
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    @Override
    protected boolean canAddPassenger(Entity p_379721_) {
        return false;
    }

    @Override
    protected boolean couldAcceptPassenger() {
        return false;
    }

    @Override
    protected void addPassenger(Entity p_379962_) {
        throw new IllegalStateException("Should never addPassenger without checking couldAcceptPassenger()");
    }

    @Override
    public boolean canUsePortal(boolean p_379904_) {
        return false;
    }

    @Override
    protected PathNavigation createNavigation(Level p_379843_) {
        return new CreakingPathNavigation(this, p_379843_);
    }

    class CreakingPathNavigation
    extends GroundPathNavigation {
        CreakingPathNavigation(Creaking p_380149_, Level p_380304_) {
            super(p_380149_, p_380304_);
        }

        @Override
        public void tick() {
            if (CreakingTransient.this.canMove()) {
                super.tick();
            }
        }

        @Override
        protected PathFinder createPathFinder(int p_380379_) {
            this.nodeEvaluator = new HomeNodeEvaluator();
            return new PathFinder(this.nodeEvaluator, p_380379_);
        }
    }

    class HomeNodeEvaluator
    extends WalkNodeEvaluator {
        private static final int MAX_DISTANCE_TO_HOME_SQ = 1024;

        HomeNodeEvaluator() {
        }

        @Override
        public PathType getPathType(PathfindingContext p_379617_, int p_380209_, int p_379621_, int p_379523_) {
            BlockPos $$4 = CreakingTransient.this.homePos;
            if ($$4 == null) {
                return super.getPathType(p_379617_, p_380209_, p_379621_, p_379523_);
            }
            double $$5 = $$4.distSqr(new Vec3i(p_380209_, p_379621_, p_379523_));
            if ($$5 > 1024.0 && $$5 >= $$4.distSqr(p_379617_.mobPosition())) {
                return PathType.BLOCKED;
            }
            return super.getPathType(p_379617_, p_380209_, p_379621_, p_379523_);
        }
    }
}

