/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundSetPlayerInventoryPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class Inventory
implements Container,
Nameable {
    public static final int POP_TIME_DURATION = 5;
    public static final int INVENTORY_SIZE = 36;
    public static final int SELECTION_SIZE = 9;
    public static final int SLOT_OFFHAND = 40;
    public static final int NOT_FOUND_INDEX = -1;
    public final NonNullList<ItemStack> items = NonNullList.withSize(36, ItemStack.EMPTY);
    public final NonNullList<ItemStack> armor = NonNullList.withSize(4, ItemStack.EMPTY);
    public final NonNullList<ItemStack> offhand = NonNullList.withSize(1, ItemStack.EMPTY);
    private final List<NonNullList<ItemStack>> compartments = ImmutableList.of(this.items, this.armor, this.offhand);
    public int selected;
    public final Player player;
    private int timesChanged;

    public Inventory(Player p_35983_) {
        this.player = p_35983_;
    }

    public ItemStack getSelected() {
        if (Inventory.isHotbarSlot(this.selected)) {
            return this.items.get(this.selected);
        }
        return ItemStack.EMPTY;
    }

    public static int getSelectionSize() {
        return 9;
    }

    private boolean hasRemainingSpaceForItem(ItemStack p_36015_, ItemStack p_36016_) {
        return !p_36015_.isEmpty() && ItemStack.isSameItemSameComponents(p_36015_, p_36016_) && p_36015_.isStackable() && p_36015_.getCount() < this.getMaxStackSize(p_36015_);
    }

    public int getFreeSlot() {
        for (int $$0 = 0; $$0 < this.items.size(); ++$$0) {
            if (!this.items.get($$0).isEmpty()) continue;
            return $$0;
        }
        return -1;
    }

    public void setPickedItem(ItemStack p_36013_) {
        int $$1 = this.findSlotMatchingItem(p_36013_);
        if (Inventory.isHotbarSlot($$1)) {
            this.selected = $$1;
            return;
        }
        if ($$1 == -1) {
            int $$2;
            this.selected = this.getSuitableHotbarSlot();
            if (!this.items.get(this.selected).isEmpty() && ($$2 = this.getFreeSlot()) != -1) {
                this.items.set($$2, this.items.get(this.selected));
            }
            this.items.set(this.selected, p_36013_);
        } else {
            this.pickSlot($$1);
        }
    }

    public void pickSlot(int p_36039_) {
        this.selected = this.getSuitableHotbarSlot();
        ItemStack $$1 = this.items.get(this.selected);
        this.items.set(this.selected, this.items.get(p_36039_));
        this.items.set(p_36039_, $$1);
    }

    public static boolean isHotbarSlot(int p_36046_) {
        return p_36046_ >= 0 && p_36046_ < 9;
    }

    public int findSlotMatchingItem(ItemStack p_36031_) {
        for (int $$1 = 0; $$1 < this.items.size(); ++$$1) {
            if (this.items.get($$1).isEmpty() || !ItemStack.isSameItemSameComponents(p_36031_, this.items.get($$1))) continue;
            return $$1;
        }
        return -1;
    }

    public static boolean isUsableForCrafting(ItemStack p_365004_) {
        return !p_365004_.isDamaged() && !p_365004_.isEnchanted() && !p_365004_.has(DataComponents.CUSTOM_NAME);
    }

    public int findSlotMatchingCraftingIngredient(Holder<Item> p_363103_) {
        for (int $$1 = 0; $$1 < this.items.size(); ++$$1) {
            ItemStack $$2 = this.items.get($$1);
            if ($$2.isEmpty() || !$$2.is(p_363103_) || !Inventory.isUsableForCrafting($$2)) continue;
            return $$1;
        }
        return -1;
    }

    public int getSuitableHotbarSlot() {
        for (int $$0 = 0; $$0 < 9; ++$$0) {
            int $$1 = (this.selected + $$0) % 9;
            if (!this.items.get($$1).isEmpty()) continue;
            return $$1;
        }
        for (int $$2 = 0; $$2 < 9; ++$$2) {
            int $$3 = (this.selected + $$2) % 9;
            if (this.items.get($$3).isEnchanted()) continue;
            return $$3;
        }
        return this.selected;
    }

    public void setSelectedHotbarSlot(int p_364957_) {
        this.selected = p_364957_;
    }

    public int clearOrCountMatchingItems(Predicate<ItemStack> p_36023_, int p_36024_, Container p_36025_) {
        int $$3 = 0;
        boolean $$4 = p_36024_ == 0;
        $$3 += ContainerHelper.clearOrCountMatchingItems(this, p_36023_, p_36024_ - $$3, $$4);
        $$3 += ContainerHelper.clearOrCountMatchingItems(p_36025_, p_36023_, p_36024_ - $$3, $$4);
        ItemStack $$5 = this.player.containerMenu.getCarried();
        $$3 += ContainerHelper.clearOrCountMatchingItems($$5, p_36023_, p_36024_ - $$3, $$4);
        if ($$5.isEmpty()) {
            this.player.containerMenu.setCarried(ItemStack.EMPTY);
        }
        return $$3;
    }

    private int addResource(ItemStack p_36067_) {
        int $$1 = this.getSlotWithRemainingSpace(p_36067_);
        if ($$1 == -1) {
            $$1 = this.getFreeSlot();
        }
        if ($$1 == -1) {
            return p_36067_.getCount();
        }
        return this.addResource($$1, p_36067_);
    }

    private int addResource(int p_36048_, ItemStack p_36049_) {
        int $$4;
        int $$5;
        int $$2 = p_36049_.getCount();
        ItemStack $$3 = this.getItem(p_36048_);
        if ($$3.isEmpty()) {
            $$3 = p_36049_.copyWithCount(0);
            this.setItem(p_36048_, $$3);
        }
        if (($$5 = Math.min($$2, $$4 = this.getMaxStackSize($$3) - $$3.getCount())) == 0) {
            return $$2;
        }
        $$3.grow($$5);
        $$3.setPopTime(5);
        return $$2 -= $$5;
    }

    public int getSlotWithRemainingSpace(ItemStack p_36051_) {
        if (this.hasRemainingSpaceForItem(this.getItem(this.selected), p_36051_)) {
            return this.selected;
        }
        if (this.hasRemainingSpaceForItem(this.getItem(40), p_36051_)) {
            return 40;
        }
        for (int $$1 = 0; $$1 < this.items.size(); ++$$1) {
            if (!this.hasRemainingSpaceForItem(this.items.get($$1), p_36051_)) continue;
            return $$1;
        }
        return -1;
    }

    public void tick() {
        for (NonNullList<ItemStack> $$0 : this.compartments) {
            for (int $$1 = 0; $$1 < $$0.size(); ++$$1) {
                if ($$0.get($$1).isEmpty()) continue;
                $$0.get($$1).inventoryTick(this.player.level(), this.player, $$1, this.selected == $$1);
            }
        }
    }

    public boolean add(ItemStack p_36055_) {
        return this.add(-1, p_36055_);
    }

    public boolean add(int p_36041_, ItemStack p_36042_) {
        if (p_36042_.isEmpty()) {
            return false;
        }
        try {
            if (!p_36042_.isDamaged()) {
                int $$2;
                do {
                    $$2 = p_36042_.getCount();
                    if (p_36041_ == -1) {
                        p_36042_.setCount(this.addResource(p_36042_));
                        continue;
                    }
                    p_36042_.setCount(this.addResource(p_36041_, p_36042_));
                } while (!p_36042_.isEmpty() && p_36042_.getCount() < $$2);
                if (p_36042_.getCount() == $$2 && this.player.hasInfiniteMaterials()) {
                    p_36042_.setCount(0);
                    return true;
                }
                return p_36042_.getCount() < $$2;
            }
            if (p_36041_ == -1) {
                p_36041_ = this.getFreeSlot();
            }
            if (p_36041_ >= 0) {
                this.items.set(p_36041_, p_36042_.copyAndClear());
                this.items.get(p_36041_).setPopTime(5);
                return true;
            }
            if (this.player.hasInfiniteMaterials()) {
                p_36042_.setCount(0);
                return true;
            }
            return false;
        }
        catch (Throwable $$3) {
            CrashReport $$4 = CrashReport.forThrowable($$3, "Adding item to inventory");
            CrashReportCategory $$5 = $$4.addCategory("Item being added");
            $$5.setDetail("Item ID", Item.getId(p_36042_.getItem()));
            $$5.setDetail("Item data", p_36042_.getDamageValue());
            $$5.setDetail("Item name", () -> p_36042_.getHoverName().getString());
            throw new ReportedException($$4);
        }
    }

    public void placeItemBackInInventory(ItemStack p_150080_) {
        this.placeItemBackInInventory(p_150080_, true);
    }

    public void placeItemBackInInventory(ItemStack p_150077_, boolean p_150078_) {
        while (!p_150077_.isEmpty()) {
            Player player;
            int $$2 = this.getSlotWithRemainingSpace(p_150077_);
            if ($$2 == -1) {
                $$2 = this.getFreeSlot();
            }
            if ($$2 == -1) {
                this.player.drop(p_150077_, false);
                break;
            }
            int $$3 = p_150077_.getMaxStackSize() - this.getItem($$2).getCount();
            if (!this.add($$2, p_150077_.split($$3)) || !p_150078_ || !((player = this.player) instanceof ServerPlayer)) continue;
            ServerPlayer $$4 = (ServerPlayer)player;
            $$4.connection.send(this.createInventoryUpdatePacket($$2));
        }
    }

    public ClientboundSetPlayerInventoryPacket createInventoryUpdatePacket(int p_365327_) {
        return new ClientboundSetPlayerInventoryPacket(p_365327_, this.getItem(p_365327_).copy());
    }

    @Override
    public ItemStack removeItem(int p_35993_, int p_35994_) {
        NonNullList<ItemStack> $$2 = null;
        for (NonNullList<ItemStack> $$3 : this.compartments) {
            if (p_35993_ < $$3.size()) {
                $$2 = $$3;
                break;
            }
            p_35993_ -= $$3.size();
        }
        if ($$2 != null && !((ItemStack)$$2.get(p_35993_)).isEmpty()) {
            return ContainerHelper.removeItem($$2, p_35993_, p_35994_);
        }
        return ItemStack.EMPTY;
    }

    public void removeItem(ItemStack p_36058_) {
        block0: for (NonNullList<ItemStack> $$1 : this.compartments) {
            for (int $$2 = 0; $$2 < $$1.size(); ++$$2) {
                if ($$1.get($$2) != p_36058_) continue;
                $$1.set($$2, ItemStack.EMPTY);
                continue block0;
            }
        }
    }

    @Override
    public ItemStack removeItemNoUpdate(int p_36029_) {
        NonNullList<ItemStack> $$1 = null;
        for (NonNullList<ItemStack> $$2 : this.compartments) {
            if (p_36029_ < $$2.size()) {
                $$1 = $$2;
                break;
            }
            p_36029_ -= $$2.size();
        }
        if ($$1 != null && !((ItemStack)$$1.get(p_36029_)).isEmpty()) {
            ItemStack $$3 = $$1.get(p_36029_);
            $$1.set(p_36029_, ItemStack.EMPTY);
            return $$3;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setItem(int p_35999_, ItemStack p_36000_) {
        NonNullList<ItemStack> $$2 = null;
        for (NonNullList<ItemStack> $$3 : this.compartments) {
            if (p_35999_ < $$3.size()) {
                $$2 = $$3;
                break;
            }
            p_35999_ -= $$3.size();
        }
        if ($$2 != null) {
            $$2.set(p_35999_, p_36000_);
        }
    }

    public float getDestroySpeed(BlockState p_36021_) {
        return this.items.get(this.selected).getDestroySpeed(p_36021_);
    }

    public ListTag save(ListTag p_36027_) {
        for (int $$1 = 0; $$1 < this.items.size(); ++$$1) {
            if (this.items.get($$1).isEmpty()) continue;
            CompoundTag $$2 = new CompoundTag();
            $$2.putByte("Slot", (byte)$$1);
            p_36027_.add(this.items.get($$1).save(this.player.registryAccess(), $$2));
        }
        for (int $$3 = 0; $$3 < this.armor.size(); ++$$3) {
            if (this.armor.get($$3).isEmpty()) continue;
            CompoundTag $$4 = new CompoundTag();
            $$4.putByte("Slot", (byte)($$3 + 100));
            p_36027_.add(this.armor.get($$3).save(this.player.registryAccess(), $$4));
        }
        for (int $$5 = 0; $$5 < this.offhand.size(); ++$$5) {
            if (this.offhand.get($$5).isEmpty()) continue;
            CompoundTag $$6 = new CompoundTag();
            $$6.putByte("Slot", (byte)($$5 + 150));
            p_36027_.add(this.offhand.get($$5).save(this.player.registryAccess(), $$6));
        }
        return p_36027_;
    }

    public void load(ListTag p_36036_) {
        this.items.clear();
        this.armor.clear();
        this.offhand.clear();
        for (int $$1 = 0; $$1 < p_36036_.size(); ++$$1) {
            CompoundTag $$2 = p_36036_.getCompound($$1);
            int $$3 = $$2.getByte("Slot") & 0xFF;
            ItemStack $$4 = ItemStack.parse(this.player.registryAccess(), $$2).orElse(ItemStack.EMPTY);
            if ($$3 >= 0 && $$3 < this.items.size()) {
                this.items.set($$3, $$4);
                continue;
            }
            if ($$3 >= 100 && $$3 < this.armor.size() + 100) {
                this.armor.set($$3 - 100, $$4);
                continue;
            }
            if ($$3 < 150 || $$3 >= this.offhand.size() + 150) continue;
            this.offhand.set($$3 - 150, $$4);
        }
    }

    @Override
    public int getContainerSize() {
        return this.items.size() + this.armor.size() + this.offhand.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack $$0 : this.items) {
            if ($$0.isEmpty()) continue;
            return false;
        }
        for (ItemStack $$1 : this.armor) {
            if ($$1.isEmpty()) continue;
            return false;
        }
        for (ItemStack $$2 : this.offhand) {
            if ($$2.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getItem(int p_35991_) {
        NonNullList<ItemStack> $$1 = null;
        for (NonNullList<ItemStack> $$2 : this.compartments) {
            if (p_35991_ < $$2.size()) {
                $$1 = $$2;
                break;
            }
            p_35991_ -= $$2.size();
        }
        return $$1 == null ? ItemStack.EMPTY : (ItemStack)$$1.get(p_35991_);
    }

    @Override
    public Component getName() {
        return Component.translatable("container.inventory");
    }

    public ItemStack getArmor(int p_36053_) {
        return this.armor.get(p_36053_);
    }

    public void dropAll() {
        for (List list : this.compartments) {
            for (int $$1 = 0; $$1 < list.size(); ++$$1) {
                ItemStack $$2 = (ItemStack)list.get($$1);
                if ($$2.isEmpty()) continue;
                this.player.drop($$2, true, false);
                list.set($$1, ItemStack.EMPTY);
            }
        }
    }

    @Override
    public void setChanged() {
        ++this.timesChanged;
    }

    public int getTimesChanged() {
        return this.timesChanged;
    }

    @Override
    public boolean stillValid(Player p_36009_) {
        return p_36009_.canInteractWithEntity(this.player, 4.0);
    }

    public boolean contains(ItemStack p_36064_) {
        for (List list : this.compartments) {
            for (ItemStack $$2 : list) {
                if ($$2.isEmpty() || !ItemStack.isSameItemSameComponents($$2, p_36064_)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(TagKey<Item> p_204076_) {
        for (List list : this.compartments) {
            for (ItemStack $$2 : list) {
                if ($$2.isEmpty() || !$$2.is(p_204076_)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(Predicate<ItemStack> p_316260_) {
        for (List list : this.compartments) {
            for (ItemStack $$2 : list) {
                if (!p_316260_.test($$2)) continue;
                return true;
            }
        }
        return false;
    }

    public void replaceWith(Inventory p_36007_) {
        for (int $$1 = 0; $$1 < this.getContainerSize(); ++$$1) {
            this.setItem($$1, p_36007_.getItem($$1));
        }
        this.selected = p_36007_.selected;
    }

    @Override
    public void clearContent() {
        for (List list : this.compartments) {
            list.clear();
        }
    }

    public void fillStackedContents(StackedItemContents p_360737_) {
        for (ItemStack $$1 : this.items) {
            p_360737_.accountSimpleStack($$1);
        }
    }

    public ItemStack removeFromSelected(boolean p_182404_) {
        ItemStack $$1 = this.getSelected();
        if ($$1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return this.removeItem(this.selected, p_182404_ ? $$1.getCount() : 1);
    }
}

