/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;

public class StackedContents<T> {
    public final Reference2IntOpenHashMap<T> amounts = new Reference2IntOpenHashMap();

    boolean hasAnyAmount(T p_363825_) {
        return this.amounts.getInt(p_363825_) > 0;
    }

    boolean hasAtLeast(T p_362841_, int p_364786_) {
        return this.amounts.getInt(p_362841_) >= p_364786_;
    }

    void take(T p_364608_, int p_36457_) {
        int $$2 = this.amounts.addTo(p_364608_, -p_36457_);
        if ($$2 < p_36457_) {
            throw new IllegalStateException("Took " + p_36457_ + " items, but only had " + $$2);
        }
    }

    void put(T p_364631_, int p_36485_) {
        this.amounts.addTo(p_364631_, p_36485_);
    }

    public boolean tryPick(List<IngredientInfo<T>> p_363544_, int p_364228_, @Nullable Output<T> p_362098_) {
        return new RecipePicker(p_363544_).tryPick(p_364228_, p_362098_);
    }

    public int tryPickAll(List<IngredientInfo<T>> p_363263_, int p_362732_, @Nullable Output<T> p_361155_) {
        return new RecipePicker(p_363263_).tryPickAll(p_362732_, p_361155_);
    }

    public void clear() {
        this.amounts.clear();
    }

    public void account(T p_362247_, int p_362975_) {
        this.put(p_362247_, p_362975_);
    }

    class RecipePicker {
        private final List<IngredientInfo<T>> ingredients;
        private final int ingredientCount;
        private final List<T> items;
        private final int itemCount;
        private final BitSet data;
        private final IntList path = new IntArrayList();

        public RecipePicker(List<IngredientInfo<T>> p_363428_) {
            this.ingredients = p_363428_;
            this.ingredientCount = this.ingredients.size();
            this.items = this.getUniqueAvailableIngredientItems();
            this.itemCount = this.items.size();
            this.data = new BitSet(this.visitedIngredientCount() + this.visitedItemCount() + this.satisfiedCount() + this.connectionCount() + this.residualCount());
            this.setInitialConnections();
        }

        private void setInitialConnections() {
            for (int $$0 = 0; $$0 < this.ingredientCount; ++$$0) {
                List $$1 = this.ingredients.get($$0).allowedItems();
                for (int $$2 = 0; $$2 < this.itemCount; ++$$2) {
                    if (!$$1.contains(this.items.get($$2))) continue;
                    this.setConnection($$2, $$0);
                }
            }
        }

        public boolean tryPick(int p_36513_, @Nullable Output<T> p_360727_) {
            IntList $$3;
            if (p_36513_ <= 0) {
                return true;
            }
            int $$2 = 0;
            while (($$3 = this.tryAssigningNewItem(p_36513_)) != null) {
                int $$4 = $$3.getInt(0);
                StackedContents.this.take(this.items.get($$4), p_36513_);
                int $$5 = $$3.size() - 1;
                this.setSatisfied($$3.getInt($$5));
                ++$$2;
                for (int $$6 = 0; $$6 < $$3.size() - 1; ++$$6) {
                    if (RecipePicker.isPathIndexItem($$6)) {
                        int $$7 = $$3.getInt($$6);
                        int $$8 = $$3.getInt($$6 + 1);
                        this.assign($$7, $$8);
                        continue;
                    }
                    int $$9 = $$3.getInt($$6 + 1);
                    int $$10 = $$3.getInt($$6);
                    this.unassign($$9, $$10);
                }
            }
            boolean $$11 = $$2 == this.ingredientCount;
            boolean $$12 = $$11 && p_360727_ != null;
            this.clearAllVisited();
            this.clearSatisfied();
            block2: for (int $$13 = 0; $$13 < this.ingredientCount; ++$$13) {
                for (int $$14 = 0; $$14 < this.itemCount; ++$$14) {
                    if (!this.isAssigned($$14, $$13)) continue;
                    this.unassign($$14, $$13);
                    StackedContents.this.put(this.items.get($$14), p_36513_);
                    if (!$$12) continue block2;
                    p_360727_.accept(this.items.get($$14));
                    continue block2;
                }
            }
            assert (this.data.get(this.residualOffset(), this.residualOffset() + this.residualCount()).isEmpty());
            return $$11;
        }

        private static boolean isPathIndexItem(int p_363458_) {
            return (p_363458_ & 1) == 0;
        }

        private List<T> getUniqueAvailableIngredientItems() {
            ReferenceOpenHashSet $$0 = new ReferenceOpenHashSet();
            for (IngredientInfo $$1 : this.ingredients) {
                $$0.addAll($$1.allowedItems());
            }
            $$0.removeIf(p_365026_ -> !StackedContents.this.hasAnyAmount(p_365026_));
            return List.copyOf($$0);
        }

        @Nullable
        private IntList tryAssigningNewItem(int p_361858_) {
            this.clearAllVisited();
            for (int $$1 = 0; $$1 < this.itemCount; ++$$1) {
                IntList $$2;
                if (!StackedContents.this.hasAtLeast(this.items.get($$1), p_361858_) || ($$2 = this.findNewItemAssignmentPath($$1)) == null) continue;
                return $$2;
            }
            return null;
        }

        @Nullable
        private IntList findNewItemAssignmentPath(int p_361628_) {
            this.path.clear();
            this.visitItem(p_361628_);
            this.path.add(p_361628_);
            while (!this.path.isEmpty()) {
                int $$6;
                int $$1 = this.path.size();
                if (RecipePicker.isPathIndexItem($$1 - 1)) {
                    int $$2 = this.path.getInt($$1 - 1);
                    for (int $$3 = 0; $$3 < this.ingredientCount; ++$$3) {
                        if (this.hasVisitedIngredient($$3) || !this.hasConnection($$2, $$3) || this.isAssigned($$2, $$3)) continue;
                        this.visitIngredient($$3);
                        this.path.add($$3);
                        break;
                    }
                } else {
                    int $$4 = this.path.getInt($$1 - 1);
                    if (!this.isSatisfied($$4)) {
                        return this.path;
                    }
                    for (int $$5 = 0; $$5 < this.itemCount; ++$$5) {
                        if (this.hasVisitedItem($$5) || !this.isAssigned($$5, $$4)) continue;
                        assert (this.hasConnection($$5, $$4));
                        this.visitItem($$5);
                        this.path.add($$5);
                        break;
                    }
                }
                if (($$6 = this.path.size()) != $$1) continue;
                this.path.removeInt($$6 - 1);
            }
            return null;
        }

        private int visitedIngredientOffset() {
            return 0;
        }

        private int visitedIngredientCount() {
            return this.ingredientCount;
        }

        private int visitedItemOffset() {
            return this.visitedIngredientOffset() + this.visitedIngredientCount();
        }

        private int visitedItemCount() {
            return this.itemCount;
        }

        private int satisfiedOffset() {
            return this.visitedItemOffset() + this.visitedItemCount();
        }

        private int satisfiedCount() {
            return this.ingredientCount;
        }

        private int connectionOffset() {
            return this.satisfiedOffset() + this.satisfiedCount();
        }

        private int connectionCount() {
            return this.ingredientCount * this.itemCount;
        }

        private int residualOffset() {
            return this.connectionOffset() + this.connectionCount();
        }

        private int residualCount() {
            return this.ingredientCount * this.itemCount;
        }

        private boolean isSatisfied(int p_36524_) {
            return this.data.get(this.getSatisfiedIndex(p_36524_));
        }

        private void setSatisfied(int p_36536_) {
            this.data.set(this.getSatisfiedIndex(p_36536_));
        }

        private int getSatisfiedIndex(int p_36545_) {
            assert (p_36545_ >= 0 && p_36545_ < this.ingredientCount);
            return this.satisfiedOffset() + p_36545_;
        }

        private void clearSatisfied() {
            this.clearRange(this.satisfiedOffset(), this.satisfiedCount());
        }

        private void setConnection(int p_363270_, int p_365139_) {
            this.data.set(this.getConnectionIndex(p_363270_, p_365139_));
        }

        private boolean hasConnection(int p_36520_, int p_36521_) {
            return this.data.get(this.getConnectionIndex(p_36520_, p_36521_));
        }

        private int getConnectionIndex(int p_361468_, int p_361569_) {
            assert (p_361468_ >= 0 && p_361468_ < this.itemCount);
            assert (p_361569_ >= 0 && p_361569_ < this.ingredientCount);
            return this.connectionOffset() + p_361468_ * this.ingredientCount + p_361569_;
        }

        private boolean isAssigned(int p_363705_, int p_362618_) {
            return this.data.get(this.getResidualIndex(p_363705_, p_362618_));
        }

        private void assign(int p_364941_, int p_363422_) {
            int $$2 = this.getResidualIndex(p_364941_, p_363422_);
            assert (!this.data.get($$2));
            this.data.set($$2);
        }

        private void unassign(int p_364332_, int p_363922_) {
            int $$2 = this.getResidualIndex(p_364332_, p_363922_);
            assert (this.data.get($$2));
            this.data.clear($$2);
        }

        private int getResidualIndex(int p_364133_, int p_363861_) {
            assert (p_364133_ >= 0 && p_364133_ < this.itemCount);
            assert (p_363861_ >= 0 && p_363861_ < this.ingredientCount);
            return this.residualOffset() + p_364133_ * this.ingredientCount + p_363861_;
        }

        private void visitIngredient(int p_364543_) {
            this.data.set(this.getVisitedIngredientIndex(p_364543_));
        }

        private boolean hasVisitedIngredient(int p_362970_) {
            return this.data.get(this.getVisitedIngredientIndex(p_362970_));
        }

        private int getVisitedIngredientIndex(int p_360807_) {
            assert (p_360807_ >= 0 && p_360807_ < this.ingredientCount);
            return this.visitedIngredientOffset() + p_360807_;
        }

        private void visitItem(int p_363443_) {
            this.data.set(this.getVisitiedItemIndex(p_363443_));
        }

        private boolean hasVisitedItem(int p_360782_) {
            return this.data.get(this.getVisitiedItemIndex(p_360782_));
        }

        private int getVisitiedItemIndex(int p_363564_) {
            assert (p_363564_ >= 0 && p_363564_ < this.itemCount);
            return this.visitedItemOffset() + p_363564_;
        }

        private void clearAllVisited() {
            this.clearRange(this.visitedIngredientOffset(), this.visitedIngredientCount());
            this.clearRange(this.visitedItemOffset(), this.visitedItemCount());
        }

        private void clearRange(int p_363225_, int p_363424_) {
            this.data.clear(p_363225_, p_363225_ + p_363424_);
        }

        public int tryPickAll(int p_36526_, @Nullable Output<T> p_361994_) {
            int $$4;
            int $$2 = 0;
            int $$3 = Math.min(p_36526_, this.getMinIngredientCount()) + 1;
            while (true) {
                if (this.tryPick($$4 = ($$2 + $$3) / 2, null)) {
                    if ($$3 - $$2 <= 1) break;
                    $$2 = $$4;
                    continue;
                }
                $$3 = $$4;
            }
            if ($$4 > 0) {
                this.tryPick($$4, p_361994_);
            }
            return $$4;
        }

        private int getMinIngredientCount() {
            int $$0 = Integer.MAX_VALUE;
            for (IngredientInfo $$1 : this.ingredients) {
                int $$2 = 0;
                for (Object $$3 : $$1.allowedItems()) {
                    $$2 = Math.max($$2, StackedContents.this.amounts.getInt($$3));
                }
                if ($$0 <= 0) continue;
                $$0 = Math.min($$0, $$2);
            }
            return $$0;
        }
    }

    @FunctionalInterface
    public static interface Output<T> {
        public void accept(T var1);
    }

    public record IngredientInfo<T>(List<T> allowedItems) {
        public IngredientInfo {
            if (allowedItems.isEmpty()) {
                throw new IllegalArgumentException("Ingredients can't be empty");
            }
        }
    }
}

