/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;

public class StackedItemContents {
    private final StackedContents<Holder<Item>> raw = new StackedContents();

    public void accountSimpleStack(ItemStack p_363120_) {
        if (Inventory.isUsableForCrafting(p_363120_)) {
            this.accountStack(p_363120_);
        }
    }

    public void accountStack(ItemStack p_364939_) {
        this.accountStack(p_364939_, p_364939_.getMaxStackSize());
    }

    public void accountStack(ItemStack p_365466_, int p_365492_) {
        if (!p_365466_.isEmpty()) {
            int $$2 = Math.min(p_365492_, p_365466_.getCount());
            this.raw.account(p_365466_.getItemHolder(), $$2);
        }
    }

    public static StackedContents.IngredientInfo<Holder<Item>> convertIngredientContents(Stream<Holder<Item>> p_363873_) {
        List<Holder> $$1 = p_363873_.sorted(Comparator.comparingInt(p_362283_ -> BuiltInRegistries.ITEM.getId((Item)p_362283_.value()))).toList();
        return new StackedContents.IngredientInfo<Holder<Item>>($$1);
    }

    public boolean canCraft(Recipe<?> p_362014_, @Nullable StackedContents.Output<Holder<Item>> p_362141_) {
        return this.canCraft(p_362014_, 1, p_362141_);
    }

    public boolean canCraft(Recipe<?> p_364477_, int p_360429_, @Nullable StackedContents.Output<Holder<Item>> p_362813_) {
        PlacementInfo $$3 = p_364477_.placementInfo();
        if ($$3.isImpossibleToPlace()) {
            return false;
        }
        return this.canCraft($$3.unpackedIngredients(), p_360429_, p_362813_);
    }

    public boolean canCraft(List<StackedContents.IngredientInfo<Holder<Item>>> p_379390_, @Nullable StackedContents.Output<Holder<Item>> p_379587_) {
        return this.canCraft(p_379390_, 1, p_379587_);
    }

    private boolean canCraft(List<StackedContents.IngredientInfo<Holder<Item>>> p_379516_, int p_380017_, @Nullable StackedContents.Output<Holder<Item>> p_380092_) {
        return this.raw.tryPick(p_379516_, p_380017_, p_380092_);
    }

    public int getBiggestCraftableStack(Recipe<?> p_363539_, @Nullable StackedContents.Output<Holder<Item>> p_363083_) {
        return this.getBiggestCraftableStack(p_363539_, Integer.MAX_VALUE, p_363083_);
    }

    public int getBiggestCraftableStack(Recipe<?> p_362520_, int p_361940_, @Nullable StackedContents.Output<Holder<Item>> p_362354_) {
        return this.raw.tryPickAll(p_362520_.placementInfo().unpackedIngredients(), p_361940_, p_362354_);
    }

    public void clear() {
        this.raw.clear();
    }
}

