/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractHurtingProjectile
extends Projectile {
    public static final double INITAL_ACCELERATION_POWER = 0.1;
    public static final double DEFLECTION_SCALE = 0.5;
    public double accelerationPower = 0.1;

    protected AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> p_36833_, Level p_36834_) {
        super((EntityType<? extends Projectile>)p_36833_, p_36834_);
    }

    protected AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> p_312669_, double p_312561_, double p_312829_, double p_312607_, Level p_312011_) {
        this(p_312669_, p_312011_);
        this.setPos(p_312561_, p_312829_, p_312607_);
    }

    public AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> p_36826_, double p_36828_, double p_36829_, double p_36830_, Vec3 p_347477_, Level p_36831_) {
        this(p_36826_, p_36831_);
        this.moveTo(p_36828_, p_36829_, p_36830_, this.getYRot(), this.getXRot());
        this.reapplyPosition();
        this.assignDirectionalMovement(p_347477_, this.accelerationPower);
    }

    public AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> p_36817_, LivingEntity p_347648_, Vec3 p_347596_, Level p_36824_) {
        this(p_36817_, p_347648_.getX(), p_347648_.getY(), p_347648_.getZ(), p_347596_, p_36824_);
        this.setOwner(p_347648_);
        this.setRot(p_347648_.getYRot(), p_347648_.getXRot());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326181_) {
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double p_36837_) {
        double $$1 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN($$1)) {
            $$1 = 4.0;
        }
        return p_36837_ < ($$1 *= 64.0) * $$1;
    }

    protected ClipContext.Block getClipType() {
        return ClipContext.Block.COLLIDER;
    }

    @Override
    public void tick() {
        Vec3 $$3;
        Entity $$0 = this.getOwner();
        this.applyInertia();
        if (!this.level().isClientSide && ($$0 != null && $$0.isRemoved() || !this.level().hasChunkAt(this.blockPosition()))) {
            this.discard();
            return;
        }
        HitResult $$1 = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity, this.getClipType());
        if ($$1.getType() != HitResult.Type.MISS) {
            Vec3 $$2 = $$1.getLocation();
        } else {
            $$3 = this.position().add(this.getDeltaMovement());
        }
        ProjectileUtil.rotateTowardsMovement(this, 0.2f);
        this.setPos($$3);
        this.applyEffectsFromBlocks();
        super.tick();
        if (this.shouldBurn()) {
            this.igniteForSeconds(1.0f);
        }
        if ($$1.getType() != HitResult.Type.MISS && this.isAlive()) {
            this.hitTargetOrDeflectSelf($$1);
        }
        this.createParticleTrail();
    }

    private void applyInertia() {
        float $$5;
        Vec3 $$0 = this.getDeltaMovement();
        Vec3 $$1 = this.position();
        if (this.isInWater()) {
            for (int $$2 = 0; $$2 < 4; ++$$2) {
                float $$3 = 0.25f;
                this.level().addParticle(ParticleTypes.BUBBLE, $$1.x - $$0.x * 0.25, $$1.y - $$0.y * 0.25, $$1.z - $$0.z * 0.25, $$0.x, $$0.y, $$0.z);
            }
            float $$4 = this.getLiquidInertia();
        } else {
            $$5 = this.getInertia();
        }
        this.setDeltaMovement($$0.add($$0.normalize().scale(this.accelerationPower)).scale($$5));
    }

    private void createParticleTrail() {
        ParticleOptions $$0 = this.getTrailParticle();
        Vec3 $$1 = this.position();
        if ($$0 != null) {
            this.level().addParticle($$0, $$1.x, $$1.y + 0.5, $$1.z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean hurtServer(ServerLevel p_376467_, DamageSource p_376509_, float p_376502_) {
        return false;
    }

    @Override
    protected boolean canHitEntity(Entity p_36842_) {
        return super.canHitEntity(p_36842_) && !p_36842_.noPhysics;
    }

    protected boolean shouldBurn() {
        return true;
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.SMOKE;
    }

    protected float getInertia() {
        return 0.95f;
    }

    protected float getLiquidInertia() {
        return 0.8f;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_36848_) {
        super.addAdditionalSaveData(p_36848_);
        p_36848_.putDouble("acceleration_power", this.accelerationPower);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_36844_) {
        super.readAdditionalSaveData(p_36844_);
        if (p_36844_.contains("acceleration_power", 6)) {
            this.accelerationPower = p_36844_.getDouble("acceleration_power");
        }
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_352396_) {
        Entity $$1 = this.getOwner();
        int $$2 = $$1 == null ? 0 : $$1.getId();
        Vec3 $$3 = p_352396_.getPositionBase();
        return new ClientboundAddEntityPacket(this.getId(), this.getUUID(), $$3.x(), $$3.y(), $$3.z(), p_352396_.getLastSentXRot(), p_352396_.getLastSentYRot(), this.getType(), $$2, p_352396_.getLastSentMovement(), 0.0);
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket p_150128_) {
        super.recreateFromPacket(p_150128_);
        Vec3 $$1 = new Vec3(p_150128_.getXa(), p_150128_.getYa(), p_150128_.getZa());
        this.setDeltaMovement($$1);
    }

    private void assignDirectionalMovement(Vec3 p_347481_, double p_347589_) {
        this.setDeltaMovement(p_347481_.normalize().scale(p_347589_));
        this.hasImpulse = true;
    }

    @Override
    protected void onDeflection(@Nullable Entity p_341940_, boolean p_341895_) {
        super.onDeflection(p_341940_, p_341895_);
        this.accelerationPower = p_341895_ ? 0.1 : (this.accelerationPower *= 0.5);
    }
}

